package com.oracle.truffle.api.interop.java;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;

/**
 * This message resolution is generated by {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.WriteFieldNode}
 * It is used by the foreign access factory {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolutionForeign}
 */
abstract class WriteFieldNodeSub extends com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.WriteFieldNode {
    public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
    @Specialization
    protected Object accessWithTarget(com.oracle.truffle.api.frame.VirtualFrame frame, com.oracle.truffle.api.interop.java.JavaObject receiver, java.lang.String name, java.lang.Object value) {
        return access(frame, receiver, name, value);
    }
    @Specialization
    protected Object accessWithTarget(com.oracle.truffle.api.frame.VirtualFrame frame, com.oracle.truffle.api.interop.java.JavaObject receiver, java.lang.Number index, java.lang.Object value) {
        return access(frame, receiver, index, value);
    }
    private static final class WriteRootNode extends RootNode {
        protected WriteRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Child private WriteFieldNodeSub node = com.oracle.truffle.api.interop.java.WriteFieldNodeSubNodeGen.create();
        @Override
        public Object execute(VirtualFrame frame) {
            Object receiver = ForeignAccess.getReceiver(frame);
            Object identifier = ForeignAccess.getArguments(frame).get(0);
            Object value = ForeignAccess.getArguments(frame).get(1);
            try {
                return node.executeWithTarget(frame, receiver, identifier, value);
            } catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e.getSuppliedValues());
            }
        }

    }
    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new WriteRootNode(language);
    }
}
