/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.client;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.debug.shell.REPLMessage;
import com.oracle.truffle.tools.debug.shell.client.REPLClientContext;
import com.oracle.truffle.tools.debug.shell.client.REPLCommand;
import com.oracle.truffle.tools.debug.shell.client.REPLContinueException;
import com.oracle.truffle.tools.debug.shell.client.REPLFrame;
import com.oracle.truffle.tools.debug.shell.client.REPLineLocation;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class REPLRemoteCommand
extends REPLCommand {
    public static final REPLRemoteCommand BREAK_AT_LINE_CMD = new REPLRemoteCommand("break-at-line", "break", "Set a breakpoint"){
        private final String[] help = new String[]{"break <n> [ignore=<n>] : set breakpoint at line <n> in current file", "break <filename>:<n> [ignore=<n>] : set breakpoint at line <n> in <filename>", " optionally ignore first <n> hits (default 0)"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            try {
                int ignoreCount;
                REPLMessage requestMessage;
                block8: {
                    REPLineLocation lineLocation = REPLineLocation.parse(context, args);
                    requestMessage = lineLocation.createMessage("break-at-line");
                    ignoreCount = 0;
                    if (args.length > 2) {
                        String ignoreText = args[2];
                        if (ignoreText.equals("ignore")) {
                            throw new IllegalArgumentException("No ignore count specified");
                        }
                        String[] split = ignoreText.split("=");
                        if (split.length == 2 && split[0].equals("ignore")) {
                            try {
                                ignoreCount = Integer.parseInt(split[1]);
                                if (ignoreCount < 0) {
                                    throw new IllegalArgumentException("Illegal ignore count: " + split[1]);
                                }
                                break block8;
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("No ignore count specified");
                            }
                        }
                        throw new IllegalArgumentException("Unrecognized argument \"" + ignoreText + "\"");
                    }
                }
                requestMessage.put("breakpoint-ignore-count", Integer.toString(ignoreCount));
                return requestMessage;
            }
            catch (IllegalArgumentException ex) {
                context.displayFailReply(ex.getMessage());
                return null;
            }
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("succeeded")) {
                String number = firstReply.get("breakpoint-id");
                String fileName = firstReply.get("source-name");
                String lineNumber = firstReply.get("line-number");
                firstReply.put("displayable-message", "breakpoint " + number + " set at " + fileName + ":" + lineNumber);
            }
            super.processReply(context, replies);
        }
    };
    public static final REPLRemoteCommand BREAK_AT_LINE_ONCE_CMD = new REPLRemoteCommand("break-at-line-once", "break1", "Set a one-shot breakpoint"){
        private final String[] help = new String[]{"break <n>: set one-shot breakpoint at line <n> in current file", "break <filename>:<n>: set one-shot breakpoint at line <n> in current file"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            try {
                return REPLineLocation.parse(context, args).createMessage("break-at-line-once");
            }
            catch (IllegalArgumentException ex) {
                context.displayFailReply(ex.getMessage());
                return null;
            }
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("succeeded")) {
                String fileName = firstReply.get("source-name");
                String lineNumber = firstReply.get("line-number");
                firstReply.put("displayable-message", "one-shot breakpoint set at " + fileName + ":" + lineNumber);
            }
            super.processReply(context, replies);
        }
    };
    public static final REPLRemoteCommand CALL_CMD = new REPLRemoteCommand("call", null, "call a method/function"){
        private final String[] help = new String[]{"call <name> <args>: calls a function by name"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (args.length == 1) {
                context.displayFailReply("name to call not speciified");
                return null;
            }
            int maxArgs = REPLMessage.ARG_NAMES.length;
            if (args.length > maxArgs + 2) {
                context.displayFailReply("too many call arguments; no more than " + maxArgs + " supported");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "call");
            request.put("call-name", args[1]);
            int argIn = 2;
            int argOut = 0;
            while (argIn < args.length) {
                request.put(REPLMessage.ARG_NAMES[argOut], args[argIn]);
                ++argIn;
                ++argOut;
            }
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("failed")) {
                String result = firstReply.get("displayable-message");
                context.displayFailReply(result != null ? result : firstReply.toString());
            } else {
                context.displayReply(firstReply.get("value"));
            }
        }
    };
    public static final REPLRemoteCommand CALL_STEP_INTO_CMD = new REPLRemoteCommand("call-step-into", "calls", "Call a method/function and step into"){
        private final String[] help = new String[]{"call <name> <args>: calls function by name and step into"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            REPLMessage request = CALL_CMD.createRequest(context, args);
            if (request != null) {
                request.put("step-into", "true");
            }
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            CALL_CMD.processReply(context, replies);
        }
    };
    public static final REPLRemoteCommand CLEAR_BREAK_CMD = new REPLRemoteCommand("clear", null, "Clear a breakpoint"){
        private final String[] help = new String[]{"clear <n>: clear breakpoint number <n>"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (args.length == 1) {
                context.displayFailReply("breakpoint number not speciified:  \"break <n>\"");
            } else if (args.length > 2) {
                context.displayFailReply("breakpoint number not understood:  \"break <n>\"");
            } else {
                try {
                    int breakpointNumber = Integer.parseInt(args[1]);
                    REPLMessage request = new REPLMessage();
                    request.put("op", "clear-breakpoint");
                    request.put("breakpoint-id", Integer.toString(breakpointNumber));
                    return request;
                }
                catch (IllegalArgumentException ex) {
                    context.displayFailReply(ex.getMessage());
                }
            }
            return null;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("succeeded")) {
                int breakpointNumber = firstReply.getIntValue("breakpoint-id");
                firstReply.put("displayable-message", "breakpoint " + breakpointNumber + " cleared");
            }
            super.processReply(context, replies);
        }
    };
    public static final REPLRemoteCommand CONDITION_BREAK_CMD = new REPLRemoteCommand("cond", null, "Set new condition on a breakpoint"){
        private final String[] help = new String[]{"cond <n> [expr]: sets new condition on breakpoint number <n>; make unconditional if no [expr]"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (args.length == 1) {
                context.displayFailReply("breakpoint number not speciified:  \"cond <n>\"");
            } else {
                try {
                    int breakpointNumber = Integer.parseInt(args[1]);
                    REPLMessage request = new REPLMessage();
                    request.put("breakpoint-id", Integer.toString(breakpointNumber));
                    if (args.length == 2) {
                        request.put("op", "unset-breakpoint-condition");
                    } else {
                        StringBuilder exprBuilder = new StringBuilder();
                        for (int i = 2; i < args.length; ++i) {
                            exprBuilder.append(args[i]).append(" ");
                        }
                        request.put("breakpoint-condition", exprBuilder.toString().trim());
                        request.put("op", "set-breakpoint-condition");
                    }
                    return request;
                }
                catch (IllegalArgumentException ex) {
                    context.displayFailReply(ex.getMessage());
                }
            }
            return null;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("succeeded")) {
                int breakpointNumber = firstReply.getIntValue("breakpoint-id");
                String condition = firstReply.get("breakpoint-condition");
                if (condition == null) {
                    firstReply.put("displayable-message", "breakpoint " + breakpointNumber + " condition cleared");
                } else {
                    firstReply.put("displayable-message", "breakpoint " + breakpointNumber + " condition=\"" + condition + "\"");
                }
            }
            super.processReply(context, replies);
        }
    };
    public static final REPLRemoteCommand CONTINUE_CMD = new REPLRemoteCommand("continue", "c", "Continue execution"){

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (context.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "continue");
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            throw new REPLContinueException();
        }
    };
    public static final REPLRemoteCommand DELETE_CMD = new REPLRemoteCommand("delete", "d", "Delete all breakpoints"){

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            REPLMessage request = new REPLMessage();
            request.put("op", "delete-breakpoint");
            return request;
        }
    };
    public static final REPLRemoteCommand DISABLE_CMD = new REPLRemoteCommand("disable", null, "Disable a breakpoint"){
        private final String[] help = new String[]{"disable <n>: disable breakpoint number <n>"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (args.length == 1) {
                context.displayFailReply("breakpoint number not speciified:  \"disable <n>\"");
            } else if (args.length > 2) {
                context.displayFailReply("breakpoint number not understood:  \"disable <n>\"");
            } else {
                try {
                    int breakpointNumber = Integer.parseInt(args[1]);
                    REPLMessage request = new REPLMessage();
                    request.put("op", "disable-breakpoint");
                    request.put("breakpoint-id", Integer.toString(breakpointNumber));
                    return request;
                }
                catch (IllegalArgumentException ex) {
                    context.displayFailReply(ex.getMessage());
                }
            }
            return null;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("succeeded")) {
                int breakpointNumber = firstReply.getIntValue("breakpoint-id");
                firstReply.put("displayable-message", "breakpoint " + breakpointNumber + " disabled");
            }
            super.processReply(context, replies);
        }
    };
    public static final REPLRemoteCommand DOWN_CMD = new REPLRemoteCommand("down", null, "Move down a stack frame"){

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (context.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            List<REPLFrame> frames = context.frames();
            int newFrameSelection = context.getSelectedFrameNumber() + 1;
            if (newFrameSelection > frames.size() - 1) {
                context.displayFailReply("at bottom of stack");
                return null;
            }
            context.selectFrameNumber(newFrameSelection);
            return FRAME_CMD.createRequest(context, Arrays.copyOfRange(args, 0, 0));
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("failed")) {
                String result = firstReply.get("displayable-message");
                context.displayFailReply(result != null ? result : firstReply.toString());
            } else {
                context.displayStack();
            }
        }
    };
    public static final REPLRemoteCommand ENABLE_CMD = new REPLRemoteCommand("enable", null, "Enable a breakpoint"){
        private final String[] help = new String[]{"enable <n>: enable breakpoint number <n>"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (args.length == 1) {
                context.displayFailReply("breakpoint number not speciified:  \"enable <n>\"");
            } else if (args.length > 2) {
                context.displayFailReply("breakpoint number not understood:  \"enable <n>\"");
            } else {
                try {
                    int breakpointNumber = Integer.parseInt(args[1]);
                    REPLMessage request = new REPLMessage();
                    request.put("op", "enable-breakpoint");
                    request.put("breakpoint-id", Integer.toString(breakpointNumber));
                    return request;
                }
                catch (IllegalArgumentException ex) {
                    context.displayFailReply(ex.getMessage());
                }
            }
            return null;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("succeeded")) {
                int breakpointNumber = firstReply.getIntValue("breakpoint-id");
                firstReply.put("displayable-message", "breakpoint " + breakpointNumber + " enabled");
            }
            super.processReply(context, replies);
        }
    };
    public static final REPLRemoteCommand EVAL_CMD = new REPLRemoteCommand("eval", null, "Evaluate a string, in context of the current frame if any"){
        private int evalCounter = 0;
        private final String[] help = new String[]{"eval <string>: evaluate <string> in context of the current frame if any"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            String code;
            if (args.length > 1 && !(code = args[1]).isEmpty()) {
                String fakeFileName = "<eval" + ++this.evalCounter + ">";
                Source.fromNamedText((CharSequence)fakeFileName, (String)code);
                REPLMessage request = new REPLMessage();
                request.put("op", "eval");
                request.put("code", code);
                request.put("source-name", fakeFileName);
                if (context.level() > 0) {
                    request.put("frame-number", Integer.toString(context.getSelectedFrameNumber()));
                }
                return request;
            }
            return null;
        }
    };
    public static final REPLRemoteCommand EVAL_STEP_INTO_CMD = new REPLRemoteCommand("eval-step-into", "evals", "Evaluate and step into a string, in context of the current frame if any"){
        private final String[] help = new String[]{"eval-step-into <string>: evaluate <string> in context of the current frame if any, and step into"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            REPLMessage request = EVAL_CMD.createRequest(context, args);
            if (request != null) {
                request.put("step-into", "true");
            }
            return request;
        }
    };
    public static final REPLRemoteCommand FRAME_CMD = new REPLRemoteCommand("frame", null, "Display a stack frame"){
        private final String[] help = new String[]{"frame : display currently selected frame", "frame <n> : display frame <n>"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (context.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "frame");
            int frameNumber = context.getSelectedFrameNumber();
            if (args.length > 1) {
                if (args.length == 2) {
                    try {
                        frameNumber = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Unrecognized argument \"" + args[1] + "\"");
                    }
                } else {
                    throw new IllegalArgumentException("Unrecognized argument \"" + args[2] + "\"");
                }
            }
            request.put("frame-number", Integer.toString(frameNumber));
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            if (replies[0].get("status").equals("failed")) {
                context.displayFailReply(replies[0].get("displayable-message"));
            } else {
                Integer frameNumber = replies[0].getIntValue("frame-number");
                context.selectFrameNumber(frameNumber);
                if (replies[0].get("slot-index") == null) {
                    context.displayReply("Frame " + frameNumber + ": <empty");
                } else {
                    context.displayReply("Frame " + frameNumber + ":");
                    for (REPLMessage message : replies) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("#" + message.get("slot-index") + ": ");
                        sb.append(message.get("slot-identifier") + " = ");
                        sb.append(message.get("slot-value"));
                        context.displayInfo(sb.toString());
                    }
                }
            }
        }
    };
    public static final REPLRemoteCommand KILL_CMD = new REPLRemoteCommand("kill", null, "Stop program execution"){

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (context.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "kill");
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            if (replies[0].get("status").equals("succeeded")) {
                context.notifyKilled();
            } else {
                context.displayFailReply(replies[0].get("displayable-message"));
            }
            throw new REPLContinueException();
        }
    };
    public static final REPLRemoteCommand LOAD_CMD = new REPLRemoteCommand("load", null, "Load source"){
        private final String[] help = new String[]{"load : load currently selected file source", "load <file name> : load file <file name>"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            Source runSource = null;
            if (args.length == 1) {
                runSource = context.getSelectedSource();
                if (runSource == null) {
                    context.displayFailReply("No file selected");
                    return null;
                }
            } else {
                try {
                    File file = new File(args[1]);
                    if (!file.canRead()) {
                        context.displayFailReply("Can't read file: " + args[1]);
                        return null;
                    }
                    String path = file.getCanonicalPath();
                    runSource = Source.newBuilder((File)new File(path)).build();
                }
                catch (IOException e) {
                    context.displayFailReply("Can't find file: " + args[1]);
                    return null;
                }
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "load-source");
            request.put("source-name", runSource.getPath());
            return request;
        }
    };
    public static final REPLRemoteCommand LOAD_STEP_INTO_CMD = new REPLRemoteCommand("load-step-into", "loads", "Load source and step in"){
        private final String[] help = new String[]{"load : load currently selected file source and step in", "load <file name> : load file <file name> and step in"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            REPLMessage request = LOAD_CMD.createRequest(context, args);
            if (request != null) {
                request.put("step-into", "true");
            }
            return request;
        }
    };
    public static final REPLRemoteCommand SET_LANG_CMD = new REPLRemoteCommand("language", "lang", "Set current language"){
        private final String[] help = new String[]{"lang <language short name>:  set default language, \"info lang\" displays choices"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            REPLMessage request = new REPLMessage();
            request.put("op", "set-language");
            if (args.length > 1) {
                request.put("language-name", args[1]);
            }
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            context.updatePrompt();
            super.processReply(context, replies);
        }
    };
    public static final REPLRemoteCommand STEP_INTO_CMD = new REPLRemoteCommand("step", "s", "(StepInto) next statement, going into functions."){
        private final String[] help = new String[]{"step:  (StepInto) next statement (into calls)", "step <n>: (StepInto) nth next statement (into calls)"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (context.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "step-into");
            if (args.length >= 2) {
                String nText = args[1];
                try {
                    int nSteps = Integer.parseInt(nText);
                    if (nSteps <= 0) {
                        return null;
                    }
                    request.put("repeat", Integer.toString(nSteps));
                }
                catch (NumberFormatException e) {
                    context.displayFailReply("Count \"" + nText + "\" not recognized");
                    return null;
                }
            }
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            throw new REPLContinueException();
        }
    };
    public static final REPLRemoteCommand STEP_OUT_CMD = new REPLRemoteCommand("finish", null, "(StepOut) return from function"){

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (context.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "step-out");
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            throw new REPLContinueException();
        }
    };
    public static final REPLRemoteCommand STEP_OVER_CMD = new REPLRemoteCommand("next", "n", "(StepOver) execute next line of code, not into functions."){
        private final String[] help = new String[]{"next:  (StepOver) execute next line of code, not into functions.", "next <n>: (StepOver) execute to nth next statement (not counting into functions)"};

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (context.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "step-over");
            if (args.length >= 2) {
                String nText = args[1];
                try {
                    int nSteps = Integer.parseInt(nText);
                    if (nSteps <= 0) {
                        return null;
                    }
                    request.put("repeat", Integer.toString(nSteps));
                }
                catch (NumberFormatException e) {
                    context.displayFailReply("Next count \"" + nText + "\" not recognized");
                    return null;
                }
            }
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            throw new REPLContinueException();
        }
    };
    public static final REPLRemoteCommand UP_CMD = new REPLRemoteCommand("up", null, "Move up a stack frame"){

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (context.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            int newFrameSelection = context.getSelectedFrameNumber() - 1;
            if (newFrameSelection < 0) {
                context.displayFailReply("at top of stack");
                return null;
            }
            context.selectFrameNumber(newFrameSelection);
            return FRAME_CMD.createRequest(context, Arrays.copyOfRange(args, 0, 0));
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("failed")) {
                String result = firstReply.get("displayable-message");
                context.displayFailReply(result != null ? result : firstReply.toString());
            } else {
                context.displayStack();
            }
        }
    };

    public REPLRemoteCommand(String command, String abbreviation, String description) {
        super(command, abbreviation, description);
    }

    protected abstract REPLMessage createRequest(REPLClientContext var1, String[] var2);

    void processReply(REPLClientContext context, REPLMessage[] replies) {
        String result;
        REPLMessage firstReply = replies[0];
        if (firstReply.get("status").equals("failed")) {
            result = firstReply.get("displayable-message");
            context.displayFailReply(result != null ? result : firstReply.toString());
        } else {
            result = firstReply.get("displayable-message");
            context.displayReply(result != null ? result : firstReply.toString());
        }
        for (int i = 1; i < replies.length; ++i) {
            REPLMessage reply = replies[i];
            String result2 = reply.get("displayable-message");
            context.displayInfo(result2 != null ? result2 : reply.toString());
        }
    }
}

