/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.client;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.debug.shell.REPLMessage;
import com.oracle.truffle.tools.debug.shell.client.REPLClientContext;
import java.io.File;
import java.io.IOException;

final class REPLineLocation {
    private final Source source;
    private final int lineNumber;

    static REPLineLocation parse(REPLClientContext context, String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            throw new IllegalArgumentException("no location specified");
        }
        Source source = null;
        int lineNumber = -1;
        String lineNumberText = null;
        String[] split = args[1].split(":");
        if (split.length == 1) {
            lineNumberText = split[0];
            try {
                lineNumber = Integer.parseInt(lineNumberText);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("no line number specified");
            }
            Source selectedSource = context.getSelectedSource();
            if (selectedSource == null) {
                throw new IllegalArgumentException("no selected file set");
            }
            source = selectedSource;
        } else {
            String fileName = split[0];
            lineNumberText = split[1];
            try {
                File file = new File(fileName);
                if (!file.canRead()) {
                    throw new IllegalArgumentException("Can't read file " + fileName);
                }
                source = Source.newBuilder((File)file.getCanonicalFile()).build();
            }
            catch (IOException e1) {
                throw new IllegalArgumentException("Can't find file \"" + fileName + "\"");
            }
            try {
                lineNumber = Integer.parseInt(lineNumberText);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid line number \"" + lineNumberText + "\"");
            }
            if (lineNumber <= 0) {
                throw new IllegalArgumentException("Invalid line number \"" + lineNumberText + "\"");
            }
        }
        return new REPLineLocation(source, lineNumber);
    }

    REPLineLocation(Source source, int lineNumber) {
        this.source = source;
        this.lineNumber = lineNumber;
    }

    public Source getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public REPLMessage createMessage(String op) {
        REPLMessage msg = new REPLMessage("op", op);
        msg.put("source-name", this.source.getShortName());
        msg.put("path", this.source.getPath());
        msg.put("line-number", Integer.toString(this.lineNumber));
        return msg;
    }
}

