/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.server;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.ExecutionEvent;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.vm.EventConsumer;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.tools.debug.shell.REPLMessage;
import com.oracle.truffle.tools.debug.shell.client.SimpleREPLClient;
import com.oracle.truffle.tools.debug.shell.server.InstrumentationUtils;
import com.oracle.truffle.tools.debug.shell.server.REPLHandler;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;

public final class REPLServer {
    private static final String REPL_SERVER_INSTRUMENT = "REPLServer";
    private static final boolean TRACE = Boolean.getBoolean("truffle.debug.trace");
    private static final String TRACE_PREFIX = "REPLSrv: ";
    private static final PrintStream OUT = System.out;
    private static int nextBreakpointUID = 0;
    private final PolyglotEngine engine;
    private final Debugger db;
    private final SimpleREPLClient replClient;
    private final String statusPrefix;
    private final Map<String, REPLHandler> handlerMap = new HashMap<String, REPLHandler>();
    private final InstrumentationUtils.ASTPrinter astPrinter;
    private final InstrumentationUtils.LocationPrinter locationPrinter = new InstrumentationUtils.LocationPrinter();
    private final REPLVisualizer visualizer = new REPLVisualizer();
    private Context currentServerContext;
    private final TreeSet<PolyglotEngine.Language> engineLanguages = new TreeSet<PolyglotEngine.Language>(new Comparator<PolyglotEngine.Language>(){

        @Override
        public int compare(PolyglotEngine.Language lang1, PolyglotEngine.Language lang2) {
            return lang1.getName().compareTo(lang2.getName());
        }
    });
    private final Map<String, PolyglotEngine.Language> nameToLanguage = new TreeMap<String, PolyglotEngine.Language>(String.CASE_INSENSITIVE_ORDER);
    private final PolyglotEngine.Language defaultLanguage = null;
    private final Map<Integer, BreakpointInfo> breakpoints = new WeakHashMap<Integer, BreakpointInfo>();
    private final EventConsumer<SuspendedEvent> onHalted = new EventConsumer<SuspendedEvent>(SuspendedEvent.class){

        protected void on(SuspendedEvent ev) {
            if (TRACE) {
                REPLServer.trace("BEGIN onSuspendedEvent()", new Object[0]);
            }
            REPLServer.this.haltedAt(ev);
            if (TRACE) {
                REPLServer.trace("END onSuspendedEvent()", new Object[0]);
            }
        }
    };
    private final EventConsumer<ExecutionEvent> onExec = new EventConsumer<ExecutionEvent>(ExecutionEvent.class){

        protected void on(ExecutionEvent event) {
            if (TRACE) {
                REPLServer.trace("BEGIN onExecutionEvent()", new Object[0]);
            }
            if (REPLServer.this.currentServerContext.steppingInto) {
                event.prepareStepInto();
            }
            if (TRACE) {
                REPLServer.trace("END onExecutionEvent()", new Object[0]);
            }
        }
    };

    private static void trace(String format, Object ... args) {
        if (TRACE) {
            OUT.println(TRACE_PREFIX + String.format(format, args));
        }
    }

    public REPLServer(SimpleREPLClient client) {
        this.replClient = client;
        this.engine = PolyglotEngine.newBuilder().onEvent(this.onHalted).onEvent(this.onExec).build();
        ((PolyglotEngine.Instrument)this.engine.getInstruments().get(REPL_SERVER_INSTRUMENT)).setEnabled(true);
        this.db = Debugger.find((PolyglotEngine)this.engine);
        this.engineLanguages.addAll(this.engine.getLanguages().values());
        for (PolyglotEngine.Language language : this.engineLanguages) {
            this.nameToLanguage.put(language.getName().toLowerCase(), language);
        }
        this.astPrinter = new REPLASTPrinter(this.engine);
        this.statusPrefix = "";
    }

    public void add(REPLHandler handler) {
        this.handlerMap.put(handler.getOp(), handler);
    }

    public void start() {
        this.add(REPLHandler.BACKTRACE_HANDLER);
        this.add(REPLHandler.BREAK_AT_LINE_HANDLER);
        this.add(REPLHandler.BREAK_AT_LINE_ONCE_HANDLER);
        this.add(REPLHandler.BREAKPOINT_INFO_HANDLER);
        this.add(REPLHandler.CALL_HANDLER);
        this.add(REPLHandler.CLEAR_BREAK_HANDLER);
        this.add(REPLHandler.CONTINUE_HANDLER);
        this.add(REPLHandler.DELETE_HANDLER);
        this.add(REPLHandler.DISABLE_BREAK_HANDLER);
        this.add(REPLHandler.ENABLE_BREAK_HANDLER);
        this.add(REPLHandler.EVAL_HANDLER);
        this.add(REPLHandler.FILE_HANDLER);
        this.add(REPLHandler.FRAME_HANDLER);
        this.add(REPLHandler.INFO_HANDLER);
        this.add(REPLHandler.KILL_HANDLER);
        this.add(REPLHandler.LOAD_HANDLER);
        this.add(REPLHandler.SET_BREAK_CONDITION_HANDLER);
        this.add(REPLHandler.SET_LANGUAGE_HANDLER);
        this.add(REPLHandler.STEP_INTO_HANDLER);
        this.add(REPLHandler.STEP_OUT_HANDLER);
        this.add(REPLHandler.STEP_OVER_HANDLER);
        this.add(REPLHandler.TRUFFLE_HANDLER);
        this.add(REPLHandler.TRUFFLE_NODE_HANDLER);
        this.add(REPLHandler.UNSET_BREAK_CONDITION_HANDLER);
        this.currentServerContext = new Context(null, null, this.defaultLanguage);
    }

    public String getWelcome() {
        return "GraalVM Polyglot Debugger 0.9\nCopyright (c) 2013-6, Oracle and/or its affiliates";
    }

    public InstrumentationUtils.ASTPrinter getASTPrinter() {
        return this.astPrinter;
    }

    public InstrumentationUtils.LocationPrinter getLocationPrinter() {
        return this.locationPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void haltedAt(SuspendedEvent event) {
        REPLMessage message = new REPLMessage();
        message.put("op", "stopped");
        PolyglotEngine.Language haltedLanguage = this.currentServerContext.currentLanguage;
        String mimeType = this.findMime(event.getNode());
        if (mimeType == null) {
            message.put("warnings", "unable to detect language at halt");
        } else {
            PolyglotEngine.Language language = (PolyglotEngine.Language)this.engine.getLanguages().get(mimeType);
            if (language == null) {
                message.put("warnings", "no language installed for MIME type \"" + mimeType + "\"");
            } else {
                haltedLanguage = language;
            }
        }
        this.currentServerContext = new Context(this.currentServerContext, event, haltedLanguage);
        message.put("language-name", haltedLanguage.getName());
        SourceSection src = event.getNode().getSourceSection();
        Source source = src.getSource();
        message.put("source-name", source.getName());
        String path = source.getPath();
        if (path == null) {
            message.put("source-text", source.getCode());
        } else {
            message.put("path", path);
        }
        message.put("line-number", Integer.toString(src.getStartLine()));
        message.put("status", "succeeded");
        message.put("debug-level", Integer.toString(this.currentServerContext.getLevel()));
        List warnings = event.getRecentWarnings();
        if (!warnings.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String warning : warnings) {
                sb.append(warning + "\n");
            }
            message.put("warnings", sb.toString());
        }
        try {
            this.replClient.halted(message);
        }
        finally {
            this.currentServerContext = this.currentServerContext.predecessor;
        }
    }

    private String findMime(Node node) {
        Source source;
        String result = null;
        SourceSection section = node.getEncapsulatingSourceSection();
        if (section != null && (source = section.getSource()) != null) {
            result = source.getMimeType();
        }
        return result;
    }

    public REPLMessage[] receive(REPLMessage request) {
        if (this.currentServerContext == null) {
            REPLMessage message = new REPLMessage();
            message.put("status", "failed");
            message.put("displayable-message", "server not started");
            REPLMessage[] reply = new REPLMessage[]{message};
            return reply;
        }
        return this.currentServerContext.receive(request);
    }

    Context getCurrentContext() {
        return this.currentServerContext;
    }

    PolyglotEngine.Language getLanguage() {
        return this.defaultLanguage;
    }

    TreeSet<PolyglotEngine.Language> getLanguages() {
        return this.engineLanguages;
    }

    public String getLanguageName() {
        return REPLServer.languageName(this.defaultLanguage);
    }

    private static String languageName(PolyglotEngine.Language lang) {
        return lang.getName() + "(" + lang.getVersion() + ")";
    }

    private String defaultMIME(PolyglotEngine.Language language) {
        return (String)language.getMimeTypes().iterator().next();
    }

    BreakpointInfo setLineBreakpoint(int ignoreCount, LineLocation lineLocation, boolean oneShot) throws IOException {
        LineBreakpointInfo info = new LineBreakpointInfo(lineLocation, ignoreCount, oneShot);
        ((BreakpointInfo)info).activate();
        return info;
    }

    synchronized BreakpointInfo findBreakpoint(int id) {
        return this.breakpoints.get(id);
    }

    Collection<BreakpointInfo> getBreakpoints() {
        return new ArrayList<BreakpointInfo>(this.breakpoints.values());
    }

    protected static String trim(String text, int trim) {
        if (trim == 0) {
            return text;
        }
        String[] lines = text.split("\n");
        String result = lines[0];
        if (lines.length == 1) {
            if (result.length() <= trim) {
                return result;
            }
            if (trim <= 3) {
                return result.substring(0, Math.min(result.length() - 1, trim - 1));
            }
            return result.substring(0, trim - 4) + "...";
        }
        return (result.length() < trim - 3 ? result : result.substring(0, trim - 4)) + "...";
    }

    private static class REPLASTPrinter
    extends InstrumentationUtils.ASTPrinter {
        private final Instrumenter instrumenter;

        REPLASTPrinter(PolyglotEngine engine) {
            this.instrumenter = (Instrumenter)((PolyglotEngine.Instrument)engine.getInstruments().get(REPLServer.REPL_SERVER_INSTRUMENT)).lookup(Instrumenter.class);
        }

        @Override
        protected String displayTags(Object objectNode) {
            Node node;
            SourceSection sourceSection;
            if (objectNode instanceof Node && (sourceSection = (node = (Node)objectNode).getSourceSection()) != null) {
                StringBuilder sb = new StringBuilder("[");
                String sep = "";
                for (Class tag : this.instrumenter.queryTags(node)) {
                    sb.append(sep).append(tag.getSimpleName());
                    sep = ",";
                }
                sb.append("]");
                return sb.toString();
            }
            return "";
        }
    }

    static class REPLVisualizer {
        REPLVisualizer() {
        }

        String displaySourceLocation(Node node) {
            if (node == null) {
                return "<unknown>";
            }
            SourceSection section = node.getSourceSection();
            boolean estimated = false;
            if (section == null) {
                section = node.getEncapsulatingSourceSection();
                estimated = true;
            }
            if (section == null) {
                return "<error: source location>";
            }
            return section.getShortDescription() + (estimated ? "~" : "");
        }

        String displayMethodName(Node node) {
            if (node == null) {
                return null;
            }
            RootNode root = node.getRootNode();
            if (root != null && root.getName() != null) {
                return root.getName();
            }
            return "??";
        }

        String displayCallTargetName(CallTarget callTarget) {
            return callTarget.toString();
        }

        String displayValue(Object value, int trim) {
            if (value == null) {
                return "<empty>";
            }
            return REPLServer.trim(value.toString(), trim);
        }

        String displayIdentifier(FrameSlot slot) {
            return slot.getIdentifier().toString();
        }
    }

    abstract class BreakpointInfo {
        protected final int uid;
        protected final boolean oneShot;
        protected final int ignoreCount;
        protected Breakpoint.State state = Breakpoint.State.ENABLED_UNRESOLVED;
        protected Breakpoint breakpoint;
        protected Source conditionSource;

        protected BreakpointInfo(int ignoreCount, boolean oneShot) {
            this.ignoreCount = ignoreCount;
            this.oneShot = oneShot;
            this.uid = nextBreakpointUID++;
        }

        protected abstract void activate() throws IOException;

        abstract String describeLocation();

        int getID() {
            return this.uid;
        }

        String describeState() {
            return (this.breakpoint == null ? this.state : this.breakpoint.getState()).getName();
        }

        void setEnabled(boolean enabled) {
            block8: {
                block7: {
                    if (this.breakpoint != null) break block7;
                    switch (this.state) {
                        case ENABLED_UNRESOLVED: {
                            if (!enabled) {
                                this.state = Breakpoint.State.DISABLED_UNRESOLVED;
                            }
                            break block8;
                        }
                        case DISABLED_UNRESOLVED: {
                            if (enabled) {
                                this.state = Breakpoint.State.ENABLED_UNRESOLVED;
                            }
                            break block8;
                        }
                        case DISPOSED: {
                            throw new IllegalStateException("Disposed breakpoints must stay disposed");
                        }
                        default: {
                            throw new IllegalStateException("Unexpected breakpoint state");
                        }
                    }
                }
                this.breakpoint.setEnabled(enabled);
            }
        }

        boolean isEnabled() {
            return this.breakpoint == null ? this.state == Breakpoint.State.ENABLED_UNRESOLVED : this.breakpoint.isEnabled();
        }

        void setCondition(String expr) throws IOException {
            if (this.breakpoint == null) {
                this.conditionSource = expr == null ? null : Source.newBuilder((String)expr).name("breakpoint condition from text: " + expr).mimeType("content/unknown").build();
            } else {
                this.breakpoint.setCondition(expr);
            }
        }

        String getCondition() {
            Source source = this.breakpoint == null ? this.conditionSource : this.breakpoint.getCondition();
            return source == null ? null : source.getCode();
        }

        int getIgnoreCount() {
            return this.breakpoint == null ? this.ignoreCount : this.breakpoint.getIgnoreCount();
        }

        int getHitCount() {
            return this.breakpoint == null ? 0 : this.breakpoint.getHitCount();
        }

        void dispose() {
            if (this.breakpoint == null) {
                if (this.state == Breakpoint.State.DISPOSED) {
                    throw new IllegalStateException("Breakpoint already disposed");
                }
            } else {
                this.breakpoint.dispose();
                this.breakpoint = null;
            }
            this.state = Breakpoint.State.DISPOSED;
            REPLServer.this.breakpoints.remove(this.uid);
            this.conditionSource = null;
        }

        String summarize() {
            StringBuilder sb = new StringBuilder("Breakpoint");
            sb.append(" id=" + this.uid);
            sb.append(" locn=(" + this.describeLocation());
            sb.append(") " + this.describeState());
            return sb.toString();
        }
    }

    final class LineBreakpointInfo
    extends BreakpointInfo {
        private final LineLocation lineLocation;

        private LineBreakpointInfo(LineLocation lineLocation, int ignoreCount, boolean oneShot) {
            super(ignoreCount, oneShot);
            this.lineLocation = lineLocation;
        }

        @Override
        protected void activate() throws IOException {
            this.breakpoint = REPLServer.this.db.setLineBreakpoint(this.ignoreCount, this.lineLocation, this.oneShot);
            REPLServer.this.breakpoints.put(this.uid, this);
        }

        @Override
        String describeLocation() {
            if (this.breakpoint == null) {
                return "Line: " + this.lineLocation.getShortDescription();
            }
            return this.breakpoint.getLocationDescription();
        }
    }

    public static final class REPLServerInstrument
    extends TruffleInstrument {
        protected void onCreate(TruffleInstrument.Env env) {
            env.registerService((Object)env.getInstrumenter());
        }
    }

    public final class Context {
        private final Context predecessor;
        private final int level;
        private final SuspendedEvent event;
        private PolyglotEngine.Language currentLanguage;
        private boolean steppingInto = false;

        Context(Context predecessor, SuspendedEvent event, PolyglotEngine.Language language) {
            this.level = predecessor == null ? 0 : predecessor.getLevel() + 1;
            this.predecessor = predecessor;
            this.event = event;
            this.currentLanguage = language;
        }

        int getLevel() {
            return this.level;
        }

        Node getNodeAtHalt() {
            return this.event.getNode();
        }

        REPLVisualizer getVisualizer() {
            return REPLServer.this.visualizer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object call(String name, boolean stepInto, List<String> argList) throws IOException {
            PolyglotEngine.Value symbol = REPLServer.this.engine.findGlobalSymbol(name);
            if (symbol == null) {
                throw new IOException("symbol \"" + name + "\" not found");
            }
            ArrayList<Object> args = new ArrayList<Object>();
            for (String stringArg : argList) {
                Integer intArg = null;
                try {
                    intArg = Integer.valueOf(stringArg);
                    args.add(intArg);
                }
                catch (NumberFormatException e) {
                    args.add(stringArg);
                }
            }
            this.steppingInto = stepInto;
            try {
                Object object = symbol.execute(args.toArray(new Object[0])).get();
                return object;
            }
            finally {
                this.steppingInto = false;
            }
        }

        void eval(Source source, boolean stepInto) {
            this.steppingInto = stepInto;
            try {
                REPLServer.this.engine.eval(source);
            }
            finally {
                this.steppingInto = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object eval(String code, Integer frameNumber, boolean stepInto) throws IOException {
            if (this.event == null) {
                if (frameNumber != null) {
                    throw new IllegalStateException("Frame number requires a halted execution");
                }
                if (this.currentLanguage == null) {
                    throw new IOException("No language set");
                }
                this.steppingInto = stepInto;
                String mimeType = REPLServer.this.defaultMIME(this.currentLanguage);
                try {
                    Object object = REPLServer.this.engine.eval(Source.newBuilder((String)code).name("eval(\"" + code + "\")").mimeType(mimeType).build()).get();
                    return object;
                }
                finally {
                    this.steppingInto = false;
                }
            }
            if (frameNumber == null) {
                throw new IllegalStateException("Eval in halted context requires a frame number");
            }
            if (stepInto) {
                this.event.prepareStepInto(1);
            }
            try {
                FrameInstance frameInstance = frameNumber == 0 ? null : (FrameInstance)this.event.getStack().get(frameNumber);
                Object result = this.event.eval(code, frameInstance);
                Object object = result instanceof PolyglotEngine.Value ? ((PolyglotEngine.Value)result).get() : result;
                return object;
            }
            finally {
                this.event.prepareContinue();
            }
        }

        public String displayValue(Integer frameNumber, Object value, int trim) {
            if (frameNumber == null) {
                throw new IllegalStateException("displayValue in halted context requires a frame number");
            }
            if (value == null) {
                return "<empty>";
            }
            return REPLServer.trim(this.event.toString(value, (FrameInstance)this.event.getStack().get(frameNumber)), trim);
        }

        MaterializedFrame getFrameAtHalt() {
            return this.event.getFrame();
        }

        REPLMessage[] receive(REPLMessage request) {
            String command = request.get("op");
            REPLHandler handler = (REPLHandler)REPLServer.this.handlerMap.get(command);
            if (handler == null) {
                REPLMessage message = new REPLMessage();
                message.put("op", command);
                message.put("status", "failed");
                message.put("displayable-message", REPLServer.this.statusPrefix + " op \"" + command + "\" not supported");
                REPLMessage[] reply = new REPLMessage[]{message};
                return reply;
            }
            return handler.receive(request, REPLServer.this);
        }

        Node getNode() {
            return this.event.getNode();
        }

        MaterializedFrame getFrame() {
            return this.event.getFrame();
        }

        List<FrameInstance> getStack() {
            return this.event.getStack();
        }

        public String getLanguageName() {
            return this.currentLanguage == null ? null : this.currentLanguage.getName();
        }

        String setLanguage(String name) throws IOException {
            assert (name != null);
            PolyglotEngine.Language language = (PolyglotEngine.Language)REPLServer.this.nameToLanguage.get(name.toLowerCase());
            if (language == null) {
                throw new IOException("Language \"" + name + "\" not supported");
            }
            if (language == this.currentLanguage) {
                return this.currentLanguage.getName();
            }
            if (this.event != null) {
                throw new IOException("Only supported at top level");
            }
            this.currentLanguage = language;
            return language.getName();
        }

        void prepareStepOut() {
            this.event.prepareStepOut();
        }

        void prepareStepInto(int repeat) {
            this.event.prepareStepInto(repeat);
        }

        void prepareStepOver(int repeat) {
            this.event.prepareStepOver(repeat);
        }

        void prepareContinue() {
            this.event.prepareContinue();
        }

        void kill() {
            this.event.prepareKill();
        }
    }
}

