/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.server;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

final class InstrumentationUtils {
    private InstrumentationUtils() {
    }

    static String getShortDescription(SourceSection sourceSection) {
        StringBuilder b = new StringBuilder();
        b.append(sourceSection.getSource().getName());
        b.append(":");
        if (sourceSection.getStartLine() == sourceSection.getEndLine()) {
            b.append(sourceSection.getStartLine());
        } else {
            b.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        return b.toString();
    }

    static class LocationPrinter {
        LocationPrinter() {
        }

        public String displaySourceLocation(Node node) {
            if (node == null) {
                return "<unknown>";
            }
            SourceSection section = node.getSourceSection();
            boolean estimated = false;
            if (section == null) {
                section = node.getEncapsulatingSourceSection();
                estimated = true;
            }
            if (section == null) {
                return "<unknown source location>";
            }
            return InstrumentationUtils.getShortDescription(section) + (estimated ? "~" : "");
        }
    }
}

