/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.server;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.tools.debug.shell.REPLMessage;
import com.oracle.truffle.tools.debug.shell.server.InstrumentationUtils;
import com.oracle.truffle.tools.debug.shell.server.REPLServer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

@Deprecated
public abstract class REPLHandler {
    private final String op;
    public static final REPLHandler BACKTRACE_HANDLER = new REPLHandler("backtrace"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler BREAK_AT_LINE_HANDLER = new REPLHandler("break-at-line"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler BREAK_AT_LINE_ONCE_HANDLER = new REPLHandler("break-at-line-once"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler BREAKPOINT_INFO_HANDLER = new REPLHandler("breakpoint-info"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler CALL_HANDLER = new REPLHandler("call"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            String arg;
            REPLMessage reply = new REPLMessage("op", "call");
            String callName = request.get("call-name");
            if (callName == null) {
                return 5.finishReplyFailed(reply, "no name specified");
            }
            ArrayList<String> argList = new ArrayList<String>();
            for (int argCount = 0; argCount < REPLMessage.ARG_NAMES.length && (arg = request.get(REPLMessage.ARG_NAMES[argCount])) != null; ++argCount) {
                argList.add(arg);
            }
            boolean stepInto = "true".equals(request.get("step-into"));
            try {
                Object result = replServer.getCurrentContext().call(callName, stepInto, argList);
                reply.put("value", result == null ? "<void>" : result.toString());
            }
            catch (Exception ex) {
                return 5.finishReplyFailed(reply, ex);
            }
            return 5.finishReplySucceeded(reply, callName + " returned");
        }
    };
    public static final REPLHandler CLEAR_BREAK_HANDLER = new REPLHandler("clear-breakpoint"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler CONTINUE_HANDLER = new REPLHandler("continue"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            replServer.getCurrentContext().prepareContinue();
            return 7.finishReplySucceeded(reply, "Continue mode entered");
        }
    };
    public static final REPLHandler DELETE_HANDLER = new REPLHandler("delete-breakpoint"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler DISABLE_BREAK_HANDLER = new REPLHandler("disable-breakpoint"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler ENABLE_BREAK_HANDLER = new REPLHandler("enable-breakpoint"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler EVAL_HANDLER = new REPLHandler("eval"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler FILE_HANDLER = new REPLHandler("file"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            String fileName = request.get("source-name");
            if (fileName == null) {
                return 12.finishReplyFailed(reply, "no file specified");
            }
            reply.put("source-name", fileName);
            try {
                Source source = Source.newBuilder((File)new File(fileName)).build();
                if (source == null) {
                    return 12.finishReplyFailed(reply, "file \"" + fileName + "\" not found");
                }
                reply.put("path", source.getPath());
                reply.put("code", source.getCode());
                return 12.finishReplySucceeded(reply, "file found");
            }
            catch (IOException ex) {
                return 12.finishReplyFailed(reply, "can't read file \"" + fileName + "\"");
            }
            catch (Exception ex) {
                return 12.finishReplyFailed(reply, ex);
            }
        }
    };
    public static final REPLHandler FRAME_HANDLER = new REPLHandler("frame"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler INFO_HANDLER = new REPLHandler("info"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            String topic = request.get("topic");
            if (topic == null || topic.isEmpty()) {
                REPLMessage message = new REPLMessage("op", "info");
                return 14.finishReplyFailed(message, "No info topic specified");
            }
            switch (topic) {
                case "info-supported-languages": {
                    ArrayList<REPLMessage> langMessages = new ArrayList<REPLMessage>();
                    for (PolyglotEngine.Language language : replServer.getLanguages()) {
                        REPLMessage infoMessage = new REPLMessage("op", "info");
                        infoMessage.put("topic", "info-supported-languages");
                        infoMessage.put("language-name", language.getName());
                        infoMessage.put("language-version", language.getVersion());
                        infoMessage.put("status", "succeeded");
                        langMessages.add(infoMessage);
                    }
                    return langMessages.toArray(new REPLMessage[0]);
                }
                case "info-current-language": {
                    REPLMessage reply = new REPLMessage("op", "info");
                    reply.put("topic", "info-current-language");
                    String languageName = replServer.getCurrentContext().getLanguageName();
                    reply.put("language-name", languageName);
                    return 14.finishReplySucceeded(reply, languageName);
                }
                case "welcome-message": {
                    REPLMessage infoMessage = new REPLMessage("op", "info");
                    infoMessage.put("topic", "welcome-message");
                    infoMessage.put("info-value", replServer.getWelcome());
                    infoMessage.put("status", "succeeded");
                    return 14.finishReplySucceeded(infoMessage, "welcome");
                }
            }
            REPLMessage message = new REPLMessage("op", "info");
            return 14.finishReplyFailed(message, "No info about topic \"" + topic + "\"");
        }
    };
    public static final REPLHandler KILL_HANDLER = new REPLHandler("kill"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = new REPLMessage("op", "kill");
            if (replServer.getCurrentContext().getLevel() == 0) {
                return 15.finishReplyFailed(reply, "nothing to kill");
            }
            replServer.getCurrentContext().kill();
            return 15.finishReplySucceeded(reply, "execution killed");
        }
    };
    public static final REPLHandler LOAD_HANDLER = new REPLHandler("load-source"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = new REPLMessage("op", "load-source");
            String fileName = request.get("source-name");
            boolean stepInto = "true".equals(request.get("step-into"));
            try {
                Source fileSource = Source.newBuilder((File)new File(fileName)).build();
                replServer.getCurrentContext().eval(fileSource, stepInto);
                reply.put("path", fileName);
                return 16.finishReplySucceeded(reply, fileName + "  loaded");
            }
            catch (Exception ex) {
                return 16.finishReplyFailed(reply, ex);
            }
        }
    };
    public static final REPLHandler SET_LANGUAGE_HANDLER = new REPLHandler("set-language"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = new REPLMessage("op", "set-language");
            String languageName = request.get("language-name");
            if (languageName == null) {
                String oldLanguageName = replServer.getCurrentContext().getLanguageName();
                reply.put("language-name", reply.put("language-name", oldLanguageName));
                return 17.finishReplySucceeded(reply, "Language set to " + oldLanguageName);
            }
            reply.put("language-name", languageName);
            try {
                String newLanguageName = replServer.getCurrentContext().setLanguage(languageName);
                if (newLanguageName != null) {
                    return 17.finishReplySucceeded(reply, "Language set to " + newLanguageName);
                }
            }
            catch (Exception ex) {
                return 17.finishReplyFailed(reply, ex);
            }
            return 17.finishReplyFailed(reply, "Language \"" + languageName + "\" not supported");
        }
    };
    public static final REPLHandler SET_BREAK_CONDITION_HANDLER = new REPLHandler("set-breakpoint-condition"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };
    public static final REPLHandler STEP_INTO_HANDLER = new REPLHandler("step-into"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            Integer repeat = request.getIntValue("repeat");
            if (repeat == null) {
                repeat = 1;
            }
            String countMessage = repeat == 1 ? "" : "<" + repeat + ">";
            replServer.getCurrentContext().prepareStepInto(repeat);
            return 19.finishReplySucceeded(reply, "StepInto " + countMessage + " enabled");
        }
    };
    public static final REPLHandler STEP_OUT_HANDLER = new REPLHandler("step-out"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            replServer.getCurrentContext().prepareStepOut();
            return 20.finishReplySucceeded(reply, "StepOut enabled");
        }
    };
    public static final REPLHandler STEP_OVER_HANDLER = new REPLHandler("step-over"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            REPLMessage reply = this.createReply();
            Integer repeat = request.getIntValue("repeat");
            if (repeat == null) {
                repeat = 1;
            }
            String countMessage = repeat == 1 ? "" : "<" + repeat + ">";
            replServer.getCurrentContext().prepareStepOver(repeat);
            return 21.finishReplySucceeded(reply, "StepOver " + countMessage + " enabled");
        }
    };
    public static final REPLHandler UNSET_BREAK_CONDITION_HANDLER = new REPLHandler("unset-breakpoint-condition"){

        @Override
        public REPLMessage[] receive(REPLMessage request, REPLServer replServer) {
            return null;
        }
    };

    protected REPLHandler(String op) {
        this.op = op;
    }

    final String getOp() {
        return this.op;
    }

    abstract REPLMessage[] receive(REPLMessage var1, REPLServer var2);

    REPLMessage createReply() {
        return new REPLMessage("op", this.op);
    }

    protected static final REPLMessage[] finishReplySucceeded(REPLMessage reply, String explanation) {
        reply.put("status", "succeeded");
        reply.put("displayable-message", explanation);
        REPLMessage[] replies = new REPLMessage[]{reply};
        return replies;
    }

    protected static final REPLMessage[] finishReplyFailed(REPLMessage reply, String explanation) {
        reply.put("status", "failed");
        reply.put("displayable-message", explanation);
        REPLMessage[] replies = new REPLMessage[]{reply};
        return replies;
    }

    protected static final REPLMessage[] finishReplyFailed(REPLMessage reply, Exception ex) {
        reply.put("status", "failed");
        String message = ex.getMessage();
        reply.put("displayable-message", message == null ? ex.getClass().getSimpleName() : message);
        REPLMessage[] replies = new REPLMessage[]{reply};
        return replies;
    }

    protected static final REPLMessage createBreakpointInfoMessage(REPLServer.BreakpointInfo info) {
        REPLMessage infoMessage = new REPLMessage("op", "breakpoint-info");
        infoMessage.put("breakpoint-id", Integer.toString(info.getID()));
        infoMessage.put("breakpoint-state", info.describeState());
        infoMessage.put("breakpoint-hit-count", Integer.toString(info.getHitCount()));
        infoMessage.put("breakpoint-ignore-count", Integer.toString(info.getIgnoreCount()));
        infoMessage.put("info-value", info.describeLocation());
        if (info.getCondition() != null) {
            infoMessage.put("breakpoint-condition", info.getCondition());
        }
        infoMessage.put("status", "succeeded");
        return infoMessage;
    }

    protected static final REPLMessage createFrameInfoMessage(REPLServer replServer, int number, Node node) {
        REPLMessage infoMessage = new REPLMessage("op", "frame-info");
        infoMessage.put("frame-number", Integer.toString(number));
        infoMessage.put("source-location", replServer.getLocationPrinter().displaySourceLocation(node));
        infoMessage.put("method-name", replServer.getCurrentContext().getVisualizer().displayMethodName(node));
        if (node != null) {
            SourceSection section = node.getSourceSection();
            if (section == null) {
                section = node.getEncapsulatingSourceSection();
            }
            if (section != null && section.getSource() != null) {
                infoMessage.put("path", section.getSource().getPath());
                infoMessage.put("line-number", Integer.toString(section.getStartLine()));
                infoMessage.put("source-line-text", section.getSource().getCode(section.getStartLine()));
            }
        }
        infoMessage.put("status", "succeeded");
        return infoMessage;
    }

    private static REPLMessage btMessage(int index, Node node, REPLServer.REPLVisualizer visualizer, InstrumentationUtils.LocationPrinter locationPrinter) {
        REPLMessage btMessage = new REPLMessage("op", "backtrace");
        btMessage.put("frame-number", Integer.toString(index));
        if (node != null) {
            btMessage.put("source-location", locationPrinter.displaySourceLocation(node));
            btMessage.put("method-name", visualizer.displayMethodName(node));
            SourceSection section = node.getSourceSection();
            if (section == null) {
                section = node.getEncapsulatingSourceSection();
            }
            if (section != null && section.getSource() != null) {
                btMessage.put("path", section.getSource().getPath());
                btMessage.put("line-number", Integer.toString(section.getStartLine()));
                btMessage.put("source-line-text", section.getSource().getCode(section.getStartLine()));
            }
            btMessage.put("status", "succeeded");
        }
        return btMessage;
    }
}

