/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.server;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.api.vm.PolyglotRuntime;
import com.oracle.truffle.tools.debug.shell.REPLMessage;
import com.oracle.truffle.tools.debug.shell.client.SimpleREPLClient;
import com.oracle.truffle.tools.debug.shell.server.InstrumentationUtils;
import com.oracle.truffle.tools.debug.shell.server.REPLHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;

@Deprecated
public final class REPLServer {
    private static final String REPL_SERVER_INSTRUMENT = "REPLServer";
    private static int nextBreakpointUID = 0;
    private final PolyglotEngine engine;
    private final String statusPrefix;
    private final Map<String, REPLHandler> handlerMap = new HashMap<String, REPLHandler>();
    private final InstrumentationUtils.LocationPrinter locationPrinter = new InstrumentationUtils.LocationPrinter();
    private final REPLVisualizer visualizer = new REPLVisualizer();
    private Context currentServerContext;
    private final TreeSet<PolyglotEngine.Language> engineLanguages = new TreeSet();
    private final Map<String, PolyglotEngine.Language> nameToLanguage = new TreeMap<String, PolyglotEngine.Language>(String.CASE_INSENSITIVE_ORDER);
    private final PolyglotEngine.Language defaultLanguage = null;
    private final Map<Integer, BreakpointInfo> breakpoints = new WeakHashMap<Integer, BreakpointInfo>();

    public REPLServer(SimpleREPLClient client) {
        this.engine = PolyglotEngine.newBuilder().build();
        ((PolyglotRuntime.Instrument)this.engine.getRuntime().getInstruments().get(REPL_SERVER_INSTRUMENT)).setEnabled(true);
        this.engineLanguages.addAll(this.engine.getLanguages().values());
        for (PolyglotEngine.Language language : this.engineLanguages) {
            this.nameToLanguage.put(language.getName().toLowerCase(), language);
        }
        this.statusPrefix = "";
    }

    public void add(REPLHandler handler) {
        this.handlerMap.put(handler.getOp(), handler);
    }

    public void start() {
        this.add(REPLHandler.BACKTRACE_HANDLER);
        this.add(REPLHandler.BREAK_AT_LINE_HANDLER);
        this.add(REPLHandler.BREAK_AT_LINE_ONCE_HANDLER);
        this.add(REPLHandler.BREAKPOINT_INFO_HANDLER);
        this.add(REPLHandler.CALL_HANDLER);
        this.add(REPLHandler.CLEAR_BREAK_HANDLER);
        this.add(REPLHandler.CONTINUE_HANDLER);
        this.add(REPLHandler.DELETE_HANDLER);
        this.add(REPLHandler.DISABLE_BREAK_HANDLER);
        this.add(REPLHandler.ENABLE_BREAK_HANDLER);
        this.add(REPLHandler.EVAL_HANDLER);
        this.add(REPLHandler.FILE_HANDLER);
        this.add(REPLHandler.FRAME_HANDLER);
        this.add(REPLHandler.INFO_HANDLER);
        this.add(REPLHandler.KILL_HANDLER);
        this.add(REPLHandler.LOAD_HANDLER);
        this.add(REPLHandler.SET_BREAK_CONDITION_HANDLER);
        this.add(REPLHandler.SET_LANGUAGE_HANDLER);
        this.add(REPLHandler.STEP_INTO_HANDLER);
        this.add(REPLHandler.STEP_OUT_HANDLER);
        this.add(REPLHandler.STEP_OVER_HANDLER);
        this.add(REPLHandler.UNSET_BREAK_CONDITION_HANDLER);
        this.currentServerContext = new Context(null, this.defaultLanguage);
    }

    public String getWelcome() {
        return "GraalVM Polyglot Debugger 0.9\nCopyright (c) 2013-6, Oracle and/or its affiliates";
    }

    public InstrumentationUtils.LocationPrinter getLocationPrinter() {
        return this.locationPrinter;
    }

    public REPLMessage[] receive(REPLMessage request) {
        if (this.currentServerContext == null) {
            REPLMessage message = new REPLMessage();
            message.put("status", "failed");
            message.put("displayable-message", "server not started");
            REPLMessage[] reply = new REPLMessage[]{message};
            return reply;
        }
        return this.currentServerContext.receive(request);
    }

    Context getCurrentContext() {
        return this.currentServerContext;
    }

    PolyglotEngine.Language getLanguage() {
        return this.defaultLanguage;
    }

    TreeSet<PolyglotEngine.Language> getLanguages() {
        return this.engineLanguages;
    }

    public String getLanguageName() {
        return REPLServer.languageName(this.defaultLanguage);
    }

    private static String languageName(PolyglotEngine.Language lang) {
        return lang.getName() + "(" + lang.getVersion() + ")";
    }

    BreakpointInfo setLineBreakpoint(int ignoreCount, LineLocation lineLocation, boolean oneShot) throws IOException {
        LineBreakpointInfo info = new LineBreakpointInfo(lineLocation, ignoreCount, oneShot);
        ((BreakpointInfo)info).activate();
        return info;
    }

    synchronized BreakpointInfo findBreakpoint(int id) {
        return this.breakpoints.get(id);
    }

    Collection<BreakpointInfo> getBreakpoints() {
        return new ArrayList<BreakpointInfo>(this.breakpoints.values());
    }

    protected static String trim(String text, int trim) {
        if (trim == 0) {
            return text;
        }
        String[] lines = text.split("\n");
        String result = lines[0];
        if (lines.length == 1) {
            if (result.length() <= trim) {
                return result;
            }
            if (trim <= 3) {
                return result.substring(0, Math.min(result.length() - 1, trim - 1));
            }
            return result.substring(0, trim - 4) + "...";
        }
        return (result.length() < trim - 3 ? result : result.substring(0, trim - 4)) + "...";
    }

    static class REPLVisualizer {
        REPLVisualizer() {
        }

        String displaySourceLocation(Node node) {
            if (node == null) {
                return "<unknown>";
            }
            SourceSection section = node.getSourceSection();
            boolean estimated = false;
            if (section == null) {
                section = node.getEncapsulatingSourceSection();
                estimated = true;
            }
            if (section == null) {
                return "<error: source location>";
            }
            return InstrumentationUtils.getShortDescription(section) + (estimated ? "~" : "");
        }

        String displayMethodName(Node node) {
            if (node == null) {
                return null;
            }
            RootNode root = node.getRootNode();
            if (root != null && root.getName() != null) {
                return root.getName();
            }
            return "??";
        }

        String displayCallTargetName(CallTarget callTarget) {
            return callTarget.toString();
        }

        String displayValue(Object value, int trim) {
            if (value == null) {
                return "<empty>";
            }
            return REPLServer.trim(value.toString(), trim);
        }

        String displayIdentifier(FrameSlot slot) {
            return slot.getIdentifier().toString();
        }
    }

    abstract class BreakpointInfo {
        protected final int uid;
        protected final boolean oneShot;
        protected final int ignoreCount;
        protected Source conditionSource;

        protected BreakpointInfo(int ignoreCount, boolean oneShot) {
            this.ignoreCount = ignoreCount;
            this.oneShot = oneShot;
            this.uid = nextBreakpointUID++;
        }

        protected abstract void activate() throws IOException;

        abstract String describeLocation();

        int getID() {
            return this.uid;
        }

        String describeState() {
            return null;
        }

        void setEnabled(boolean enabled) {
        }

        boolean isEnabled() {
            return false;
        }

        void setCondition(String expr) throws IOException {
        }

        String getCondition() {
            return null;
        }

        int getIgnoreCount() {
            return 0;
        }

        int getHitCount() {
            return 0;
        }

        void dispose() {
        }

        String summarize() {
            StringBuilder sb = new StringBuilder("Breakpoint");
            sb.append(" id=" + this.uid);
            sb.append(" locn=(" + this.describeLocation());
            sb.append(") " + this.describeState());
            return sb.toString();
        }
    }

    final class LineBreakpointInfo
    extends BreakpointInfo {
        private LineBreakpointInfo(LineLocation lineLocation, int ignoreCount, boolean oneShot) {
            super(ignoreCount, oneShot);
        }

        @Override
        protected void activate() throws IOException {
        }

        @Override
        String describeLocation() {
            return null;
        }
    }

    public static final class REPLServerInstrument
    extends TruffleInstrument {
        protected void onCreate(TruffleInstrument.Env env) {
            env.registerService((Object)env.getInstrumenter());
        }
    }

    public final class Context {
        private final int level;
        private PolyglotEngine.Language currentLanguage;

        Context(Context predecessor, PolyglotEngine.Language language) {
            this.level = predecessor == null ? 0 : predecessor.getLevel() + 1;
            this.currentLanguage = language;
        }

        int getLevel() {
            return this.level;
        }

        Node getNodeAtHalt() {
            return null;
        }

        REPLVisualizer getVisualizer() {
            return REPLServer.this.visualizer;
        }

        Object call(String name, boolean stepInto, List<String> argList) throws IOException {
            PolyglotEngine.Value symbol = REPLServer.this.engine.findGlobalSymbol(name);
            if (symbol == null) {
                throw new IOException("symbol \"" + name + "\" not found");
            }
            ArrayList<Object> args = new ArrayList<Object>();
            for (String stringArg : argList) {
                Integer intArg = null;
                try {
                    intArg = Integer.valueOf(stringArg);
                    args.add(intArg);
                }
                catch (NumberFormatException e) {
                    args.add(stringArg);
                }
            }
            return symbol.execute(args.toArray(new Object[0])).get();
        }

        void eval(Source source, boolean stepInto) {
            REPLServer.this.engine.eval(source);
        }

        Object eval(String code, Integer frameNumber, boolean stepInto) throws IOException {
            return null;
        }

        public String displayValue(Integer frameNumber, Object value, int trim) {
            return null;
        }

        MaterializedFrame getFrameAtHalt() {
            return null;
        }

        REPLMessage[] receive(REPLMessage request) {
            String command = request.get("op");
            REPLHandler handler = (REPLHandler)REPLServer.this.handlerMap.get(command);
            if (handler == null) {
                REPLMessage message = new REPLMessage();
                message.put("op", command);
                message.put("status", "failed");
                message.put("displayable-message", REPLServer.this.statusPrefix + " op \"" + command + "\" not supported");
                REPLMessage[] reply = new REPLMessage[]{message};
                return reply;
            }
            return handler.receive(request, REPLServer.this);
        }

        Node getNode() {
            return null;
        }

        MaterializedFrame getFrame() {
            return null;
        }

        List<FrameInstance> getStack() {
            return null;
        }

        public String getLanguageName() {
            return this.currentLanguage == null ? null : this.currentLanguage.getName();
        }

        String setLanguage(String name) throws IOException {
            assert (name != null);
            PolyglotEngine.Language language = (PolyglotEngine.Language)REPLServer.this.nameToLanguage.get(name.toLowerCase());
            if (language == null) {
                throw new IOException("Language \"" + name + "\" not supported");
            }
            if (language == this.currentLanguage) {
                return this.currentLanguage.getName();
            }
            this.currentLanguage = language;
            return language.getName();
        }

        void prepareStepOut() {
        }

        void prepareStepInto(int repeat) {
        }

        void prepareStepOver(int repeat) {
        }

        void prepareContinue() {
        }

        void kill() {
        }
    }
}

