/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.instrumentation;

import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspendedCallback;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.SuspensionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tck.instrumentation.DebugALotOptionDescriptors;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;

@TruffleInstrument.Registration(name="Debug a lot", id="debugalot")
public class DebugALot
extends TruffleInstrument
implements SuspendedCallback {
    static final String ID = "debugalot";
    private boolean failFast;
    private PrintWriter logger;
    private boolean doEval;
    private volatile boolean hasFailed;
    private Throwable error;
    @Option(name="", help="Start debugging logger.", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> DebugALot = new OptionKey((Object)true);
    @Option(name="Eval", help="Whether to test evaluations. (default:false)", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> Eval = new OptionKey((Object)false);
    @Option(name="FailFast", help="Fail fast, give up after the first error. (default:false)", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> FailFast = new OptionKey((Object)false);
    @Option(name="LogFile", help="File to print the debugger log into. (default:standard output)", category=OptionCategory.EXPERT)
    static final OptionKey<String> LogFile = new OptionKey((Object)"");

    protected void onCreate(TruffleInstrument.Env env) {
        Boolean debugALot = (Boolean)env.getOptions().get(DebugALot);
        this.failFast = (Boolean)env.getOptions().get(FailFast);
        this.doEval = (Boolean)env.getOptions().get(Eval);
        boolean isLogFile = env.getOptions().hasBeenSet(LogFile);
        if (!(Boolean.TRUE.equals(debugALot) || this.failFast || this.doEval || isLogFile)) {
            return;
        }
        if (isLogFile) {
            String logFilePath = (String)env.getOptions().get(LogFile);
            try {
                this.logger = new PrintWriter(new FileWriter(logFilePath));
            }
            catch (IOException ioex) {
                this.logger = new PrintWriter(env.out());
                this.logger.print(ioex.getLocalizedMessage());
            }
        } else {
            this.logger = new PrintWriter(env.out());
        }
        Debugger debugger = (Debugger)env.lookup((InstrumentInfo)env.getInstruments().get("debugger"), Debugger.class);
        DebuggerSession debuggerSession = debugger.startSession((SuspendedCallback)this);
        debuggerSession.suspendNextExecution();
        debuggerSession.setSteppingFilter(SuspensionFilter.newBuilder().ignoreLanguageContextInitialization(true).build());
    }

    protected void onDispose(TruffleInstrument.Env env) {
        this.logger.print("Executed successfully: ");
        this.logger.print(Boolean.toString(!this.hasFailed).toUpperCase());
        this.logger.flush();
        super.onDispose(env);
        if (this.error != null) {
            throw new AssertionError("Failure", this.error);
        }
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new DebugALotOptionDescriptors();
    }

    public void onSuspend(SuspendedEvent event) {
        block8: {
            try {
                this.logSuspendLocation(event.isLanguageContextInitialized(), event.getSuspendAnchor(), event.getSourceSection());
                this.logFrames(event.getStackFrames());
            }
            catch (Throwable t) {
                block7: {
                    this.hasFailed = true;
                    try {
                        this.logThrowable(t);
                    }
                    catch (Throwable lt) {
                        lt.printStackTrace(this.logger);
                        if (!(lt instanceof ThreadDeath)) break block7;
                        throw lt;
                    }
                }
                if (t instanceof ThreadDeath) {
                    throw t;
                }
                if (!this.failFast) break block8;
                this.error = t;
            }
        }
        this.logger.flush();
        if (this.failFast && this.hasFailed) {
            event.prepareContinue();
        } else {
            event.prepareStepInto(1);
        }
    }

    private void logSuspendLocation(boolean initialized, SuspendAnchor suspendAnchor, com.oracle.truffle.api.source.SourceSection sourceSection) {
        if (!initialized) {
            this.logger.print("Uninitialized: ");
        }
        this.logger.print(suspendAnchor);
        if (sourceSection == null) {
            throw new NullPointerException("No source section is available at suspend location.");
        }
        this.logSourceSection(sourceSection);
    }

    private void logSourceSection(com.oracle.truffle.api.source.SourceSection sourceSection) {
        if (sourceSection == null) {
            this.logger.println(" <NONE>");
            return;
        }
        this.logger.print(" [");
        this.logger.print(sourceSection.getStartLine());
        this.logger.print(':');
        this.logger.print(sourceSection.getStartColumn());
        this.logger.print('-');
        this.logger.print(sourceSection.getEndLine());
        this.logger.print(':');
        this.logger.print(sourceSection.getEndColumn());
        this.logger.print("] in ");
        this.logger.println(sourceSection.getSource().getURI());
    }

    private void logSourceSection(SourceSection sourceSection) {
        if (sourceSection == null) {
            this.logger.println(" <NONE>");
            return;
        }
        this.logger.print(" [");
        this.logger.print(sourceSection.getStartLine());
        this.logger.print(':');
        this.logger.print(sourceSection.getStartColumn());
        this.logger.print('-');
        this.logger.print(sourceSection.getEndLine());
        this.logger.print(':');
        this.logger.print(sourceSection.getEndColumn());
        this.logger.print("] in ");
        this.logger.println(sourceSection.getSource().getURI());
    }

    private void logFrames(Iterable<DebugStackFrame> stackFrames) {
        this.logger.print("Stack: ");
        ArrayList<DebugStackFrame> frames = new ArrayList<DebugStackFrame>();
        for (DebugStackFrame frame : stackFrames) {
            frames.add(frame);
        }
        this.logger.print(frames.size());
        this.logger.println(frames.size() == 1 ? " frame" : " frames");
        for (int i = 0; i < frames.size(); ++i) {
            this.logger.print(i + 1);
            this.logger.print(". ");
            int offset = Integer.toString(i + 1).length() + 2;
            String framePrefix = com.oracle.truffle.tck.instrumentation.DebugALot.getPrefix(offset);
            this.logFrame(framePrefix, (DebugStackFrame)frames.get(i));
        }
    }

    private void logFrame(String prefix, DebugStackFrame frame) {
        this.logger.print(frame.getName());
        if (frame.isInternal()) {
            this.logger.print(" [Internal]");
        }
        this.logSourceSection(frame.getSourceSection());
        ArrayList<DebugScope> scopes = new ArrayList<DebugScope>();
        for (DebugScope scope = frame.getScope(); scope != null; scope = scope.getParent()) {
            scopes.add(scope);
        }
        this.logger.print(prefix);
        this.logger.print("Scopes: ");
        this.logger.println(scopes.size());
        for (int i = 0; i < scopes.size(); ++i) {
            this.logger.print(prefix);
            this.logger.print(i + 1);
            this.logger.print(". ");
            int offset = prefix.length() + Integer.toString(i + 1).length() + 2;
            String scopePrefix = com.oracle.truffle.tck.instrumentation.DebugALot.getPrefix(offset);
            this.logScope(scopePrefix, (DebugScope)scopes.get(i), (DebugStackFrame)(i == 0 ? frame : null));
        }
    }

    private void logScope(String prefix, DebugScope scope, DebugStackFrame frameForEval) {
        ArrayList<DebugValue> values;
        this.logger.print(scope.getName());
        if (scope.isFunctionScope()) {
            this.logger.println(" [Function]");
        } else {
            this.logger.println();
        }
        Iterable arguments = scope.getArguments();
        if (arguments != null) {
            this.logger.print(prefix);
            this.logger.print("Arguments: ");
            values = new ArrayList<DebugValue>();
            for (DebugValue v : arguments) {
                values.add(v);
            }
            this.logger.println(values.size());
            this.logValues(prefix, values);
        }
        Iterable variables = scope.getDeclaredValues();
        this.logger.print(prefix);
        this.logger.print("Variables: ");
        values = new ArrayList();
        for (DebugValue v : variables) {
            values.add(v);
        }
        this.logger.println(values.size());
        this.logValues(prefix, values);
        if (frameForEval != null && this.doEval) {
            this.testEval(prefix, frameForEval, values);
        }
    }

    private void logValues(String prefix, List<DebugValue> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.logger.print(prefix);
            this.logger.print(i + 1);
            this.logger.print(". ");
            DebugValue v = values.get(i);
            this.logger.print(v.getName());
            this.logger.print(" = ");
            this.logger.println((String)v.as(String.class));
            int offset = prefix.length() + Integer.toString(i + 1).length() + 2;
            String valuePrefix = com.oracle.truffle.tck.instrumentation.DebugALot.getPrefix(offset);
            this.logValue(valuePrefix, v);
        }
    }

    private void logValue(String prefix, DebugValue v) {
        com.oracle.truffle.api.source.SourceSection sourceLocation;
        DebugValue metaObject;
        LanguageInfo language = v.getOriginalLanguage();
        if (language != null) {
            this.logger.print(prefix);
            this.logger.print("From: ");
            this.logger.println(language.getId());
        }
        if ((metaObject = v.getMetaObject()) != null) {
            this.logger.print(prefix);
            this.logger.print("Type: ");
            this.logger.println((String)metaObject.as(String.class));
        }
        if ((sourceLocation = v.getSourceLocation()) != null) {
            this.logger.print(prefix);
            this.logger.print("SourceSection: ");
            this.logSourceSection(sourceLocation);
        }
        if (v.isArray()) {
            List array = v.getArray();
            int length = array.size();
            this.logger.print(prefix);
            this.logger.print("Array of length: ");
            this.logger.println(Integer.toString(length));
            for (int i = 0; i < length && i < 10; ++i) {
                this.logger.print(prefix);
                this.logger.print("  element #");
                this.logger.print(Integer.toString(i));
                this.logger.print(" : ");
                this.logger.println((String)((DebugValue)array.get(i)).as(String.class));
            }
        }
        Collection properties = v.getProperties();
        this.logger.print(prefix);
        if (properties == null || properties.isEmpty()) {
            this.logger.println("Properties: none");
        } else {
            this.logger.print("Properties: ");
            this.logger.println(Integer.toString(properties.size()));
        }
        this.logger.print(prefix);
        this.logger.print("Internal: ");
        this.logger.println(v.isInternal());
        this.logger.print(prefix);
        this.logger.print("Readable: ");
        this.logger.println(v.isReadable());
        this.logger.print(prefix);
        this.logger.print("Writable: ");
        this.logger.println(v.isWritable());
    }

    private void testEval(String prefix, DebugStackFrame frame, List<DebugValue> values) {
        for (DebugValue v : values) {
            String evalue;
            DebugValue ev = frame.eval(v.getName());
            String value = (String)v.as(String.class);
            if (value.equals(evalue = (String)ev.as(String.class))) continue;
            this.hasFailed = true;
            this.logger.print(prefix);
            this.logger.print("ERROR: local value '");
            this.logger.print(v.getName());
            this.logger.print("' has value '");
            this.logger.print((String)v.as(String.class));
            this.logger.print("' but evaluated to '");
            this.logger.print((String)ev.as(String.class));
            this.logger.println("'");
        }
    }

    private void logThrowable(Throwable t) {
        this.logger.print("\nERROR: Thrown: '");
        this.logger.print(t.getLocalizedMessage());
        this.logger.print("', throwable class = ");
        this.logger.println(t.getClass());
        if (t instanceof PolyglotException) {
            PolyglotException pe = (PolyglotException)t;
            this.logger.print("  Polyglot Message: '");
            this.logger.print(pe.getMessage());
            this.logger.println("'");
            this.logger.print("  canceled = ");
            this.logger.print(pe.isCancelled());
            this.logger.print(", exited = ");
            this.logger.print(pe.isExit());
            this.logger.print(", guest ex. = ");
            this.logger.print(pe.isGuestException());
            this.logger.print(", host ex. = ");
            this.logger.print(pe.isHostException());
            this.logger.print(", incompl. source = ");
            this.logger.print(pe.isIncompleteSource());
            this.logger.print(", internal = ");
            this.logger.print(pe.isInternalError());
            this.logger.print(", syntax error = ");
            this.logger.println(pe.isSyntaxError());
            this.logger.print("  Source Section: ");
            this.logSourceSection(pe.getSourceLocation());
            if (pe.isExit()) {
                this.logger.print("  Exit Status = ");
                this.logger.println(pe.getExitStatus());
            }
            if (pe.isGuestException()) {
                Value guestObject = pe.getGuestObject();
                this.logger.print("  Guest Object = ");
                this.logger.println(guestObject.toString());
            }
            if (pe.isHostException()) {
                this.logger.println("  Host Exception:");
                pe.asHostException().printStackTrace(this.logger);
            }
            this.logger.println("  Polyglot Stack Trace:");
            for (PolyglotException.StackFrame sf : pe.getPolyglotStackTrace()) {
                this.logger.print("    Language ID: ");
                this.logger.println(sf.getLanguage().getId());
                this.logger.print("    Root Name: ");
                this.logger.println(sf.getRootName());
                this.logger.print("    Source Location: ");
                this.logSourceSection(sf.getSourceLocation());
                this.logger.print("    Guest Frame: ");
                this.logger.println(sf.isGuestFrame());
                this.logger.print("    Host Frame: ");
                if (sf.isHostFrame()) {
                    this.logger.println(sf.toHostFrame());
                    continue;
                }
                this.logger.println(false);
            }
        } else {
            t.printStackTrace(this.logger);
        }
    }

    private static String getPrefix(int length) {
        char[] prefixChars = new char[length];
        Arrays.fill(prefixChars, ' ');
        return new String(prefixChars);
    }
}

