/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.instrumentation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tck.common.inline.InlineVerifier;
import java.util.function.Predicate;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.tck.InlineSnippet;
import org.junit.Assert;

@TruffleInstrument.Registration(name="TckVerifierInstrument", id="TckVerifierInstrument", services={InlineVerifier.class})
public class VerifierInstrument
extends TruffleInstrument
implements InlineVerifier {
    private TruffleInstrument.Env env;
    private InlineScriptFactory inlineScriptFactory;
    private EventBinding<InlineScriptFactory> inlineBinding;
    static final TruffleTCKAccessor ACCESSOR = new TruffleTCKAccessor();

    protected void onCreate(TruffleInstrument.Env instrumentEnv) {
        this.env = instrumentEnv;
        instrumentEnv.registerService((Object)this);
        instrumentEnv.getInstrumenter().attachExecutionEventListener(SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build(), (ExecutionEventListener)new RootFrameChecker());
    }

    public void setInlineSnippet(String languageId, InlineSnippet inlineSnippet, InlineVerifier.ResultVerifier verifier) {
        if (inlineSnippet != null) {
            this.inlineScriptFactory = new InlineScriptFactory(languageId, inlineSnippet, verifier);
            this.inlineBinding = this.env.getInstrumenter().attachExecutionEventFactory(SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.StatementTag.class, StandardTags.CallTag.class}).build(), (ExecutionEventNodeFactory)this.inlineScriptFactory);
        } else if (this.inlineBinding != null) {
            this.inlineBinding.dispose();
            this.inlineBinding = null;
            this.inlineScriptFactory = null;
        }
    }

    static final class TruffleTCKAccessor
    extends Accessor {
        TruffleTCKAccessor() {
        }

        static Accessor.EngineSupport engineAccess() {
            return ACCESSOR.engineSupport();
        }

        static Accessor.Nodes nodesAccess() {
            return ACCESSOR.nodes();
        }

        static Accessor.InstrumentSupport instrumentAccess() {
            return ACCESSOR.instrumentSupport();
        }
    }

    private static class RootFrameChecker
    implements ExecutionEventListener {
        private RootFrameChecker() {
        }

        public void onEnter(EventContext context, VirtualFrame frame) {
            this.checkFrameIsEmpty(context, frame.materialize());
        }

        @CompilerDirectives.TruffleBoundary
        private void checkFrameIsEmpty(EventContext context, MaterializedFrame frame) {
            Node node = context.getInstrumentedNode();
            if (!this.hasParentRootTag(node) && node.getRootNode().getFrameDescriptor() == frame.getFrameDescriptor()) {
                Object defaultValue = frame.getFrameDescriptor().getDefaultValue();
                for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
                    Assert.assertEquals((Object)defaultValue, (Object)frame.getValue(slot));
                }
            }
        }

        private boolean hasParentRootTag(Node node) {
            Node parent = node.getParent();
            if (parent == null) {
                return false;
            }
            if (TruffleTCKAccessor.nodesAccess().isTaggedWith(parent, StandardTags.RootTag.class)) {
                return true;
            }
            return this.hasParentRootTag(parent);
        }

        public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
        }

        public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
        }
    }

    private class InlineScriptFactory
    implements ExecutionEventNodeFactory {
        private final Source snippet;
        private final Predicate<SourceSection> predicate;
        private final InlineVerifier.ResultVerifier resultVerifier;

        InlineScriptFactory(String languageId, InlineSnippet inlineSnippet, InlineVerifier.ResultVerifier verifier) {
            CharSequence code = inlineSnippet.getCode();
            this.snippet = Source.newBuilder((String)languageId, (CharSequence)code, (String)"inline_source").build();
            this.predicate = inlineSnippet.getLocationPredicate();
            this.resultVerifier = verifier;
        }

        public ExecutionEventNode create(EventContext context) {
            if (this.predicate == null || this.canRunAt(context.getInstrumentedSourceSection())) {
                return new InlineScriptNode(context);
            }
            return null;
        }

        private boolean canRunAt(com.oracle.truffle.api.source.SourceSection ss) {
            SourceSection section = TruffleTCKAccessor.instrumentAccess().createSourceSection((Object)VerifierInstrument.this.env, null, ss);
            return this.predicate.test(section);
        }

        private class InlineScriptNode
        extends ExecutionEventNode {
            private final Node instrumentedNode;
            @CompilerDirectives.CompilationFinal
            private volatile ExecutableNode inlineNode;

            InlineScriptNode(EventContext context) {
                this.instrumentedNode = context.getInstrumentedNode();
            }

            protected void onEnter(VirtualFrame frame) {
                this.executeSnippet(frame);
            }

            protected void onReturnValue(VirtualFrame frame, Object result) {
                this.executeSnippet(frame);
            }

            protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
                this.executeSnippet(frame);
            }

            private void executeSnippet(VirtualFrame frame) {
                if (this.inlineNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    try {
                        this.inlineNode = VerifierInstrument.this.env.parseInline(InlineScriptFactory.this.snippet, this.instrumentedNode, frame.materialize());
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        this.verify(t);
                        throw t;
                    }
                    this.insert((Node)this.inlineNode);
                }
                try {
                    Object ret = this.inlineNode.execute(frame);
                    if (InlineScriptFactory.this.resultVerifier != null) {
                        this.verify(ret);
                    }
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    CompilerDirectives.transferToInterpreter();
                    this.verify(t);
                    throw t;
                }
            }

            @CompilerDirectives.TruffleBoundary
            private void verify(Throwable exception) {
                PolyglotException pe = TruffleTCKAccessor.engineAccess().wrapGuestException(InlineScriptFactory.this.snippet.getLanguage(), exception);
                InlineScriptFactory.this.resultVerifier.verify(pe);
            }

            @CompilerDirectives.TruffleBoundary
            private void verify(Object result) {
                InlineScriptFactory.this.resultVerifier.verify(result);
            }
        }
    }
}

