/*
 * Decompiled with CFR 0.152.
 */
package lightdb.lucene;

import java.io.Serializable;
import java.util.NoSuchElementException;
import lightdb.lucene.LucenePaginatedIterator$;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopFieldDocs;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class LucenePaginatedIterator
implements Iterator<Tuple2<Document, Object>>,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LucenePaginatedIterator.class.getDeclaredField("storedFields$lzy1"));
    private final IndexSearcher searcher;
    private final Query query;
    private final Sort sort;
    private final int pageSize;
    private final boolean scoreDocs;
    private int currentPageIndex;
    private ScoreDoc[] currentDocs;
    private int currentIndexInPage;
    private boolean exhausted;
    private int totalHits;
    private volatile Object storedFields$lzy1;

    public static LucenePaginatedIterator apply(IndexSearcher indexSearcher, Query query, Sort sort, int n, boolean bl) {
        return LucenePaginatedIterator$.MODULE$.apply(indexSearcher, query, sort, n, bl);
    }

    public static LucenePaginatedIterator fromProduct(Product product) {
        return LucenePaginatedIterator$.MODULE$.fromProduct(product);
    }

    public static LucenePaginatedIterator unapply(LucenePaginatedIterator lucenePaginatedIterator) {
        return LucenePaginatedIterator$.MODULE$.unapply(lucenePaginatedIterator);
    }

    public LucenePaginatedIterator(IndexSearcher searcher, Query query, Sort sort, int pageSize, boolean scoreDocs) {
        this.searcher = searcher;
        this.query = query;
        this.sort = sort;
        this.pageSize = pageSize;
        this.scoreDocs = scoreDocs;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.currentPageIndex = 0;
        this.currentDocs = (ScoreDoc[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScoreDoc.class));
        this.currentIndexInPage = 0;
        this.exhausted = false;
        this.totalHits = -1;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.searcher()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.query()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sort()));
        n = Statics.mix((int)n, (int)this.pageSize());
        n = Statics.mix((int)n, (int)(this.scoreDocs() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LucenePaginatedIterator)) return false;
        LucenePaginatedIterator lucenePaginatedIterator = (LucenePaginatedIterator)object;
        if (this.pageSize() != lucenePaginatedIterator.pageSize()) return false;
        if (this.scoreDocs() != lucenePaginatedIterator.scoreDocs()) return false;
        IndexSearcher indexSearcher = this.searcher();
        IndexSearcher indexSearcher2 = lucenePaginatedIterator.searcher();
        if (indexSearcher == null) {
            if (indexSearcher2 != null) {
                return false;
            }
        } else if (!indexSearcher.equals(indexSearcher2)) return false;
        Query query = this.query();
        Query query2 = lucenePaginatedIterator.query();
        if (query == null) {
            if (query2 != null) {
                return false;
            }
        } else if (!query.equals(query2)) return false;
        Sort sort = this.sort();
        Sort sort2 = lucenePaginatedIterator.sort();
        if (sort == null) {
            if (sort2 != null) {
                return false;
            }
        } else if (!sort.equals(sort2)) return false;
        if (!lucenePaginatedIterator.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof LucenePaginatedIterator;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "LucenePaginatedIterator";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this._5());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "searcher";
            }
            case 1: {
                return "query";
            }
            case 2: {
                return "sort";
            }
            case 3: {
                return "pageSize";
            }
            case 4: {
                return "scoreDocs";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public IndexSearcher searcher() {
        return this.searcher;
    }

    public Query query() {
        return this.query;
    }

    public Sort sort() {
        return this.sort;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public boolean scoreDocs() {
        return this.scoreDocs;
    }

    public StoredFields storedFields() {
        Object object = this.storedFields$lzy1;
        if (object instanceof StoredFields) {
            return (StoredFields)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (StoredFields)this.storedFields$lzyINIT1();
    }

    private Object storedFields$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.storedFields$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    StoredFields storedFields = null;
                    try {
                        storedFields = this.searcher().storedFields();
                        object2 = storedFields == null ? LazyVals.NullValue$.MODULE$ : storedFields;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.storedFields$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return storedFields;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int total() {
        if (this.totalHits == -1) {
            this.fetchPage();
        }
        return this.totalHits;
    }

    private void fetchPage() {
        if (this.exhausted) {
            return;
        }
        int start = this.currentPageIndex * this.pageSize();
        int threshold = this.totalHits == -1 ? Integer.MAX_VALUE : 0;
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.currentDocs);
        FieldDoc after = (FieldDoc)ArrayOps$.MODULE$.lastOption$extension(object).map((Function1 & Serializable)_$1 -> (FieldDoc)_$1).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        TopFieldCollectorManager collectorManager = new TopFieldCollectorManager(this.sort(), this.pageSize(), after, threshold, false);
        TopFieldDocs topDocs = (TopFieldDocs)this.searcher().search(this.query(), (CollectorManager)collectorManager);
        if (this.currentPageIndex == 0) {
            this.totalHits = (int)topDocs.totalHits.value;
        }
        if (start >= this.totalHits) {
            this.exhausted = true;
            return;
        }
        this.currentDocs = topDocs.scoreDocs;
        this.currentIndexInPage = 0;
        ++this.currentPageIndex;
    }

    public boolean hasNext() {
        if (this.currentIndexInPage < this.currentDocs.length) {
            return true;
        }
        this.fetchPage();
        return this.currentIndexInPage < this.currentDocs.length;
    }

    public Tuple2<Document, Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more documents");
        }
        ScoreDoc scoreDoc = this.currentDocs[this.currentIndexInPage];
        Document doc = this.storedFields().document(scoreDoc.doc);
        ++this.currentIndexInPage;
        Document document = (Document)Predef$.MODULE$.ArrowAssoc((Object)doc);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)document, (Object)BoxesRunTime.boxToDouble((double)scoreDoc.score));
    }

    public LucenePaginatedIterator copy(IndexSearcher searcher, Query query, Sort sort, int pageSize, boolean scoreDocs) {
        return new LucenePaginatedIterator(searcher, query, sort, pageSize, scoreDocs);
    }

    public IndexSearcher copy$default$1() {
        return this.searcher();
    }

    public Query copy$default$2() {
        return this.query();
    }

    public Sort copy$default$3() {
        return this.sort();
    }

    public int copy$default$4() {
        return this.pageSize();
    }

    public boolean copy$default$5() {
        return this.scoreDocs();
    }

    public IndexSearcher _1() {
        return this.searcher();
    }

    public Query _2() {
        return this.query();
    }

    public Sort _3() {
        return this.sort();
    }

    public int _4() {
        return this.pageSize();
    }

    public boolean _5() {
        return this.scoreDocs();
    }
}

