/*
 * Decompiled with CFR 0.152.
 */
package lightdb.lucene;

import fabric.Arr;
import fabric.Arr$;
import fabric.Bool;
import fabric.Bool$;
import fabric.Json;
import fabric.Null$;
import fabric.NumDec;
import fabric.NumDec$;
import fabric.NumInt;
import fabric.NumInt$;
import fabric.Obj;
import fabric.Str;
import fabric.Str$;
import fabric.define.DefType;
import fabric.io.JsonFormatter$;
import java.io.Serializable;
import java.nio.file.Path;
import lightdb.Id;
import lightdb.Id$;
import lightdb.LightDB;
import lightdb.Query;
import lightdb.Query$;
import lightdb.SearchResults;
import lightdb.SearchResults$;
import lightdb.Sort;
import lightdb.SortDirection;
import lightdb.aggregate.AggregateQuery;
import lightdb.collection.Collection;
import lightdb.distance.Distance;
import lightdb.distance.Distance$;
import lightdb.doc.DocumentModel;
import lightdb.doc.JsonConversion;
import lightdb.facet.FacetResult$;
import lightdb.facet.FacetResultValue$;
import lightdb.feature.FeatureKey;
import lightdb.field.Field;
import lightdb.field.Field$;
import lightdb.field.IndexingState;
import lightdb.filter.Condition;
import lightdb.filter.Filter;
import lightdb.filter.FilterSupport;
import lightdb.lucene.LuceneState$;
import lightdb.lucene.LuceneStore$;
import lightdb.lucene.index.Index;
import lightdb.lucene.index.Index$;
import lightdb.lucene.package$;
import lightdb.materialized.MaterializedAggregate;
import lightdb.materialized.MaterializedAndDoc$;
import lightdb.materialized.MaterializedIndex$;
import lightdb.spatial.DistanceAndDoc;
import lightdb.spatial.DistanceAndDoc$;
import lightdb.spatial.Geo;
import lightdb.spatial.Geo$;
import lightdb.spatial.Spatial$;
import lightdb.store.Conversion;
import lightdb.store.Store;
import lightdb.store.StoreMode;
import lightdb.transaction.Transaction;
import lightdb.transaction.TransactionKey;
import lightdb.util.Aggregator$;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public class LuceneStore<Doc extends lightdb.doc.Document<Doc>, Model extends DocumentModel<Doc>>
extends Store<Doc, Model> {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(LuceneStore.class.getDeclaredField("hasFacets$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(LuceneStore.class.getDeclaredField("facetsConfig$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LuceneStore.class.getDeclaredField("index$lzy1"));
    private Option<Path> directory;
    private final StoreMode storeMode;
    private volatile Object index$lzy1;
    private volatile Object facetsConfig$lzy1;
    private volatile Object hasFacets$lzy1;

    public static <Doc extends lightdb.doc.Document<Doc>, Model extends DocumentModel<Doc>> Store<Doc, Model> create(LightDB lightDB, String string, StoreMode storeMode) {
        return LuceneStore$.MODULE$.create(lightDB, string, storeMode);
    }

    public LuceneStore(Option<Path> directory, StoreMode storeMode) {
        this.directory = directory;
        this.storeMode = storeMode;
    }

    public StoreMode storeMode() {
        return this.storeMode;
    }

    private Index index() {
        Object object = this.index$lzy1;
        if (object instanceof Index) {
            return (Index)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Index)this.index$lzyINIT1();
    }

    private Object index$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.index$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Index index = null;
                    try {
                        index = Index$.MODULE$.apply(this.directory);
                        object2 = index == null ? LazyVals.NullValue$.MODULE$ : index;
                        this.directory = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.index$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return index;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private FacetsConfig facetsConfig() {
        Object object = this.facetsConfig$lzy1;
        if (object instanceof FacetsConfig) {
            return (FacetsConfig)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FacetsConfig)this.facetsConfig$lzyINIT1();
    }

    private Object facetsConfig$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.facetsConfig$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FacetsConfig facetsConfig = null;
                    try {
                        FacetsConfig c = new FacetsConfig();
                        this.fields().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                            lightdb.field.Field field = x$1;
                            if (field instanceof Field.FacetField) {
                                Field.FacetField ff = (Field.FacetField)field;
                                if (ff.hierarchical()) {
                                    c.setHierarchical(ff.name(), ff.hierarchical());
                                }
                                if (ff.multiValued()) {
                                    c.setMultiValued(ff.name(), ff.multiValued());
                                }
                                if (ff.requireDimCount()) {
                                    c.setRequireDimCount(ff.name(), ff.requireDimCount());
                                    return;
                                }
                                return;
                            }
                        });
                        facetsConfig = c;
                        object2 = facetsConfig == null ? LazyVals.NullValue$.MODULE$ : facetsConfig;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.facetsConfig$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return facetsConfig;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private boolean hasFacets() {
        Object object = this.hasFacets$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.hasFacets$lzyINIT1());
    }

    private Object hasFacets$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hasFacets$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.fields().exists((Function1 & Serializable)_$1 -> _$1 instanceof Field.FacetField));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hasFacets$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Document facetsPrepareDoc(Document doc) {
        if (this.hasFacets()) {
            return this.facetsConfig().build((TaxonomyWriter)this.index().taxonomyWriter(), doc);
        }
        return doc;
    }

    public void init(Collection<Doc, Model> collection) {
        super.init(collection);
    }

    public void prepareTransaction(Transaction<Doc> transaction) {
        transaction.put((FeatureKey)new TransactionKey(package$.MODULE$.StateKey()), LuceneState$.MODULE$.apply(this.index(), this.hasFacets()));
    }

    public void insert(Doc doc, Transaction<Doc> transaction) {
        this.addDoc(doc, false);
    }

    public void upsert(Doc doc, Transaction<Doc> transaction) {
        this.addDoc(doc, true);
    }

    private void createGeoFields(lightdb.field.Field<Doc, ?> field, Json json, Function1<Field, BoxedUnit> add) {
        Option option = field.className();
        if (option instanceof Some && "lightdb.spatial.Geo.Point".equals(((Some)option).value())) {
            Geo.Point p = (Geo.Point)fabric.rw.package$.MODULE$.Asable(json).as(Geo$.MODULE$.pRW());
            add.apply((Object)new LatLonPoint(field.name(), p.latitude(), p.longitude()));
        } else {
            List list;
            Json json2 = json;
            if (json2 instanceof Arr) {
                Arr arr = Arr$.MODULE$.unapply((Arr)json2);
                Vector vector = arr._1();
                Option option2 = arr._2();
                Vector value = vector;
                list = value.toList().map((Function1 & Serializable)_$6 -> (Geo)fabric.rw.package$.MODULE$.Asable(_$6).as(Geo$.MODULE$.rw()));
            } else {
                list = (List)new .colon.colon((Object)((Geo)fabric.rw.package$.MODULE$.Asable(json).as(Geo$.MODULE$.rw())), (List)Nil$.MODULE$);
            }
            List list2 = list;
            list2.foreach((Function1)(JProcedure1 & Serializable)geo -> {
                Geo geo2 = geo;
                if (geo2 instanceof Geo.Point) {
                    Geo.Point p2 = (Geo.Point)geo2;
                    LuceneStore.indexPoint$1(field, p2);
                } else if (geo2 instanceof Geo.MultiPoint) {
                    List list;
                    Geo.MultiPoint multiPoint = Geo.MultiPoint$.MODULE$.unapply((Geo.MultiPoint)geo2);
                    List points = list = multiPoint._1();
                    points.foreach((Function1)(JProcedure1 & Serializable)p -> LuceneStore.indexPoint$1(field, p));
                } else if (geo2 instanceof Geo.Line) {
                    Geo.Line l2 = (Geo.Line)geo2;
                    LuceneStore.indexLine$1(field, l2);
                } else if (geo2 instanceof Geo.MultiLine) {
                    List list;
                    Geo.MultiLine multiLine = Geo.MultiLine$.MODULE$.unapply((Geo.MultiLine)geo2);
                    List lines = list = multiLine._1();
                    lines.foreach((Function1)(JProcedure1 & Serializable)l -> LuceneStore.indexLine$1(field, l));
                } else if (geo2 instanceof Geo.Polygon) {
                    Geo.Polygon p3 = (Geo.Polygon)geo2;
                    LuceneStore.indexPolygon$1(field, p3);
                } else if (geo2 instanceof Geo.MultiPolygon) {
                    List list;
                    Geo.MultiPolygon multiPolygon = Geo.MultiPolygon$.MODULE$.unapply((Geo.MultiPolygon)geo2);
                    List polygons = list = multiPolygon._1();
                    polygons.foreach((Function1)(JProcedure1 & Serializable)p -> LuceneStore.indexPolygon$1(field, p));
                } else {
                    throw new MatchError((Object)geo2);
                }
                add.apply((Object)new LatLonPoint(field.name(), geo.center().latitude(), geo.center().longitude()));
            });
            if (list2.isEmpty()) {
                add.apply((Object)new LatLonPoint(field.name(), 0.0, 0.0));
            }
        }
        add.apply((Object)new StoredField(field.name(), JsonFormatter$.MODULE$.Compact().apply(json)));
    }

    private List<Field> createLuceneFields(lightdb.field.Field<Doc, ?> field, Doc doc, IndexingState state) {
        ObjectRef fields;
        block6: {
            Json json;
            String fieldSortName;
            block7: {
                block5: {
                    Json json2 = field.getJson(doc, state);
                    fields = ObjectRef.create((Object)scala.package$.MODULE$.List().empty());
                    lightdb.field.Field field2 = field;
                    if (field2 instanceof Field.FacetField) {
                        Field.FacetField ff = (Field.FacetField)field2;
                        return ((List)ff.get().apply(doc, (lightdb.field.Field)ff, state)).flatMap((Function1 & Serializable)value -> {
                            if (value.path().nonEmpty() || ff.hierarchical()) {
                                List path = ff.hierarchical() ? ((List)new .colon.colon((Object)"$ROOT$", (List)Nil$.MODULE$)).$colon$colon$colon(value.path()) : value.path();
                                return Some$.MODULE$.apply((Object)new FacetField(field.name(), (String[])Arrays$.MODULE$.seqToArray((Seq)path, String.class)));
                            }
                            return None$.MODULE$;
                        });
                    }
                    if (field2 instanceof Field.Tokenized) {
                        Field.Tokenized t = (Field.Tokenized)field2;
                        Field.Store store = this.fs$1(field);
                        Field.Store store2 = Field.Store.YES;
                        return (List)new .colon.colon((Object)new Field(field.name(), (CharSequence)((lightdb.field.Field)t).get().apply(doc, (lightdb.field.Field)t, state), (IndexableFieldType)(!(store != null ? !store.equals(store2) : store2 != null) ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED)), (List)Nil$.MODULE$);
                    }
                    this.addJson$1(field, fields, json2, field.rw().definition());
                    fieldSortName = new StringBuilder(4).append(field.name()).append("Sort").toString();
                    json = field.getJson(doc, state);
                    if (!(json instanceof Str)) break block5;
                    Str str = Str$.MODULE$.unapply((Str)json);
                    String string = str._1();
                    Option option = str._2();
                    String s = string;
                    BytesRef bytes = new BytesRef((CharSequence)s);
                    SortedDocValuesField sorted = new SortedDocValuesField(fieldSortName, bytes);
                    LuceneStore.add$2(fields, (Field)sorted);
                    break block6;
                }
                if (!(json instanceof NumInt)) break block7;
                NumInt numInt = NumInt$.MODULE$.unapply((NumInt)json);
                long l = numInt._1();
                Option option = numInt._2();
                long l2 = l;
                LuceneStore.add$2(fields, (Field)new NumericDocValuesField(fieldSortName, l2));
                break block6;
            }
            Json j = json;
            if (!field.isSpatial()) break block6;
            Json json3 = j;
            Null$ null$ = Null$.MODULE$;
            if (json3 == null ? null$ != null : !json3.equals(null$)) {
                List list;
                Json json4 = j;
                if (json4 instanceof Arr) {
                    Arr arr = Arr$.MODULE$.unapply((Arr)json4);
                    Vector vector = arr._1();
                    Option option = arr._2();
                    Vector values = vector;
                    list = values.toList().map((Function1 & Serializable)_$7 -> (Geo)fabric.rw.package$.MODULE$.Asable(_$7).as(Geo$.MODULE$.rw()));
                } else {
                    list = (List)new .colon.colon((Object)((Geo)fabric.rw.package$.MODULE$.Asable(j).as(Geo$.MODULE$.rw())), (List)Nil$.MODULE$);
                }
                List list2 = list;
                list2.foreach((Function1)(JProcedure1 & Serializable)g -> LuceneStore.add$2(fields, (Field)new LatLonDocValuesField(fieldSortName, g.center().latitude(), g.center().longitude())));
            }
        }
        return (List)fields.elem;
    }

    private void addDoc(Doc doc, boolean upsert) {
        if (((IterableOnceOps)this.fields().tail()).nonEmpty()) {
            String id = this.id((lightdb.doc.Document)doc);
            IndexingState state = new IndexingState();
            List luceneFields = this.fields().flatMap((Function1 & Serializable)field -> this.createLuceneFields((lightdb.field.Field<Doc, ?>)field, doc, state));
            Document document = new Document();
            luceneFields.foreach((Function1)(JProcedure1 & Serializable)x$0 -> document.add(x$0));
            if (upsert) {
                this.index().indexWriter().updateDocument(new Term("_id", id), (Iterable)this.facetsPrepareDoc(document));
                return;
            }
            this.index().indexWriter().addDocument((Iterable)this.facetsPrepareDoc(document));
            return;
        }
    }

    public boolean exists(String id, Transaction<Doc> transaction) {
        return this.get(this.idField(), new Id(id), transaction).nonEmpty();
    }

    public <V> Option<Doc> get(Field.UniqueIndex<Doc, V> field, V value, Transaction<Doc> transaction) {
        Filter.Equals filter = Filter.Equals$.MODULE$.apply((lightdb.field.Field)field, value);
        Collection collection = this.collection();
        Some some = Some$.MODULE$.apply((Object)filter);
        Some some2 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        List list = Query$.MODULE$.$lessinit$greater$default$3();
        int n = Query$.MODULE$.$lessinit$greater$default$4();
        boolean bl = Query$.MODULE$.$lessinit$greater$default$6();
        boolean bl2 = Query$.MODULE$.$lessinit$greater$default$7();
        Option option = Query$.MODULE$.$lessinit$greater$default$8();
        Nil$ nil$ = Query$.MODULE$.$lessinit$greater$default$9();
        Query query = Query$.MODULE$.apply(collection, (Option)some, list, n, (Option)some2, bl, bl2, option, (List)nil$);
        return this.doSearch((Query<Doc, Model>)query, (Conversion<Doc, V>)Conversion.Doc$.MODULE$.apply(), transaction).list().headOption();
    }

    public <V> boolean delete(Field.UniqueIndex<Doc, V> field, V value, Transaction<Doc> transaction) {
        org.apache.lucene.search.Query query = this.filter2Lucene((Option<Filter<Doc>>)Some$.MODULE$.apply(((FilterSupport)field).$eq$eq$eq(value)));
        this.index().indexWriter().deleteDocuments(new org.apache.lucene.search.Query[]{query});
        return true;
    }

    public int count(Transaction<Doc> transaction) {
        return package$.MODULE$.state(transaction).indexSearcher().count((org.apache.lucene.search.Query)new MatchAllDocsQuery());
    }

    public Iterator<Doc> iterator(Transaction<Doc> transaction) {
        return this.doSearch((Query<Doc, Model>)Query$.MODULE$.apply(this.collection(), (Option)Query$.MODULE$.$lessinit$greater$default$2(), Query$.MODULE$.$lessinit$greater$default$3(), Query$.MODULE$.$lessinit$greater$default$4(), Query$.MODULE$.$lessinit$greater$default$5(), Query$.MODULE$.$lessinit$greater$default$6(), Query$.MODULE$.$lessinit$greater$default$7(), Query$.MODULE$.$lessinit$greater$default$8(), (List)Query$.MODULE$.$lessinit$greater$default$9()), (Conversion)Conversion.Doc$.MODULE$.apply(), transaction).iterator();
    }

    public <V> SearchResults<Doc, Model, V> doSearch(Query<Doc, Model> query, Conversion<Doc, V> conversion, Transaction<Doc> transaction) {
        Iterator iterator;
        List list;
        org.apache.lucene.search.Query q = this.filter2Lucene(query.filter());
        List list2 = query.sort();
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list3 = list2;
        List sortFields = !(nil$ != null ? !nil$.equals(list3) : list3 != null) ? (List)new .colon.colon((Object)SortField.FIELD_SCORE, (List)Nil$.MODULE$) : query.sort().map((Function1 & Serializable)sort -> this.sort2SortField((Sort)sort));
        org.apache.lucene.search.Sort s = new org.apache.lucene.search.Sort((SortField[])Arrays$.MODULE$.seqToArray((Seq)sortFields, SortField.class));
        IndexSearcher indexSearcher = package$.MODULE$.state(transaction).indexSearcher();
        ObjectRef facetsCollectorManager = ObjectRef.create((Object)None$.MODULE$);
        int limit = BoxesRunTime.unboxToInt((Object)query.limit().map((Function1)(JFunction1.mcII.sp & Serializable)l -> scala.math.package$.MODULE$.min(l, 100)).getOrElse(LuceneStore::$anonfun$8)) + query.offset();
        if (limit <= 0) {
            throw new RuntimeException(new StringBuilder(43).append("Limit must be a positive value, but set to ").append(limit).toString());
        }
        ObjectRef facetResults = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        TopFieldDocs topFieldDocs = this.search$1(query, facetsCollectorManager, indexSearcher, q, limit, s, facetResults, transaction, (Option)None$.MODULE$);
        List list4 = (List)Predef$.MODULE$.wrapRefArray((Object[])topFieldDocs.scoreDocs).toList().drop(query.offset());
        Option option = query.minDocScore();
        if (option instanceof Some) {
            double min = BoxesRunTime.unboxToDouble((Object)((Some)option).value());
            list = list4.filter((Function1 & Serializable)_$10 -> (double)_$10.score >= min);
        } else if (None$.MODULE$.equals(option)) {
            list = list4;
        } else {
            throw new MatchError((Object)option);
        }
        List scoreDocs = list;
        int total = (int)topFieldDocs.totalHits.value;
        StoredFields storedFields = indexSearcher.storedFields();
        List idsAndScores = scoreDocs.map((Function1 & Serializable)doc -> {
            Id id = (Id)Predef$.MODULE$.ArrowAssoc((Object)new Id(Id$.MODULE$.apply(storedFields.document(doc.doc).get("_id"))));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)id, (Object)BoxesRunTime.boxToDouble((double)doc.score));
        });
        Conversion<Doc, V> conversion2 = conversion;
        if (conversion2 instanceof Conversion.Value) {
            lightdb.field.Field field;
            Conversion.Value value = Conversion.Value$.MODULE$.unapply((Conversion.Value)conversion2);
            lightdb.field.Field field2 = field = value._1();
            iterator = scoreDocs.iterator().map((Function1 & Serializable)scoreDoc -> {
                Object object = Predef$.MODULE$.ArrowAssoc(LuceneStore.value$1(storedFields, scoreDoc, field2));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxesRunTime.boxToDouble((double)scoreDoc.score));
            });
        } else if (conversion2 instanceof Conversion.Doc && Conversion.Doc$.MODULE$.unapply((Conversion.Doc)conversion2)) {
            iterator = this.docIterator$1(scoreDocs, storedFields, transaction);
        } else if (conversion2 instanceof Conversion.Converted) {
            Function1 function1;
            Conversion.Converted converted = Conversion.Converted$.MODULE$.unapply((Conversion.Converted)conversion2);
            Function1 c = function1 = converted._1();
            iterator = this.docIterator$1(scoreDocs, storedFields, transaction).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    lightdb.doc.Document doc = (lightdb.doc.Document)tuple2._1();
                    double score = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                    Object object = Predef$.MODULE$.ArrowAssoc(c.apply((Object)doc));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxesRunTime.boxToDouble((double)score));
                }
                throw new MatchError((Object)tuple2);
            });
        } else if (conversion2 instanceof Conversion.Materialized) {
            List list5;
            Conversion.Materialized materialized = Conversion.Materialized$.MODULE$.unapply((Conversion.Materialized)conversion2);
            List fields = list5 = materialized._1();
            iterator = LuceneStore.jsonIterator$1(scoreDocs, storedFields, fields).map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    Json json = (Json)tuple3._2();
                    double score = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)MaterializedIndex$.MODULE$.apply(json, this.collection().model()));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxesRunTime.boxToDouble((double)score));
                }
                throw new MatchError((Object)tuple3);
            });
        } else if (conversion2 instanceof Conversion.DocAndIndexes && Conversion.DocAndIndexes$.MODULE$.unapply((Conversion.DocAndIndexes)conversion2)) {
            iterator = LuceneStore.jsonIterator$1(scoreDocs, storedFields, this.fields().filter((Function1 & Serializable)_$11 -> _$11.indexed())).map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    ScoreDoc scoreDoc = (ScoreDoc)tuple3._1();
                    Json json = (Json)tuple3._2();
                    double score = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)MaterializedAndDoc$.MODULE$.apply(json, this.collection().model(), (lightdb.doc.Document)this.loadScoreDoc$1(storedFields, transaction, scoreDoc)._1()));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxesRunTime.boxToDouble((double)score));
                }
                throw new MatchError((Object)tuple3);
            });
        } else if (conversion2 instanceof Conversion.Json) {
            List list6;
            Conversion.Json json = Conversion.Json$.MODULE$.unapply((Conversion.Json)conversion2);
            List fields = list6 = json._1();
            iterator = LuceneStore.jsonIterator$1(scoreDocs, storedFields, fields).map((Function1 & Serializable)t -> {
                Json json = (Json)Predef$.MODULE$.ArrowAssoc(t._2());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)json, t._3());
            });
        } else if (conversion2 instanceof Conversion.Distance) {
            Conversion.Distance distance = Conversion.Distance$.MODULE$.unapply((Conversion.Distance)conversion2);
            lightdb.field.Field field = distance._1();
            Geo.Point point = distance._2();
            boolean bl = distance._3();
            Option option2 = distance._4();
            lightdb.field.Field field3 = field;
            Geo.Point from = point;
            boolean sort2 = bl;
            Option radius = option2;
            iterator = idsAndScores.iterator().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String id = tuple2._1() == null ? null : ((Id)tuple2._1()).value();
                    double score = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                    IndexingState state = new IndexingState();
                    lightdb.doc.Document doc = this.collection().apply(id, transaction);
                    List distance = ((List)field3.get().apply(doc, field3, state)).map((Function1 & Serializable)d -> new Distance(Spatial$.MODULE$.distance((Geo)from, d)));
                    DistanceAndDoc distanceAndDoc = (DistanceAndDoc)Predef$.MODULE$.ArrowAssoc((Object)DistanceAndDoc$.MODULE$.apply((Object)doc, distance));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)distanceAndDoc, (Object)BoxesRunTime.boxToDouble((double)score));
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            throw new MatchError(conversion2);
        }
        Iterator iterator2 = iterator;
        return SearchResults$.MODULE$.apply(this.collection().model(), query.offset(), query.limit(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)total)), iterator2, (Map)facetResults.elem, transaction);
    }

    private org.apache.lucene.search.Query filter2Lucene(Option<Filter<Doc>> filter) {
        Option<Filter<Doc>> option = filter;
        if (option instanceof Some) {
            Filter f = (Filter)((Some)option).value();
            List fields = f.fields(this.collection().model());
            Filter filter2 = f;
            if (filter2 instanceof Filter.Equals) {
                Filter.Equals f2 = (Filter.Equals)filter2;
                return this.exactQuery(f2.field(this.collection().model()), f2.getJson(this.collection().model()));
            }
            if (filter2 instanceof Filter.NotEquals) {
                Filter.NotEquals f3 = (Filter.NotEquals)filter2;
                BooleanQuery.Builder b = new BooleanQuery.Builder();
                b.add((org.apache.lucene.search.Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                b.add(this.exactQuery(f3.field(this.collection().model()), f3.getJson(this.collection().model())), BooleanClause.Occur.MUST_NOT);
                return b.build();
            }
            if (filter2 instanceof Filter.Regex) {
                Filter.Regex f4 = (Filter.Regex)filter2;
                return new RegexpQuery(new Term(f4.fieldName(), f4.expression()));
            }
            if (filter2 instanceof Filter.In) {
                Filter.In f5 = (Filter.In)filter2;
                List queries = f5.getJson(this.collection().model()).map((Function1 & Serializable)json -> this.exactQuery((lightdb.field.Field<Doc, ?>)f5.field(this.collection().model()), (Json)json));
                BooleanQuery.Builder b = new BooleanQuery.Builder();
                b.setMinimumNumberShouldMatch(1);
                queries.foreach((Function1 & Serializable)q -> b.add(q, BooleanClause.Occur.SHOULD));
                return b.build();
            }
            if (filter2 instanceof Filter.RangeLong) {
                Filter.RangeLong rangeLong = Filter.RangeLong$.MODULE$.unapply((Filter.RangeLong)filter2);
                String string = rangeLong._1();
                Option option2 = rangeLong._2();
                Option option3 = rangeLong._3();
                String fieldName = string;
                Option from = option2;
                Option to = option3;
                return LongField.newRangeQuery((String)fieldName, (long)BoxesRunTime.unboxToLong((Object)from.getOrElse(LuceneStore::filter2Lucene$$anonfun$2)), (long)BoxesRunTime.unboxToLong((Object)to.getOrElse(LuceneStore::filter2Lucene$$anonfun$3)));
            }
            if (filter2 instanceof Filter.RangeDouble) {
                Filter.RangeDouble rangeDouble = Filter.RangeDouble$.MODULE$.unapply((Filter.RangeDouble)filter2);
                String string = rangeDouble._1();
                Option option4 = rangeDouble._2();
                Option option5 = rangeDouble._3();
                String fieldName = string;
                Option from = option4;
                Option to = option5;
                return DoubleField.newRangeQuery((String)fieldName, (double)BoxesRunTime.unboxToDouble((Object)from.getOrElse(LuceneStore::filter2Lucene$$anonfun$4)), (double)BoxesRunTime.unboxToDouble((Object)to.getOrElse(LuceneStore::filter2Lucene$$anonfun$5)));
            }
            if (filter2 instanceof Filter.StartsWith) {
                String string;
                Filter.StartsWith startsWith = Filter.StartsWith$.MODULE$.unapply((Filter.StartsWith)filter2);
                String string2 = startsWith._1();
                String query = string = startsWith._2();
                if (((lightdb.field.Field)fields.head()).isTokenized()) {
                    return this.parsed$1(f, new StringBuilder(1).append(query).append("*").toString(), LuceneStore.parsed$default$2$1());
                }
            }
            if (filter2 instanceof Filter.EndsWith) {
                String string;
                Filter.EndsWith endsWith = Filter.EndsWith$.MODULE$.unapply((Filter.EndsWith)filter2);
                String string3 = endsWith._1();
                String query = string = endsWith._2();
                if (((lightdb.field.Field)fields.head()).isTokenized()) {
                    return this.parsed$1(f, new StringBuilder(1).append("*").append(query).toString(), true);
                }
            }
            if (filter2 instanceof Filter.Contains) {
                String string;
                Filter.Contains contains = Filter.Contains$.MODULE$.unapply((Filter.Contains)filter2);
                String string4 = contains._1();
                String query = string = contains._2();
                if (((lightdb.field.Field)fields.head()).isTokenized()) {
                    return this.parsed$1(f, new StringBuilder(2).append("*").append(query).append("*").toString(), true);
                }
            }
            if (filter2 instanceof Filter.Exact) {
                String string;
                Filter.Exact exact = Filter.Exact$.MODULE$.unapply((Filter.Exact)filter2);
                String string5 = exact._1();
                String query = string = exact._2();
                if (((lightdb.field.Field)fields.head()).isTokenized()) {
                    return this.parsed$1(f, query, LuceneStore.parsed$default$2$1());
                }
            }
            if (filter2 instanceof Filter.StartsWith) {
                Filter.StartsWith startsWith = Filter.StartsWith$.MODULE$.unapply((Filter.StartsWith)filter2);
                String string = startsWith._1();
                String string6 = startsWith._2();
                String fieldName = string;
                String query = string6;
                return new WildcardQuery(new Term(fieldName, new StringBuilder(1).append(query).append("*").toString()));
            }
            if (filter2 instanceof Filter.EndsWith) {
                Filter.EndsWith endsWith = Filter.EndsWith$.MODULE$.unapply((Filter.EndsWith)filter2);
                String string = endsWith._1();
                String string7 = endsWith._2();
                String fieldName = string;
                String query = string7;
                return new WildcardQuery(new Term(fieldName, new StringBuilder(1).append("*").append(query).toString()));
            }
            if (filter2 instanceof Filter.Contains) {
                Filter.Contains contains = Filter.Contains$.MODULE$.unapply((Filter.Contains)filter2);
                String string = contains._1();
                String string8 = contains._2();
                String fieldName = string;
                String query = string8;
                return new WildcardQuery(new Term(fieldName, new StringBuilder(2).append("*").append(query).append("*").toString()));
            }
            if (filter2 instanceof Filter.Exact) {
                Filter.Exact exact = Filter.Exact$.MODULE$.unapply((Filter.Exact)filter2);
                String string = exact._1();
                String string9 = exact._2();
                String fieldName = string;
                String query = string9;
                return new WildcardQuery(new Term(fieldName, query));
            }
            if (filter2 instanceof Filter.Distance) {
                Filter.Distance distance = Filter.Distance$.MODULE$.unapply((Filter.Distance)filter2);
                String string = distance._1();
                Geo.Point point = distance._2();
                double d = distance._3();
                String fieldName = string;
                Geo.Point from = point;
                double radius = d;
                BooleanQuery.Builder b = new BooleanQuery.Builder();
                b.add(LatLonPoint.newDistanceQuery((String)fieldName, (double)from.latitude(), (double)from.longitude(), (double)Distance$.MODULE$.toMeters$extension(radius)), BooleanClause.Occur.MUST);
                b.add(LatLonPoint.newBoxQuery((String)fieldName, (double)0.0, (double)0.0, (double)0.0, (double)0.0), BooleanClause.Occur.MUST_NOT);
                return b.build();
            }
            if (filter2 instanceof Filter.Multi) {
                Filter.Multi multi = Filter.Multi$.MODULE$.unapply((Filter.Multi)filter2);
                int n = multi._1();
                List list = multi._2();
                int minShould = n;
                List clauses = list;
                BooleanQuery.Builder b = new BooleanQuery.Builder();
                boolean hasShould = clauses.exists((Function1 & Serializable)c -> {
                    Condition condition = c.condition();
                    Condition.Should$ should$ = Condition.Should$.MODULE$;
                    if (condition == null) {
                        if (should$ == null) return true;
                    } else if (condition.equals(should$)) return true;
                    Condition condition2 = c.condition();
                    Condition.Filter$ filter$ = Condition.Filter$.MODULE$;
                    if (condition2 != null) {
                        if (!condition2.equals(filter$)) return false;
                        return true;
                    }
                    if (filter$ == null) return true;
                    return false;
                });
                int minShouldMatch = hasShould ? minShould : 0;
                b.setMinimumNumberShouldMatch(minShouldMatch);
                clauses.foreach((Function1 & Serializable)c -> {
                    BooleanClause.Occur occur;
                    org.apache.lucene.search.Query query;
                    org.apache.lucene.search.Query q = this.filter2Lucene((Option<Filter<Doc>>)Some$.MODULE$.apply((Object)c.filter()));
                    Option option = c.boost();
                    if (option instanceof Some) {
                        double boost = BoxesRunTime.unboxToDouble((Object)((Some)option).value());
                        query = new BoostQuery(q, (float)boost);
                    } else if (None$.MODULE$.equals(option)) {
                        query = q;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    org.apache.lucene.search.Query query2 = query;
                    Condition condition = c.condition();
                    if (Condition.Must$.MODULE$.equals(condition)) {
                        occur = BooleanClause.Occur.MUST;
                    } else if (Condition.MustNot$.MODULE$.equals(condition)) {
                        occur = BooleanClause.Occur.MUST_NOT;
                    } else if (Condition.Filter$.MODULE$.equals(condition)) {
                        occur = BooleanClause.Occur.FILTER;
                    } else if (Condition.Should$.MODULE$.equals(condition)) {
                        occur = BooleanClause.Occur.SHOULD;
                    } else {
                        throw new MatchError((Object)condition);
                    }
                    BooleanClause.Occur occur2 = occur;
                    return b.add(query2, occur2);
                });
                if (minShouldMatch == 0 && !clauses.exists((Function1 & Serializable)_$12 -> {
                    Condition condition = _$12.condition();
                    Condition.Must$ must$ = Condition.Must$.MODULE$;
                    return !(condition != null ? !condition.equals(must$) : must$ != null);
                })) {
                    b.add((org.apache.lucene.search.Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                }
                return b.build();
            }
            if (filter2 instanceof Filter.DrillDownFacetFilter) {
                Filter.DrillDownFacetFilter drillDownFacetFilter = Filter.DrillDownFacetFilter$.MODULE$.unapply((Filter.DrillDownFacetFilter)filter2);
                String string = drillDownFacetFilter._1();
                List list = drillDownFacetFilter._2();
                boolean bl = drillDownFacetFilter._3();
                String fieldName = string;
                List path = list;
                boolean showOnlyThisLevel = bl;
                String indexedFieldName = this.facetsConfig().getDimConfig((String)fieldName).indexFieldName;
                List exactPath = showOnlyThisLevel ? ((List)new .colon.colon((Object)"$ROOT$", (List)Nil$.MODULE$)).$colon$colon$colon(path) : path;
                return new TermQuery(DrillDownQuery.term((String)indexedFieldName, (String)fieldName, (String[])((String[])Arrays$.MODULE$.seqToArray((Seq)exactPath, String.class))));
            }
            throw new MatchError((Object)filter2);
        }
        if (None$.MODULE$.equals(option)) {
            return new MatchAllDocsQuery();
        }
        throw new MatchError(option);
    }

    private org.apache.lucene.search.Query exactQuery(lightdb.field.Field<Doc, ?> field, Json json2) {
        Json json3 = json2;
        if (json3 instanceof Str) {
            Str str = Str$.MODULE$.unapply((Str)json3);
            String string = str._1();
            Option option = str._2();
            String s2 = string;
            if (field instanceof Field.Tokenized) {
                BooleanQuery.Builder b = new BooleanQuery.Builder();
                Object object = Predef$.MODULE$.refArrayOps((Object[])s2.split("\\s+"));
                ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)s -> b.add((org.apache.lucene.search.Query)new TermQuery(new Term(field.name(), s)), BooleanClause.Occur.MUST));
                return b.build();
            }
            String s3 = string;
            return new TermQuery(new Term(field.name(), s3));
        }
        if (json3 instanceof Bool) {
            Bool bool = Bool$.MODULE$.unapply((Bool)json3);
            boolean bl = bool._1();
            Option option = bool._2();
            boolean b = bl;
            return IntPoint.newExactQuery((String)field.name(), (int)(b ? 1 : 0));
        }
        if (json3 instanceof NumInt) {
            NumInt numInt = NumInt$.MODULE$.unapply((NumInt)json3);
            long l = numInt._1();
            Option option = numInt._2();
            long l2 = l;
            return LongPoint.newExactQuery((String)field.name(), (long)l2);
        }
        if (json3 instanceof NumDec) {
            NumDec numDec = NumDec$.MODULE$.unapply((NumDec)json3);
            BigDecimal bigDecimal = numDec._1();
            Option option = numDec._2();
            BigDecimal bd = bigDecimal;
            return DoublePoint.newExactQuery((String)field.name(), (double)bd.toDouble());
        }
        if (json3 instanceof Arr) {
            Arr arr = Arr$.MODULE$.unapply((Arr)json3);
            Vector vector = arr._1();
            Option option = arr._2();
            Vector v = vector;
            BooleanQuery.Builder b = new BooleanQuery.Builder();
            v.foreach((Function1 & Serializable)json -> {
                org.apache.lucene.search.Query q = this.exactQuery(field, (Json)json);
                return b.add(q, BooleanClause.Occur.MUST);
            });
            return b.build();
        }
        if (Null$.MODULE$.equals(json3)) {
            DefType.Opt opt;
            DefType defType;
            DefType defType2 = field.rw().definition();
            if (defType2 instanceof DefType.Opt && DefType.Str$.MODULE$.equals(defType = (opt = DefType.Opt$.MODULE$.unapply((DefType.Opt)defType2))._1())) {
                return new TermQuery(new Term(field.name(), Field$.MODULE$.NullString()));
            }
            return new TermQuery(new Term(field.name(), "null"));
        }
        Json json4 = json3;
        throw new RuntimeException(new StringBuilder(31).append("Unsupported equality check: ").append(json4).append(" (").append(field.rw().definition()).append(")").toString());
    }

    private SortField sort2SortField(Sort sort) {
        Sort sort2 = sort;
        if (Sort.BestMatch$.MODULE$.equals(sort2)) {
            return SortField.FIELD_SCORE;
        }
        if (Sort.IndexOrder$.MODULE$.equals(sort2)) {
            return SortField.FIELD_DOC;
        }
        if (sort2 instanceof Sort.ByField) {
            Sort.ByField byField = Sort.ByField$.MODULE$.unapply((Sort.ByField)sort2);
            lightdb.field.Field field = byField._1();
            SortDirection sortDirection = byField._2();
            lightdb.field.Field field2 = field;
            SortDirection dir = sortDirection;
            String fieldSortName = new StringBuilder(4).append(field2.name()).append("Sort").toString();
            SortField.Type sortType = LuceneStore.st$1(field2, field2.rw().definition());
            return LuceneStore.sf$1(fieldSortName, sortType, dir, field2.rw().definition());
        }
        if (sort2 instanceof Sort.ByDistance) {
            Sort.ByDistance byDistance = Sort.ByDistance$.MODULE$.unapply((Sort.ByDistance)sort2);
            lightdb.field.Field field = byDistance._1();
            Geo.Point point = byDistance._2();
            SortDirection sortDirection = byDistance._3();
            lightdb.field.Field field3 = field;
            Geo.Point from = point;
            String fieldSortName = new StringBuilder(4).append(field3.name()).append("Sort").toString();
            return LatLonDocValuesField.newDistanceSort((String)fieldSortName, (double)from.latitude(), (double)from.longitude());
        }
        throw new MatchError((Object)sort2);
    }

    public Iterator<MaterializedAggregate<Doc, Model>> aggregate(AggregateQuery<Doc, Model> query, Transaction<Doc> transaction) {
        return Aggregator$.MODULE$.apply(query, this.collection(), transaction);
    }

    public int aggregateCount(AggregateQuery<Doc, Model> query, Transaction<Doc> transaction) {
        return this.aggregate(query, transaction).length();
    }

    public int truncate(Transaction<Doc> transaction) {
        int count = this.count(transaction);
        this.index().indexWriter().deleteAll();
        return count;
    }

    public void dispose() {
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.dispose$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private static final void indexPoint$1(lightdb.field.Field field$1, Geo.Point p) {
        LatLonShape.createIndexableFields((String)field$1.name(), (double)p.latitude(), (double)p.longitude());
    }

    private static final void indexLine$1(lightdb.field.Field field$2, Geo.Line l) {
        Line line = new Line((double[])l.points().map((Function1 & Serializable)_$2 -> _$2.latitude()).toArray(ClassTag$.MODULE$.apply(Double.TYPE)), (double[])l.points().map((Function1 & Serializable)_$3 -> _$3.longitude()).toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
        LatLonShape.createIndexableFields((String)field$2.name(), (Line)line);
    }

    private static final Polygon convert$1(Geo.Polygon p) {
        return new Polygon((double[])p.points().map((Function1 & Serializable)_$4 -> _$4.latitude()).toArray(ClassTag$.MODULE$.apply(Double.TYPE)), (double[])p.points().map((Function1 & Serializable)_$5 -> _$5.longitude()).toArray(ClassTag$.MODULE$.apply(Double.TYPE)), new Polygon[0]);
    }

    private static final void indexPolygon$1(lightdb.field.Field field$3, Geo.Polygon p) {
        Polygon polygon = LuceneStore.convert$1(p);
        LatLonShape.createIndexableFields((String)field$3.name(), (Polygon)polygon);
    }

    private final Field.Store fs$1(lightdb.field.Field field$5) {
        StoreMode storeMode = this.storeMode();
        StoreMode.All$ all$ = StoreMode.All$.MODULE$;
        if (!(storeMode == null ? all$ != null : !storeMode.equals(all$)) || field$5.indexed()) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    private static final void add$2(ObjectRef fields$1, Field field) {
        fields$1.elem = ((List)fields$1.elem).$colon$colon((Object)field);
    }

    private final void addJson$1(lightdb.field.Field field$7, ObjectRef fields$2, Json json2, DefType d) {
        DefType defType;
        block14: {
            block13: {
                while (true) {
                    DefType defType2;
                    DefType d2;
                    if (field$7.isSpatial()) {
                        Json json3 = json2;
                        Null$ null$ = Null$.MODULE$;
                        if (json3 == null ? null$ != null : !json3.equals(null$)) {
                            this.createGeoFields(field$7, json2, (Function1<Field, BoxedUnit>)(JProcedure1 & Serializable)field -> LuceneStore.add$2(fields$2, field));
                            return;
                        }
                        return;
                    }
                    defType = d;
                    if (DefType.Str$.MODULE$.equals(defType)) {
                        Json json4 = json2;
                        if (Null$.MODULE$.equals(json4)) {
                            LuceneStore.add$2(fields$2, (Field)new StringField(field$7.name(), Field$.MODULE$.NullString(), this.fs$1(field$7)));
                            return;
                        }
                        LuceneStore.add$2(fields$2, (Field)new StringField(field$7.name(), json2.asString(), this.fs$1(field$7)));
                        return;
                    }
                    if (!(defType instanceof DefType.Opt)) break;
                    DefType.Opt opt = DefType.Opt$.MODULE$.unapply((DefType.Opt)defType);
                    d = d2 = (defType2 = opt._1());
                }
                if (DefType.Json$.MODULE$.equals(defType)) break block13;
                if (!(defType instanceof DefType.Obj)) break block14;
                DefType.Obj obj = DefType.Obj$.MODULE$.unapply((DefType.Obj)defType);
                Map map = obj._1();
                Option option = obj._2();
            }
            LuceneStore.add$2(fields$2, (Field)new StringField(field$7.name(), JsonFormatter$.MODULE$.Compact().apply(json2), this.fs$1(field$7)));
            return;
        }
        Json json5 = json2;
        Null$ null$ = Null$.MODULE$;
        if (!(json5 != null ? !json5.equals(null$) : null$ != null)) {
            return;
        }
        if (defType instanceof DefType.Arr) {
            DefType defType3;
            DefType.Arr arr = DefType.Arr$.MODULE$.unapply((DefType.Arr)defType);
            DefType d3 = defType3 = arr._1();
            json2.asVector().foreach((Function1)(JProcedure1 & Serializable)json -> this.addJson$1(field$7, fields$2, (Json)json, d3));
            return;
        }
        if (DefType.Bool$.MODULE$.equals(defType)) {
            LuceneStore.add$2(fields$2, (Field)new IntField(field$7.name(), json2.asBoolean() ? 1 : 0, this.fs$1(field$7)));
            return;
        }
        if (DefType.Int$.MODULE$.equals(defType)) {
            LuceneStore.add$2(fields$2, (Field)new LongField(field$7.name(), json2.asLong(), this.fs$1(field$7)));
            return;
        }
        if (DefType.Dec$.MODULE$.equals(defType)) {
            LuceneStore.add$2(fields$2, (Field)new DoubleField(field$7.name(), json2.asDouble(), this.fs$1(field$7)));
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(52).append("Unsupported definition (field: ").append(field$7.name()).append(", className: ").append(field$7.className()).append("): ").append(d).append(" for ").append(json2).toString());
    }

    private static final int $anonfun$8() {
        return 100;
    }

    private static final int $anonfun$9(int limit$3) {
        return limit$3;
    }

    private static final int $anonfun$10(int limit$4) {
        return limit$4;
    }

    private static final int $anonfun$14(TopFieldDocs topFieldDocs$1) {
        return (int)topFieldDocs$1.totalHits.value;
    }

    private static final int search$1$$anonfun$4(int totalHits$2) {
        return totalHits$2;
    }

    private final TopFieldDocs search$1(Query query$1, ObjectRef facetsCollectorManager$1, IndexSearcher indexSearcher$1, org.apache.lucene.search.Query q$1, int limit$2, org.apache.lucene.search.Sort s$1, ObjectRef facetResults$1, Transaction transaction$1, Option total) {
        TopFieldDocs topFieldDocs;
        while (true) {
            Map map;
            Tuple2 tuple2;
            Option option;
            if (query$1.facets().nonEmpty()) {
                facetsCollectorManager$1.elem = Some$.MODULE$.apply((Object)new FacetsCollectorManager(query$1.scoreDocs()));
            }
            if ((option = (Option)facetsCollectorManager$1.elem) instanceof Some) {
                FacetsCollectorManager fcm = (FacetsCollectorManager)((Some)option).value();
                FacetsCollectorManager.FacetsResult facetsResult = FacetsCollectorManager.search((IndexSearcher)indexSearcher$1, (org.apache.lucene.search.Query)q$1, (int)BoxesRunTime.unboxToInt((Object)total.getOrElse(() -> LuceneStore.$anonfun$9(limit$2))), (org.apache.lucene.search.Sort)s$1, (boolean)query$1.scoreDocs(), (FacetsCollectorManager)fcm);
                tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)facetsResult.facetsCollector()), (Object)((TopFieldDocs)facetsResult.topDocs()));
            } else if (None$.MODULE$.equals(option)) {
                tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)indexSearcher$1.search(q$1, BoxesRunTime.unboxToInt((Object)total.getOrElse(() -> LuceneStore.$anonfun$10(limit$2))), s$1, query$1.scoreDocs()));
            } else {
                throw new MatchError((Object)option);
            }
            Tuple2 tuple22 = tuple2;
            Option facetsCollector = (Option)tuple22._1();
            topFieldDocs = (TopFieldDocs)tuple22._2();
            Option option2 = facetsCollector;
            if (option2 instanceof Some) {
                FacetsCollector fc = (FacetsCollector)((Some)option2).value();
                FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts(package$.MODULE$.state(transaction$1).taxonomyReader(), this.facetsConfig(), fc);
                map = query$1.facets().map((Function1 & Serializable)fq -> {
                    FacetResult facetResult;
                    Option option = fq.childrenLimit();
                    if (option instanceof Some) {
                        int l = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                        facetResult = facets.getTopChildren(l, fq.field().name(), (String[])Arrays$.MODULE$.seqToArray((Seq)fq.path(), String.class));
                    } else if (None$.MODULE$.equals(option)) {
                        facetResult = facets.getAllChildren(fq.field().name(), (String[])Arrays$.MODULE$.seqToArray((Seq)fq.path(), String.class));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    Option option2 = Option$.MODULE$.apply((Object)facetResult);
                    if (option2 instanceof Some) {
                        FacetResult facetResult2 = (FacetResult)((Some)option2).value();
                        Nil$ values = facetResult2.childCount > 0 ? Predef$.MODULE$.wrapRefArray((Object[])facetResult2.labelValues).toList().map((Function1 & Serializable)lv -> FacetResultValue$.MODULE$.apply(lv.label, lv.value.intValue())) : scala.package$.MODULE$.Nil();
                        List updatedValues = values.filterNot((Function1 & Serializable)_$8 -> {
                            String string = _$8.value();
                            String string2 = "$ROOT$";
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        });
                        int totalCount = BoxesRunTime.unboxToInt((Object)updatedValues.map((Function1 & Serializable)_$9 -> _$9.count()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                        Field.FacetField facetField = (Field.FacetField)Predef$.MODULE$.ArrowAssoc((Object)fq.field());
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)facetField, (Object)FacetResult$.MODULE$.apply(updatedValues, updatedValues.length(), totalCount));
                    }
                    if (None$.MODULE$.equals(option2)) {
                        Field.FacetField facetField = (Field.FacetField)Predef$.MODULE$.ArrowAssoc((Object)fq.field());
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)facetField, (Object)FacetResult$.MODULE$.apply((List)scala.package$.MODULE$.Nil(), 0, 0));
                    }
                    throw new MatchError((Object)option2);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            } else if (None$.MODULE$.equals(option2)) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                throw new MatchError((Object)option2);
            }
            facetResults$1.elem = map;
            int totalHits = BoxesRunTime.unboxToInt((Object)total.getOrElse(() -> LuceneStore.$anonfun$14(topFieldDocs)));
            if (totalHits <= topFieldDocs.scoreDocs.length || !total.isEmpty() || !query$1.limit().forall((Function1)(JFunction1.mcZI.sp & Serializable)l -> l + query$1.offset() > limit$2)) break;
            total = Some$.MODULE$.apply(query$1.limit().map((Function1)(JFunction1.mcII.sp & Serializable)l -> scala.math.package$.MODULE$.min(l, totalHits)).getOrElse(() -> LuceneStore.search$1$$anonfun$4(totalHits)));
        }
        return topFieldDocs;
    }

    private static final Json json$1(StoredFields storedFields$2, ScoreDoc scoreDoc, lightdb.field.Field field) {
        String s = storedFields$2.document(scoreDoc.doc).get(field.name());
        return Field$.MODULE$.string2Json(field.name(), s, field.rw().definition());
    }

    private static final Object value$1(StoredFields storedFields$11, ScoreDoc scoreDoc, lightdb.field.Field field) {
        return fabric.rw.package$.MODULE$.Asable(LuceneStore.json$1(storedFields$11, scoreDoc, field)).as(field.rw());
    }

    private final Tuple2 loadScoreDoc$1(StoredFields storedFields$5, Transaction transaction$2, ScoreDoc scoreDoc) {
        StoreMode storeMode = this.storeMode();
        StoreMode.All$ all$ = StoreMode.All$.MODULE$;
        if (!(storeMode != null ? !storeMode.equals(all$) : all$ != null)) {
            DocumentModel documentModel = this.collection().model();
            if (documentModel instanceof JsonConversion) {
                JsonConversion c = (JsonConversion)documentModel;
                Obj o = fabric.package$.MODULE$.obj((Seq)this.fields().map((Function1 & Serializable)f -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)f.name());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)LuceneStore.json$1(storedFields$5, scoreDoc, f));
                }));
                lightdb.doc.Document document = (lightdb.doc.Document)Predef$.MODULE$.ArrowAssoc((Object)c.convertFromJson((Json)o));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)document, (Object)BoxesRunTime.boxToDouble((double)scoreDoc.score));
            }
            Map map = this.fields().map((Function1 & Serializable)field -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)field.name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, LuceneStore.value$1(storedFields$5, scoreDoc, field));
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            lightdb.doc.Document document = (lightdb.doc.Document)Predef$.MODULE$.ArrowAssoc((Object)this.collection().model().map2Doc(map));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)document, (Object)BoxesRunTime.boxToDouble((double)scoreDoc.score));
        }
        int docId = scoreDoc.doc;
        String id = Id$.MODULE$.apply(storedFields$5.document(docId).get("_id"));
        double score = scoreDoc.score;
        lightdb.doc.Document document = (lightdb.doc.Document)Predef$.MODULE$.ArrowAssoc((Object)this.collection().apply(id, transaction$2));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)document, (Object)BoxesRunTime.boxToDouble((double)score));
    }

    private final Iterator docIterator$1(List scoreDocs$2, StoredFields storedFields$6, Transaction transaction$3) {
        return scoreDocs$2.iterator().map((Function1 & Serializable)scoreDoc -> this.loadScoreDoc$1(storedFields$6, transaction$3, (ScoreDoc)scoreDoc));
    }

    private static final Iterator jsonIterator$1(List scoreDocs$3, StoredFields storedFields$7, List fields) {
        return scoreDocs$3.iterator().map((Function1 & Serializable)scoreDoc -> {
            Obj json = fabric.package$.MODULE$.obj((Seq)fields.map((Function1 & Serializable)field -> {
                String s = storedFields$7.document(scoreDoc$3.doc).get(field.name());
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)field.name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Field$.MODULE$.string2Json(field.name(), s, field.rw().definition()));
            }));
            double score = scoreDoc.score;
            return Tuple3$.MODULE$.apply(scoreDoc, (Object)json, (Object)BoxesRunTime.boxToDouble((double)score));
        });
    }

    private final org.apache.lucene.search.Query parsed$1(Filter f$1, String q, boolean allowLeading) {
        QueryParser parser = new QueryParser((String)f$1.fieldNames().head(), this.index().analyzer());
        parser.setAllowLeadingWildcard(allowLeading);
        parser.setSplitOnWhitespace(true);
        return parser.parse(q);
    }

    private static final boolean parsed$default$2$1() {
        return false;
    }

    private static final long filter2Lucene$$anonfun$2() {
        return Long.MIN_VALUE;
    }

    private static final long filter2Lucene$$anonfun$3() {
        return Long.MAX_VALUE;
    }

    private static final double filter2Lucene$$anonfun$4() {
        return -1.7976931348623157E308;
    }

    private static final double filter2Lucene$$anonfun$5() {
        return Double.MAX_VALUE;
    }

    private static final SortField.Type st$1(lightdb.field.Field field$13, DefType d) {
        while (true) {
            DefType defType;
            DefType t;
            DefType defType2;
            if (DefType.Str$.MODULE$.equals(defType2 = d)) {
                return SortField.Type.STRING;
            }
            if (DefType.Dec$.MODULE$.equals(defType2)) {
                return SortField.Type.DOUBLE;
            }
            if (DefType.Int$.MODULE$.equals(defType2)) {
                return SortField.Type.LONG;
            }
            if (!(defType2 instanceof DefType.Opt)) break;
            DefType.Opt opt = DefType.Opt$.MODULE$.unapply((DefType.Opt)defType2);
            d = t = (defType = opt._1());
        }
        throw new RuntimeException(new StringBuilder(26).append("Unsupported sort type for ").append(field$13.rw().definition()).toString());
    }

    private static final SortField sf$1(String fieldSortName$2, SortField.Type sortType$1, SortDirection dir$1, DefType d) {
        DefType defType;
        while (true) {
            DefType defType2;
            DefType t;
            if (DefType.Int$.MODULE$.equals(defType = d) || DefType.Dec$.MODULE$.equals(defType)) {
                SortDirection sortDirection = dir$1;
                SortDirection.Descending$ descending$ = SortDirection.Descending$.MODULE$;
                return new SortedNumericSortField(fieldSortName$2, sortType$1, !(sortDirection != null ? !sortDirection.equals(descending$) : descending$ != null));
            }
            if (DefType.Str$.MODULE$.equals(defType)) {
                SortDirection sortDirection = dir$1;
                SortDirection.Descending$ descending$ = SortDirection.Descending$.MODULE$;
                return new SortField(fieldSortName$2, sortType$1, !(sortDirection != null ? !sortDirection.equals(descending$) : descending$ != null));
            }
            if (!(defType instanceof DefType.Opt)) break;
            DefType.Opt opt = DefType.Opt$.MODULE$.unapply((DefType.Opt)defType);
            d = t = (defType2 = opt._1());
        }
        DefType d2 = defType;
        throw new RuntimeException(new StringBuilder(29).append("Unsupported sort definition: ").append(d2).toString());
    }

    private final void dispose$$anonfun$1() {
        this.index().dispose();
    }
}

