/*
 * Decompiled with CFR 0.152.
 */
package lightdb.lucene.index;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lightdb.lucene.index.Index$;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class Index
implements Product,
Serializable {
    public static final long OFFSET$8 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("taxonomyWriter$lzy1"));
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("taxonomyDirectory$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("taxonomyPath$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("searcherManager$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("indexWriter$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("config$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("indexDirectory$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("parser$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Index.class.getDeclaredField("analyzer$lzy1"));
    private final Option<Path> path;
    private volatile Object analyzer$lzy1;
    private volatile Object parser$lzy1;
    private volatile Object indexDirectory$lzy1;
    private volatile Object config$lzy1;
    private volatile Object indexWriter$lzy1;
    private volatile Object searcherManager$lzy1;
    private volatile Object taxonomyPath$lzy1;
    private boolean taxonomyLoaded;
    private volatile Object taxonomyDirectory$lzy1;
    private volatile Object taxonomyWriter$lzy1;

    public static Index apply(Option<Path> option) {
        return Index$.MODULE$.apply(option);
    }

    public static Index fromProduct(Product product) {
        return Index$.MODULE$.fromProduct(product);
    }

    public static Index unapply(Index index) {
        return Index$.MODULE$.unapply(index);
    }

    public Index(Option<Path> path) {
        this.path = path;
        this.taxonomyLoaded = false;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Index)) return false;
        Index index = (Index)object;
        Option<Path> option = this.path();
        Option<Path> option2 = index.path();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!index.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Index;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Index";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "path";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<Path> path() {
        return this.path;
    }

    public Analyzer analyzer() {
        Object object = this.analyzer$lzy1;
        if (object instanceof Analyzer) {
            return (Analyzer)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Analyzer)this.analyzer$lzyINIT1();
    }

    private Object analyzer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.analyzer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    StandardAnalyzer standardAnalyzer = null;
                    try {
                        standardAnalyzer = new StandardAnalyzer();
                        object2 = standardAnalyzer == null ? LazyVals.NullValue$.MODULE$ : standardAnalyzer;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.analyzer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return standardAnalyzer;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public QueryParser parser() {
        Object object = this.parser$lzy1;
        if (object instanceof QueryParser) {
            return (QueryParser)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (QueryParser)this.parser$lzyINIT1();
    }

    private Object parser$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parser$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    QueryParser queryParser = null;
                    try {
                        queryParser = new QueryParser("_id", this.analyzer());
                        object2 = queryParser == null ? LazyVals.NullValue$.MODULE$ : queryParser;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parser$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return queryParser;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private BaseDirectory indexDirectory() {
        Object object = this.indexDirectory$lzy1;
        if (object instanceof BaseDirectory) {
            return (BaseDirectory)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BaseDirectory)this.indexDirectory$lzyINIT1();
    }

    private Object indexDirectory$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.indexDirectory$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BaseDirectory baseDirectory = null;
                    try {
                        baseDirectory = (BaseDirectory)this.path().map((Function1 & Serializable)x$0 -> FSDirectory.open((Path)x$0)).getOrElse(Index::indexDirectory$lzyINIT1$$anonfun$2);
                        object2 = baseDirectory == null ? LazyVals.NullValue$.MODULE$ : baseDirectory;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.indexDirectory$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return baseDirectory;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private IndexWriterConfig config() {
        Object object = this.config$lzy1;
        if (object instanceof IndexWriterConfig) {
            return (IndexWriterConfig)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IndexWriterConfig)this.config$lzyINIT1();
    }

    private Object config$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.config$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IndexWriterConfig indexWriterConfig = null;
                    try {
                        IndexWriterConfig c = new IndexWriterConfig(this.analyzer());
                        c.setCommitOnClose(true);
                        c.setRAMBufferSizeMB(1000.0);
                        indexWriterConfig = c;
                        object2 = indexWriterConfig == null ? LazyVals.NullValue$.MODULE$ : indexWriterConfig;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.config$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.config$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return indexWriterConfig;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public IndexWriter indexWriter() {
        Object object = this.indexWriter$lzy1;
        if (object instanceof IndexWriter) {
            return (IndexWriter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IndexWriter)this.indexWriter$lzyINIT1();
    }

    private Object indexWriter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.indexWriter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IndexWriter indexWriter = null;
                    try {
                        indexWriter = new IndexWriter((Directory)this.indexDirectory(), this.config());
                        object2 = indexWriter == null ? LazyVals.NullValue$.MODULE$ : indexWriter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.indexWriter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return indexWriter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private SearcherManager searcherManager() {
        Object object = this.searcherManager$lzy1;
        if (object instanceof SearcherManager) {
            return (SearcherManager)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SearcherManager)this.searcherManager$lzyINIT1();
    }

    private Object searcherManager$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.searcherManager$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SearcherManager searcherManager = null;
                    try {
                        searcherManager = new SearcherManager(this.indexWriter(), new SearcherFactory());
                        object2 = searcherManager == null ? LazyVals.NullValue$.MODULE$ : searcherManager;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.searcherManager$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return searcherManager;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<Path> taxonomyPath() {
        Object object = this.taxonomyPath$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.taxonomyPath$lzyINIT1();
    }

    private Object taxonomyPath$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.taxonomyPath$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.path().map((Function1 & Serializable)p -> p.resolve("taxonomy"));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.taxonomyPath$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private BaseDirectory taxonomyDirectory() {
        Object object = this.taxonomyDirectory$lzy1;
        if (object instanceof BaseDirectory) {
            return (BaseDirectory)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BaseDirectory)this.taxonomyDirectory$lzyINIT1();
    }

    private Object taxonomyDirectory$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.taxonomyDirectory$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BaseDirectory baseDirectory = null;
                    try {
                        baseDirectory = (BaseDirectory)this.taxonomyPath().map((Function1 & Serializable)path -> {
                            if (!Files.exists(path, new LinkOption[0])) {
                                Files.createDirectories(path, new FileAttribute[0]);
                            }
                            this.taxonomyLoaded = true;
                            return FSDirectory.open((Path)path);
                        }).getOrElse(Index::taxonomyDirectory$lzyINIT1$$anonfun$2);
                        object2 = baseDirectory == null ? LazyVals.NullValue$.MODULE$ : baseDirectory;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.taxonomyDirectory$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return baseDirectory;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DirectoryTaxonomyWriter taxonomyWriter() {
        Object object = this.taxonomyWriter$lzy1;
        if (object instanceof DirectoryTaxonomyWriter) {
            return (DirectoryTaxonomyWriter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DirectoryTaxonomyWriter)this.taxonomyWriter$lzyINIT1();
    }

    private Object taxonomyWriter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.taxonomyWriter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DirectoryTaxonomyWriter directoryTaxonomyWriter = null;
                    try {
                        directoryTaxonomyWriter = new DirectoryTaxonomyWriter((Directory)this.taxonomyDirectory());
                        object2 = directoryTaxonomyWriter == null ? LazyVals.NullValue$.MODULE$ : directoryTaxonomyWriter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.taxonomyWriter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return directoryTaxonomyWriter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public IndexSearcher createIndexSearcher() {
        this.searcherManager().maybeRefreshBlocking();
        return (IndexSearcher)this.searcherManager().acquire();
    }

    public TaxonomyReader createTaxonomyReader() {
        return new DirectoryTaxonomyReader(this.taxonomyWriter());
    }

    public void releaseIndexSearch(IndexSearcher indexSearcher) {
        this.searcherManager().release((Object)indexSearcher);
    }

    public void releaseTaxonomyReader(TaxonomyReader taxonomyReader) {
        taxonomyReader.close();
    }

    public void commit() {
        this.indexWriter().flush();
        this.indexWriter().commit();
        if (this.taxonomyLoaded) {
            this.taxonomyWriter().commit();
            return;
        }
    }

    public void rollback() {
        this.indexWriter().rollback();
        if (this.taxonomyLoaded) {
            this.taxonomyWriter().rollback();
            return;
        }
    }

    public void dispose() {
        this.commit();
        this.indexWriter().close();
        if (this.taxonomyLoaded) {
            this.taxonomyDirectory().close();
            return;
        }
    }

    public Index copy(Option<Path> path) {
        return new Index(path);
    }

    public Option<Path> copy$default$1() {
        return this.path();
    }

    public Option<Path> _1() {
        return this.path();
    }

    private static final BaseDirectory indexDirectory$lzyINIT1$$anonfun$2() {
        return new ByteBuffersDirectory();
    }

    private static final BaseDirectory taxonomyDirectory$lzyINIT1$$anonfun$2() {
        return new ByteBuffersDirectory();
    }
}

