/*
 * Decompiled with CFR 0.152.
 */
package lightdb.lucene;

import java.io.Serializable;
import lightdb.doc.Document;
import lightdb.lucene.LuceneState$;
import lightdb.lucene.index.Index;
import lightdb.transaction.TransactionFeature;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.search.IndexSearcher;
import scala.Function1;
import scala.Product;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class LuceneState<Doc extends Document<Doc>>
implements TransactionFeature,
Product,
Serializable {
    private final Index index;
    private final boolean hasFacets;
    private List<IndexSearcher> oldIndexSearchers;
    private List<TaxonomyReader> oldTaxonomyReaders;
    private IndexSearcher _indexSearcher;
    private TaxonomyReader _taxonomyReader;

    public static <Doc extends Document<Doc>> LuceneState<Doc> apply(Index index, boolean bl) {
        return LuceneState$.MODULE$.apply(index, bl);
    }

    public static LuceneState<?> fromProduct(Product product) {
        return LuceneState$.MODULE$.fromProduct(product);
    }

    public static <Doc extends Document<Doc>> LuceneState<Doc> unapply(LuceneState<Doc> luceneState) {
        return LuceneState$.MODULE$.unapply(luceneState);
    }

    public LuceneState(Index index, boolean hasFacets) {
        this.index = index;
        this.hasFacets = hasFacets;
        this.oldIndexSearchers = package$.MODULE$.List().empty();
        this.oldTaxonomyReaders = package$.MODULE$.List().empty();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.index()));
        n = Statics.mix((int)n, (int)(this.hasFacets() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LuceneState)) return false;
        LuceneState luceneState = (LuceneState)object;
        if (this.hasFacets() != luceneState.hasFacets()) return false;
        Index index = this.index();
        Index index2 = luceneState.index();
        if (index == null) {
            if (index2 != null) {
                return false;
            }
        } else if (!((Object)index).equals(index2)) return false;
        if (!luceneState.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LuceneState;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "LuceneState";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return BoxesRunTime.boxToBoolean((boolean)this._2());
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "index";
        }
        if (1 == n2) {
            return "hasFacets";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Index index() {
        return this.index;
    }

    public boolean hasFacets() {
        return this.hasFacets;
    }

    public IndexSearcher indexSearcher() {
        IndexSearcher indexSearcher;
        LuceneState luceneState = this;
        synchronized (luceneState) {
            if (this._indexSearcher == null) {
                this._indexSearcher = this.index().createIndexSearcher();
                if (this.hasFacets()) {
                    this._taxonomyReader = this.index().createTaxonomyReader();
                }
            }
            indexSearcher = this._indexSearcher;
        }
        return indexSearcher;
    }

    private void releaseIndexSearcher() {
        LuceneState luceneState = this;
        synchronized (luceneState) {
            BoxedUnit boxedUnit;
            if (this._indexSearcher != null) {
                IndexSearcher indexSearcher = this._indexSearcher;
                this.oldIndexSearchers = this.oldIndexSearchers.$colon$colon((Object)indexSearcher);
                this._indexSearcher = null;
            }
            if (this._taxonomyReader != null) {
                TaxonomyReader taxonomyReader = this._taxonomyReader;
                this.oldTaxonomyReaders = this.oldTaxonomyReaders.$colon$colon((Object)taxonomyReader);
                this._taxonomyReader = null;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public TaxonomyReader taxonomyReader() {
        return this._taxonomyReader;
    }

    public void commit() {
        this.index().commit();
        this.releaseIndexSearcher();
    }

    public void rollback() {
        this.index().rollback();
        this.releaseIndexSearcher();
    }

    public void close() {
        this.commit();
        this.oldIndexSearchers.foreach((Function1)(JProcedure1 & Serializable)indexSearcher -> this.index().releaseIndexSearch((IndexSearcher)indexSearcher));
        this.oldTaxonomyReaders.foreach((Function1)(JProcedure1 & Serializable)taxonomyReader -> this.index().releaseTaxonomyReader((TaxonomyReader)taxonomyReader));
        if (this._indexSearcher != null) {
            this.index().releaseIndexSearch(this._indexSearcher);
        }
        if (this._taxonomyReader != null) {
            this.index().releaseTaxonomyReader(this._taxonomyReader);
            return;
        }
    }

    public <Doc extends Document<Doc>> LuceneState<Doc> copy(Index index, boolean hasFacets) {
        return new LuceneState<Doc>(index, hasFacets);
    }

    public <Doc extends Document<Doc>> Index copy$default$1() {
        return this.index();
    }

    public boolean copy$default$2() {
        return this.hasFacets();
    }

    public Index _1() {
        return this.index();
    }

    public boolean _2() {
        return this.hasFacets();
    }
}

