/*
 * Decompiled with CFR 0.152.
 */
package lightdb.lucene;

import fabric.Bool;
import fabric.Bool$;
import fabric.Json;
import fabric.Null$;
import fabric.NumDec;
import fabric.NumDec$;
import fabric.NumInt;
import fabric.NumInt$;
import fabric.Obj;
import fabric.Str;
import fabric.Str$;
import fabric.define.DefType;
import fabric.rw.RW;
import java.io.Serializable;
import lightdb.Document;
import lightdb.index.IndexSupport;
import lightdb.index.IndexedField;
import lightdb.lucene.LuceneFilter;
import lightdb.lucene.LuceneFilter$;
import lightdb.lucene.LuceneIndex$;
import lightdb.lucene.LuceneSupport;
import lightdb.spatial.GeoPoint;
import lightdb.spatial.GeoPoint$;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class LuceneIndex<F, D extends Document<D>>
implements IndexedField<F, D>,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LuceneIndex.class.getDeclaredField("fieldSortName$lzy1"));
    private final String fieldName;
    private final IndexSupport<D> indexSupport;
    private final Function1<D, List<F>> get;
    private final boolean store;
    private final boolean sorted;
    private final boolean tokenized;
    private final RW<F> rw;
    private volatile Object fieldSortName$lzy1;

    public static <F, D extends Document<D>> LuceneIndex<F, D> apply(String string, IndexSupport<D> indexSupport, Function1<D, List<F>> function1, boolean bl, boolean bl2, boolean bl3, RW<F> rW) {
        return LuceneIndex$.MODULE$.apply(string, indexSupport, function1, bl, bl2, bl3, rW);
    }

    public static <F, D extends Document<D>> LuceneIndex<F, D> unapply(LuceneIndex<F, D> luceneIndex) {
        return LuceneIndex$.MODULE$.unapply(luceneIndex);
    }

    public LuceneIndex(String fieldName, IndexSupport<D> indexSupport, Function1<D, List<F>> get, boolean store, boolean sorted, boolean tokenized, RW<F> rw) {
        this.fieldName = fieldName;
        this.indexSupport = indexSupport;
        this.get = get;
        this.store = store;
        this.sorted = sorted;
        this.tokenized = tokenized;
        this.rw = rw;
        IndexedField.$init$((IndexedField)this);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fieldName()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.indexSupport()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.get()));
        n = Statics.mix((int)n, (int)(this.store() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.sorted() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.tokenized() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LuceneIndex)) return false;
        LuceneIndex luceneIndex = (LuceneIndex)object;
        if (this.store() != luceneIndex.store()) return false;
        if (this.sorted() != luceneIndex.sorted()) return false;
        if (this.tokenized() != luceneIndex.tokenized()) return false;
        String string = this.fieldName();
        String string2 = luceneIndex.fieldName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        IndexSupport<D> indexSupport = this.indexSupport();
        IndexSupport<D> indexSupport2 = luceneIndex.indexSupport();
        if (indexSupport == null) {
            if (indexSupport2 != null) {
                return false;
            }
        } else if (!indexSupport.equals(indexSupport2)) return false;
        Function1<D, List<F>> function1 = this.get();
        Function1<D, List<F>> function12 = luceneIndex.get();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        if (!luceneIndex.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LuceneIndex;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "LuceneIndex";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this._4());
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this._5());
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this._6());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "fieldName";
            }
            case 1: {
                return "indexSupport";
            }
            case 2: {
                return "get";
            }
            case 3: {
                return "store";
            }
            case 4: {
                return "sorted";
            }
            case 5: {
                return "tokenized";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String fieldName() {
        return this.fieldName;
    }

    public IndexSupport<D> indexSupport() {
        return this.indexSupport;
    }

    public Function1<D, List<F>> get() {
        return this.get;
    }

    public boolean store() {
        return this.store;
    }

    public boolean sorted() {
        return this.sorted;
    }

    public boolean tokenized() {
        return this.tokenized;
    }

    public RW<F> rw() {
        return this.rw;
    }

    private LuceneSupport<D> lucene() {
        return (LuceneSupport)this.indexSupport();
    }

    public String fieldSortName() {
        Object object = this.fieldSortName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.fieldSortName$lzyINIT1();
    }

    private Object fieldSortName$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.fieldSortName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        boolean separate = BoxesRunTime.unboxToBoolean((Object)this.rw().definition().className().collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(String x) {
                                String string = x;
                                return "lightdb.spatial.GeoPoint".equals(string);
                            }

                            public final Object applyOrElse(String x, Function1 function1) {
                                String string = x;
                                if ("lightdb.spatial.GeoPoint".equals(string)) {
                                    return BoxesRunTime.boxToBoolean((boolean)true);
                                }
                                return function1.apply((Object)x);
                            }
                        }).getOrElse(LuceneIndex::$anonfun$1));
                        String string2 = string = separate ? new StringBuilder(4).append(this.fieldName()).append("Sort").toString() : this.fieldName();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.fieldSortName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.fieldSortName$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public LuceneFilter<D> $eq$eq$eq(F value) {
        return this.is(value);
    }

    public LuceneFilter<D> is(F value) {
        return LuceneFilter$.MODULE$.apply((Function0<Query>)(Function0 & Serializable)() -> {
            Json json = fabric.rw.package$.MODULE$.Convertible(value).json(this.rw());
            if (json instanceof Str) {
                Str str = Str$.MODULE$.unapply((Str)json);
                String string = str._1();
                Option option = str._2();
                String s2 = string;
                if (this.tokenized()) {
                    BooleanQuery.Builder b = new BooleanQuery.Builder();
                    Object object = Predef$.MODULE$.refArrayOps((Object[])s2.split("\\s+"));
                    ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)s -> b.add((Query)new TermQuery(new Term(this.fieldName(), s)), BooleanClause.Occur.MUST));
                    return b.build();
                }
                String s3 = string;
                return new TermQuery(new Term(this.fieldName(), s3));
            }
            Json json2 = json;
            throw new RuntimeException(new StringBuilder(31).append("Unsupported equality check: ").append(json2).append(" (").append(this.rw().definition()).append(")").toString());
        });
    }

    public LuceneFilter<D> parsed(String query, boolean allowLeadingWildcard) {
        return LuceneFilter$.MODULE$.apply((Function0<Query>)(Function0 & Serializable)() -> {
            QueryParser parser = new QueryParser(this.fieldName(), this.lucene().index().analyzer());
            parser.setAllowLeadingWildcard(allowLeadingWildcard);
            parser.setSplitOnWhitespace(true);
            return parser.parse(query);
        });
    }

    public boolean parsed$default$2() {
        return false;
    }

    public LuceneFilter<D> words(String s, boolean matchStartsWith, boolean matchEndsWith) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s.split("\\s+"));
        String words = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)w -> {
            if (matchStartsWith && matchEndsWith) {
                return new StringBuilder(2).append("%").append((String)w).append("%").toString();
            }
            if (matchStartsWith) {
                return new StringBuilder(1).append("%").append((String)w).toString();
            }
            if (matchEndsWith) {
                return new StringBuilder(1).append((String)w).append("%").toString();
            }
            return w;
        }, ClassTag$.MODULE$.apply(String.class))).mkString(" ");
        return this.parsed(words, matchEndsWith);
    }

    public boolean words$default$2() {
        return true;
    }

    public boolean words$default$3() {
        return false;
    }

    public LuceneFilter<D> IN(Seq<F> values) {
        BooleanQuery.Builder b = new BooleanQuery.Builder();
        b.setMinimumNumberShouldMatch(1);
        values.foreach((Function1 & Serializable)value -> b.add((Query)this.is(value).asQuery().apply(), BooleanClause.Occur.SHOULD));
        return LuceneFilter$.MODULE$.apply((Function0<Query>)(Function0 & Serializable)() -> b.build());
    }

    public LuceneFilter<D> between(F lower, F upper) {
        return LuceneFilter$.MODULE$.apply((Function0<Query>)(Function0 & Serializable)() -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)fabric.rw.package$.MODULE$.Convertible(lower).json(this.rw()), (Object)fabric.rw.package$.MODULE$.Convertible(upper).json(this.rw()));
            if (tuple2 != null) {
                Json json = (Json)tuple2._1();
                Json json2 = (Json)tuple2._2();
                if (json instanceof NumInt) {
                    NumInt numInt = NumInt$.MODULE$.unapply((NumInt)json);
                    long l = numInt._1();
                    Option option = numInt._2();
                    long l2 = l;
                    if (json2 instanceof NumInt) {
                        NumInt numInt2 = NumInt$.MODULE$.unapply((NumInt)json2);
                        long l3 = numInt2._1();
                        Option option2 = numInt2._2();
                        long u = l3;
                        return LongField.newRangeQuery((String)this.fieldName(), (long)l2, (long)u);
                    }
                }
            }
            throw new RuntimeException(new StringBuilder(30).append("Unsupported between for ").append(lower).append(" - ").append(upper).append(" (").append(this.rw().definition()).append(")").toString());
        });
    }

    public List<Field> createFields(D doc) {
        if (this.tokenized()) {
            return ((List)this.getJson().apply(doc)).flatMap((Function1 & Serializable)x$1 -> {
                Json json = x$1;
                if (Null$.MODULE$.equals(json)) {
                    return package$.MODULE$.Nil();
                }
                if (json instanceof Str) {
                    Str str = Str$.MODULE$.unapply((Str)json);
                    String string = str._1();
                    Option option = str._2();
                    String s = string;
                    return (List)new .colon.colon((Object)s, (List)Nil$.MODULE$);
                }
                Json f = json;
                throw new RuntimeException(new StringBuilder(32).append("Unsupported tokenized value: ").append(f).append(" (").append(this.rw().definition()).append(")").toString());
            }).map((Function1 & Serializable)value -> new Field(this.fieldName(), (CharSequence)value, (IndexableFieldType)(this.store() ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED)));
        }
        List filterField = ((List)this.getJson().apply(doc)).flatMap((Function1 & Serializable)x$1 -> {
            Obj obj;
            Json json = x$1;
            if (Null$.MODULE$.equals(json)) {
                return None$.MODULE$;
            }
            if (json instanceof Str) {
                Str str = Str$.MODULE$.unapply((Str)json);
                String string = str._1();
                Option option = str._2();
                String s = string;
                return Some$.MODULE$.apply((Object)new StringField(this.fieldName(), s, this.fs$1()));
            }
            if (json instanceof Bool) {
                Bool bool = Bool$.MODULE$.unapply((Bool)json);
                boolean bl = bool._1();
                Option option = bool._2();
                boolean b = bl;
                return Some$.MODULE$.apply((Object)new StringField(this.fieldName(), BoxesRunTime.boxToBoolean((boolean)b).toString(), this.fs$1()));
            }
            if (json instanceof NumInt) {
                NumInt numInt = NumInt$.MODULE$.unapply((NumInt)json);
                long l = numInt._1();
                Option option = numInt._2();
                long l2 = l;
                return Some$.MODULE$.apply((Object)new LongField(this.fieldName(), l2, this.fs$1()));
            }
            if (json instanceof NumDec) {
                NumDec numDec = NumDec$.MODULE$.unapply((NumDec)json);
                BigDecimal bigDecimal = numDec._1();
                Option option = numDec._2();
                BigDecimal bd = bigDecimal;
                return Some$.MODULE$.apply((Object)new DoubleField(this.fieldName(), bd.toDouble(), this.fs$1()));
            }
            if (json instanceof Obj && (obj = (Obj)json).reference().nonEmpty()) {
                Object object = obj.reference().get();
                if (object instanceof GeoPoint) {
                    GeoPoint geoPoint = GeoPoint$.MODULE$.unapply((GeoPoint)object);
                    double d = geoPoint._1();
                    double d2 = geoPoint._2();
                    double latitude = d;
                    double longitude = d2;
                    return Some$.MODULE$.apply((Object)new LatLonPoint(this.fieldName(), latitude, longitude));
                }
                Object ref = object;
                throw new RuntimeException(new StringBuilder(41).append("Unsupported object reference: ").append(ref).append(" for JSON: ").append(obj).toString());
            }
            Json json2 = json;
            throw new RuntimeException(new StringBuilder(21).append("Unsupported JSON: ").append(json2).append(" (").append(this.rw().definition()).append(")").toString());
        });
        Nil$ sortField = this.sorted() ? ((List)this.getJson().apply(doc)).flatMap((Function1 & Serializable)x$1 -> {
            Obj obj;
            Json json = x$1;
            if (json instanceof Obj && (obj = (Obj)json).reference().nonEmpty()) {
                Object object = obj.reference().get();
                if (object instanceof GeoPoint) {
                    GeoPoint geoPoint = GeoPoint$.MODULE$.unapply((GeoPoint)object);
                    double d = geoPoint._1();
                    double d2 = geoPoint._2();
                    double latitude = d;
                    double longitude = d2;
                    return Some$.MODULE$.apply((Object)new LatLonDocValuesField(this.fieldSortName(), latitude, longitude));
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }) : package$.MODULE$.Nil();
        return sortField.$colon$colon$colon(filterField);
    }

    public SortField.Type sortType() {
        DefType defType = this.rw().definition();
        if (DefType.Str$.MODULE$.equals(defType)) {
            return SortField.Type.STRING;
        }
        if (DefType.Dec$.MODULE$.equals(defType)) {
            return SortField.Type.DOUBLE;
        }
        if (DefType.Int$.MODULE$.equals(defType)) {
            return SortField.Type.LONG;
        }
        throw new RuntimeException(new StringBuilder(26).append("Unsupported sort type for ").append(this.rw().definition()).toString());
    }

    public <F, D extends Document<D>> LuceneIndex<F, D> copy(String fieldName, IndexSupport<D> indexSupport, Function1<D, List<F>> get, boolean store, boolean sorted, boolean tokenized, RW<F> rw) {
        return new LuceneIndex<F, D>(fieldName, indexSupport, get, store, sorted, tokenized, rw);
    }

    public <F, D extends Document<D>> String copy$default$1() {
        return this.fieldName();
    }

    public <F, D extends Document<D>> IndexSupport<D> copy$default$2() {
        return this.indexSupport();
    }

    public <F, D extends Document<D>> Function1<D, List<F>> copy$default$3() {
        return this.get();
    }

    public boolean copy$default$4() {
        return this.store();
    }

    public boolean copy$default$5() {
        return this.sorted();
    }

    public boolean copy$default$6() {
        return this.tokenized();
    }

    public String _1() {
        return this.fieldName();
    }

    public IndexSupport<D> _2() {
        return this.indexSupport();
    }

    public Function1<D, List<F>> _3() {
        return this.get();
    }

    public boolean _4() {
        return this.store();
    }

    public boolean _5() {
        return this.sorted();
    }

    public boolean _6() {
        return this.tokenized();
    }

    private static final boolean $anonfun$1() {
        return false;
    }

    private final Field.Store fs$1() {
        if (this.store()) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }
}

