/*
 * Decompiled with CFR 0.152.
 */
package lightdb.lucene;

import cats.effect.IO;
import cats.effect.IO$;
import fabric.rw.RW;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import lightdb.Document;
import lightdb.index.IndexSupport;
import lightdb.index.Indexer;
import lightdb.lucene.LuceneIndex;
import lightdb.lucene.LuceneIndex$;
import lightdb.lucene.LuceneIndexer$;
import lightdb.lucene.LuceneSupport;
import lightdb.model.AbstractCollection;
import lightdb.query.SearchContext;
import lightdb.query.SearchContext$;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class LuceneIndexer<D extends Document<D>>
implements Indexer<D>,
Product,
Serializable {
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(LuceneIndexer.class.getDeclaredField("parser$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(LuceneIndexer.class.getDeclaredField("searcherManager$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(LuceneIndexer.class.getDeclaredField("indexWriter$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(LuceneIndexer.class.getDeclaredField("config$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(LuceneIndexer.class.getDeclaredField("directory$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LuceneIndexer.class.getDeclaredField("path$lzy1"));
    private List _fields;
    private final IndexSupport<D> indexSupport;
    private final boolean persistent;
    private final Analyzer analyzer;
    private volatile Object path$lzy1;
    private volatile Object directory$lzy1;
    private volatile Object config$lzy1;
    private volatile Object indexWriter$lzy1;
    private volatile Object searcherManager$lzy1;
    private volatile Object parser$lzy1;
    private final ConcurrentHashMap<SearchContext<D>, IndexSearcher> contextMapping;

    public static LuceneIndexer<?> fromProduct(Product product) {
        return LuceneIndexer$.MODULE$.fromProduct(product);
    }

    public static <D extends Document<D>> LuceneIndexer<D> unapply(LuceneIndexer<D> luceneIndexer) {
        return LuceneIndexer$.MODULE$.unapply(luceneIndexer);
    }

    public static <D extends Document<D>> boolean $lessinit$greater$default$2() {
        return LuceneIndexer$.MODULE$.$lessinit$greater$default$2();
    }

    public static <D extends Document<D>> Analyzer $lessinit$greater$default$3() {
        return LuceneIndexer$.MODULE$.$lessinit$greater$default$3();
    }

    public LuceneIndexer(IndexSupport<D> indexSupport, boolean persistent, Analyzer analyzer) {
        this.indexSupport = indexSupport;
        this.persistent = persistent;
        this.analyzer = analyzer;
        Indexer.$init$((Indexer)this);
        this.contextMapping = new ConcurrentHashMap();
    }

    public List _fields() {
        return this._fields;
    }

    public void _fields_$eq(List x$1) {
        this._fields = x$1;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.indexSupport()));
        n = Statics.mix((int)n, (int)(this.persistent() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.analyzer()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LuceneIndexer)) return false;
        LuceneIndexer luceneIndexer = (LuceneIndexer)object;
        if (this.persistent() != luceneIndexer.persistent()) return false;
        IndexSupport<D> indexSupport = this.indexSupport();
        IndexSupport<D> indexSupport2 = luceneIndexer.indexSupport();
        if (indexSupport == null) {
            if (indexSupport2 != null) {
                return false;
            }
        } else if (!indexSupport.equals(indexSupport2)) return false;
        Analyzer analyzer = this.analyzer();
        Analyzer analyzer2 = luceneIndexer.analyzer();
        if (analyzer == null) {
            if (analyzer2 != null) {
                return false;
            }
        } else if (!analyzer.equals(analyzer2)) return false;
        if (!luceneIndexer.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LuceneIndexer;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "LuceneIndexer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "indexSupport";
            }
            case 1: {
                return "persistent";
            }
            case 2: {
                return "analyzer";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public IndexSupport<D> indexSupport() {
        return this.indexSupport;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    private AbstractCollection<D> collection() {
        return this.indexSupport().collection();
    }

    private Option<Path> path() {
        Object object = this.path$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.path$lzyINIT1();
    }

    private Object path$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.path$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    None$ none$ = null;
                    try {
                        None$ none$2;
                        if (this.persistent()) {
                            Path p = this.collection().db().directory().resolve(this.collection().collectionName()).resolve("index");
                            Files.createDirectories(p, new FileAttribute[0]);
                            none$2 = Some$.MODULE$.apply((Object)p);
                        } else {
                            none$2 = none$ = None$.MODULE$;
                        }
                        object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.path$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return none$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private BaseDirectory directory() {
        Object object = this.directory$lzy1;
        if (object instanceof BaseDirectory) {
            return (BaseDirectory)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BaseDirectory)this.directory$lzyINIT1();
    }

    private Object directory$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.directory$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BaseDirectory baseDirectory = null;
                    try {
                        baseDirectory = (BaseDirectory)this.path().map((Function1 & Serializable)p -> FSDirectory.open((Path)p)).getOrElse(LuceneIndexer::directory$lzyINIT1$$anonfun$2);
                        object2 = baseDirectory == null ? LazyVals.NullValue$.MODULE$ : baseDirectory;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.directory$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return baseDirectory;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private IndexWriterConfig config() {
        Object object = this.config$lzy1;
        if (object instanceof IndexWriterConfig) {
            return (IndexWriterConfig)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IndexWriterConfig)this.config$lzyINIT1();
    }

    private Object config$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.config$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IndexWriterConfig indexWriterConfig = null;
                    try {
                        indexWriterConfig = new IndexWriterConfig(this.analyzer());
                        object2 = indexWriterConfig == null ? LazyVals.NullValue$.MODULE$ : indexWriterConfig;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.config$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return indexWriterConfig;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private IndexWriter indexWriter() {
        Object object = this.indexWriter$lzy1;
        if (object instanceof IndexWriter) {
            return (IndexWriter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IndexWriter)this.indexWriter$lzyINIT1();
    }

    private Object indexWriter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.indexWriter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IndexWriter indexWriter = null;
                    try {
                        indexWriter = new IndexWriter((Directory)this.directory(), this.config());
                        object2 = indexWriter == null ? LazyVals.NullValue$.MODULE$ : indexWriter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.indexWriter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return indexWriter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private SearcherManager searcherManager() {
        Object object = this.searcherManager$lzy1;
        if (object instanceof SearcherManager) {
            return (SearcherManager)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SearcherManager)this.searcherManager$lzyINIT1();
    }

    private Object searcherManager$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.searcherManager$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SearcherManager searcherManager = null;
                    try {
                        searcherManager = new SearcherManager(this.indexWriter(), new SearcherFactory());
                        object2 = searcherManager == null ? LazyVals.NullValue$.MODULE$ : searcherManager;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.searcherManager$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return searcherManager;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private QueryParser parser() {
        Object object = this.parser$lzy1;
        if (object instanceof QueryParser) {
            return (QueryParser)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (QueryParser)this.parser$lzyINIT1();
    }

    private Object parser$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parser$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    QueryParser queryParser = null;
                    try {
                        queryParser = new QueryParser("_id", this.analyzer());
                        object2 = queryParser == null ? LazyVals.NullValue$.MODULE$ : queryParser;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parser$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return queryParser;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ConcurrentHashMap<SearchContext<D>, IndexSearcher> contextMapping() {
        return this.contextMapping;
    }

    public <Return> IO<Return> withSearchContext(Function1<SearchContext<D>, IO<Return>> f) {
        IndexSearcher indexSearcher = (IndexSearcher)this.searcherManager().acquire();
        SearchContext context = SearchContext$.MODULE$.apply(this.indexSupport());
        this.contextMapping().put(context, indexSearcher);
        return ((IO)f.apply((Object)context)).guarantee(IO$.MODULE$.blocking((Function0 & Serializable)() -> {
            this.withSearchContext$$anonfun$1(context, indexSearcher);
            return BoxedUnit.UNIT;
        }));
    }

    public void addDoc(String id, List<Field> fields) {
        if (fields.length() > 1) {
            org.apache.lucene.document.Document document = new org.apache.lucene.document.Document();
            fields.foreach((Function1)(JProcedure1 & Serializable)x$0 -> document.add(x$0));
            this.indexWriter().updateDocument(new Term("_id", id), (Iterable)document);
            return;
        }
    }

    public IO<BoxedUnit> delete(String id) {
        return IO$.MODULE$.blocking((Function0 & Serializable)() -> {
            this.delete$$anonfun$1(id);
            return BoxedUnit.UNIT;
        });
    }

    public IO<BoxedUnit> truncate() {
        return IO$.MODULE$.blocking((Function0 & Serializable)() -> {
            this.truncate$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private void commitBlocking() {
        this.indexWriter().flush();
        this.indexWriter().commit();
        this.searcherManager().maybeRefreshBlocking();
    }

    public <F> LuceneIndex<F, D> apply(String name, Function1<D, List<F>> get, boolean store, boolean sorted, boolean tokenized, RW<F> rw) {
        return LuceneIndex$.MODULE$.apply(name, this.indexSupport(), get, store, sorted, tokenized, rw);
    }

    public boolean apply$default$3() {
        return false;
    }

    public boolean apply$default$4() {
        return false;
    }

    public boolean apply$default$5() {
        return false;
    }

    public <F> LuceneIndex<F, D> one(String name, Function1<D, F> get, boolean store, boolean sorted, boolean tokenized, RW<F> rw) {
        return this.apply(name, (Function1 & Serializable)doc -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{get.apply(doc)})), store, sorted, tokenized, rw);
    }

    public boolean one$default$3() {
        return false;
    }

    public boolean one$default$4() {
        return false;
    }

    public boolean one$default$5() {
        return false;
    }

    public IO<BoxedUnit> commit() {
        return IO$.MODULE$.blocking((Function0 & Serializable)() -> {
            this.commit$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public IO<Object> size() {
        return this.withSearchContext((Function1 & Serializable)context -> IO$.MODULE$.blocking(() -> LuceneIndexer.size$$anonfun$1$$anonfun$1(context)));
    }

    public <D extends Document<D>> LuceneIndexer<D> copy(IndexSupport<D> indexSupport, boolean persistent, Analyzer analyzer) {
        return new LuceneIndexer<D>(indexSupport, persistent, analyzer);
    }

    public <D extends Document<D>> IndexSupport<D> copy$default$1() {
        return this.indexSupport();
    }

    public boolean copy$default$2() {
        return this.persistent();
    }

    public <D extends Document<D>> Analyzer copy$default$3() {
        return this.analyzer();
    }

    public IndexSupport<D> _1() {
        return this.indexSupport();
    }

    public boolean _2() {
        return this.persistent();
    }

    public Analyzer _3() {
        return this.analyzer();
    }

    private static final BaseDirectory directory$lzyINIT1$$anonfun$2() {
        return new ByteBuffersDirectory();
    }

    private final void withSearchContext$$anonfun$1(SearchContext context$1, IndexSearcher indexSearcher$1) {
        this.contextMapping().remove(context$1);
        this.searcherManager().release((Object)indexSearcher$1);
    }

    private final void delete$$anonfun$1(String id$1) {
        this.indexWriter().deleteDocuments(new Query[]{this.parser().parse(new StringBuilder(4).append("_id:").append(id$1).toString())});
    }

    private final void truncate$$anonfun$1() {
        this.indexWriter().deleteAll();
    }

    private final void commit$$anonfun$1() {
        this.commitBlocking();
    }

    private static final int size$$anonfun$1$$anonfun$1(SearchContext context$2) {
        return ((LuceneSupport)context$2.indexSupport()).indexSearcher(context$2).count((Query)new MatchAllDocsQuery());
    }
}

