/*
 * Decompiled with CFR 0.152.
 */
package lightdb.lucene;

import cats.effect.IO;
import cats.effect.IO$;
import fabric.define.DefType;
import java.io.Serializable;
import lightdb.Document;
import lightdb.Id;
import lightdb.Id$;
import lightdb.index.IndexSupport;
import lightdb.index.IndexedField;
import lightdb.lucene.LuceneFilter;
import lightdb.lucene.LuceneFilter$;
import lightdb.lucene.LuceneIndex;
import lightdb.lucene.LuceneIndexer;
import lightdb.lucene.LuceneIndexer$;
import lightdb.lucene.LucenePageContext;
import lightdb.lucene.LucenePageContext$;
import lightdb.model.AbstractCollection;
import lightdb.query.Filter;
import lightdb.query.PagedResults;
import lightdb.query.PagedResults$;
import lightdb.query.SearchContext;
import lightdb.query.Sort;
import lightdb.query.SortDirection;
import lightdb.spatial.GeoPoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TopFieldDocs;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import squants.space.Length;

public interface LuceneSupport<D extends Document<D>>
extends IndexSupport<D> {
    public static void $init$(LuceneSupport $this) {
        $this.lightdb$lucene$LuceneSupport$_setter_$_id_$eq($this.index().apply("_id", (Function1 & Serializable)doc -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Id[]{new Id(doc._id())})), true, $this.index().apply$default$4(), $this.index().apply$default$5(), Id$.MODULE$.rw()));
    }

    public /* synthetic */ void lightdb$lucene$LuceneSupport$$super$initModel(AbstractCollection var1);

    public static LuceneIndexer index$(LuceneSupport $this) {
        return $this.index();
    }

    default public LuceneIndexer<D> index() {
        return LuceneIndexer$.MODULE$.apply(this, LuceneIndexer$.MODULE$.$lessinit$greater$default$2(), LuceneIndexer$.MODULE$.$lessinit$greater$default$3());
    }

    public LuceneIndex<String, D> _id();

    public void lightdb$lucene$LuceneSupport$_setter_$_id_$eq(LuceneIndex var1);

    public static IndexSearcher indexSearcher$(LuceneSupport $this, SearchContext context) {
        return $this.indexSearcher(context);
    }

    default public IndexSearcher indexSearcher(SearchContext<D> context) {
        return this.index().contextMapping().get(context);
    }

    private SortField sort2SortField(lightdb.query.Sort sort) {
        lightdb.query.Sort sort2 = sort;
        if (Sort.BestMatch$.MODULE$.equals(sort2)) {
            return SortField.FIELD_SCORE;
        }
        if (Sort.IndexOrder$.MODULE$.equals(sort2)) {
            return SortField.FIELD_DOC;
        }
        if (sort2 instanceof Sort.ByField) {
            Sort.ByField byField = Sort.ByField$.MODULE$.unapply((Sort.ByField)sort2);
            IndexedField indexedField = byField._1();
            SortDirection sortDirection = byField._2();
            IndexedField field = indexedField;
            SortDirection dir = sortDirection;
            LuceneIndex f = (LuceneIndex)field;
            DefType defType = f.rw().definition();
            if (DefType.Int$.MODULE$.equals(defType)) {
                SortDirection sortDirection2 = dir;
                SortDirection.Descending$ descending$ = SortDirection.Descending$.MODULE$;
                return new SortedNumericSortField(field.fieldName(), f.sortType(), !(sortDirection2 != null ? !sortDirection2.equals(descending$) : descending$ != null));
            }
            if (DefType.Str$.MODULE$.equals(defType)) {
                SortDirection sortDirection3 = dir;
                SortDirection.Descending$ descending$ = SortDirection.Descending$.MODULE$;
                return new SortField(field.fieldName(), f.sortType(), !(sortDirection3 != null ? !sortDirection3.equals(descending$) : descending$ != null));
            }
            DefType d = defType;
            throw new RuntimeException(new StringBuilder(29).append("Unsupported sort definition: ").append(d).toString());
        }
        if (sort2 instanceof Sort.ByDistance) {
            Sort.ByDistance byDistance = Sort.ByDistance$.MODULE$.unapply((Sort.ByDistance)sort2);
            IndexedField indexedField = byDistance._1();
            GeoPoint geoPoint = byDistance._2();
            IndexedField field = indexedField;
            GeoPoint from = geoPoint;
            LuceneIndex f = (LuceneIndex)field;
            return LatLonDocValuesField.newDistanceSort((String)f.fieldSortName(), (double)from.latitude(), (double)from.longitude());
        }
        throw new MatchError((Object)sort2);
    }

    public static IO doSearch$(LuceneSupport $this, lightdb.query.Query query, SearchContext context, int offset, Option limit, Option after) {
        return $this.doSearch(query, context, offset, (Option<Object>)limit, after);
    }

    default public <V> IO<PagedResults<D, V>> doSearch(lightdb.query.Query<D, V> query, SearchContext<D> context, int offset, Option<Object> limit, Option<PagedResults<D, V>> after) {
        return IO$.MODULE$.blocking(() -> this.doSearch$$anonfun$1(query, context, after, limit, offset));
    }

    public static IO indexDoc$(LuceneSupport $this, Document doc, List fields) {
        return $this.indexDoc(doc, fields);
    }

    default public IO<BoxedUnit> indexDoc(D doc, List<IndexedField<?, D>> fields2) {
        return IO$.MODULE$.blocking(() -> LuceneSupport.indexDoc$$anonfun$1(fields2, doc)).map((Function1 & Serializable)fields -> {
            BoxedUnit boxedUnit;
            this.index().addDoc(doc._id(), (List<Field>)fields);
            BoxedUnit $1$ = boxedUnit = BoxedUnit.UNIT;
            BoxedUnit $1$2 = BoxedUnit.UNIT;
            return Tuple2$.MODULE$.apply(fields, (Object)$1$2);
        }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List fields = (List)tuple2._1();
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static void initModel$(LuceneSupport $this, AbstractCollection collection) {
        $this.initModel(collection);
    }

    default public void initModel(AbstractCollection<D> collection) {
        this.lightdb$lucene$LuceneSupport$$super$initModel(collection);
        collection.truncateActions().add(this::initModel$$anonfun$1);
    }

    public static Filter distanceFilter$(LuceneSupport $this, IndexedField field, GeoPoint from, Length distance) {
        return $this.distanceFilter(field, from, distance);
    }

    default public Filter<D> distanceFilter(IndexedField<GeoPoint, D> field, GeoPoint from, Length distance) {
        return LuceneFilter$.MODULE$.apply((Function0<Query>)(Function0 & Serializable)() -> LatLonPoint.newDistanceQuery((String)field.fieldName(), (double)from.latitude(), (double)from.longitude(), (double)distance.toMeters()));
    }

    private static Query $anonfun$2() {
        return new MatchAllDocsQuery();
    }

    private static int $anonfun$4() {
        return Integer.MAX_VALUE;
    }

    private PagedResults doSearch$$anonfun$1(lightdb.query.Query query$1, SearchContext context$1, Option after$1, Option limit$1, int offset$1) {
        TopFieldDocs topFieldDocs;
        Query q = (Query)query$1.filter().map((Function1 & Serializable)_$1 -> (Query)((LuceneFilter)_$1).asQuery().apply()).getOrElse(LuceneSupport::$anonfun$2);
        List list = query$1.sort();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        List sortFields = !(nil$ != null ? !nil$.equals(list2) : list2 != null) ? (List)new .colon.colon((Object)SortField.FIELD_SCORE, (List)Nil$.MODULE$) : query$1.sort().map((Function1 & Serializable)sort -> this.sort2SortField((lightdb.query.Sort)sort));
        Sort s = new Sort((SortField[])Arrays$.MODULE$.seqToArray((Seq)sortFields, SortField.class));
        IndexSearcher indexSearcher = ((LuceneSupport)query$1.indexSupport()).indexSearcher(context$1);
        Option option = after$1;
        if (option instanceof Some) {
            PagedResults afterPage = (PagedResults)((Some)option).value();
            ScoreDoc afterDoc = (ScoreDoc)((LucenePageContext)afterPage.context()).lastScoreDoc().get();
            topFieldDocs = indexSearcher.searchAfter(afterDoc, q, query$1.pageSize(), s, query$1.scoreDocs());
        } else if (None$.MODULE$.equals(option)) {
            topFieldDocs = indexSearcher.search(q, query$1.pageSize(), s, query$1.scoreDocs());
        } else {
            throw new MatchError((Object)option);
        }
        TopFieldDocs topFieldDocs2 = topFieldDocs;
        List scoreDocs = Predef$.MODULE$.wrapRefArray((Object[])topFieldDocs2.scoreDocs).toList().take(BoxesRunTime.unboxToInt((Object)limit$1.getOrElse(LuceneSupport::$anonfun$4)) - offset$1);
        int total = (int)topFieldDocs2.totalHits.value;
        StoredFields storedFields = indexSearcher.storedFields();
        List idsAndScores = scoreDocs.map((Function1 & Serializable)doc -> {
            Id id = (Id)Predef$.MODULE$.ArrowAssoc((Object)new Id(Id$.MODULE$.apply(storedFields.document(doc.doc).get("_id"))));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)id, (Object)BoxesRunTime.boxToDouble((double)doc.score));
        });
        LucenePageContext indexContext = LucenePageContext$.MODULE$.apply(context$1, (Option<ScoreDoc>)scoreDocs.lastOption());
        return PagedResults$.MODULE$.apply(query$1, indexContext, offset$1, total, idsAndScores, (Option)PagedResults$.MODULE$.$lessinit$greater$default$6());
    }

    private static List indexDoc$$anonfun$1(List fields$1, Document doc$1) {
        return fields$1.flatMap((Function1 & Serializable)field -> ((LuceneIndex)field).createFields(doc$1));
    }

    private IO initModel$$anonfun$1() {
        return this.index().truncate();
    }
}

