/*
 * Decompiled with CFR 0.152.
 */
package lightdb.redis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import lightdb.Id;
import lightdb.LightDB;
import lightdb.doc.Document;
import lightdb.doc.DocumentModel;
import lightdb.feature.FeatureKey;
import lightdb.field.Field;
import lightdb.redis.RedisStore$;
import lightdb.store.Store;
import lightdb.store.StoreManager;
import lightdb.store.StoreMode;
import lightdb.transaction.Transaction;
import lightdb.transaction.TransactionFeature;
import lightdb.transaction.TransactionKey;
import lightdb.transaction.TransactionKey$;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import rapid.Stream$;
import rapid.Task;
import rapid.Task$;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class RedisStore<Doc extends Document<Doc>, Model extends DocumentModel<Doc>>
extends Store<Doc, Model> {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(RedisStore.class.getDeclaredField("pool$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(RedisStore.class.getDeclaredField("config$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RedisStore.class.getDeclaredField("InstanceKey$lzy1"));
    private final StoreMode<Doc, Model> storeMode;
    private String hostname;
    private final int port;
    private volatile Object InstanceKey$lzy1;
    private volatile Object config$lzy1;
    private volatile Object pool$lzy1;

    public static <Doc extends Document<Doc>, Model extends DocumentModel<Doc>> String $lessinit$greater$default$5() {
        return RedisStore$.MODULE$.$lessinit$greater$default$5();
    }

    public static <Doc extends Document<Doc>, Model extends DocumentModel<Doc>> int $lessinit$greater$default$6() {
        return RedisStore$.MODULE$.$lessinit$greater$default$6();
    }

    public RedisStore(String name, Option<Path> path, Model model, StoreMode<Doc, Model> storeMode, String hostname, int port, LightDB db, StoreManager storeManager) {
        this.storeMode = storeMode;
        this.hostname = hostname;
        this.port = port;
        super(name, path, model, db, storeManager);
    }

    private String name$accessor() {
        return super.name();
    }

    private Option<Path> path$accessor() {
        return super.path();
    }

    private Model model$accessor() {
        return (Model)super.model();
    }

    public StoreMode<Doc, Model> storeMode() {
        return this.storeMode;
    }

    private StoreManager storeManager$accessor() {
        return super.storeManager();
    }

    public String lightdb$redis$RedisStore$$InstanceKey() {
        Object object = this.InstanceKey$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.InstanceKey$lzyINIT1();
    }

    private Object InstanceKey$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.InstanceKey$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = TransactionKey$.MODULE$.apply("redisInstance");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.InstanceKey$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private JedisPoolConfig config() {
        Object object = this.config$lzy1;
        if (object instanceof JedisPoolConfig) {
            return (JedisPoolConfig)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JedisPoolConfig)this.config$lzyINIT1();
    }

    private Object config$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.config$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JedisPoolConfig jedisPoolConfig = null;
                    try {
                        jedisPoolConfig = new JedisPoolConfig();
                        object2 = jedisPoolConfig == null ? LazyVals.NullValue$.MODULE$ : jedisPoolConfig;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.config$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jedisPoolConfig;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public JedisPool lightdb$redis$RedisStore$$pool() {
        Object object = this.pool$lzy1;
        if (object instanceof JedisPool) {
            return (JedisPool)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JedisPool)this.pool$lzyINIT1();
    }

    private Object pool$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.pool$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JedisPool jedisPool = null;
                    try {
                        jedisPool = new JedisPool((GenericObjectPoolConfig)this.config(), this.hostname, this.port);
                        object2 = jedisPool == null ? LazyVals.NullValue$.MODULE$ : jedisPool;
                        this.hostname = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pool$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jedisPool;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<BoxedUnit> initialize() {
        return super.initialize().next(this::initialize$$anonfun$1);
    }

    private Jedis getInstance(Transaction<Doc> transaction) {
        return (Jedis)transaction.getOrCreate((FeatureKey)new TransactionKey(this.lightdb$redis$RedisStore$$InstanceKey()), this::getInstance$$anonfun$1);
    }

    public Task<BoxedUnit> prepareTransaction(Transaction<Doc> transaction) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.prepareTransaction$$anonfun$1(transaction);
            return BoxedUnit.UNIT;
        });
    }

    public Task<Doc> _insert(Doc doc, Transaction<Doc> transaction) {
        return this.upsert((Document)doc, (Transaction)transaction);
    }

    public Task<Doc> _upsert(Doc doc, Transaction<Doc> transaction) {
        return Task$.MODULE$.apply(() -> this._upsert$$anonfun$1(transaction, doc));
    }

    public Task<Object> exists(String id, Transaction<Doc> transaction) {
        return Task$.MODULE$.apply(() -> this.exists$$anonfun$1(transaction, id));
    }

    public <V> Task<Option<Doc>> _get(Field.UniqueIndex<Doc, V> field, V value, Transaction<Doc> transaction) {
        return Task$.MODULE$.apply(() -> this._get$$anonfun$1(field, transaction, value));
    }

    public <V> Task<Object> _delete(Field.UniqueIndex<Doc, V> field, V value, Transaction<Doc> transaction) {
        return Task$.MODULE$.apply(() -> this._delete$$anonfun$1(transaction, value));
    }

    public Task<Object> count(Transaction<Doc> transaction) {
        return Task$.MODULE$.apply(() -> this.count$$anonfun$1(transaction));
    }

    public Task jsonStream(Transaction<Doc> transaction) {
        return Stream$.MODULE$.fromIterator(Task$.MODULE$.apply(() -> this.jsonStream$$anonfun$1(transaction)));
    }

    public Task<Object> truncate(Transaction<Doc> transaction) {
        return this.count(transaction).map((Function1)(JFunction1.mcII.sp & Serializable)size -> {
            this.getInstance(transaction).del(this.name$accessor());
            return size;
        });
    }

    public Task<BoxedUnit> doDispose() {
        return super.doDispose().next(this::doDispose$$anonfun$1);
    }

    private final void initialize$$anonfun$1$$anonfun$1() {
        this.lightdb$redis$RedisStore$$pool().preparePool();
    }

    private final Task initialize$$anonfun$1() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.initialize$$anonfun$1$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private final Jedis getInstance$$anonfun$1() {
        return this.lightdb$redis$RedisStore$$pool().getResource();
    }

    private final void prepareTransaction$$anonfun$1(Transaction transaction$1) {
        transaction$1.put((FeatureKey)new TransactionKey(TransactionKey$.MODULE$.apply(TransactionKey$.MODULE$.$lessinit$greater$default$1())), (Object)new TransactionFeature(transaction$1, this){
            private final Transaction transaction$2;
            private final /* synthetic */ RedisStore $outer;
            {
                this.transaction$2 = transaction$10;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Task commit() {
                return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.commit$$anonfun$1();
                    return BoxedUnit.UNIT;
                }).next(this::commit$$anonfun$2);
            }

            private final void commit$$anonfun$1() {
                this.transaction$2.get((FeatureKey)new TransactionKey(this.$outer.lightdb$redis$RedisStore$$InstanceKey())).foreach((Function1)(JProcedure1 & Serializable)jedis -> this.$outer.lightdb$redis$RedisStore$$pool().returnResource(jedis));
            }

            private final Task commit$$anonfun$2() {
                return TransactionFeature.commit$((TransactionFeature)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{commit$$anonfun$adapted$1(), commit$$anonfun$2(), commit$$anonfun$1$$anonfun$1(redis.clients.jedis.Jedis )}, serializedLambda);
            }
        });
    }

    private final Document _upsert$$anonfun$1(Transaction transaction$3, Document doc$1) {
        this.getInstance(transaction$3).hset(this.name$accessor(), doc$1._id(), this.toString(doc$1));
        return doc$1;
    }

    private final boolean exists$$anonfun$1(Transaction transaction$4, String id$1) {
        return this.getInstance(transaction$4).hexists(this.name$accessor(), id$1);
    }

    private final Option _get$$anonfun$1(Field.UniqueIndex field$1, Transaction transaction$5, Object value$1) {
        Field.UniqueIndex uniqueIndex = field$1;
        Field.UniqueIndex uniqueIndex2 = this.idField();
        if (!(uniqueIndex != null ? !uniqueIndex.equals(uniqueIndex2) : uniqueIndex2 != null)) {
            return Option$.MODULE$.apply((Object)this.getInstance(transaction$5).hget(this.name$accessor(), ((Id)value$1).value())).map((Function1 & Serializable)string -> this.fromString((String)string));
        }
        throw new UnsupportedOperationException(new StringBuilder(51).append("HaloDBStore can only get on _id, but ").append(((Field)field$1).name()).append(" was attempted").toString());
    }

    private final boolean _delete$$anonfun$1(Transaction transaction$6, Object value$2) {
        return this.getInstance(transaction$6).hdel(((Id)value$2).value(), new String[0]) > 0L;
    }

    private final int count$$anonfun$1(Transaction transaction$7) {
        return (int)this.getInstance(transaction$7).hlen(this.name$accessor());
    }

    private final Iterator jsonStream$$anonfun$1(Transaction transaction$8) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.getInstance(transaction$8).hgetAll(this.name$accessor()).values().iterator()).asScala().map((Function1 & Serializable)string -> this.toJson((String)string));
    }

    private final void doDispose$$anonfun$1$$anonfun$1() {
        this.lightdb$redis$RedisStore$$pool().close();
    }

    private final Task doDispose$$anonfun$1() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.doDispose$$anonfun$1$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }
}

