/*
 * Decompiled with CFR 0.152.
 */
package com.outr.arango;

import cats.Applicative;
import cats.Traverse;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.IORuntime$;
import cats.implicits$;
import cats.syntax.ApplicativeByNameOps$;
import com.outr.arango.CollectionType;
import com.outr.arango.DatabaseStore;
import com.outr.arango.DatabaseStore$;
import com.outr.arango.Document;
import com.outr.arango.DocumentModel;
import com.outr.arango.Edge;
import com.outr.arango.EdgeModel;
import com.outr.arango.Graph$AppliedUpgrades$;
import com.outr.arango.collection.Collection;
import com.outr.arango.collection.DocumentCollection;
import com.outr.arango.collection.EdgeCollection;
import com.outr.arango.collection.QueryBuilder;
import com.outr.arango.core.ArangoDB;
import com.outr.arango.core.ArangoDBConfig;
import com.outr.arango.core.ArangoDBConfig$;
import com.outr.arango.core.ArangoDBServer;
import com.outr.arango.core.ArangoDBServer$;
import com.outr.arango.core.ArangoDBTransaction;
import com.outr.arango.core.CreateResult;
import com.outr.arango.core.SortCompression;
import com.outr.arango.core.SortCompression$LZ4$;
import com.outr.arango.query.Query;
import com.outr.arango.query.Sort;
import com.outr.arango.upgrade.CreateDatabase$;
import com.outr.arango.upgrade.DatabaseUpgrade;
import com.outr.arango.view.View;
import com.outr.arango.view.ViewLink;
import fabric.Json;
import fabric.Obj;
import fabric.Obj$;
import fabric.rw.RW;
import fabric.rw.Writer;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Pkg$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Graph {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Graph.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final ArangoDB db;
    private final boolean managed;
    private final AtomicBoolean _initialized;
    private List<DocumentCollection<? extends Document<?>, ? extends DocumentModel<?>>> _collections;
    private List<View> _views;
    private List<DatabaseStore> _stores;
    private final DatabaseStore store;
    public ArangoDBTransaction transaction$lzy1;
    public Graph$AppliedUpgrades$ AppliedUpgrades$lzy1;

    public Graph(ArangoDB db, boolean managed) {
        this.db = db;
        this.managed = managed;
        this._initialized = new AtomicBoolean(false);
        this._collections = package$.MODULE$.Nil();
        this._views = package$.MODULE$.Nil();
        this._stores = package$.MODULE$.Nil();
        this.store = this.keyStore(this.storeCollectionName(), this.keyStore$default$2());
    }

    public ArangoDB db() {
        return this.db;
    }

    public boolean managed() {
        return this.managed;
    }

    public String storeCollectionName() {
        return "backingStore";
    }

    public ArangoDBServer server() {
        return this.db().server();
    }

    public List<DocumentCollection<? extends Document<?>, ? extends DocumentModel<?>>> collections() {
        return this._collections;
    }

    public List<View> views() {
        return this._views;
    }

    public List<DatabaseStore> stores() {
        return this._stores;
    }

    public Graph(String name, ArangoDBServer server, boolean managed) {
        this(server.db(name), managed);
    }

    public Graph(String name, ArangoDBConfig config, boolean managed) {
        this(name, ArangoDBServer$.MODULE$.apply(config), managed);
    }

    public Graph(String name, boolean managed) {
        this(name, ArangoDBConfig$.MODULE$.apply(ArangoDBConfig$.MODULE$.$lessinit$greater$default$1(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$2(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$3(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$4(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$5(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$6(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$7(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$8(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$9(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$10(), ArangoDBConfig$.MODULE$.$lessinit$greater$default$11()), managed);
    }

    public Graph(String name, ArangoDBServer server) {
        this(name, server, true);
    }

    public Graph(String name, ArangoDBConfig config) {
        this(name, config, true);
    }

    public Graph(String name) {
        this(name, true);
    }

    public DatabaseStore store() {
        return this.store;
    }

    public boolean initialized() {
        return this._initialized.get();
    }

    public IO<BoxedUnit> init(boolean createDatabase) {
        if (this._initialized.compareAndSet(false, true)) {
            Function0 function0 = implicits$.MODULE$.catsSyntaxApplicativeByName(this::init$$anonfun$1);
            return ((IO)ApplicativeByNameOps$.MODULE$.whenA$extension(function0, createDatabase, (Applicative)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.store().apply(this.AppliedUpgrades().key(), (Function1 & Serializable)_$1 -> this.AppliedUpgrades().empty(), this.AppliedUpgrades().rw()).map((Function1 & Serializable)_$2 -> _$2.labels()).map((Function1 & Serializable)appliedUpgrades -> {
                    BoxedUnit boxedUnit;
                    List upgrades = this.upgrades().filter((Function1 & Serializable)u -> u.alwaysRun() || !appliedUpgrades.contains((Object)u.label()));
                    if (upgrades.nonEmpty()) {
                        scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message(() -> Graph.$anonfun$2(upgrades))}), Pkg$.MODULE$.apply("com.outr.arango"), FileName$.MODULE$.apply("Graph.scala"), Name$.MODULE$.apply("$1"), Line$.MODULE$.apply(60), MDC$.MODULE$.global());
                    }
                    BoxedUnit $1$ = boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit $1$2 = BoxedUnit.UNIT;
                    return Tuple3$.MODULE$.apply(appliedUpgrades, (Object)upgrades, (Object)$1$2);
                }).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple3 tuple3 = x$12;
                    if (tuple3 != null) {
                        Set appliedUpgrades = (Set)tuple3._1();
                        List upgrades = (List)tuple3._2();
                        return this.doUpgrades((List<DatabaseUpgrade>)upgrades, (List<DatabaseUpgrade>)upgrades, true, (Set<String>)appliedUpgrades).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    }
                    throw new MatchError((Object)tuple3);
                });
            });
        }
        return IO$.MODULE$.unit();
    }

    public boolean init$default$1() {
        return true;
    }

    public <Return> Return initted(Function0<Return> f) {
        if (!this.initialized()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Database has not been initialized yet");
        }
        return (Return)f.apply();
    }

    public <T> QueryBuilder<T> query(Query query, RW<T> rw) {
        return this.query(query, (Function1 & Serializable)value -> rw.write(value));
    }

    public <T> QueryBuilder<T> query(Query query, Function1<Json, T> converter) {
        return new QueryBuilder<T>(this, query, converter);
    }

    public IO<BoxedUnit> execute(Query query) {
        return this.db().query().execute(query);
    }

    public String databaseName() {
        return this.db().name();
    }

    public ArangoDBTransaction<Collection> transaction() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    ArangoDBTransaction<Collection> arangoDBTransaction;
                    this.transaction$lzy1 = arangoDBTransaction = new ArangoDBTransaction<Collection>(this.db().db(), (Function1 & Serializable)_$4 -> _$4.name());
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return arangoDBTransaction;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.transaction$lzy1;
    }

    public List<DatabaseUpgrade> upgrades() {
        return package$.MODULE$.Nil();
    }

    public IO<BoxedUnit> doUpgrades(List<DatabaseUpgrade> allUpgrades, List<DatabaseUpgrade> upgrades, boolean stillBlocking, Set<String> appliedUpgrades) {
        if (upgrades.isEmpty()) {
            return this.afterStartup(allUpgrades);
        }
        boolean continueBlocking = upgrades.exists((Function1 & Serializable)_$5 -> _$5.blockStartup());
        DatabaseUpgrade upgrade = (DatabaseUpgrade)upgrades.head();
        IO io = upgrade.upgrade(this).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            BoxedUnit $2$ = boxedUnit = BoxedUnit.UNIT;
            Set applied = (Set)appliedUpgrades.$plus((Object)upgrade.label());
            return Tuple2$.MODULE$.apply((Object)$2$, (Object)applied);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Set applied = (Set)tuple2._2();
                return this.store().update(this.AppliedUpgrades().key(), this.AppliedUpgrades().apply((Set<String>)applied), this.AppliedUpgrades().rw()).flatMap((Function1 & Serializable)x$12 -> {
                    CreateResult createResult = x$12;
                    return this.doUpgrades(allUpgrades, (List<DatabaseUpgrade>)((List)upgrades.tail()), continueBlocking, (Set<String>)applied).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                });
            }
            throw new MatchError((Object)tuple2);
        });
        if (stillBlocking && !continueBlocking) {
            io.unsafeRunAndForget(IORuntime$.MODULE$.global());
            return IO$.MODULE$.unit();
        }
        return io;
    }

    public IO<BoxedUnit> afterStartup(List<DatabaseUpgrade> upgrades) {
        if (upgrades.isEmpty()) {
            scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message(Graph::afterStartup$$anonfun$1)}), Pkg$.MODULE$.apply("com.outr.arango"), FileName$.MODULE$.apply("Graph.scala"), Name$.MODULE$.apply("afterStartup"), Line$.MODULE$.apply(125), MDC$.MODULE$.global());
            return IO$.MODULE$.unit();
        }
        DatabaseUpgrade upgrade = (DatabaseUpgrade)upgrades.head();
        return upgrade.afterStartup(this).flatMap((Function1 & Serializable)_$6 -> this.afterStartup((List<DatabaseUpgrade>)((List)upgrades.tail())));
    }

    public IO<BoxedUnit> truncate() {
        return ((IO)implicits$.MODULE$.toTraverseOps((Object)this.collections().map((Function1 & Serializable)_$7 -> _$7.collection().truncate()), (Traverse)implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1)(JProcedure1 & Serializable)_$8 -> {});
    }

    public <D extends Document<D>, M extends DocumentModel<D>> DocumentCollection<D, M> vertex(M model, boolean managed) {
        DocumentCollection documentCollection;
        Graph graph = this;
        synchronized (graph) {
            DocumentCollection c = new DocumentCollection(this, this.db().collection(model.collectionName()), model, (CollectionType)CollectionType.Vertex$.MODULE$, managed);
            List<DocumentCollection<? extends Document<?>, ? extends DocumentModel<?>>> list = this._collections;
            this._collections = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DocumentCollection[]{c}))).$colon$colon$colon(list);
            documentCollection = c;
        }
        return documentCollection;
    }

    public boolean vertex$default$2() {
        return this.managed();
    }

    public <E extends Edge<E, From, To>, M extends EdgeModel<E, From, To>, From, To> EdgeCollection<E, M, From, To> edge(M model, boolean managed) {
        EdgeCollection edgeCollection;
        Graph graph = this;
        synchronized (graph) {
            EdgeCollection c = new EdgeCollection(this, this.db().collection(model.collectionName()), model, managed);
            List<DocumentCollection<? extends Document<?>, ? extends DocumentModel<?>>> list = this._collections;
            this._collections = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EdgeCollection[]{c}))).$colon$colon$colon(list);
            edgeCollection = c;
        }
        return edgeCollection;
    }

    public boolean edge$default$2() {
        return this.managed();
    }

    public View view(String name, List<ViewLink> links, boolean managed, List<Sort> primarySort, SortCompression primarySortCompression, FiniteDuration consolidationInterval, FiniteDuration commitInterval, int cleanupIntervalStep) {
        View view;
        Graph graph = this;
        synchronized (graph) {
            View view2 = this.db().view(name, managed, links, primarySort, primarySortCompression, consolidationInterval, commitInterval, cleanupIntervalStep);
            List<View> list = this._views;
            this._views = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new View[]{view2}))).$colon$colon$colon(list);
            view = view2;
        }
        return view;
    }

    public boolean view$default$3() {
        return this.managed();
    }

    public List<Sort> view$default$4() {
        return package$.MODULE$.Nil();
    }

    public SortCompression view$default$5() {
        return SortCompression$LZ4$.MODULE$;
    }

    public FiniteDuration view$default$6() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public FiniteDuration view$default$7() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public int view$default$8() {
        return 2;
    }

    public DatabaseStore keyStore(String collectionName, boolean managed) {
        DatabaseStore databaseStore;
        Graph graph = this;
        synchronized (graph) {
            DatabaseStore s = DatabaseStore$.MODULE$.apply(this.db().collection(collectionName), managed);
            List<DatabaseStore> list = this._stores;
            this._stores = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DatabaseStore[]{s}))).$colon$colon$colon(list);
            databaseStore = s;
        }
        return databaseStore;
    }

    public boolean keyStore$default$2() {
        return this.managed();
    }

    public IO<Object> drop() {
        return this.db().drop();
    }

    public IO<BoxedUnit> shutdown() {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.shutdown$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public final Graph$AppliedUpgrades$ AppliedUpgrades() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    Graph$AppliedUpgrades$ graph$AppliedUpgrades$;
                    this.AppliedUpgrades$lzy1 = graph$AppliedUpgrades$ = new Graph$AppliedUpgrades$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return graph$AppliedUpgrades$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.AppliedUpgrades$lzy1;
    }

    private final IO init$$anonfun$1() {
        return CreateDatabase$.MODULE$.upgrade(this);
    }

    private static final String $anonfun$2(List upgrades$1) {
        return new StringBuilder(24).append("Applying ").append(upgrades$1.length()).append(" upgrades (").append(upgrades$1.map((Function1 & Serializable)_$3 -> _$3.label()).mkString(", ")).append(")...").toString();
    }

    private static final String afterStartup$$anonfun$1() {
        return "Upgrades completed successfully";
    }

    private final void shutdown$$anonfun$1() {
        this.db().shutdown();
    }

    public static final /* synthetic */ Object com$outr$arango$Graph$$anon$1$$_$_$$anonfun$6(Object _$3) {
        return _$3;
    }

    public static final /* synthetic */ Set com$outr$arango$Graph$$anon$1$$_$_$$anonfun$7(Writer hdWritable$1, Json value) {
        return (Set)hdWritable$1.write(value);
    }

    private static final Object defaultAlternative$1(Map map$1, boolean isJsonWrapper$1, String hdLabelValue$1) {
        String string = hdLabelValue$1;
        String string2 = "json";
        if (!(string != null ? !string.equals(string2) : string2 != null) && isJsonWrapper$1) {
            return new Obj(Obj$.MODULE$.apply(map$1));
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(48).append("Unable to find field ").append("com.outr.arango.Graph.AppliedUpgrades$").append(".").append(hdLabelValue$1).append(" (and no defaults set) in ").append(new Obj(Obj$.MODULE$.apply(map$1))).toString());
    }

    private static final Object default$1$$anonfun$1(Map map$3, boolean isJsonWrapper$3, String hdLabelValue$3) {
        return Graph.defaultAlternative$1(map$3, isJsonWrapper$3, hdLabelValue$3);
    }

    private static final Object default$1(Map map$2, Map defaults$1, boolean isJsonWrapper$2, String hdLabelValue$2) {
        return defaults$1.getOrElse((Object)hdLabelValue$2, () -> Graph.default$1$$anonfun$1(map$2, isJsonWrapper$2, hdLabelValue$2));
    }

    public static final Object com$outr$arango$Graph$$anon$1$$_$_$$anonfun$8(Map map$4, Map defaults$2, boolean isJsonWrapper$4, String hdLabelValue$4) {
        return Graph.default$1(map$4, defaults$2, isJsonWrapper$4, hdLabelValue$4);
    }

    public class AppliedUpgrades
    implements Product,
    Serializable {
        private final Set labels;
        private final /* synthetic */ Graph $outer;

        public AppliedUpgrades(Graph $outer, Set<String> labels) {
            this.labels = labels;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AppliedUpgrades)) return false;
            if (((AppliedUpgrades)object).com$outr$arango$Graph$AppliedUpgrades$$$outer() != this.$outer) return false;
            AppliedUpgrades appliedUpgrades = (AppliedUpgrades)object;
            Set<String> set = this.labels();
            Set<String> set2 = appliedUpgrades.labels();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!appliedUpgrades.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AppliedUpgrades;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AppliedUpgrades";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "labels";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<String> labels() {
            return this.labels;
        }

        public AppliedUpgrades copy(Set<String> labels) {
            return new AppliedUpgrades(this.$outer, labels);
        }

        public Set<String> copy$default$1() {
            return this.labels();
        }

        public Set<String> _1() {
            return this.labels();
        }

        public final /* synthetic */ Graph com$outr$arango$Graph$AppliedUpgrades$$$outer() {
            return this.$outer;
        }
    }
}

