/*
 * Decompiled with CFR 0.152.
 */
package com.outr.arango.collection;

import cats.MonadError;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import com.outr.arango.Graph;
import com.outr.arango.collection.ProcessStats;
import com.outr.arango.collection.ProcessStats$;
import com.outr.arango.query.Query;
import com.outr.arango.queue.DBQueue;
import com.outr.arango.queue.DBQueue$;
import fabric.Json;
import fabric.rw.RW;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.java8.JFunction1;

public class QueryBuilder<R> {
    private final Graph graph;
    private final Query query;
    private final Function1 converter;

    public QueryBuilder(Graph graph, Query query, Function1<Json, R> converter) {
        this.graph = graph;
        this.query = query;
        this.converter = converter;
    }

    public Query query() {
        return this.query;
    }

    public Function1<Json, R> converter() {
        return this.converter;
    }

    public <T> QueryBuilder<T> as(RW<T> rw) {
        return new QueryBuilder<R>(this.graph, this.query(), (Function1 & Serializable)value -> rw.write(value));
    }

    public Stream<IO, R> stream() {
        return this.graph.db().query().apply(this.query()).map(this.converter());
    }

    public IO<Iterator<R>> iterator() {
        return this.graph.db().query().iterator(this.query()).map((Function1 & Serializable)_$1 -> _$1.map(this.converter()));
    }

    public IO<List<R>> all() {
        return this.iterator().map((Function1 & Serializable)_$2 -> _$2.toList());
    }

    public IO<R> one() {
        return this.all().map((Function1 & Serializable)x$1 -> {
            List list = x$1;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                throw new RuntimeException("No results");
            }
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                Object d = colon2.head();
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                    return d;
                }
            }
            List list5 = list;
            throw new RuntimeException(new StringBuilder(31).append("More than one result returned: ").append(list5).toString());
        });
    }

    public IO<Option<R>> first() {
        return (IO)this.stream().take(1L).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).last();
    }

    public IO<Option<R>> last() {
        return (IO)this.stream().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).last();
    }

    public IO<Object> count() {
        return ((IO)this.stream().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).count()).map((Function1)(JFunction1.mcIJ.sp & Serializable)_$3 -> (int)_$3);
    }

    public IO<ProcessStats> process(Function2<DBQueue, R, IO<DBQueue>> processor, int batchSize) {
        AtomicInteger counter = new AtomicInteger(0);
        return ((IO)this.stream().evalScan((Object)DBQueue$.MODULE$.apply(batchSize, DBQueue$.MODULE$.$lessinit$greater$default$2()), (Function2 & Serializable)(queue, value) -> {
            counter.incrementAndGet();
            return (IO)processor.apply(queue, value);
        }).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).lastOrError((MonadError)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)queue -> queue.finish().map((Function1 & Serializable)_$4 -> ProcessStats$.MODULE$.apply(counter.get(), queue.inserted(), queue.upserted(), queue.deleted())));
    }

    public int process$default$2() {
        return 1000;
    }

    public String toString() {
        return this.query().toString();
    }
}

