/*
 * Decompiled with CFR 0.152.
 */
package com.outr.arango.core;

import cats.effect.IO;
import com.arangodb.async.ArangoDatabaseAsync;
import com.arangodb.entity.StreamTransactionStatus;
import com.arangodb.model.StreamTransactionOptions;
import com.outr.arango.core.StreamTransaction;
import com.outr.arango.core.StreamTransaction$;
import com.outr.arango.core.TransactionLock;
import com.outr.arango.core.TransactionLock$Exclusive$;
import com.outr.arango.core.TransactionLock$Read$;
import com.outr.arango.core.TransactionLock$Write$;
import com.outr.arango.core.TransactionStatus;
import com.outr.arango.core.TransactionStatus$Aborted$;
import com.outr.arango.core.TransactionStatus$Committed$;
import com.outr.arango.core.TransactionStatus$Running$;
import com.outr.arango.util.Helpers$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class ArangoDBTransaction<Collection> {
    private final ArangoDatabaseAsync db;
    public final Function1<Collection, String> com$outr$arango$core$ArangoDBTransaction$$c2Name;

    public ArangoDBTransaction(ArangoDatabaseAsync db, Function1<Collection, String> c2Name) {
        this.db = db;
        this.com$outr$arango$core$ArangoDBTransaction$$c2Name = c2Name;
    }

    public <Return> IO<Return> apply(boolean allowImplicit, Option<FiniteDuration> lockTimeout, boolean waitForSync, Option<Object> maxTransactionSize, List<Tuple2<Collection, TransactionLock>> locks, Function1<StreamTransaction, IO<Return>> f) {
        return this.begin(allowImplicit, lockTimeout, waitForSync, maxTransactionSize, locks).flatMap((Function1 & Serializable)transaction -> ((IO)f.apply(transaction)).attempt().flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                return this.abort((StreamTransaction)transaction).map((Function1 & Serializable)_$1 -> {
                    throw throwable;
                });
            }
            if (either instanceof Right) {
                Object r = ((Right)either).value();
                return this.commit((StreamTransaction)transaction).map((Function1 & Serializable)_$2 -> r);
            }
            throw new MatchError((Object)either);
        }));
    }

    public boolean apply$default$1() {
        return true;
    }

    public <Return> Option<FiniteDuration> apply$default$2() {
        return None$.MODULE$;
    }

    public boolean apply$default$3() {
        return false;
    }

    public <Return> Option<Object> apply$default$4() {
        return None$.MODULE$;
    }

    public <Return> List<Tuple2<Collection, TransactionLock>> apply$default$5() {
        return package$.MODULE$.Nil();
    }

    public IO<StreamTransaction> begin(boolean allowImplicit, Option<FiniteDuration> lockTimeout, boolean waitForSync, Option<Object> maxTransactionSize, List<Tuple2<Collection, TransactionLock>> locks) {
        List exclusive;
        List write;
        StreamTransactionOptions options = new StreamTransactionOptions();
        lockTimeout.foreach((Function1 & Serializable)d -> options.lockTimeout(Predef$.MODULE$.int2Integer((int)d.toSeconds())));
        options.allowImplicit(Predef$.MODULE$.boolean2Boolean(allowImplicit));
        options.waitForSync(Predef$.MODULE$.boolean2Boolean(waitForSync));
        maxTransactionSize.foreach((Function1 & Serializable)_$3 -> options.maxTransactionSize(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)_$3))));
        List read = locks.collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ ArangoDBTransaction $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    TransactionLock lock;
                    Object collection = tuple2._1();
                    TransactionLock transactionLock = lock = (TransactionLock)tuple2._2();
                    TransactionLock$Read$ transactionLock$Read$ = TransactionLock$Read$.MODULE$;
                    if (!(transactionLock != null ? !transactionLock.equals(transactionLock$Read$) : transactionLock$Read$ != null)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    TransactionLock lock;
                    Object collection = tuple2._1();
                    TransactionLock transactionLock = lock = (TransactionLock)tuple2._2();
                    TransactionLock$Read$ transactionLock$Read$ = TransactionLock$Read$.MODULE$;
                    if (!(transactionLock != null ? !transactionLock.equals(transactionLock$Read$) : transactionLock$Read$ != null)) {
                        return this.$outer.com$outr$arango$core$ArangoDBTransaction$$c2Name.apply(collection);
                    }
                }
                return function1.apply((Object)x);
            }
        });
        if (read.nonEmpty()) {
            options.readCollections((String[])Arrays$.MODULE$.seqToArray((Seq)read, String.class));
        }
        if ((write = locks.collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ ArangoDBTransaction $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    TransactionLock lock;
                    Object collection = tuple2._1();
                    TransactionLock transactionLock = lock = (TransactionLock)tuple2._2();
                    TransactionLock$Write$ transactionLock$Write$ = TransactionLock$Write$.MODULE$;
                    if (!(transactionLock != null ? !transactionLock.equals(transactionLock$Write$) : transactionLock$Write$ != null)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    TransactionLock lock;
                    Object collection = tuple2._1();
                    TransactionLock transactionLock = lock = (TransactionLock)tuple2._2();
                    TransactionLock$Write$ transactionLock$Write$ = TransactionLock$Write$.MODULE$;
                    if (!(transactionLock != null ? !transactionLock.equals(transactionLock$Write$) : transactionLock$Write$ != null)) {
                        return this.$outer.com$outr$arango$core$ArangoDBTransaction$$c2Name.apply(collection);
                    }
                }
                return function1.apply((Object)x);
            }
        })).nonEmpty()) {
            options.writeCollections((String[])Arrays$.MODULE$.seqToArray((Seq)write, String.class));
        }
        if ((exclusive = locks.collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ ArangoDBTransaction $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    TransactionLock lock;
                    Object collection = tuple2._1();
                    TransactionLock transactionLock = lock = (TransactionLock)tuple2._2();
                    TransactionLock$Exclusive$ transactionLock$Exclusive$ = TransactionLock$Exclusive$.MODULE$;
                    if (!(transactionLock != null ? !transactionLock.equals(transactionLock$Exclusive$) : transactionLock$Exclusive$ != null)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    TransactionLock lock;
                    Object collection = tuple2._1();
                    TransactionLock transactionLock = lock = (TransactionLock)tuple2._2();
                    TransactionLock$Exclusive$ transactionLock$Exclusive$ = TransactionLock$Exclusive$.MODULE$;
                    if (!(transactionLock != null ? !transactionLock.equals(transactionLock$Exclusive$) : transactionLock$Exclusive$ != null)) {
                        return this.$outer.com$outr$arango$core$ArangoDBTransaction$$c2Name.apply(collection);
                    }
                }
                return function1.apply((Object)x);
            }
        })).nonEmpty()) {
            options.exclusiveCollections((String[])Arrays$.MODULE$.seqToArray((Seq)exclusive, String.class));
        }
        return Helpers$.MODULE$.CompletableFutureExtras(this.db.beginStreamTransaction(options)).toIO().map((Function1 & Serializable)entity -> StreamTransaction$.MODULE$.apply(entity.getId()));
    }

    public boolean begin$default$1() {
        return true;
    }

    public Option<FiniteDuration> begin$default$2() {
        return None$.MODULE$;
    }

    public boolean begin$default$3() {
        return false;
    }

    public Option<Object> begin$default$4() {
        return None$.MODULE$;
    }

    public List<Tuple2<Collection, TransactionLock>> begin$default$5() {
        return package$.MODULE$.Nil();
    }

    private TransactionStatus t2Status(StreamTransactionStatus status) {
        Mirror.Singleton singleton;
        StreamTransactionStatus streamTransactionStatus = status;
        StreamTransactionStatus streamTransactionStatus2 = StreamTransactionStatus.running;
        StreamTransactionStatus streamTransactionStatus3 = streamTransactionStatus;
        if (!(streamTransactionStatus2 != null ? !streamTransactionStatus2.equals(streamTransactionStatus3) : streamTransactionStatus3 != null)) {
            singleton = TransactionStatus$Running$.MODULE$;
        } else {
            StreamTransactionStatus streamTransactionStatus4 = StreamTransactionStatus.committed;
            StreamTransactionStatus streamTransactionStatus5 = streamTransactionStatus;
            if (!(streamTransactionStatus4 != null ? !streamTransactionStatus4.equals(streamTransactionStatus5) : streamTransactionStatus5 != null)) {
                singleton = TransactionStatus$Committed$.MODULE$;
            } else {
                StreamTransactionStatus streamTransactionStatus6 = StreamTransactionStatus.aborted;
                StreamTransactionStatus streamTransactionStatus7 = streamTransactionStatus;
                if (!(streamTransactionStatus6 != null ? !streamTransactionStatus6.equals(streamTransactionStatus7) : streamTransactionStatus7 != null)) {
                    singleton = TransactionStatus$Aborted$.MODULE$;
                } else {
                    throw new MatchError((Object)streamTransactionStatus);
                }
            }
        }
        return singleton;
    }

    public IO<TransactionStatus> status(StreamTransaction transaction) {
        return Helpers$.MODULE$.CompletableFutureExtras(this.db.getStreamTransaction(transaction.id())).toIO().map((Function1 & Serializable)e -> this.t2Status(e.getStatus()));
    }

    public IO<TransactionStatus> abort(StreamTransaction transaction) {
        return Helpers$.MODULE$.CompletableFutureExtras(this.db.abortStreamTransaction(transaction.id())).toIO().map((Function1 & Serializable)e -> this.t2Status(e.getStatus()));
    }

    public IO<TransactionStatus> commit(StreamTransaction transaction) {
        return Helpers$.MODULE$.CompletableFutureExtras(this.db.commitStreamTransaction(transaction.id())).toIO().map((Function1 & Serializable)e -> this.t2Status(e.getStatus()));
    }

    public IO<List<Tuple2<StreamTransaction, TransactionStatus>>> all() {
        return Helpers$.MODULE$.CompletableFutureExtras(this.db.getStreamTransactions()).toIO().map((Function1 & Serializable)_$4 -> CollectionConverters$.MODULE$.CollectionHasAsScala(_$4).asScala().toList().map((Function1 & Serializable)entity -> Tuple2$.MODULE$.apply((Object)StreamTransaction$.MODULE$.apply(entity.getId()), (Object)this.t2Status(entity.getStatus()))));
    }
}

