/*
 * Decompiled with CFR 0.152.
 */
package scribe.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scribe.file.FileWriter;
import scribe.file.FlushMode;
import scribe.file.LogFile;

public final class LogFile$
implements scala.Serializable {
    public static LogFile$ MODULE$;
    private Map<Path, LogFile> paths;
    private Map<LogFile, Set<FileWriter>> usage;
    private Map<FileWriter, LogFile> current;

    static {
        new LogFile$();
    }

    private Map<Path, LogFile> paths() {
        return this.paths;
    }

    private void paths_$eq(Map<Path, LogFile> x$1) {
        this.paths = x$1;
    }

    private Map<LogFile, Set<FileWriter>> usage() {
        return this.usage;
    }

    private void usage_$eq(Map<LogFile, Set<FileWriter>> x$1) {
        this.usage = x$1;
    }

    private Map<FileWriter, LogFile> current() {
        return this.current;
    }

    private void current_$eq(Map<FileWriter, LogFile> x$1) {
        this.current = x$1;
    }

    public Option<LogFile> get(Path path) {
        return this.paths().get((Object)path);
    }

    public synchronized void close(LogFile logFile) {
        logFile.flush();
        this.paths().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogFile$.$anonfun$close$1(logFile, x0$1);
            return BoxedUnit.UNIT;
        });
        this.usage_$eq((Map<LogFile, Set<FileWriter>>)((Map)this.usage().$minus((Object)logFile)));
        this.current().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            LogFile$.$anonfun$close$2(logFile, x0$2);
            return BoxedUnit.UNIT;
        });
        logFile.scribe$file$LogFile$$dispose();
    }

    public void delete(LogFile logFile) {
        LogFile$ logFile$ = this;
        synchronized (logFile$) {
            this.close(logFile);
            Files.deleteIfExists(logFile.path());
        }
    }

    public void move(LogFile logFile, Path path) {
        LogFile$ logFile$ = this;
        synchronized (logFile$) {
            Object object;
            this.close(logFile);
            if (Files.exists(logFile.path(), new LinkOption[0])) {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                }
                object = Files.move(logFile.path(), path, new CopyOption[0]);
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public void copy(LogFile logFile, Path path) {
        LogFile$ logFile$ = this;
        synchronized (logFile$) {
            Object object;
            this.close(logFile);
            if (Files.exists(logFile.path(), new LinkOption[0])) {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                }
                object = Files.copy(logFile.path(), path, new CopyOption[0]);
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized void gzip(LogFile logFile, Path path, boolean deleteOriginal, int bufferSize) {
        this.close(logFile);
        if (Files.exists(logFile.path(), new LinkOption[0])) {
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            byte[] buffer = new byte[bufferSize];
            File file = logFile.path().toFile();
            File outputFile = path.toFile();
            FileInputStream input = new FileInputStream(file);
            GZIPOutputStream output = new GZIPOutputStream(new FileOutputStream(outputFile));
            try {
                this.stream(input, output, buffer);
                output.flush();
            }
            finally {
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> input.close());
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> output.close());
                if (deleteOriginal && !file.delete()) {
                    file.deleteOnExit();
                }
            }
        }
    }

    private void stream(InputStream input, OutputStream output, byte[] buffer) {
        int len;
        while ((len = input.read(buffer)) > 0) {
            output.write(buffer, 0, len);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized LogFile apply(FileWriter writer) {
        Path path = writer.path();
        LogFile logFile = this.request(path, writer);
        boolean bl = false;
        Some some = null;
        Option option = this.current().get((Object)writer);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogFile lf = (LogFile)some.value();
            if (lf == logFile) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return logFile;
            }
        }
        if (bl) {
            LogFile lf = (LogFile)some.value();
            this.release(lf, writer);
            this.current_$eq((Map<FileWriter, LogFile>)this.current().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)writer), (Object)logFile)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return logFile;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        this.current_$eq((Map<FileWriter, LogFile>)this.current().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)writer), (Object)logFile)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return logFile;
    }

    private LogFile request(Path path, FileWriter writer) {
        LogFile logFile;
        Option option = this.paths().get((Object)path);
        if (option instanceof Some) {
            LogFile lf;
            Some some = (Some)option;
            logFile = lf = (LogFile)some.value();
        } else if (None$.MODULE$.equals(option)) {
            LogFile logFile2;
            Path absolutePath = path.toAbsolutePath();
            Option option2 = this.paths().get((Object)absolutePath);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogFile lf = (LogFile)some.value();
                this.paths_$eq((Map<Path, LogFile>)this.paths().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)lf)));
                logFile2 = lf;
            } else if (None$.MODULE$.equals(option2)) {
                LogFile lf = new LogFile(absolutePath, writer.append(), writer.flushMode(), writer.charset());
                this.paths_$eq((Map<Path, LogFile>)this.paths().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)lf)));
                this.paths_$eq((Map<Path, LogFile>)this.paths().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)absolutePath), (Object)lf)));
                logFile2 = lf;
            } else {
                throw new MatchError((Object)option2);
            }
            logFile = logFile2;
        } else {
            throw new MatchError((Object)option);
        }
        LogFile logFile3 = logFile;
        Set set = (Set)((SetLike)this.usage().getOrElse((Object)logFile3, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).$plus((Object)writer);
        this.usage_$eq((Map<LogFile, Set<FileWriter>>)this.usage().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logFile3), (Object)set)));
        return logFile3;
    }

    private void release(LogFile logFile, FileWriter writer) {
        Set set = (Set)((SetLike)this.usage().getOrElse((Object)logFile, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).$minus((Object)writer);
        if (set.isEmpty()) {
            logFile.flush();
            logFile.scribe$file$LogFile$$dispose();
            this.usage_$eq((Map<LogFile, Set<FileWriter>>)((Map)this.usage().$minus((Object)logFile)));
            this.paths().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                LogFile$.$anonfun$release$2(logFile, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            this.usage_$eq((Map<LogFile, Set<FileWriter>>)this.usage().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logFile), (Object)set)));
        }
    }

    public LogFile apply(Path path, boolean append, FlushMode flushMode, Charset charset) {
        return new LogFile(path, append, flushMode, charset);
    }

    public Option<Tuple4<Path, Object, FlushMode, Charset>> unapply(LogFile x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.path(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.append()), (Object)x$0.flushMode(), (Object)x$0.charset()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$close$1(LogFile logFile$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Path path = (Path)tuple2._1();
            LogFile lf = (LogFile)tuple2._2();
            if (lf == logFile$1) {
                MODULE$.paths_$eq((Map<Path, LogFile>)((Map)MODULE$.paths().$minus((Object)path)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$close$2(LogFile logFile$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            FileWriter fileWriter = (FileWriter)tuple2._1();
            LogFile lf = (LogFile)tuple2._2();
            if (lf == logFile$1) {
                MODULE$.current_$eq((Map<FileWriter, LogFile>)((Map)MODULE$.current().$minus((Object)fileWriter)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$release$2(LogFile logFile$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Path key = (Path)tuple2._1();
            LogFile value = (LogFile)tuple2._2();
            if (value == logFile$2) {
                MODULE$.paths_$eq((Map<Path, LogFile>)((Map)MODULE$.paths().$minus((Object)key)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private LogFile$() {
        MODULE$ = this;
        this.paths = Predef$.MODULE$.Map().empty();
        this.usage = Predef$.MODULE$.Map().empty();
        this.current = Predef$.MODULE$.Map().empty();
    }
}

