/*
 * Decompiled with CFR 0.152.
 */
package scribe.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scribe.file.FileWriter;
import scribe.file.FlushMode;
import scribe.file.LogFile;
import scribe.file.Platform$;

public final class LogFile$
implements scala.Serializable {
    public static LogFile$ MODULE$;
    private Map<File, LogFile> files;
    private Map<LogFile, Set<FileWriter>> usage;
    private Map<FileWriter, LogFile> current;

    static {
        new LogFile$();
    }

    private Map<File, LogFile> files() {
        return this.files;
    }

    private void files_$eq(Map<File, LogFile> x$1) {
        this.files = x$1;
    }

    private Map<LogFile, Set<FileWriter>> usage() {
        return this.usage;
    }

    private void usage_$eq(Map<LogFile, Set<FileWriter>> x$1) {
        this.usage = x$1;
    }

    private Map<FileWriter, LogFile> current() {
        return this.current;
    }

    private void current_$eq(Map<FileWriter, LogFile> x$1) {
        this.current = x$1;
    }

    public Option<LogFile> get(File file) {
        return this.files().get((Object)file);
    }

    public synchronized void close(LogFile logFile) {
        logFile.flush();
        this.files().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogFile$.$anonfun$close$1(logFile, x0$1);
            return BoxedUnit.UNIT;
        });
        this.usage_$eq((Map<LogFile, Set<FileWriter>>)((Map)this.usage().$minus((Object)logFile)));
        this.current().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            LogFile$.$anonfun$close$2(logFile, x0$2);
            return BoxedUnit.UNIT;
        });
        logFile.scribe$file$LogFile$$dispose();
    }

    public synchronized void delete(LogFile logFile) {
        this.close(logFile);
        this.delete(logFile.file());
    }

    public synchronized void delete(File file) {
        block0: {
            if (!file.exists() || file.delete()) break block0;
            file.deleteOnExit();
        }
    }

    public synchronized void move(LogFile logFile, File file) {
        this.close(logFile);
        this.move(logFile.file(), file);
    }

    public void move(File from, File to) {
        LogFile$ logFile$ = this;
        synchronized (logFile$) {
            Object object;
            if (from.exists()) {
                Object object2 = to.exists() ? BoxesRunTime.boxToBoolean((boolean)to.delete()) : BoxedUnit.UNIT;
                object = BoxesRunTime.boxToBoolean((boolean)from.renameTo(to));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized void copy(LogFile logFile, File file) {
        this.close(logFile);
        this.copy(logFile.file(), file);
    }

    public void copy(File from, File to) {
        LogFile$ logFile$ = this;
        synchronized (logFile$) {
            Object object;
            if (from.exists()) {
                Object object2 = to.exists() ? BoxesRunTime.boxToBoolean((boolean)to.delete()) : BoxedUnit.UNIT;
                object = Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized void truncate(LogFile logFile) {
        this.close(logFile);
        this.truncate(logFile.file());
    }

    public void truncate(File file) {
        LogFile$ logFile$ = this;
        synchronized (logFile$) {
            try (FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);){
                fc.truncate(0L);
            }
        }
    }

    public void gzip(LogFile logFile, File file, boolean deleteOriginal, int bufferSize) {
        this.close(logFile);
        this.gzip(logFile.file(), file, deleteOriginal, bufferSize);
    }

    public synchronized void gzip(File current, File path, boolean deleteOriginal, int bufferSize) {
        if (current.exists()) {
            Object object = path.exists() ? BoxesRunTime.boxToBoolean((boolean)path.delete()) : BoxedUnit.UNIT;
            byte[] buffer = new byte[bufferSize];
            FileInputStream input = new FileInputStream(current);
            GZIPOutputStream output = new GZIPOutputStream(new FileOutputStream(path));
            try {
                this.stream(input, output, buffer);
                output.flush();
            }
            finally {
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> input.close());
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> output.close());
                if (deleteOriginal && !current.delete()) {
                    current.deleteOnExit();
                }
            }
        }
    }

    private void stream(InputStream input, OutputStream output, byte[] buffer) {
        int len;
        while ((len = input.read(buffer)) > 0) {
            output.write(buffer, 0, len);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized LogFile apply(FileWriter writer) {
        File file = writer.file();
        LogFile logFile = this.request(file, writer);
        boolean bl = false;
        Some some = null;
        Option option = this.current().get((Object)writer);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogFile lf = (LogFile)some.value();
            if (lf == logFile) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return logFile;
            }
        }
        if (bl) {
            LogFile lf = (LogFile)some.value();
            this.release(lf, writer);
            this.current_$eq((Map<FileWriter, LogFile>)this.current().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)writer), (Object)logFile)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return logFile;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        this.current_$eq((Map<FileWriter, LogFile>)this.current().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)writer), (Object)logFile)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return logFile;
    }

    private LogFile request(File file, FileWriter writer) {
        LogFile logFile;
        Option option = this.files().get((Object)file);
        if (option instanceof Some) {
            LogFile lf;
            Some some = (Some)option;
            logFile = lf = (LogFile)some.value();
        } else if (None$.MODULE$.equals(option)) {
            LogFile logFile2;
            File absolutePath = file.getAbsoluteFile();
            Option option2 = this.files().get((Object)absolutePath);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogFile lf = (LogFile)some.value();
                this.files_$eq((Map<File, LogFile>)this.files().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)lf)));
                logFile2 = lf;
            } else if (None$.MODULE$.equals(option2)) {
                LogFile lf = new LogFile(absolutePath, writer.append(), writer.flushMode(), writer.charset());
                this.files_$eq((Map<File, LogFile>)this.files().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)lf)));
                this.files_$eq((Map<File, LogFile>)this.files().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)absolutePath), (Object)lf)));
                logFile2 = lf;
            } else {
                throw new MatchError((Object)option2);
            }
            logFile = logFile2;
        } else {
            throw new MatchError((Object)option);
        }
        LogFile logFile3 = logFile;
        Set set = (Set)((SetLike)this.usage().getOrElse((Object)logFile3, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).$plus((Object)writer);
        this.usage_$eq((Map<LogFile, Set<FileWriter>>)this.usage().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logFile3), (Object)set)));
        return logFile3;
    }

    private void release(LogFile logFile, FileWriter writer) {
        Set set = (Set)((SetLike)this.usage().getOrElse((Object)logFile, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).$minus((Object)writer);
        if (set.isEmpty()) {
            this.close(logFile);
        } else {
            this.usage_$eq((Map<LogFile, Set<FileWriter>>)this.usage().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logFile), (Object)set)));
        }
    }

    public synchronized void dispose() {
        this.usage().keys().foreach((Function1 & Serializable & scala.Serializable)logFile -> {
            LogFile$.$anonfun$dispose$1(logFile);
            return BoxedUnit.UNIT;
        });
        this.files_$eq((Map<File, LogFile>)Predef$.MODULE$.Map().empty());
        this.usage_$eq((Map<LogFile, Set<FileWriter>>)Predef$.MODULE$.Map().empty());
        this.current_$eq((Map<FileWriter, LogFile>)Predef$.MODULE$.Map().empty());
    }

    public LogFile apply(File file, boolean append, FlushMode flushMode, Charset charset) {
        return new LogFile(file, append, flushMode, charset);
    }

    public Option<Tuple4<File, Object, FlushMode, Charset>> unapply(LogFile x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.file(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.append()), (Object)x$0.flushMode(), (Object)x$0.charset()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$close$1(LogFile logFile$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            File path = (File)tuple2._1();
            LogFile lf = (LogFile)tuple2._2();
            if (lf == logFile$1) {
                MODULE$.files_$eq((Map<File, LogFile>)((Map)MODULE$.files().$minus((Object)path)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$close$2(LogFile logFile$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            FileWriter fileWriter = (FileWriter)tuple2._1();
            LogFile lf = (LogFile)tuple2._2();
            if (lf == logFile$1) {
                MODULE$.current_$eq((Map<FileWriter, LogFile>)((Map)MODULE$.current().$minus((Object)fileWriter)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$dispose$1(LogFile logFile) {
        logFile.flush();
        logFile.scribe$file$LogFile$$dispose();
    }

    private LogFile$() {
        MODULE$ = this;
        this.files = Predef$.MODULE$.Map().empty();
        this.usage = Predef$.MODULE$.Map().empty();
        this.current = Predef$.MODULE$.Map().empty();
        Platform$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.dispose());
    }
}

