/*
 * Decompiled with CFR 0.152.
 */
package spice.http.server.rest;

import cats.effect.IO;
import fabric.Arr;
import fabric.Json;
import fabric.Json$;
import fabric.Obj;
import fabric.Str;
import fabric.io.JsonParser$;
import fabric.rw.RW;
import fabric.rw.Reader$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import spice.ValidationError;
import spice.http.HttpExchange;
import spice.http.HttpRequest;
import spice.http.HttpStatus;
import spice.http.content.Content;
import spice.http.server.dsl.PathFilter$;
import spice.http.server.rest.Restful;
import spice.http.server.rest.RestfulResponse;
import spice.http.server.rest.RestfulValidation;
import spice.net.Param;
import spice.net.URL;
import spice.net.URLPath;

public final class Restful$ {
    public static final Restful$ MODULE$ = new Restful$();
    private static final String key = "restful";

    private String key() {
        return key;
    }

    public void store(HttpExchange exchange, Json json) {
        Json merged = Json$.MODULE$.merge((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Json[]{(Json)exchange.store().getOrElse(this.key(), (Function0 & Serializable)() -> new Obj(fabric.package$.MODULE$.obj((Seq)Nil$.MODULE$))), json}));
        exchange.store().update(this.key(), (Object)merged);
    }

    public <Request, Response> Restful<Request, Response> apply(Function1<Request, IO<Response>> handler, Option<URLPath> path, RW<Request> evidence$1, RW<Response> evidence$2) {
        return new Restful<Request, Response>(evidence$1, evidence$2, path, handler){
            private final Option path$1;
            private final Function1 handler$1;

            public Option<URLPath> pathOption() {
                return this.path$1;
            }

            public IO<RestfulResponse<Response>> apply(HttpExchange exchange, Request request) {
                return ((IO)this.handler$1.apply(request)).map((Function1 & Serializable)response -> this.ok(response));
            }

            public RestfulResponse<Response> error(List<ValidationError> errors, HttpStatus status) {
                throw new RuntimeException(new StringBuilder(16).append("Error occurred: ").append(errors.map((Function1 & Serializable)x$2 -> x$2.message()).mkString(", ")).toString());
            }
            {
                this.path$1 = path$1;
                this.handler$1 = handler$1;
                super(evidence$1$1, evidence$2$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$2(spice.http.server.rest.Restful$$anon$1 java.lang.Object ), $anonfun$error$1(spice.ValidationError )}, serializedLambda);
            }
        };
    }

    public <Request, Response> Option<URLPath> apply$default$2() {
        return None$.MODULE$;
    }

    public <Request> Either<List<ValidationError>, Request> validate(Request request, List<RestfulValidation<Request>> validations) {
        ListBuffer errors = ListBuffer$.MODULE$.empty();
        ObjectRef r = ObjectRef.create(request);
        validations.foreach((Function1 & Serializable)v -> {
            Either<ValidationError, Object> either = v.validate(r$1.elem);
            if (either instanceof Left) {
                Left left = (Left)either;
                ValidationError err = (ValidationError)left.value();
                return errors.$plus$eq((Object)err);
            }
            if (either instanceof Right) {
                Object req;
                Right right = (Right)either;
                r$1.elem = req = right.value();
                return BoxedUnit.UNIT;
            }
            throw new MatchError(either);
        });
        if (errors.nonEmpty()) {
            return package$.MODULE$.Left().apply((Object)errors.toList());
        }
        return package$.MODULE$.Right().apply(r.elem);
    }

    public Json jsonFromExchange(HttpExchange exchange) {
        HttpRequest request = exchange.request();
        Json contentJson = (Json)request.content().map((Function1 & Serializable)content -> MODULE$.jsonFromContent((Content)content)).flatMap((Function1 & Serializable)x$3 -> x$3.toOption()).getOrElse((Function0 & Serializable)() -> new Obj(fabric.package$.MODULE$.obj((Seq)Nil$.MODULE$)));
        Json urlJson = this.jsonFromURL(request.url());
        Json pathJson = fabric.rw.package$.MODULE$.Convertible(PathFilter$.MODULE$.argumentsFromConnection(exchange)).json(Reader$.MODULE$.mapR(Reader$.MODULE$.stringR()));
        Json storeJson = (Json)exchange.store().getOrElse(this.key(), (Function0 & Serializable)() -> new Obj(fabric.package$.MODULE$.obj((Seq)Nil$.MODULE$)));
        return (Json)((LinearSeqOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Json[]{urlJson, pathJson, storeJson}))).foldLeft((Object)contentJson, (Function2 & Serializable)(merged, json) -> {
            if (json.nonEmpty()) {
                return Json$.MODULE$.merge((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Json[]{merged, json}));
            }
            return merged;
        });
    }

    public Either<ValidationError, Json> jsonFromContent(Content content) {
        String contentString = content.asString();
        char firstChar = contentString.charAt(0);
        Str json = ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'\"', '{', '['}))).contains((Object)BoxesRunTime.boxToCharacter((char)firstChar)) ? JsonParser$.MODULE$.apply(contentString) : new Str(contentString);
        return package$.MODULE$.Right().apply((Object)json);
    }

    public Json jsonFromURL(URL url) {
        List entries = url.parameters().map().toList().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Param param = (Param)tuple2._2();
                List values = param.values();
                Arr valuesJson = values.length() > 1 ? new Arr(fabric.package$.MODULE$.arr((Seq)values.map((Function1 & Serializable)s -> new Str(fabric.package$.MODULE$.str(s))))) : new Str(fabric.package$.MODULE$.str((String)values.head()));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)valuesJson);
            }
            throw new MatchError((Object)tuple2);
        });
        return new Obj(fabric.package$.MODULE$.obj((Seq)entries));
    }

    private Restful$() {
    }
}

