/*
 * Decompiled with CFR 0.152.
 */
package spice.http.server.validation;

import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import scala.Function0;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;
import spice.http.HttpExchange;
import spice.http.HttpStatus$;
import spice.http.server.validation.ValidationResult;
import spice.http.server.validation.Validator;
import spice.net.IP;

@ScalaSignature(bytes="\u0006\u0005-3AAB\u0004\u0001!!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003\u001d\u0011!q\u0003A!A!\u0002\u0013y\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004\"\u0002\u001d\u0001\t\u0003J$AE%Q\u0003\u0012$'/Z:t-\u0006d\u0017\u000eZ1u_JT!\u0001C\u0005\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002\u000b\u0017\u000511/\u001a:wKJT!\u0001D\u0007\u0002\t!$H\u000f\u001d\u0006\u0002\u001d\u0005)1\u000f]5dK\u000e\u00011c\u0001\u0001\u0012/A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\u0004\"\u0001G\r\u000e\u0003\u001dI!AG\u0004\u0003\u0013Y\u000bG.\u001b3bi>\u0014\u0018!B1mY><\bcA\u000f%O9\u0011aD\t\t\u0003?Mi\u0011\u0001\t\u0006\u0003C=\ta\u0001\u0010:p_Rt\u0014BA\u0012\u0014\u0003\u0019\u0001&/\u001a3fM&\u0011QE\n\u0002\u0004'\u0016$(BA\u0012\u0014!\tA3&D\u0001*\u0015\tQS\"A\u0002oKRL!\u0001L\u0015\u0003\u0005%\u0003\u0016A\u0002:fU\u0016\u001cG/\u0001\u0007eK\u001a\fW\u000f\u001c;BY2|w\u000f\u0005\u0002\u0013a%\u0011\u0011g\u0005\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q!A'\u000e\u001c8!\tA\u0002\u0001C\u0003\u001c\t\u0001\u0007A\u0004C\u0003.\t\u0001\u0007A\u0004C\u0003/\t\u0001\u0007q&\u0001\u0005wC2LG-\u0019;f)\tQT\tE\u0002<\u0001\nk\u0011\u0001\u0010\u0006\u0003{y\na!\u001a4gK\u000e$(\"A \u0002\t\r\fGo]\u0005\u0003\u0003r\u0012!!S(\u0011\u0005a\u0019\u0015B\u0001#\b\u0005A1\u0016\r\\5eCRLwN\u001c*fgVdG\u000fC\u0003G\u000b\u0001\u0007q)\u0001\u0005fq\u000eD\u0017M\\4f!\tA\u0015*D\u0001\f\u0013\tQ5B\u0001\u0007IiR\u0004X\t_2iC:<W\r")
public class IPAddressValidator
implements Validator {
    private final Set<IP> allow;
    private final Set<IP> reject;
    private final boolean defaultAllow;

    @Override
    public IO<ValidationResult> validate(HttpExchange exchange) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            IP ip = exchange.request().originalSource();
            if (($this.allow.contains((Object)ip) || $this.defaultAllow) && !$this.reject.contains((Object)ip)) {
                return new ValidationResult.Continue(exchange);
            }
            package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(80).append("Unauthorized attempt to access: ").append(exchange.request().url()).append(" from IP: ").append(ip).append(". Allowed: ").append($this.allow.mkString(", ")).append(", Reject: ").append($this.reject.mkString(", ")).append(", Default Allow? ").append($this.defaultAllow).toString())}), new Pkg("spice.http.server.validation"), new FileName("IPAddressValidator.scala"), new Name("validate"), new Line(13), MDC$.MODULE$.global());
            return new ValidationResult.Error(exchange, HttpStatus$.MODULE$.Forbidden().code(), new StringBuilder(25).append("Unauthorized IP address: ").append(ip).toString());
        });
    }

    public IPAddressValidator(Set<IP> allow, Set<IP> reject, boolean defaultAllow) {
        this.allow = allow;
        this.reject = reject;
        this.defaultAllow = defaultAllow;
    }
}

