/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.ResolverUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BICResolver {
    public static List<String> bicStrings(Field f) {
        Objects.requireNonNull(f);
        return ResolverUtils.findWantedType(f.typesPattern(), 'B', f.getComponents());
    }

    public static List<BIC> bics(Field f) {
        Objects.requireNonNull(f);
        List<String> values = ResolverUtils.findWantedType(f.typesPattern(), 'B', f.getComponents());
        return values.stream().map(v -> v != null ? SwiftFormatUtils.getBIC(v) : null).collect(Collectors.toList());
    }
}

