/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field33K
extends Field
implements Serializable,
MonetaryAmountContainer {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "33K";
    public static final String F_33K = "33K";
    @Deprecated
    public static final String PARSER_PATTERN = "cNS<CUR>N";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SNSCN";
    @Deprecated
    public static final String TYPES_PATTERN = "SNSCI";
    public static final Integer DAYMONTH = 1;
    @Deprecated
    public static final Integer DM_MARK = 1;
    public static final Integer NUMBER_OF_DAYSMONTHS = 2;
    public static final Integer CODE = 3;
    public static final Integer CURRENCY = 4;
    public static final Integer AMOUNT = 5;

    public Field33K() {
        super(5);
    }

    public Field33K(String value) {
        super(value);
    }

    public Field33K(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"33K")) {
            throw new IllegalArgumentException("cannot create field 33K from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field33K newInstance(Field33K source) {
        Field33K cp = new Field33K();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("33K", value);
    }

    public static Tag emptyTag() {
        return new Tag("33K", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        String toparse = SwiftParseUtils.getNumericSuffix(value);
        this.setComponent2(SwiftParseUtils.getNumericPrefix(toparse));
        String toparse2 = SwiftParseUtils.getAlphaSuffix(toparse);
        this.setComponent5(SwiftParseUtils.getNumericSuffix(toparse2));
        String toparse3 = SwiftParseUtils.getAlphaPrefix(toparse2);
        if (toparse3 != null && toparse3.length() > 0) {
            if (toparse3.length() >= 4) {
                String currency = StringUtils.substring((String)toparse3, (int)-3);
                String code = StringUtils.removeEnd((String)toparse3, (String)currency);
                this.setComponent3(code);
                this.setComponent4(currency);
            } else if (toparse3.length() == 3) {
                this.setComponent4(toparse3);
            } else {
                this.setComponent3(toparse3);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 33K");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent5AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<DM>3!n2!a<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("DayMonth");
        result.add("Number Of Days/Months");
        result.add("Code");
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dayMonth");
        result.put(2, "numberOfDaysMonths");
        result.put(3, "code");
        result.put(4, "currency");
        result.put(5, "amount");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getDayMonth() {
        return this.getComponent1();
    }

    @Deprecated
    public String getDMMark() {
        return this.getDayMonth();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        Long l = this.getComponent2AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getNumberOfDaysMonths() {
        return this.getComponent2();
    }

    @Deprecated
    public String getNumberofDaysMonths() {
        return this.getNumberOfDaysMonths();
    }

    public Long getNumberOfDaysMonthsAsLong() {
        return this.getComponent2AsLong();
    }

    @Deprecated
    public Number getNumberOfDaysMonthsAsNumber() {
        return this.getComponent2AsNumber();
    }

    @Deprecated
    public Long getNumberofDaysMonthsAsLong() {
        return this.getNumberOfDaysMonthsAsLong();
    }

    @Deprecated
    public Number getNumberofDaysMonthsAsNumber() {
        return this.getNumberOfDaysMonthsAsNumber();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getCode() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Currency getComponent4AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getCurrency() {
        return this.getComponent4();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent4AsCurrency();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public BigDecimal getComponent5AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(5));
    }

    @Deprecated
    public Number getComponent5AsNumber() {
        return this.getComponent5AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent5();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent5AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent5AsNumber();
    }

    public Field33K setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field33K setDayMonth(String component1) {
        return this.setComponent1(component1);
    }

    @Deprecated
    public Field33K setDMMark(String component1) {
        return this.setDayMonth(component1);
    }

    public Field33K setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33K setComponent2(Long component2) {
        this.setComponent(2, SwiftFormatUtils.getLong(component2));
        return this;
    }

    public Field33K setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field33K setNumberOfDaysMonths(String component2) {
        return this.setComponent2(component2);
    }

    public Field33K setNumberOfDaysMonths(Long component2) {
        return this.setComponent2(component2);
    }

    public Field33K setNumberOfDaysMonths(Number component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field33K setNumberofDaysMonths(String component2) {
        return this.setNumberOfDaysMonths(component2);
    }

    @Deprecated
    public Field33K setNumberofDaysMonths(Long component2) {
        return this.setNumberOfDaysMonths(component2);
    }

    @Deprecated
    public Field33K setNumberofDaysMonths(Number component2) {
        return this.setNumberOfDaysMonths(component2);
    }

    public Field33K setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field33K setCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field33K setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field33K setComponent4(Currency component4) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(component4));
        return this;
    }

    public Field33K setCurrency(String component4) {
        return this.setComponent4(component4);
    }

    public Field33K setCurrency(Currency component4) {
        return this.setComponent4(component4);
    }

    public Field33K setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field33K setComponent5(BigDecimal component5) {
        this.setComponent(5, SwiftFormatUtils.getBigDecimal(component5));
        return this;
    }

    public Field33K setComponent5(Number component5) {
        if (component5 instanceof BigDecimal) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal((BigDecimal)component5));
        } else if (component5 instanceof BigInteger) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component5)));
        } else if (component5 instanceof Long || component5 instanceof Integer) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.longValue())));
        } else if (component5 != null) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.doubleValue())));
        } else {
            this.setComponent(5, null);
        }
        return this;
    }

    public Field33K setAmount(String component5) {
        return this.setComponent5(component5);
    }

    public Field33K setAmount(BigDecimal component5) {
        return this.setComponent5(component5);
    }

    public Field33K setAmount(Number component5) {
        return this.setComponent5(component5);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "33K";
    }

    public static Field33K get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("33K");
        if (t == null) {
            return null;
        }
        return new Field33K(t);
    }

    public static Field33K get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field33K.get(msg.getBlock4());
    }

    public static List<Field33K> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field33K.getAll(msg.getBlock4());
    }

    public static List<Field33K> getAll(SwiftTagListBlock block) {
        ArrayList<Field33K> result = new ArrayList<Field33K>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("33K");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field33K(f));
            }
        }
        return result;
    }

    public static Field33K fromJson(String json) {
        Field33K field = new Field33K();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("dMMark") != null) {
            field.setComponent1(jsonObject.get("dMMark").getAsString());
        }
        if (jsonObject.get("dayMonth") != null) {
            field.setComponent1(jsonObject.get("dayMonth").getAsString());
        }
        if (jsonObject.get("numberofDaysMonths") != null) {
            field.setComponent2(jsonObject.get("numberofDaysMonths").getAsString());
        }
        if (jsonObject.get("numberOfDaysMonths") != null) {
            field.setComponent2(jsonObject.get("numberOfDaysMonths").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent3(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent4(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent5(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

