/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field70H
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "70H";
    public static final String F_70H = "70H";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SS";
    @Deprecated
    public static final String TYPES_PATTERN = "SS";
    public static final Integer QUALIFIER = 1;
    public static final Integer NARRATIVE = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field70H() {
        super(2);
    }

    public Field70H(String value) {
        super(value);
    }

    public Field70H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"70H")) {
            throw new IllegalArgumentException("cannot create field 70H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field70H newInstance(Field70H source) {
        Field70H cp = new Field70H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("70H", value);
    }

    public static Tag emptyTag() {
        return new Tag("70H", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 70H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SS";
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//2500z";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "narrative");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrative() {
        return this.getComponent2();
    }

    public Field70H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field70H setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field70H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field70H setNarrative(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "70H";
    }

    public static Field70H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("70H");
        if (t == null) {
            return null;
        }
        return new Field70H(t);
    }

    public static Field70H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field70H.get(msg.getBlock4());
    }

    public static List<Field70H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field70H.getAll(msg.getBlock4());
    }

    public static List<Field70H> getAll(SwiftTagListBlock block) {
        ArrayList<Field70H> result = new ArrayList<Field70H>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("70H");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field70H(f));
            }
        }
        return result;
    }

    public static Field70H fromJson(String json) {
        Field70H field = new Field70H();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        return field;
    }
}

