/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.OptionAPartyField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Field85A
extends OptionAPartyField
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "85A";
    public static final String F_85A = "85A";

    public Field85A() {
    }

    public Field85A(String value) {
        super(value);
    }

    public Field85A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"85A")) {
            throw new IllegalArgumentException("cannot create field 85A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field85A newInstance(Field85A source) {
        Field85A cp = new Field85A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("85A", value);
    }

    public static Tag emptyTag() {
        return new Tag("85A", "");
    }

    @Override
    public final String validatorPattern() {
        return "[[/<DC>][/34x]$]<BIC>";
    }

    public Field85A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field85A setDCMark(String component1) {
        return this.setComponent1(component1);
    }

    public Field85A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field85A setAccount(String component2) {
        return this.setComponent2(component2);
    }

    public Field85A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field85A setComponent3(BIC component3) {
        this.setComponent(3, SwiftFormatUtils.getBIC(component3));
        return this;
    }

    public Field85A setIdentifierCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field85A setIdentifierCode(BIC component3) {
        return this.setComponent3(component3);
    }

    @Deprecated
    public Field85A setBIC(String component3) {
        return this.setIdentifierCode(component3);
    }

    @Deprecated
    public Field85A setBIC(BIC component3) {
        return this.setIdentifierCode(component3);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getName() {
        return "85A";
    }

    public static Field85A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("85A");
        if (t == null) {
            return null;
        }
        return new Field85A(t);
    }

    public static Field85A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field85A.get(msg.getBlock4());
    }

    public static List<Field85A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field85A.getAll(msg.getBlock4());
    }

    public static List<Field85A> getAll(SwiftTagListBlock block) {
        ArrayList<Field85A> result = new ArrayList<Field85A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("85A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field85A(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field85A cp = Field85A.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field85A cp = Field85A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field85A cp = Field85A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field85A fromJson(String json) {
        Field85A field = new Field85A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("dCMark") != null) {
            field.setComponent1(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("account") != null) {
            field.setComponent2(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent3(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent3(jsonObject.get("identifierCode").getAsString());
        }
        return field;
    }
}

