/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field90F
extends Field
implements Serializable,
MonetaryAmountContainer,
GenericField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90F";
    public static final String F_90F = "90F";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S/SN/S/N";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSCNSN";
    @Deprecated
    public static final String TYPES_PATTERN = "SSCISI";
    public static final Integer QUALIFIER = 1;
    public static final Integer AMOUNT_TYPE_CODE = 2;
    public static final Integer CURRENCY_CODE = 3;
    @Deprecated
    public static final Integer CURRENCY = 3;
    public static final Integer AMOUNT = 4;
    public static final Integer QUANTITY_TYPE_CODE = 5;
    public static final Integer QUANTITY = 6;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field90F() {
        super(6);
    }

    public Field90F(String value) {
        super(value);
    }

    public Field90F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"90F")) {
            throw new IllegalArgumentException("cannot create field 90F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field90F newInstance(Field90F source) {
        Field90F cp = new Field90F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("90F", value);
    }

    public static Tag emptyTag() {
        return new Tag("90F", "");
    }

    @Override
    public void parse(String value) {
        this.init(6);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        String toparse3 = SwiftParseUtils.getTokenFirst(toparse2, "/");
        this.setComponent3(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse3));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse3));
        String toparse4 = SwiftParseUtils.getTokenSecondLast(toparse2, "/");
        this.setComponent5(SwiftParseUtils.getTokenFirst(toparse4, "/"));
        this.setComponent6(SwiftParseUtils.getTokenSecondLast(toparse4, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        result.append("/");
        this.append(result, 5);
        result.append("/");
        this.append(result, 6);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        BigDecimal n;
        NumberFormat f;
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 90F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent4AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent6AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//4!c/<CUR><AMOUNT>15/4!c/<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Amount Type Code");
        result.add("Currency Code");
        result.add("Amount");
        result.add("Quantity Type Code");
        result.add("Quantity");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "amountTypeCode");
        result.put(3, "currencyCode");
        result.put(4, "amount");
        result.put(5, "quantityTypeCode");
        result.put(6, "quantity");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getAmountTypeCode() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrencyCode() {
        return this.getComponent3();
    }

    @Deprecated
    public String getCurrency() {
        return this.getCurrencyCode();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent3AsCurrency();
    }

    @Deprecated
    public Currency getCurrencyAsCurrency() {
        return this.getCurrencyCodeAsCurrency();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public BigDecimal getComponent4AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(4));
    }

    @Deprecated
    public Number getComponent4AsNumber() {
        return this.getComponent4AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent4();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent4AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent4AsNumber();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getQuantityTypeCode() {
        return this.getComponent5();
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public BigDecimal getComponent6AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(6));
    }

    @Deprecated
    public Number getComponent6AsNumber() {
        return this.getComponent6AsBigDecimal();
    }

    public String getQuantity() {
        return this.getComponent6();
    }

    public BigDecimal getQuantityAsBigDecimal() {
        return this.getComponent6AsBigDecimal();
    }

    @Deprecated
    public Number getQuantityAsNumber() {
        return this.getComponent6AsNumber();
    }

    public Field90F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90F setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field90F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90F setAmountTypeCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field90F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90F setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field90F setCurrencyCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field90F setCurrencyCode(Currency component3) {
        return this.setComponent3(component3);
    }

    @Deprecated
    public Field90F setCurrency(String component3) {
        return this.setCurrencyCode(component3);
    }

    @Deprecated
    public Field90F setCurrency(Currency component3) {
        return this.setCurrencyCode(component3);
    }

    public Field90F setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90F setComponent4(BigDecimal component4) {
        this.setComponent(4, SwiftFormatUtils.getBigDecimal(component4));
        return this;
    }

    public Field90F setComponent4(Number component4) {
        if (component4 instanceof BigDecimal) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal((BigDecimal)component4));
        } else if (component4 instanceof BigInteger) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component4)));
        } else if (component4 instanceof Long || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.longValue())));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.doubleValue())));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field90F setAmount(String component4) {
        return this.setComponent4(component4);
    }

    public Field90F setAmount(BigDecimal component4) {
        return this.setComponent4(component4);
    }

    public Field90F setAmount(Number component4) {
        return this.setComponent4(component4);
    }

    public Field90F setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field90F setQuantityTypeCode(String component5) {
        return this.setComponent5(component5);
    }

    public Field90F setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field90F setComponent6(BigDecimal component6) {
        this.setComponent(6, SwiftFormatUtils.getBigDecimal(component6));
        return this;
    }

    public Field90F setComponent6(Number component6) {
        if (component6 instanceof BigDecimal) {
            this.setComponent(6, SwiftFormatUtils.getBigDecimal((BigDecimal)component6));
        } else if (component6 instanceof BigInteger) {
            this.setComponent(6, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component6)));
        } else if (component6 instanceof Long || component6 instanceof Integer) {
            this.setComponent(6, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component6.longValue())));
        } else if (component6 != null) {
            this.setComponent(6, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component6.doubleValue())));
        } else {
            this.setComponent(6, null);
        }
        return this;
    }

    public Field90F setQuantity(String component6) {
        return this.setComponent6(component6);
    }

    public Field90F setQuantity(BigDecimal component6) {
        return this.setComponent6(component6);
    }

    public Field90F setQuantity(Number component6) {
        return this.setComponent6(component6);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "90F";
    }

    public static Field90F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("90F");
        if (t == null) {
            return null;
        }
        return new Field90F(t);
    }

    public static Field90F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field90F.get(msg.getBlock4());
    }

    public static List<Field90F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field90F.getAll(msg.getBlock4());
    }

    public static List<Field90F> getAll(SwiftTagListBlock block) {
        ArrayList<Field90F> result = new ArrayList<Field90F>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("90F");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field90F(f));
            }
        }
        return result;
    }

    public static Field90F fromJson(String json) {
        Field90F field = new Field90F();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("amountTypeCode") != null) {
            field.setComponent2(jsonObject.get("amountTypeCode").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent3(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent3(jsonObject.get("currencyCode").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent4(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("quantityTypeCode") != null) {
            field.setComponent5(jsonObject.get("quantityTypeCode").getAsString());
        }
        if (jsonObject.get("quantity") != null) {
            field.setComponent6(jsonObject.get("quantity").getAsString());
        }
        return field;
    }
}

