/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.prowidesoftware.swift.model.field.Narrative;
import com.prowidesoftware.swift.model.field.StructuredNarrativeField;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NarrativeContainerJsonUtils {
    static Pattern NARRATIVE_PATTERN = Pattern.compile("[\"|']narrative([0-9]*)[\"|']");

    NarrativeContainerJsonUtils() {
    }

    static void fromJson(JsonObject jsonObject, String json, StructuredNarrativeField field) {
        if (jsonObject.get("narrative") != null) {
            int numberOfNarrativesInJson = NarrativeContainerJsonUtils.countNarrativesInJson(json);
            if (numberOfNarrativesInJson > 1) {
                JsonObject jsonWithNarrativeGroup = NarrativeContainerJsonUtils.groupNarratives(json, numberOfNarrativesInJson);
                field.setComponent(1, jsonWithNarrativeGroup.get("narrative").getAsString());
            } else {
                field.setComponent(1, jsonObject.get("narrative").getAsString());
            }
        } else if (jsonObject.get("structured") != null) {
            Narrative narrative = (Narrative)new Gson().fromJson((JsonElement)jsonObject, Narrative.class);
            field.setNarrative(narrative);
        }
    }

    private static JsonObject groupNarratives(String json, int numberOfNarrativesInJson) {
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(json, JsonElement.class);
        JsonObject jsonObj = element.getAsJsonObject();
        String finalNarrativeValue = jsonObj.get("narrative").getAsString();
        for (int i = 2; i <= numberOfNarrativesInJson; ++i) {
            String currentNarrativeValue = jsonObj.get("narrative" + i).getAsString();
            finalNarrativeValue = finalNarrativeValue + currentNarrativeValue;
            jsonObj.remove("narrative" + i);
        }
        jsonObj.addProperty("narrative", finalNarrativeValue);
        return jsonObj;
    }

    static int countNarrativesInJson(String json) {
        Matcher narrativeMatcher = NARRATIVE_PATTERN.matcher(json);
        int count = 0;
        while (narrativeMatcher.find()) {
            ++count;
        }
        return count;
    }
}

