/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.Gson;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Narrative;
import com.prowidesoftware.swift.model.field.NarrativeContainer;
import com.prowidesoftware.swift.model.field.NarrativeResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class StructuredNarrativeField
extends Field
implements NarrativeContainer {
    public static final String PARSER_PATTERN = "S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "S";
    public static final String TYPES_PATTERN = "S";

    public StructuredNarrativeField() {
        super(1);
    }

    public StructuredNarrativeField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(1);
        this.setComponent(1, value);
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component != 1) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent1();
    }

    @Override
    public String getValue() {
        return this.getComponent1();
    }

    @Override
    public abstract String getName();

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "S";
    }

    @Override
    public final String typesPattern() {
        return "S";
    }

    @Override
    public final String parserPattern() {
        return "S";
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 1;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "narrative");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Override
    public Narrative narrative() {
        return NarrativeResolver.parse(this);
    }

    @Override
    public NarrativeContainer appendLine(String line) {
        StringBuilder value = new StringBuilder();
        if (this.getComponent1() != null) {
            value.append(this.getComponent1());
        }
        if (value.length() > 0) {
            value.append("\r\n");
        }
        value.append(line);
        this.setComponent(1, value.toString());
        return this;
    }

    @Override
    public NarrativeContainer setNarrative(Narrative narrative) {
        this.setComponent(1, narrative.getValue());
        return this;
    }

    @Override
    public String toJson() {
        String json = super.toJson();
        return json.substring(0, json.length() - 1) + "," + new Gson().toJson((Object)this.narrative()).substring(1);
    }
}

