/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class AbstractReader
implements Iterator<String>,
Iterable<String> {
    private static final Logger log = Logger.getLogger(AbstractReader.class.getName());
    protected Reader reader;
    private boolean usedAsIterable = false;

    @Override
    public abstract String next();

    @Override
    public abstract boolean hasNext();

    public AbstractReader(Reader r) {
        this.reader = r;
    }

    public AbstractReader(String string) {
        Objects.requireNonNull(string, "string must not be null");
        this.reader = new StringReader(string);
    }

    public AbstractReader(InputStream stream) {
        this(stream, null);
    }

    public AbstractReader(InputStream _stream, Charset _charset) {
        Objects.requireNonNull(_stream, "stream must not be null");
        this.reader = new InputStreamReader(_stream, _charset != null ? _charset : StandardCharsets.UTF_8);
    }

    public AbstractReader(File file) throws FileNotFoundException {
        this(file, null);
    }

    public AbstractReader(File _file, Charset _charset) throws FileNotFoundException {
        Objects.requireNonNull(_file, "file must not be null");
        Validate.isTrue((boolean)_file.exists(), (String)("Non existent file: " + _file.getAbsolutePath()), (Object[])new Object[0]);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(_file), _charset != null ? _charset : StandardCharsets.UTF_8));
    }

    @Override
    public Iterator<String> iterator() throws IllegalArgumentException {
        if (this.usedAsIterable) {
            throw new IllegalStateException("This reader has already been used as Iterator and the implementation does not support multiple iterations, create another reader instance instead");
        }
        this.usedAsIterable = true;
        return this;
    }

    public AbstractMT nextMT() throws IOException {
        SwiftMessage candidate = this.nextSwiftMessage();
        if (candidate != null) {
            if (candidate.isServiceMessage21()) {
                String fin = candidate.getUnparsedTexts().getAsFINString();
                return AbstractMT.parse(fin);
            }
            if (candidate.isServiceMessage()) {
                log.warning("nextMT in " + this.getClass().getName() + " is not intended for service messages, use nextSwiftMessage() instead");
                return null;
            }
            return candidate.toMT();
        }
        return null;
    }

    public SwiftMessage nextSwiftMessage() throws IOException {
        String msg = this.next();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return SwiftMessage.parse(msg);
        }
        log.warning("Ignoring blank message");
        return null;
    }
}

