/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.writer;

import com.prowidesoftware.swift.io.writer.FINWriterVisitor;
import com.prowidesoftware.swift.io.writer.XMLWriterVisitor;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.utils.IMessageVisitor;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;

public class SwiftWriter {
    private static final transient Logger log = Logger.getLogger(SwiftWriter.class.getName());
    private static final String WRITER_MESSAGE = "writer cannot be null";

    public static void writeMessage(SwiftMessage msg, Writer writer) {
        SwiftWriter.writeMessage(msg, writer, false);
    }

    public static void writeMessage(SwiftMessage msg, Writer writer, boolean ignoreEmptyBlocks) {
        SwiftWriter.writeMessage(msg, writer, ignoreEmptyBlocks, false);
    }

    public static void writeMessage(SwiftMessage msg, Writer writer, boolean ignoreEmptyBlocks, boolean trimTagValues) {
        Validate.notNull((Object)msg, (String)"msg cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)writer, (String)WRITER_MESSAGE, (Object[])new Object[0]);
        FINWriterVisitor v = new FINWriterVisitor(writer);
        v.setTrimTagValues(trimTagValues);
        if (ignoreEmptyBlocks) {
            SwiftMessage copy = new SwiftMessage();
            copy.setBlock1(msg.getBlock1());
            copy.setBlock2(msg.getBlock2());
            copy.setBlock3(msg.getBlock3());
            copy.setBlock4(msg.getBlock4());
            copy.setBlock5(msg.getBlock5());
            copy.setUnparsedTexts(msg.getUnparsedTexts());
            if (msg.getUserBlocks() != null) {
                copy.setUserBlocks(msg.getUserBlocks());
            }
            copy.removeEmptyBlocks();
            copy.visit(v);
        } else {
            msg.visit(v);
        }
    }

    public static String getInternalXml(SwiftMessage msg) {
        Validate.notNull((Object)msg, (String)"msg cannot be null", (Object[])new Object[0]);
        StringWriter w = new StringWriter();
        XMLWriterVisitor visitor = new XMLWriterVisitor(w);
        msg.visit(visitor);
        return w.toString();
    }

    public static void writeBlock1(SwiftBlock1 b1, Writer writer) {
        Validate.notNull((Object)b1, (String)"b1 cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)writer, (String)WRITER_MESSAGE, (Object[])new Object[0]);
        FINWriterVisitor visitor = new FINWriterVisitor(writer);
        visitor.startBlock1(b1);
        visitor.value(b1, b1.getValue());
        visitor.endBlock1(b1);
    }

    public static String writeBlock1(SwiftBlock1 b1) {
        StringWriter w = new StringWriter();
        SwiftWriter.writeBlock1(b1, w);
        return w.toString();
    }

    public static void writeBlock2(SwiftBlock2 b2, Writer writer) {
        Validate.notNull((Object)b2, (String)"b2 cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)writer, (String)WRITER_MESSAGE, (Object[])new Object[0]);
        FINWriterVisitor visitor = new FINWriterVisitor(writer);
        visitor.startBlock2(b2);
        visitor.value(b2, b2.getValue());
        visitor.endBlock2(b2);
    }

    public static String writeBlock2(SwiftBlock2 b2) {
        StringWriter w = new StringWriter();
        SwiftWriter.writeBlock2(b2, w);
        return w.toString();
    }

    public static void writeBlock3(SwiftBlock3 b3, Writer writer) {
        Validate.notNull((Object)b3, (String)"b3 cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)writer, (String)WRITER_MESSAGE, (Object[])new Object[0]);
        FINWriterVisitor visitor = new FINWriterVisitor(writer);
        visitor.startBlock3(b3);
        SwiftMessage.visit(b3, (IMessageVisitor)visitor);
        visitor.endBlock3(b3);
    }

    public static String writeBlock3(SwiftBlock3 b3) {
        StringWriter w = new StringWriter();
        SwiftWriter.writeBlock3(b3, w);
        return w.toString();
    }

    public static void writeBlock4(SwiftBlock4 b4, Writer writer) {
        Validate.notNull((Object)b4, (String)"b4 cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)writer, (String)WRITER_MESSAGE, (Object[])new Object[0]);
        FINWriterVisitor visitor = new FINWriterVisitor(writer);
        visitor.startBlock4(b4);
        SwiftMessage.visit(b4, (IMessageVisitor)visitor);
        visitor.endBlock4(b4);
    }

    public static String writeBlock4(SwiftBlock4 b4) {
        StringWriter w = new StringWriter();
        SwiftWriter.writeBlock4(b4, w);
        return w.toString();
    }

    public static void writeBlock5(SwiftBlock5 b5, Writer writer) {
        Validate.notNull((Object)b5, (String)"b5 cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)writer, (String)WRITER_MESSAGE, (Object[])new Object[0]);
        FINWriterVisitor visitor = new FINWriterVisitor(writer);
        visitor.startBlock5(b5);
        SwiftMessage.visit(b5, (IMessageVisitor)visitor);
        visitor.endBlock5(b5);
    }

    public static String writeBlock5(SwiftBlock5 b5) {
        StringWriter w = new StringWriter();
        SwiftWriter.writeBlock5(b5, w);
        return w.toString();
    }

    public static String ensureEols(String content) {
        StringBuilder buf = new StringBuilder();
        try {
            String l;
            BufferedReader r = new BufferedReader(new StringReader(content));
            while ((l = r.readLine()) != null) {
                buf.append(l).append("\r\n");
            }
        }
        catch (Exception e) {
            log.severe("Error in EOL correction: " + e);
        }
        if (buf.length() > 0) {
            return buf.substring(0, buf.length() - "\r\n".length());
        }
        return "";
    }
}

