/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class OptionRPartyField
extends Field {
    public static final String PARSER_PATTERN = ":S/S/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSS";
    public static final String TYPES_PATTERN = "SSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer PROPRIETARY_CODE = 3;

    public OptionRPartyField() {
        super(3);
    }

    public OptionRPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent(1, SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent(2, SwiftParseUtils.getTokenSecond(value, "/"));
        this.setComponent(3, SwiftParseUtils.getTokenThirdLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        DeprecationUtils.phase3(this.getClass(), "componentsPattern()", "Use typesPattern() instead.");
        return this.typesPattern();
    }

    @Override
    public final String typesPattern() {
        return "SSS";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Proprietary Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "dataSourceScheme");
        result.put(3, "proprietaryCode");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("datasourcescheme", 2);
        this.labelMap.put("proprietarycode", 3);
        return this.labelMap;
    }

    @Override
    public abstract String getName();

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent(2);
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getProprietaryCode() {
        return this.getComponent(3);
    }
}

