/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation;

import com.qaprosoft.carina.core.foundation.dataprovider.core.DataProviderFactory;
import com.qaprosoft.carina.core.foundation.listeners.CarinaListener;
import com.qaprosoft.carina.core.foundation.report.testrail.ITestCases;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.common.CommonUtils;
import com.qaprosoft.carina.core.foundation.utils.naming.TestNamingUtil;
import com.qaprosoft.carina.core.foundation.webdriver.IDriverPool;
import java.lang.annotation.Annotation;
import org.apache.log4j.Logger;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Listeners;

@Listeners(value={CarinaListener.class})
public abstract class AbstractTest
implements IDriverPool,
ITestCases {
    protected static final Logger LOGGER = Logger.getLogger(AbstractTest.class);
    protected static final long EXPLICIT_TIMEOUT = Configuration.getLong((Configuration.Parameter)Configuration.Parameter.EXPLICIT_TIMEOUT);

    @BeforeSuite(alwaysRun=true)
    private void onBeforeSuite() {
    }

    @BeforeClass(alwaysRun=true)
    private void onBeforeClass() {
    }

    @BeforeMethod(alwaysRun=true)
    private void onBeforeMethod() {
    }

    @DataProvider(name="DataProvider", parallel=true)
    public Object[][] createData(ITestNGMethod testMethod, ITestContext context) {
        Annotation[] annotations = testMethod.getConstructorOrMethod().getMethod().getDeclaredAnnotations();
        Object[][] objects = DataProviderFactory.getNeedRerunDataProvider((Annotation[])annotations, (ITestContext)context, (ITestNGMethod)testMethod);
        return objects;
    }

    @DataProvider(name="SingleDataProvider")
    public Object[][] createDataSingleThread(ITestNGMethod testMethod, ITestContext context) {
        Annotation[] annotations = testMethod.getConstructorOrMethod().getMethod().getDeclaredAnnotations();
        Object[][] objects = DataProviderFactory.getNeedRerunDataProvider((Annotation[])annotations, (ITestContext)context, (ITestNGMethod)testMethod);
        return objects;
    }

    protected void setBug(String id) {
        String test = TestNamingUtil.getTestNameByThread();
        TestNamingUtil.associateBug((String)test, (String)id);
    }

    public void pause(long timeout) {
        CommonUtils.pause((Number)timeout);
    }

    public void pause(Double timeout) {
        CommonUtils.pause((Number)timeout);
    }

    protected void skipExecution(String message) {
        throw new SkipException("SKIP_EXECUTION: " + message);
    }
}

