/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.qaprosoft.carina.core.foundation.dataprovider.parser.DSBean;
import com.qaprosoft.carina.core.foundation.jira.Jira;
import com.qaprosoft.carina.core.foundation.report.Artifacts;
import com.qaprosoft.carina.core.foundation.report.ReportContext;
import com.qaprosoft.carina.core.foundation.report.TestResultItem;
import com.qaprosoft.carina.core.foundation.report.TestResultType;
import com.qaprosoft.carina.core.foundation.report.email.EmailReportItemCollector;
import com.qaprosoft.carina.core.foundation.retry.RetryAnalyzer;
import com.qaprosoft.carina.core.foundation.retry.RetryCounter;
import com.qaprosoft.carina.core.foundation.utils.DateUtils;
import com.qaprosoft.carina.core.foundation.utils.Messager;
import com.qaprosoft.carina.core.foundation.utils.ParameterGenerator;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.StringGenerator;
import com.qaprosoft.carina.core.foundation.utils.naming.TestNamingUtil;
import com.qaprosoft.carina.core.foundation.webdriver.CarinaDriver;
import com.qaprosoft.carina.core.foundation.webdriver.IDriverPool;
import com.qaprosoft.carina.core.foundation.webdriver.Screenshot;
import com.qaprosoft.carina.core.foundation.webdriver.device.Device;
import com.qaprosoft.carina.core.foundation.webdriver.device.DevicePool;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.testng.IRetryAnalyzer;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class AbstractTestListener
extends TestListenerAdapter
implements IDriverPool {
    private static final Logger LOGGER = Logger.getLogger(AbstractTestListener.class);
    protected static ThreadLocal<TestResultItem> configFailures = new ThreadLocal();

    private void startItem(ITestResult result, Messager messager) {
        RetryCounter.initCounter();
        String test = TestNamingUtil.getCanonicalTestName((ITestResult)result);
        test = TestNamingUtil.associateTestInfo2Thread((String)test, (Long)Thread.currentThread().getId());
        String deviceName = this.getDeviceName();
        messager.info(new String[]{deviceName, test, DateUtils.now()});
    }

    private void passItem(ITestResult result, Messager messager) {
        String test = TestNamingUtil.getCanonicalTestName((ITestResult)result);
        String deviceName = this.getDeviceName();
        messager.info(new String[]{deviceName, test, DateUtils.now()});
        EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.PASS, null, result.getMethod().getDescription()));
        result.getTestContext().removeAttribute("testFailureMessage");
    }

    private String failItem(ITestResult result, Messager messager) {
        String test = TestNamingUtil.getCanonicalTestName((ITestResult)result);
        String errorMessage = this.getFailureReason(result);
        this.takeScreenshot(result, "TEST FAILED - " + errorMessage);
        String deviceName = this.getDeviceName();
        if (!errorMessage.contains("All tests were skipped! Analyze logs to determine possible configuration issues.")) {
            messager.info(new String[]{deviceName, test, DateUtils.now(), errorMessage});
            if (!R.EMAIL.getBoolean("fail_full_stacktrace_in_report") && result.getThrowable() != null && result.getThrowable().getMessage() != null && !StringUtils.isEmpty((CharSequence)result.getThrowable().getMessage())) {
                EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.FAIL, result.getThrowable().getMessage(), result.getMethod().getDescription()));
            } else {
                EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.FAIL, errorMessage, result.getMethod().getDescription()));
            }
        }
        result.getTestContext().removeAttribute("testFailureMessage");
        return errorMessage;
    }

    private String failRetryItem(ITestResult result, Messager messager, int count, int maxCount) {
        String test = TestNamingUtil.getCanonicalTestName((ITestResult)result);
        String errorMessage = this.getFailureReason(result);
        this.takeScreenshot(result, "TEST FAILED - " + errorMessage);
        String deviceName = this.getDeviceName();
        messager.info(new String[]{deviceName, test, String.valueOf(count), String.valueOf(maxCount), errorMessage});
        result.getTestContext().removeAttribute("testFailureMessage");
        return errorMessage;
    }

    private String skipItem(ITestResult result, Messager messager) {
        String test = TestNamingUtil.getCanonicalTestName((ITestResult)result);
        String errorMessage = this.getFailureReason(result);
        if (errorMessage.isEmpty()) {
            int i;
            String[] methods = result.getMethod().getMethodsDependedUpon();
            boolean dependentMethod = false;
            String dependentMethodName = "";
            block0: for (ITestResult failedTest : result.getTestContext().getFailedTests().getAllResults()) {
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].contains(failedTest.getName())) continue;
                    dependentMethodName = failedTest.getName();
                    dependentMethod = true;
                    continue block0;
                }
            }
            block2: for (ITestResult skippedTest : result.getTestContext().getSkippedTests().getAllResults()) {
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].contains(skippedTest.getName())) continue;
                    dependentMethodName = skippedTest.getName();
                    dependentMethod = true;
                    continue block2;
                }
            }
            if (dependentMethod) {
                errorMessage = "Test skipped due to the dependency from: " + dependentMethodName;
            } else {
                TestResultItem resultItem = this.getConfigFailure();
                if (resultItem != null) {
                    errorMessage = resultItem.getFailReason();
                }
            }
        }
        String deviceName = this.getDeviceName();
        messager.info(new String[]{deviceName, test, DateUtils.now(), errorMessage});
        EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.SKIP, errorMessage, result.getMethod().getDescription()));
        result.getTestContext().removeAttribute("testFailureMessage");
        return errorMessage;
    }

    private void skipAlreadyPassedItem(ITestResult result, Messager messager) {
        String test = TestNamingUtil.getCanonicalTestName((ITestResult)result);
        String deviceName = this.getDeviceName();
        messager.info(new String[]{deviceName, test, DateUtils.now()});
    }

    private String getDeviceName() {
        String deviceName = DevicePool.getDevice().getName();
        String deviceUdid = DevicePool.getDevice().getUdid();
        if (!deviceName.isEmpty() && !deviceUdid.isEmpty()) {
            deviceName = deviceName + " - " + deviceUdid;
        }
        return deviceName;
    }

    private void afterConfiguration(ITestResult result) {
        TestNamingUtil.releaseTestInfoByThread();
    }

    private void afterTest(ITestResult result) {
        String test = TestNamingUtil.getCanonicalTestName((ITestResult)result);
        Device device = DevicePool.getDevice();
        if (!device.isNull()) {
            LOGGER.debug((Object)"Device isn't null additional artifacts will be extracted.");
            File sysLogFile = device.saveSysLog();
            if (sysLogFile != null) {
                LOGGER.debug((Object)"Logcat log will be extracted and added as artifact");
                Artifacts.add((String)"Logcat", (String)ReportContext.getSysLogLink((String)test));
            }
        }
        ReportContext.renameTestDir((String)test);
        TestNamingUtil.releaseTestInfoByThread();
    }

    public void beforeConfiguration(ITestResult result) {
        this.removeIncorrectlyFailedTests(result.getTestContext());
        TestNamingUtil.releaseTestInfoByThread();
        super.beforeConfiguration(result);
    }

    public void onConfigurationSuccess(ITestResult result) {
        this.afterConfiguration(result);
        super.onConfigurationSuccess(result);
    }

    public void onConfigurationSkip(ITestResult result) {
        this.afterConfiguration(result);
        super.onConfigurationSkip(result);
    }

    public void onConfigurationFailure(ITestResult result) {
        this.afterConfiguration(result);
        String errorMessage = this.getFailureReason(result);
        this.takeScreenshot(result, "CONFIGURATION FAILED - " + errorMessage);
        TestResultItem resultItem = this.createTestResult(result, TestResultType.FAIL, errorMessage, result.getMethod().getDescription());
        this.setConfigFailure(resultItem);
        super.onConfigurationFailure(result);
    }

    public void onStart(ITestContext context) {
        String uuid = StringGenerator.generateNumeric((int)8);
        ParameterGenerator.setUUID((String)uuid);
        ReportContext.getBaseDir();
        super.onStart(context);
    }

    public void onTestStart(ITestResult result) {
        RetryAnalyzer retryAnalyzer = new RetryAnalyzer();
        IRetryAnalyzer curRetryAnalyzer = result.getMethod().getRetryAnalyzer();
        if (curRetryAnalyzer == null) {
            result.getMethod().setRetryAnalyzer((IRetryAnalyzer)retryAnalyzer);
        } else if (!"com.qaprosoft.carina.core.foundation.retry.RetryAnalyzer".equals(curRetryAnalyzer.getClass().getName())) {
            LOGGER.warn((Object)("Custom RetryAnalyzer is used: " + curRetryAnalyzer.getClass().getName()));
        }
        this.generateParameters(result);
        if (!result.getTestContext().getCurrentXmlTest().getTestParameters().containsKey("{excel_ds_custom_provider}") && result.getParameters().length > 0 && result.getTestContext().getCurrentXmlTest().getTestParameters().containsKey("{excel_ds_args}")) {
            DSBean dsBean = new DSBean(result.getTestContext());
            int index = 0;
            for (String arg : dsBean.getArgs()) {
                dsBean.getTestParams().put(arg, (String)result.getParameters()[index++]);
            }
            result.getTestContext().getCurrentXmlTest().setParameters(dsBean.getTestParams());
        }
        TestNamingUtil.releaseTestInfoByThread();
        this.startItem(result, Messager.TEST_STARTED);
    }

    private void generateParameters(ITestResult result) {
        if (result != null && result.getParameters() != null) {
            for (int i = 0; i < result.getParameters().length; ++i) {
                if (result.getParameters()[i] instanceof String) {
                    result.getParameters()[i] = ParameterGenerator.process((String)result.getParameters()[i].toString());
                }
                if (!(result.getParameters()[i] instanceof Map)) continue;
                Map dynamicAgrs = (Map)result.getParameters()[i];
                for (Map.Entry entry : dynamicAgrs.entrySet()) {
                    Object param = ParameterGenerator.process((String)((String)entry.getValue()));
                    if (param != null) {
                        dynamicAgrs.put(entry.getKey(), param.toString());
                        continue;
                    }
                    dynamicAgrs.put(entry.getKey(), null);
                }
            }
        }
    }

    public void onTestSuccess(ITestResult result) {
        this.passItem(result, Messager.TEST_PASSED);
        this.afterTest(result);
        super.onTestSuccess(result);
    }

    public void onTestFailure(ITestResult result) {
        this.failItem(result, Messager.TEST_FAILED);
        this.afterTest(result);
        RetryCounter.resetCounter();
        super.onTestFailure(result);
    }

    public void onTestSkipped(ITestResult result) {
        if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("ALREADY_PASSED")) {
            this.skipAlreadyPassedItem(result, Messager.TEST_SKIPPED_AS_ALREADY_PASSED);
            return;
        }
        if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("SKIP_EXECUTION")) {
            return;
        }
        int count = RetryCounter.getRunCount();
        int maxCount = RetryAnalyzer.getMaxRetryCountForTest();
        LOGGER.debug((Object)("count: " + count + "; maxCount:" + maxCount));
        IRetryAnalyzer retry = result.getMethod().getRetryAnalyzer();
        if (count > 0 && retry == null) {
            LOGGER.error((Object)("retry_count will be ignored as RetryAnalyzer is not declared for " + result.getMethod().getMethodName()));
        } else if (count > 0 && count <= maxCount && !Jira.isRetryDisabled((ITestResult)result)) {
            this.failRetryItem(result, Messager.RETRY_RETRY_FAILED, count - 1, maxCount);
            result.setStatus(2);
            this.afterTest(result);
            super.onTestFailure(result);
        } else {
            this.skipItem(result, Messager.TEST_SKIPPED);
            this.afterTest(result);
            super.onTestSkipped(result);
        }
    }

    public void onFinish(ITestContext context) {
        this.removeIncorrectlyFailedTests(context);
        super.onFinish(context);
    }

    private void removeIncorrectlyFailedTests(ITestContext context) {
        ArrayList<ITestResult> testsToBeRemoved = new ArrayList<ITestResult>();
        HashSet<Long> passedTestIds = new HashSet<Long>();
        for (Object passedTest : context.getPassedTests().getAllResults()) {
            long passedTestId = this.getMethodId((ITestResult)passedTest);
            passedTestIds.add(passedTestId);
        }
        HashSet<Long> failedTestIds = new HashSet<Long>();
        for (ITestResult failedTest : context.getFailedTests().getAllResults()) {
            long failedTestId = this.getMethodId(failedTest);
            if (failedTestIds.contains(failedTestId) || passedTestIds.contains(failedTestId)) {
                testsToBeRemoved.add(failedTest);
                continue;
            }
            failedTestIds.add(failedTestId);
        }
        Iterator iterator = context.getFailedTests().getAllResults().iterator();
        while (iterator.hasNext()) {
            ITestResult testResult = (ITestResult)iterator.next();
            if (!testsToBeRemoved.contains(testResult)) continue;
            iterator.remove();
        }
    }

    private void printContextTestsSummary(ITestContext context) {
        long testId;
        LOGGER.debug((Object)("getAllTestMethods length: " + context.getAllTestMethods().length));
        LOGGER.debug((Object)"---------------- PRINT SUMMARIZED SUCCESS -----------------------");
        LOGGER.debug((Object)("passed tests size: " + context.getPassedTests().getAllResults().size()));
        for (ITestResult testResult : context.getPassedTests().getAllResults()) {
            testId = this.getMethodId(testResult);
            LOGGER.debug((Object)("Pass test in context: " + testId + "; " + testResult.getName()));
        }
        LOGGER.debug((Object)"---------------- PRINT SUMMARIZED FAILURE -----------------------");
        LOGGER.debug((Object)("failed tests size: " + context.getFailedTests().getAllResults().size()));
        for (ITestResult testResult : context.getFailedTests().getAllResults()) {
            testId = this.getMethodId(testResult);
            LOGGER.debug((Object)("Failed test in context: " + testId + "; " + testResult.getName()));
        }
        LOGGER.debug((Object)"---------------- PRINT SUMMARIZED SKIP -----------------------");
        LOGGER.debug((Object)("skipped tests size: " + context.getSkippedTests().getAllResults().size()));
        for (ITestResult testResult : context.getSkippedTests().getAllResults()) {
            testId = this.getMethodId(testResult);
            LOGGER.debug((Object)("Skipped test in context: " + testId + "; " + testResult.getName()));
        }
        LOGGER.debug((Object)"---------------- PRINT SUMMARIZED CONFIGURATION SUCCESS -----------------------");
        LOGGER.debug((Object)("passed configurations size: " + context.getPassedConfigurations().getAllResults().size()));
        for (ITestResult testResult : context.getPassedConfigurations().getAllResults()) {
            testId = this.getMethodId(testResult);
            LOGGER.debug((Object)("passed configurations in context: " + testId + "; " + testResult.getName()));
        }
        LOGGER.debug((Object)"---------------- PRINT SUMMARIZED CONFIGURATION FAILURE -----------------------");
        LOGGER.debug((Object)("failed configurations size: " + context.getFailedConfigurations().getAllResults().size()));
        for (ITestResult testResult : context.getFailedConfigurations().getAllResults()) {
            testId = this.getMethodId(testResult);
            LOGGER.debug((Object)("failed configurations in context: " + testId + "; " + testResult.getName()));
        }
        LOGGER.debug((Object)"---------------- PRINT SUMMARIZED CONFIGURATION SKIP -----------------------");
        LOGGER.debug((Object)("skipped configurations size: " + context.getSkippedConfigurations().getAllResults().size()));
        for (ITestResult testResult : context.getSkippedConfigurations().getAllResults()) {
            testId = this.getMethodId(testResult);
            LOGGER.debug((Object)("failed configurations in context: " + testId + "; " + testResult.getName()));
        }
    }

    private long getMethodId(ITestResult result) {
        long id = result.getTestClass().getName().hashCode();
        id = 31L * id + (long)result.getMethod().getMethodName().hashCode();
        id = 31L * id + (long)(result.getParameters() != null ? Arrays.hashCode(result.getParameters()) : 0);
        return id;
    }

    protected TestResultItem createTestResult(ITestResult result, TestResultType resultType, String failReason, String description) {
        String bugInfo;
        String group = TestNamingUtil.getPackageName((ITestResult)result);
        String test = TestNamingUtil.getCanonicalTestName((ITestResult)result);
        String linkToLog = ReportContext.getTestLogLink((String)test);
        String linkToScreenshots = null;
        if (TestResultType.FAIL.equals((Object)resultType) && (bugInfo = Jira.processBug((ITestResult)result)) != null) {
            failReason = failReason != null ? bugInfo.concat("\n").concat(failReason) : bugInfo;
        }
        if (!FileUtils.listFiles((File)ReportContext.getTestDir(), (String[])new String[]{"png"}, (boolean)false).isEmpty()) {
            linkToScreenshots = ReportContext.getTestScreenshotsLink((String)test);
        }
        TestResultItem testResultItem = new TestResultItem(group, test, resultType, linkToScreenshots, linkToLog, failReason);
        testResultItem.setDescription(description);
        testResultItem.setJiraTickets(Jira.getTickets((ITestResult)result));
        return testResultItem;
    }

    protected String getFailureReason(ITestResult result) {
        String errorMessage = "";
        String message = "";
        if (result.getThrowable() != null) {
            Throwable thr = result.getThrowable();
            errorMessage = this.getFullStackTrace(thr);
            message = thr.getMessage();
            result.getTestContext().setAttribute("testFailureMessage", (Object)message);
        }
        if (errorMessage.isEmpty()) {
            Set results = result.getTestContext().getSkippedConfigurations().getAllResults();
            for (ITestResult resultItem : results) {
                String methodName = resultItem.getMethod().getMethodName();
                if (!methodName.equals("executeBeforeTestMethod")) continue;
                errorMessage = this.getFullStackTrace(resultItem.getThrowable());
            }
        }
        return errorMessage;
    }

    private String getFullStackTrace(Throwable thr) {
        String stackTrace = "";
        if (thr != null) {
            StackTraceElement[] elems;
            stackTrace = thr.getMessage() + "\n";
            for (StackTraceElement elem : elems = thr.getStackTrace()) {
                stackTrace = stackTrace + "\n" + elem.toString();
            }
        }
        return stackTrace;
    }

    private TestResultItem getConfigFailure() {
        return configFailures.get();
    }

    protected void setConfigFailure(TestResultItem resultItem) {
        configFailures.set(resultItem);
    }

    private String takeScreenshot(ITestResult result, String msg) {
        String screenId = "";
        ConcurrentHashMap drivers = this.getDrivers();
        for (Map.Entry entry : drivers.entrySet()) {
            String driverName = (String)entry.getKey();
            WebDriver drv = ((CarinaDriver)entry.getValue()).getDriver();
            if (drv instanceof EventFiringWebDriver) {
                drv = ((EventFiringWebDriver)drv).getWrappedDriver();
            }
            screenId = Screenshot.captureFailure((WebDriver)drv, (String)(driverName + ": " + msg));
        }
        return screenId;
    }
}

