/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.report;

import com.qaprosoft.carina.core.foundation.jira.Jira;
import com.qaprosoft.carina.core.foundation.performance.Timer;
import com.qaprosoft.carina.core.foundation.report.Artifacts;
import com.qaprosoft.carina.core.foundation.report.qtest.IQTestManager;
import com.qaprosoft.carina.core.foundation.report.testrail.ITestRailManager;
import com.qaprosoft.carina.core.foundation.retry.RetryCounter;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.naming.TestNamingUtil;
import com.qaprosoft.carina.core.foundation.utils.ownership.Ownership;
import com.qaprosoft.carina.core.foundation.utils.tag.PriorityManager;
import com.qaprosoft.carina.core.foundation.utils.tag.TagManager;
import com.qaprosoft.carina.core.foundation.webdriver.device.Device;
import com.qaprosoft.carina.core.foundation.webdriver.device.DevicePool;
import com.qaprosoft.zafira.config.IConfigurator;
import com.qaprosoft.zafira.models.db.TestRun;
import com.qaprosoft.zafira.models.dto.TagType;
import com.qaprosoft.zafira.models.dto.TestArtifactType;
import com.qaprosoft.zafira.models.dto.config.ArgumentType;
import com.qaprosoft.zafira.models.dto.config.ConfigurationType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.testng.ISuite;
import org.testng.ITestResult;

public class ZafiraConfigurator
implements IConfigurator,
ITestRailManager,
IQTestManager {
    protected static final Logger LOGGER = Logger.getLogger(ZafiraConfigurator.class);

    public ConfigurationType getConfiguration() {
        ConfigurationType conf = new ConfigurationType();
        for (Configuration.Parameter parameter : Configuration.Parameter.values()) {
            conf.getArg().add(this.buildArgumentType(parameter.getKey(), R.CONFIG.get(parameter.getKey())));
        }
        if (R.CONFIG.containsKey("actual_browser_version")) {
            conf.getArg().add(this.buildArgumentType("browser_version", R.CONFIG.get("actual_browser_version")));
        }
        if (this.buildArgumentType("platform", R.CONFIG.get("os")).getValue() != null) {
            conf.getArg().add(this.buildArgumentType("platform", R.CONFIG.get("os")));
            conf.getArg().add(this.buildArgumentType("platform_version", R.CONFIG.get("os_version")));
        }
        long threadId = Thread.currentThread().getId();
        Device device = DevicePool.getDevice();
        if (!device.getName().isEmpty()) {
            String deviceName = device.getName();
            String deviceOs = device.getOs();
            String deviceOsVersion = device.getOsVersion();
            conf.getArg().add(this.buildArgumentType("device", deviceName));
            conf.getArg().add(this.buildArgumentType("platform", deviceOs));
            conf.getArg().add(this.buildArgumentType("platform_version", deviceOsVersion));
            LOGGER.debug((Object)("Detected device: '" + deviceName + "'; os: '" + deviceOs + "'; os version: '" + deviceOsVersion + "'"));
        } else {
            LOGGER.debug((Object)("Unable to detect current device for threadId: " + threadId));
        }
        return conf;
    }

    private ArgumentType buildArgumentType(String key, String value) {
        ArgumentType arg = new ArgumentType();
        arg.setKey(key);
        arg.setValue("NULL".equalsIgnoreCase(value) ? null : value);
        return arg;
    }

    public String getOwner(ISuite suite) {
        String owner = suite.getParameter("suiteOwner");
        LOGGER.debug((Object)("owner: " + owner));
        return owner != null ? owner : "";
    }

    public String getPrimaryOwner(ITestResult test) {
        String primaryOwner = Ownership.getMethodOwner((ITestResult)test, (Ownership.OwnerType)Ownership.OwnerType.PRIMARY);
        LOGGER.debug((Object)("primaryOwner: " + primaryOwner));
        return primaryOwner;
    }

    public String getSecondaryOwner(ITestResult test) {
        String secondaryOwner = Ownership.getMethodOwner((ITestResult)test, (Ownership.OwnerType)Ownership.OwnerType.SECONDARY);
        LOGGER.debug((Object)("secondaryOwner: " + secondaryOwner));
        return secondaryOwner;
    }

    public String getTestName(ITestResult test) {
        String testName = TestNamingUtil.getCanonicalTestName((ITestResult)test);
        LOGGER.debug((Object)("testName: " + testName));
        return testName;
    }

    public String getTestMethodName(ITestResult test) {
        String testMethodName = TestNamingUtil.getCanonicalTestMethodName((ITestResult)test);
        LOGGER.debug((Object)("testMethodName: " + testMethodName));
        return testMethodName;
    }

    public List<String> getTestWorkItems(ITestResult test) {
        return Jira.getTickets((ITestResult)test);
    }

    public int getRunCount(ITestResult test) {
        int runCount = RetryCounter.getRunCount();
        LOGGER.debug((Object)("runCount: " + runCount));
        return runCount;
    }

    public Map<String, Long> getTestMetrics(ITestResult test) {
        return Timer.readAndClear();
    }

    public TestRun.DriverMode getDriverMode() {
        return TestRun.DriverMode.valueOf((String)"METHOD_MODE");
    }

    public Set<TagType> getTestTags(ITestResult test) {
        LOGGER.debug((Object)"Collecting TestTags...");
        HashSet<TagType> tags = new HashSet<TagType>();
        String testPriority = PriorityManager.getPriority((ITestResult)test);
        if (testPriority != null && !testPriority.isEmpty()) {
            TagType priority = new TagType();
            priority.setName("priority");
            priority.setValue(testPriority);
            tags.add(priority);
        }
        Map testTags = TagManager.getTags((ITestResult)test);
        testTags.entrySet().stream().forEach(entry -> {
            TagType tagEntry = new TagType();
            tagEntry.setName((String)entry.getKey());
            tagEntry.setValue((String)entry.getValue());
            tags.add(tagEntry);
        });
        tags.addAll(this.getTestRailTags(test));
        tags.addAll(this.getQTestTags(test));
        LOGGER.debug((Object)("Found " + tags.size() + " new TestTags"));
        return tags;
    }

    public Set<TestArtifactType> getArtifacts(ITestResult test) {
        LOGGER.debug((Object)"Collecting artifacts...");
        return Artifacts.getArtifacts();
    }

    private Set<TagType> getTestRailTags(ITestResult test) {
        LOGGER.debug((Object)"Collecting TestRail Tags...");
        HashSet<TagType> tags = new HashSet<TagType>();
        Set testRailTags = this.getTestRailCasesUuid(test);
        int projectID = this.getTestRailProjectId(test.getTestContext());
        int suiteID = this.getTestRailSuiteId(test.getTestContext());
        if (projectID != -1 && suiteID != -1) {
            testRailTags.forEach(entry -> {
                TagType tagEntry = new TagType();
                tagEntry.setName("TESTRAIL_TESTCASE_UUID");
                tagEntry.setValue(projectID + "-" + suiteID + "-" + entry);
                tags.add(tagEntry);
            });
        }
        LOGGER.debug((Object)("Found " + tags.size() + " new TestRail tags"));
        return tags;
    }

    private Set<TagType> getQTestTags(ITestResult test) {
        LOGGER.debug((Object)"Collecting qTest Tags...");
        HashSet<TagType> tags = new HashSet<TagType>();
        Set qTestTags = this.getQTestCasesUuid(test);
        int projectID = this.getQTestProjectId(test.getTestContext());
        if (projectID != -1) {
            qTestTags.forEach(entry -> {
                TagType tagEntry = new TagType();
                tagEntry.setName("QTEST_TESTCASE_UUID");
                tagEntry.setValue(projectID + "-" + entry);
                tags.add(tagEntry);
            });
        }
        LOGGER.debug((Object)("Found " + tags.size() + " new qTest tags"));
        return tags;
    }
}

