/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.report.email;

import com.qaprosoft.carina.core.foundation.report.TestResultItem;
import com.qaprosoft.carina.core.foundation.report.TestResultType;
import com.qaprosoft.carina.core.foundation.report.email.EmailReportItemComparator;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.R;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class EmailReportGenerator {
    protected static final Logger LOGGER = Logger.getLogger(EmailReportGenerator.class);
    private static String CONTAINER = R.EMAIL.get("container");
    private static String PACKAGE_TR = R.EMAIL.get("package_tr");
    private static String PASS_TEST_LOG_DEMO_TR = R.EMAIL.get("pass_test_log_demo_tr");
    private static String FAIL_TEST_LOG_DEMO_TR = R.EMAIL.get("fail_test_log_demo_tr");
    private static String BUG_TEST_LOG_DEMO_TR = R.EMAIL.get("bug_test_log_demo_tr");
    private static String SKIP_TEST_LOG_DEMO_TR = R.EMAIL.get("skip_test_log_demo_tr");
    private static String FAIL_CONFIG_LOG_DEMO_TR = R.EMAIL.get("fail_config_log_demo_tr");
    private static String PASS_TEST_LOG_TR = R.EMAIL.get("pass_test_log_tr");
    private static String FAIL_TEST_LOG_TR = R.EMAIL.get("fail_test_log_tr");
    private static String BUG_TEST_LOG_TR = R.EMAIL.get("bug_test_log_tr");
    private static String SKIP_TEST_LOG_TR = R.EMAIL.get("skip_test_log_tr");
    private static String FAIL_CONFIG_LOG_TR = R.EMAIL.get("fail_config_log_tr");
    private static String CREATED_ITEMS_LIST = R.EMAIL.get("created_items_list");
    private static String CREATED_ITEM = R.EMAIL.get("created_item");
    private static final String TITLE_PLACEHOLDER = "${title}";
    private static final String ENV_PLACEHOLDER = "${env}";
    private static final String DEVICE_PLACEHOLDER = "${device}";
    private static final String BROWSER_PLACEHOLDER = "${browser}";
    private static final String VERSION_PLACEHOLDER = "${version}";
    private static final String FINISH_DATE_PLACEHOLDER = "${finish_date}";
    private static final String PASS_COUNT_PLACEHOLDER = "${pass_count}";
    private static final String FAIL_COUNT_PLACEHOLDER = "${fail_count}";
    private static final String SKIP_COUNT_PLACEHOLDER = "${skip_count}";
    private static final String PASS_RATE_PLACEHOLDER = "${pass_rate}";
    private static final String RESULTS_PLACEHOLDER = "${result_rows}";
    private static final String PACKAGE_NAME_PLACEHOLDER = "${package_name}";
    private static final String TEST_NAME_PLACEHOLDER = "${test_name}";
    private static final String FAIL_REASON_PLACEHOLDER = "${fail_reason}";
    private static final String SKIP_REASON_PLACEHOLDER = "${skip_reason}";
    private static final String FAIL_CONFIG_REASON_PLACEHOLDER = "${fail_config_reason}";
    private static final String SCREENSHOTS_URL_PLACEHOLDER = "${screenshots_url}";
    private static final String LOG_URL_PLACEHOLDER = "${log_url}";
    private static final String CREATED_ITEMS_LIST_PLACEHOLDER = "${created_items_list}";
    private static final String CREATED_ITEM_PLACEHOLDER = "${created_item}";
    private static final String BUG_URL_PLACEHOLDER = "${bug_url}";
    private static final String BUG_ID_PLACEHOLDER = "${bug_id}";
    private static final int MESSAGE_LIMIT = R.EMAIL.getInt("fail_description_limit");
    private static boolean INCLUDE_PASS = R.EMAIL.getBoolean("include_pass");
    private static boolean INCLUDE_FAIL = R.EMAIL.getBoolean("include_fail");
    private static boolean INCLUDE_SKIP = R.EMAIL.getBoolean("include_skip");
    private String emailBody = CONTAINER;
    private StringBuilder testResults = null;
    private int passCount = 0;
    private int failCount = 0;
    private int skipCount = 0;

    public EmailReportGenerator(String title, String url, String version, String device, String browser, String finishDate, List<TestResultItem> testResultItems, List<String> createdItems) {
        this.emailBody = this.emailBody.replace(TITLE_PLACEHOLDER, title);
        this.emailBody = this.emailBody.replace(ENV_PLACEHOLDER, url);
        this.emailBody = this.emailBody.replace(DEVICE_PLACEHOLDER, device);
        this.emailBody = this.emailBody.replace(VERSION_PLACEHOLDER, version);
        this.emailBody = this.emailBody.replace(BROWSER_PLACEHOLDER, browser);
        this.emailBody = this.emailBody.replace(FINISH_DATE_PLACEHOLDER, finishDate);
        this.emailBody = this.emailBody.replace(RESULTS_PLACEHOLDER, this.getTestResultsList(testResultItems));
        this.emailBody = this.emailBody.replace(PASS_COUNT_PLACEHOLDER, String.valueOf(this.passCount));
        this.emailBody = this.emailBody.replace(FAIL_COUNT_PLACEHOLDER, String.valueOf(this.failCount));
        this.emailBody = this.emailBody.replace(SKIP_COUNT_PLACEHOLDER, String.valueOf(this.skipCount));
        this.emailBody = this.emailBody.replace(PASS_RATE_PLACEHOLDER, String.valueOf(this.getSuccessRate()));
        this.emailBody = this.emailBody.replace(CREATED_ITEMS_LIST_PLACEHOLDER, this.getCreatedItemsList(createdItems));
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    private String getTestResultsList(List<TestResultItem> testResultItems) {
        if (testResultItems.size() > 0) {
            if (Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.RESULT_SORTING)) {
                Collections.sort(testResultItems, new EmailReportItemComparator());
            }
            String packageName = "";
            this.testResults = new StringBuilder();
            for (TestResultItem testResultItem : testResultItems) {
                if (!testResultItem.isConfig() && !packageName.equals(testResultItem.getPack())) {
                    packageName = testResultItem.getPack();
                    this.testResults.append(PACKAGE_TR.replace(PACKAGE_NAME_PLACEHOLDER, packageName));
                }
                this.testResults.append(this.getTestRow(testResultItem));
            }
        }
        return this.testResults != null ? this.testResults.toString() : "";
    }

    private String getTestRow(TestResultItem testResultItem) {
        String result = "";
        String failReason = "";
        if (testResultItem.getResult().name().equalsIgnoreCase("FAIL")) {
            if (INCLUDE_FAIL) {
                if (testResultItem.isConfig()) {
                    result = testResultItem.getLinkToScreenshots() != null ? FAIL_CONFIG_LOG_DEMO_TR : FAIL_CONFIG_LOG_TR;
                    result = result.replace(TEST_NAME_PLACEHOLDER, testResultItem.getTest());
                    failReason = testResultItem.getFailReason();
                    if (!StringUtils.isEmpty((CharSequence)failReason)) {
                        failReason = failReason.length() > MESSAGE_LIMIT ? failReason.substring(0, MESSAGE_LIMIT) + "..." : failReason;
                        result = result.replace(FAIL_CONFIG_REASON_PLACEHOLDER, this.formatFailReasonAsHtml(failReason));
                    } else {
                        result = result.replace(FAIL_CONFIG_REASON_PLACEHOLDER, "Undefined failure: contact qa engineer!");
                    }
                } else {
                    result = Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.TRACK_KNOWN_ISSUES) && !testResultItem.getJiraTickets().isEmpty() ? (testResultItem.getLinkToScreenshots() != null ? BUG_TEST_LOG_DEMO_TR : BUG_TEST_LOG_TR) : (testResultItem.getLinkToScreenshots() != null ? FAIL_TEST_LOG_DEMO_TR : FAIL_TEST_LOG_TR);
                    result = result.replace(TEST_NAME_PLACEHOLDER, testResultItem.getTest());
                    failReason = testResultItem.getFailReason();
                    if (!StringUtils.isEmpty((CharSequence)failReason)) {
                        failReason = failReason.length() > MESSAGE_LIMIT ? failReason.substring(0, MESSAGE_LIMIT) + "..." : failReason;
                        result = result.replace(FAIL_REASON_PLACEHOLDER, this.formatFailReasonAsHtml(failReason));
                    } else {
                        result = result.replace(FAIL_REASON_PLACEHOLDER, "Undefined failure: contact qa engineer!");
                    }
                }
                result = result.replace(LOG_URL_PLACEHOLDER, testResultItem.getLinkToLog());
                if (testResultItem.getLinkToScreenshots() != null) {
                    result = result.replace(SCREENSHOTS_URL_PLACEHOLDER, testResultItem.getLinkToScreenshots());
                }
            }
            if (!Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.TRACK_KNOWN_ISSUES) || testResultItem.getJiraTickets().isEmpty()) {
                ++this.failCount;
            }
        }
        if (testResultItem.getResult().name().equalsIgnoreCase("SKIP")) {
            failReason = testResultItem.getFailReason();
            if (!(testResultItem.isConfig() || failReason.contains("ALREADY_PASSED") || failReason.contains("SKIP_EXECUTION"))) {
                if (INCLUDE_SKIP) {
                    result = testResultItem.getLinkToScreenshots() != null ? SKIP_TEST_LOG_DEMO_TR : SKIP_TEST_LOG_TR;
                    result = result.replace(TEST_NAME_PLACEHOLDER, testResultItem.getTest());
                    if (!StringUtils.isEmpty((CharSequence)failReason)) {
                        failReason = failReason.length() > MESSAGE_LIMIT ? failReason.substring(0, MESSAGE_LIMIT) + "..." : failReason;
                        result = result.replace(SKIP_REASON_PLACEHOLDER, this.formatFailReasonAsHtml(failReason));
                    } else {
                        result = result.replace(SKIP_REASON_PLACEHOLDER, "Analyze SYSTEM ISSUE log for details or check dependency settings for the test.");
                    }
                    result = result.replace(LOG_URL_PLACEHOLDER, testResultItem.getLinkToLog());
                    if (testResultItem.getLinkToScreenshots() != null) {
                        result = result.replace(SCREENSHOTS_URL_PLACEHOLDER, testResultItem.getLinkToScreenshots());
                    }
                }
                ++this.skipCount;
            }
        }
        if (testResultItem.getResult().name().equalsIgnoreCase("PASS") && !testResultItem.isConfig()) {
            ++this.passCount;
            if (INCLUDE_PASS) {
                result = testResultItem.getLinkToScreenshots() != null ? PASS_TEST_LOG_DEMO_TR : PASS_TEST_LOG_TR;
                result = result.replace(TEST_NAME_PLACEHOLDER, testResultItem.getTest());
                result = result.replace(LOG_URL_PLACEHOLDER, testResultItem.getLinkToLog());
                if (testResultItem.getLinkToScreenshots() != null) {
                    result = result.replace(SCREENSHOTS_URL_PLACEHOLDER, testResultItem.getLinkToScreenshots());
                }
            }
        }
        List jiraTickets = testResultItem.getJiraTickets();
        String bugId = null;
        String bugUrl = null;
        if (jiraTickets.size() > 0) {
            bugId = (String)jiraTickets.get(0);
            if (!Configuration.get((Configuration.Parameter)Configuration.Parameter.JIRA_URL).isEmpty()) {
                bugUrl = Configuration.get((Configuration.Parameter)Configuration.Parameter.JIRA_URL) + "/browse/" + (String)jiraTickets.get(0);
            }
            if (jiraTickets.size() > 1) {
                LOGGER.error((Object)"Current implementation doesn't support email report generation with several Jira Tickets fo single test!");
            }
        }
        if (bugId == null) {
            bugId = "N/A";
        }
        if (bugUrl == null) {
            bugUrl = "#";
        }
        result = result.replace(BUG_ID_PLACEHOLDER, bugId);
        result = result.replace(BUG_URL_PLACEHOLDER, bugUrl);
        return result;
    }

    private int getSuccessRate() {
        return this.passCount > 0 ? (int)((double)this.passCount / ((double)this.passCount + (double)this.failCount + (double)this.skipCount) * 100.0) : 0;
    }

    public static TestResultType getSuiteResult(List<TestResultItem> ris) {
        int passed = 0;
        int failed = 0;
        int failedKnownIssue = 0;
        int skipped = 0;
        int skipped_already_passed = 0;
        for (TestResultItem ri : ris) {
            if (ri.isConfig()) continue;
            switch (ri.getResult()) {
                case PASS: {
                    ++passed;
                    break;
                }
                case FAIL: {
                    if (Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.TRACK_KNOWN_ISSUES)) {
                        if (ri.getJiraTickets().size() > 0) {
                            ++failedKnownIssue;
                            break;
                        }
                        ++failed;
                        break;
                    }
                    ++failed;
                    break;
                }
                case SKIP: {
                    if (ri.getFailReason().startsWith("ALREADY_PASSED")) {
                        ++skipped_already_passed;
                        break;
                    }
                    if (ri.getFailReason().startsWith("SKIP_EXECUTION")) break;
                    ++skipped;
                    break;
                }
                case SKIP_ALL: {
                    break;
                }
            }
        }
        TestResultType result = passed == 0 && failed == 0 && skipped == 0 && skipped_already_passed > 0 ? TestResultType.SKIP_ALL_ALREADY_PASSED : (passed > 0 && failedKnownIssue == 0 && failed == 0 && skipped == 0 ? TestResultType.PASS : (passed >= 0 && failedKnownIssue > 0 && failed == 0 && skipped == 0 ? TestResultType.PASS_WITH_KNOWN_ISSUES : (passed == 0 && failed == 0 && skipped > 0 ? TestResultType.SKIP_ALL : (passed >= 0 && failed == 0 && skipped > 0 ? TestResultType.SKIP : TestResultType.FAIL))));
        result.setPassed(passed);
        result.setFailed(failed + failedKnownIssue);
        result.setSkipped(skipped);
        return result;
    }

    public String getCreatedItemsList(List<String> createdItems) {
        if (!CollectionUtils.isEmpty(createdItems)) {
            StringBuilder result = new StringBuilder();
            for (String createdItem : createdItems) {
                result.append(CREATED_ITEM.replace(CREATED_ITEM_PLACEHOLDER, createdItem));
            }
            return CREATED_ITEMS_LIST.replace(CREATED_ITEMS_LIST_PLACEHOLDER, result.toString());
        }
        return "";
    }

    public String formatFailReasonAsHtml(String reasonText) {
        if (!StringUtils.isEmpty((CharSequence)reasonText)) {
            reasonText = StringEscapeUtils.escapeHtml4((String)reasonText);
            reasonText = reasonText.replace("\n", "<br/>");
        }
        return reasonText;
    }
}

