/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.filter;

import com.qaprosoft.carina.core.foundation.filter.IFilter;
import com.qaprosoft.carina.core.foundation.filter.IncorrectFilterException;
import com.qaprosoft.carina.core.foundation.filter.impl.OwnerFilter;
import com.qaprosoft.carina.core.foundation.filter.impl.PriorityFilter;
import com.qaprosoft.carina.core.foundation.filter.impl.TagFilter;
import org.apache.log4j.Logger;

public enum Filter {
    PRIORITY("PRIORITY", new PriorityFilter()),
    OWNER("OWNER", new OwnerFilter()),
    TAGS("TAGS", new TagFilter());

    private static final Logger LOGGER;
    private String ruleName;
    private IFilter filter;

    private Filter(String ruleName, IFilter filter) {
        this.ruleName = ruleName;
        this.filter = filter;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public Filter getRuleByName(String ruleName) {
        try {
            Filter rule = Filter.valueOf(ruleName.toUpperCase());
            return rule;
        }
        catch (IllegalArgumentException e) {
            LOGGER.info((Object)String.format("Filter [%s] is not defined. Please, review all available filters", ruleName));
            throw new IncorrectFilterException(String.format("Filter [%s] is not defined. Please, review all available filters", ruleName));
        }
    }

    static {
        LOGGER = Logger.getLogger(Filter.class);
    }
}

