/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.filter.impl;

import com.qaprosoft.carina.core.foundation.filter.IFilter;
import com.qaprosoft.carina.core.foundation.utils.tag.Priority;
import com.qaprosoft.carina.core.foundation.utils.tag.TestPriority;
import java.util.List;
import org.apache.log4j.Logger;
import org.testng.ITestNGMethod;

public class PriorityFilter
implements IFilter {
    private static final Logger LOGGER = Logger.getLogger(PriorityFilter.class);

    @Override
    public boolean isPerform(ITestNGMethod testMethod, List<String> expectedData) {
        TestPriority priority = testMethod.getConstructorOrMethod().getMethod().getAnnotation(TestPriority.class);
        if (priority != null) {
            Priority testPriority = priority.value();
            String actualTestPriority = testPriority.toString();
            LOGGER.info((Object)String.format("Test: [%s]. Priority: [%s]. Expected priority: [%s]", testMethod.getMethodName(), actualTestPriority, expectedData.toString()));
            return expectedData.parallelStream().anyMatch(d -> d.equals(actualTestPriority));
        }
        return false;
    }
}

