/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.filter.impl;

import com.qaprosoft.carina.core.foundation.filter.IFilter;
import com.qaprosoft.carina.core.foundation.utils.tag.TestTag;
import java.util.List;
import org.apache.log4j.Logger;
import org.testng.ITestNGMethod;

public class TagFilter
implements IFilter {
    private static final Logger LOGGER = Logger.getLogger(TagFilter.class);

    @Override
    public boolean isPerform(ITestNGMethod testMethod, List<String> expectedData) {
        if (testMethod != null) {
            TestTag methodAnnotation;
            if (testMethod.getConstructorOrMethod().getMethod().isAnnotationPresent(TestTag.class) && (methodAnnotation = testMethod.getConstructorOrMethod().getMethod().getAnnotation(TestTag.class)) != null) {
                String tagName = methodAnnotation.name();
                String tagValue = methodAnnotation.value();
                String tag = tagName + "=" + tagValue;
                LOGGER.info((Object)String.format("Test: [%s]. Tag: [%s]. Expected tag: [%s]", testMethod.getMethodName(), tag, expectedData.toString()));
                return expectedData.parallelStream().anyMatch(d -> d.equalsIgnoreCase(tag));
            }
            if (testMethod.getConstructorOrMethod().getMethod().isAnnotationPresent(TestTag.List.class)) {
                methodAnnotation = testMethod.getConstructorOrMethod().getMethod().getAnnotation(TestTag.List.class);
                for (TestTag tagLocal : methodAnnotation.value()) {
                    if (tagLocal == null) continue;
                    String tagName = tagLocal.name();
                    String tagValue = tagLocal.value();
                    String tag = tagName + "=" + tagValue;
                    LOGGER.info((Object)String.format("Test: [%s]. Tag: [%s]. Expected tag: [%s]", testMethod.getMethodName(), tag, expectedData.toString()));
                    return expectedData.parallelStream().anyMatch(d -> d.equalsIgnoreCase(tag));
                }
            }
        }
        return false;
    }
}

