/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.qaprosoft.carina.core.foundation.dataprovider.parser.DSBean;
import com.qaprosoft.carina.core.foundation.jira.Jira;
import com.qaprosoft.carina.core.foundation.listeners.TestNamingListener;
import com.qaprosoft.carina.core.foundation.report.ReportContext;
import com.qaprosoft.carina.core.foundation.report.TestResultItem;
import com.qaprosoft.carina.core.foundation.report.TestResultType;
import com.qaprosoft.carina.core.foundation.report.email.EmailReportItemCollector;
import com.qaprosoft.carina.core.foundation.retry.RetryAnalyzer;
import com.qaprosoft.carina.core.foundation.utils.DateUtils;
import com.qaprosoft.carina.core.foundation.utils.Messager;
import com.qaprosoft.carina.core.foundation.utils.ParameterGenerator;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.StringGenerator;
import com.qaprosoft.carina.core.foundation.utils.video.VideoAnalyzer;
import com.qaprosoft.carina.core.foundation.webdriver.IDriverPool;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.testng.IRetryAnalyzer;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class AbstractTestListener
extends TestListenerAdapter
implements IDriverPool {
    private static final Logger LOGGER = Logger.getLogger(AbstractTestListener.class);
    protected static ThreadLocal<TestResultItem> configFailures = new ThreadLocal();

    private void startItem(ITestResult result, Messager messager) {
        String test = TestNamingListener.getTestName();
        String deviceName = this.getDeviceName();
        messager.info(new String[]{deviceName, test, DateUtils.now()});
    }

    private void passItem(ITestResult result, Messager messager) {
        String test = TestNamingListener.getTestName();
        String deviceName = this.getDeviceName();
        messager.info(new String[]{deviceName, test, DateUtils.now()});
        EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.PASS, null, result.getMethod().getDescription()));
        result.getTestContext().removeAttribute("testFailureMessage");
    }

    private String failItem(ITestResult result, Messager messager) {
        String test = TestNamingListener.getTestName();
        String errorMessage = this.getFailureReason(result);
        String deviceName = this.getDeviceName();
        if (!errorMessage.contains("All tests were skipped! Analyze logs to determine possible configuration issues.")) {
            messager.error(new String[]{deviceName, test, DateUtils.now(), errorMessage});
            if (!R.EMAIL.getBoolean("fail_full_stacktrace_in_report") && result.getThrowable() != null && result.getThrowable().getMessage() != null && !StringUtils.isEmpty((CharSequence)result.getThrowable().getMessage())) {
                EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.FAIL, result.getThrowable().getMessage(), result.getMethod().getDescription()));
            } else {
                EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.FAIL, errorMessage, result.getMethod().getDescription()));
            }
        }
        result.getTestContext().removeAttribute("testFailureMessage");
        return errorMessage;
    }

    private String failRetryItem(ITestResult result, Messager messager, int count, int maxCount) {
        String test = TestNamingListener.getTestName();
        String errorMessage = this.getFailureReason(result);
        String deviceName = this.getDeviceName();
        messager.error(new String[]{deviceName, test, String.valueOf(count), String.valueOf(maxCount), errorMessage});
        result.getTestContext().removeAttribute("testFailureMessage");
        return errorMessage;
    }

    private String skipItem(ITestResult result, Messager messager) {
        String test = TestNamingListener.getTestName();
        String errorMessage = this.getFailureReason(result);
        if (errorMessage.isEmpty()) {
            int i;
            String[] methods = result.getMethod().getMethodsDependedUpon();
            boolean dependentMethod = false;
            String dependentMethodName = "";
            block0: for (ITestResult failedTest : result.getTestContext().getFailedTests().getAllResults()) {
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].contains(failedTest.getName())) continue;
                    dependentMethodName = failedTest.getName();
                    dependentMethod = true;
                    continue block0;
                }
            }
            block2: for (ITestResult skippedTest : result.getTestContext().getSkippedTests().getAllResults()) {
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].contains(skippedTest.getName())) continue;
                    dependentMethodName = skippedTest.getName();
                    dependentMethod = true;
                    continue block2;
                }
            }
            if (dependentMethod) {
                errorMessage = "Test skipped due to the dependency from: " + dependentMethodName;
            } else {
                TestResultItem resultItem = this.getConfigFailure();
                if (resultItem != null) {
                    errorMessage = resultItem.getFailReason();
                }
            }
        }
        String deviceName = this.getDeviceName();
        messager.warn(new String[]{deviceName, test, DateUtils.now(), errorMessage});
        EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.SKIP, errorMessage, result.getMethod().getDescription()));
        result.getTestContext().removeAttribute("testFailureMessage");
        return errorMessage;
    }

    private void skipTestItem(ITestResult result, Messager messager) {
        String test = TestNamingListener.getTestName();
        String deviceName = this.getDeviceName();
        messager.info(new String[]{deviceName, test, DateUtils.now()});
    }

    private String getDeviceName() {
        String deviceName = IDriverPool.getDefaultDevice().getName();
        String deviceUdid = IDriverPool.getDefaultDevice().getUdid();
        if (!deviceName.isEmpty() && !deviceUdid.isEmpty()) {
            deviceName = deviceName + " - " + deviceUdid;
        }
        return deviceName;
    }

    private void afterTest(ITestResult result) {
        ReportContext.generateTestReport();
        ReportContext.emptyTestDirData();
    }

    public void beforeConfiguration(ITestResult result) {
        LOGGER.info((Object)"AbstractTestListener->beforeConfiguration");
        super.beforeConfiguration(result);
    }

    public void onConfigurationSuccess(ITestResult result) {
        LOGGER.info((Object)"AbstractTestListener->onConfigurationSuccess");
        super.onConfigurationSuccess(result);
    }

    public void onConfigurationSkip(ITestResult result) {
        LOGGER.info((Object)"AbstractTestListener->onConfigurationSkip");
        super.onConfigurationSkip(result);
    }

    public void onConfigurationFailure(ITestResult result) {
        LOGGER.info((Object)"AbstractTestListener->onConfigurationFailure");
        String errorMessage = this.getFailureReason(result);
        TestResultItem resultItem = this.createTestResult(result, TestResultType.FAIL, errorMessage, result.getMethod().getDescription());
        this.setConfigFailure(resultItem);
        super.onConfigurationFailure(result);
    }

    public void onStart(ITestContext context) {
        LOGGER.info((Object)"AbstractTestListener->onStart(ITestContext context)");
        String uuid = StringGenerator.generateNumeric((int)8);
        ParameterGenerator.setUUID((String)uuid);
        ReportContext.getBaseDir();
        super.onStart(context);
    }

    public void onTestStart(ITestResult result) {
        LOGGER.info((Object)"AbstractTestListener->onTestStart");
        VideoAnalyzer.disableVideoUpload();
        RetryAnalyzer curRetryAnalyzer = this.getRetryAnalyzer(result);
        if (curRetryAnalyzer == null) {
            result.getMethod().setRetryAnalyzerClass(RetryAnalyzer.class);
        } else if (!(curRetryAnalyzer instanceof RetryAnalyzer)) {
            LOGGER.warn((Object)("Custom RetryAnalyzer is used: " + curRetryAnalyzer.getClass().getName()));
        }
        this.generateParameters(result);
        if (!result.getTestContext().getCurrentXmlTest().getAllParameters().containsKey("{excel_ds_custom_provider}") && result.getParameters().length > 0 && result.getTestContext().getCurrentXmlTest().getAllParameters().containsKey("{excel_ds_args}")) {
            DSBean dsBean = new DSBean(result.getTestContext());
            int index = 0;
            for (String arg : dsBean.getArgs()) {
                dsBean.getTestParams().put(arg, (String)result.getParameters()[index++]);
            }
            result.getTestContext().getCurrentXmlTest().setParameters(dsBean.getTestParams());
        }
        this.startItem(result, Messager.TEST_STARTED);
    }

    private void generateParameters(ITestResult result) {
        if (result != null && result.getParameters() != null) {
            for (int i = 0; i < result.getParameters().length; ++i) {
                if (result.getParameters()[i] instanceof String) {
                    result.getParameters()[i] = ParameterGenerator.process((String)result.getParameters()[i].toString());
                }
                if (!(result.getParameters()[i] instanceof Map)) continue;
                Map dynamicAgrs = (Map)result.getParameters()[i];
                for (Map.Entry entry : dynamicAgrs.entrySet()) {
                    Object param = ParameterGenerator.process((String)((String)entry.getValue()));
                    if (param != null) {
                        dynamicAgrs.put(entry.getKey(), param.toString());
                        continue;
                    }
                    dynamicAgrs.put(entry.getKey(), null);
                }
            }
        }
    }

    public void onTestSuccess(ITestResult result) {
        LOGGER.info((Object)"AbstractTestListener->onTestSuccess");
        this.passItem(result, Messager.TEST_PASSED);
        VideoAnalyzer.enableVideoUpload();
        this.afterTest(result);
        super.onTestSuccess(result);
        RetryAnalyzer retryAnalyzer = this.getRetryAnalyzer(result);
        if (retryAnalyzer != null && retryAnalyzer.getRunCount() > 0) {
            this.removeRetriedTests(result);
            retryAnalyzer.resetCounter();
        }
    }

    public void onTestFailure(ITestResult result) {
        LOGGER.info((Object)"AbstractTestListener->onTestFailure");
        this.failItem(result, Messager.TEST_FAILED);
        VideoAnalyzer.enableVideoUpload();
        this.afterTest(result);
        super.onTestFailure(result);
        RetryAnalyzer retryAnalyzer = this.getRetryAnalyzer(result);
        if (retryAnalyzer != null && retryAnalyzer.getRunCount() > 0) {
            this.removeRetriedTests(result);
            retryAnalyzer.resetCounter();
        }
    }

    public void onTestSkipped(ITestResult result) {
        int count;
        LOGGER.info((Object)"AbstractTestListener->onTestSkipped");
        if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("ALREADY_PASSED")) {
            this.skipTestItem(result, Messager.TEST_SKIPPED_AS_ALREADY_PASSED);
            return;
        }
        if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("SKIP_EXECUTION")) {
            return;
        }
        if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("ALREADY_FAILED_BY_KNOWN_BUG")) {
            this.skipTestItem(result, Messager.TEST_SKIPPED_AS_ALREADY_FAILED_BY_BUG);
            return;
        }
        RetryAnalyzer retryAnalyzer = this.getRetryAnalyzer(result);
        count = retryAnalyzer != null ? (count = retryAnalyzer.getRunCount().intValue()) : 0;
        int maxCount = RetryAnalyzer.getMaxRetryCountForTest();
        LOGGER.debug((Object)("count: " + count + "; maxCount:" + maxCount));
        if (count > 0 && retryAnalyzer == null) {
            LOGGER.error((Object)("retry_count will be ignored as RetryAnalyzer is not declared for " + result.getMethod().getMethodName()));
        } else if (count > 0 && count <= maxCount && !Jira.isRetryDisabled((ITestResult)result)) {
            this.failRetryItem(result, Messager.RETRY_FAILED, count, maxCount + 1);
            result.setStatus(2);
            this.afterTest(result);
            super.onTestFailure(result);
        } else {
            this.skipItem(result, Messager.TEST_SKIPPED);
            this.afterTest(result);
            super.onTestSkipped(result);
            if (retryAnalyzer != null) {
                retryAnalyzer.resetCounter();
            }
        }
    }

    public void onFinish(ITestContext context) {
        LOGGER.info((Object)"AbstractTestListener->onFinish(ITestContext context)");
        super.onFinish(context);
        this.removeAlreadyPassedTests(context);
    }

    private long getMethodId(ITestResult result) {
        long id = result.getTestClass().getName().hashCode();
        id = 31L * id + (long)result.getMethod().getMethodName().hashCode();
        id = 31L * id + (long)(result.getParameters() != null ? Arrays.hashCode(result.getParameters()) : 0);
        return id;
    }

    protected TestResultItem createTestResult(ITestResult result, TestResultType resultType, String failReason, String description) {
        String group = StringEscapeUtils.escapeHtml4((String)TestNamingListener.getPackageName((ITestResult)result));
        String linkToLog = ReportContext.getTestLogLink();
        String linkToScreenshots = ReportContext.getTestScreenshotsLink();
        String test = StringEscapeUtils.escapeHtml4((String)TestNamingListener.getTestName());
        TestResultItem testResultItem = new TestResultItem(group, test, resultType, linkToScreenshots, linkToLog, failReason);
        testResultItem.setDescription(description);
        testResultItem.setJiraTickets(Jira.getTickets((ITestResult)result));
        return testResultItem;
    }

    protected String getFailureReason(ITestResult result) {
        String errorMessage = "";
        String message = "";
        if (result.getThrowable() != null) {
            Throwable thr = result.getThrowable();
            errorMessage = this.getFullStackTrace(thr);
            message = thr.getMessage();
            result.getTestContext().setAttribute("testFailureMessage", (Object)message);
        }
        if (errorMessage.isEmpty()) {
            Set results = result.getTestContext().getSkippedConfigurations().getAllResults();
            for (ITestResult resultItem : results) {
                String methodName = resultItem.getMethod().getMethodName();
                if (!methodName.equals("executeBeforeTestMethod")) continue;
                errorMessage = this.getFullStackTrace(resultItem.getThrowable());
            }
        }
        return errorMessage;
    }

    private String getFullStackTrace(Throwable thr) {
        String stackTrace = "";
        if (thr != null) {
            StackTraceElement[] elems;
            stackTrace = thr.getMessage() + "\n";
            for (StackTraceElement elem : elems = thr.getStackTrace()) {
                stackTrace = stackTrace + "\n" + elem.toString();
            }
        }
        return stackTrace;
    }

    private TestResultItem getConfigFailure() {
        return configFailures.get();
    }

    protected void setConfigFailure(TestResultItem resultItem) {
        configFailures.set(resultItem);
    }

    private void removeRetriedTests(ITestResult result) {
        ITestContext context = result.getTestContext();
        long passedTestId = this.getMethodId(result);
        LOGGER.debug((Object)("passedTest: " + passedTestId));
        Iterator iterator = context.getFailedTests().getAllResults().iterator();
        while (iterator.hasNext()) {
            ITestResult testResult = (ITestResult)iterator.next();
            if (this.getMethodId(testResult) != passedTestId) continue;
            LOGGER.debug((Object)("Removed test retry from context: " + testResult.getName()));
            iterator.remove();
        }
    }

    private void removeAlreadyPassedTests(ITestContext context) {
        Iterator iterator = context.getSkippedTests().getAllResults().iterator();
        while (iterator.hasNext()) {
            ITestResult testResult = (ITestResult)iterator.next();
            if (!testResult.getThrowable().toString().startsWith("org.testng.SkipException: ALREADY_PASSED")) continue;
            LOGGER.debug((Object)("Removed skipped test from context: " + testResult.getName()));
            iterator.remove();
        }
    }

    private RetryAnalyzer getRetryAnalyzer(ITestResult result) {
        RetryAnalyzer retryAnalyzer = null;
        IRetryAnalyzer iRetry = result.getMethod().getRetryAnalyzer(result);
        if (iRetry instanceof RetryAnalyzer) {
            retryAnalyzer = (RetryAnalyzer)iRetry;
        }
        return retryAnalyzer;
    }
}

