/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.qaprosoft.amazon.AmazonS3Manager;
import com.qaprosoft.appcenter.AppCenterManager;
import com.qaprosoft.carina.browsermobproxy.ProxyPool;
import com.qaprosoft.carina.core.foundation.jira.Jira;
import com.qaprosoft.carina.core.foundation.listeners.AbstractTestListener;
import com.qaprosoft.carina.core.foundation.report.ReportContext;
import com.qaprosoft.carina.core.foundation.report.TestResultItem;
import com.qaprosoft.carina.core.foundation.report.TestResultType;
import com.qaprosoft.carina.core.foundation.report.email.EmailReportGenerator;
import com.qaprosoft.carina.core.foundation.report.email.EmailReportItemCollector;
import com.qaprosoft.carina.core.foundation.skip.ExpectedSkipManager;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.DateUtils;
import com.qaprosoft.carina.core.foundation.utils.JsonUtils;
import com.qaprosoft.carina.core.foundation.utils.Messager;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.common.CommonUtils;
import com.qaprosoft.carina.core.foundation.utils.ftp.FtpUtils;
import com.qaprosoft.carina.core.foundation.utils.metadata.MetadataCollector;
import com.qaprosoft.carina.core.foundation.utils.resources.L10N;
import com.qaprosoft.carina.core.foundation.utils.resources.L10Nparser;
import com.qaprosoft.carina.core.foundation.webdriver.CarinaDriver;
import com.qaprosoft.carina.core.foundation.webdriver.IDriverPool;
import com.qaprosoft.carina.core.foundation.webdriver.Screenshot;
import com.qaprosoft.carina.core.foundation.webdriver.TestPhase;
import com.qaprosoft.carina.core.foundation.webdriver.core.capability.CapabilitiesLoader;
import com.qaprosoft.carina.core.foundation.webdriver.device.Device;
import com.qaprosoft.carina.core.foundation.webdriver.screenshot.AutoScreenshotRule;
import com.qaprosoft.carina.core.foundation.webdriver.screenshot.IScreenshotRule;
import com.qaprosoft.zafira.client.ZafiraSingleton;
import com.qaprosoft.zafira.listener.ZafiraEventRegistrar;
import com.qaprosoft.zafira.models.dto.TestRunType;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.testng.Assert;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CarinaListener
extends AbstractTestListener
implements ISuiteListener {
    private static final Logger LOGGER = Logger.getLogger(CarinaListener.class);
    protected static final long EXPLICIT_TIMEOUT = Configuration.getLong((Configuration.Parameter)Configuration.Parameter.EXPLICIT_TIMEOUT);
    protected static final String SUITE_TITLE = "%s%s%s - %s (%s%s)";
    protected static final String XML_SUITE_NAME = " (%s)";
    protected static boolean automaticDriversCleanup = true;

    public void onStart(ISuite suite) {
        LOGGER.debug((Object)"CarinaListener->onStart(ISuite suite)");
        ArrayList<String> coreLogPackages = new ArrayList<String>(Arrays.asList(Configuration.get((Configuration.Parameter)Configuration.Parameter.CORE_LOG_PACKAGES).split(",")));
        if (coreLogPackages.size() > 0 && !"INFO".equalsIgnoreCase(Configuration.get((Configuration.Parameter)Configuration.Parameter.CORE_LOG_LEVEL))) {
            try {
                Logger root = Logger.getRootLogger();
                Enumeration allLoggers = root.getLoggerRepository().getCurrentCategories();
                while (allLoggers.hasMoreElements()) {
                    Category tmpLogger = (Category)allLoggers.nextElement();
                    LOGGER.debug((Object)("loggerName: " + tmpLogger.getName()));
                    if ("log4j.logger.org.apache.http.wire".equals(tmpLogger.getName())) {
                        LOGGER.info((Object)("Updaged logger level for '" + tmpLogger.getName() + "' to " + Configuration.get((Configuration.Parameter)Configuration.Parameter.CORE_LOG_LEVEL)));
                        tmpLogger.setLevel(Level.toLevel((String)Configuration.get((Configuration.Parameter)Configuration.Parameter.CORE_LOG_LEVEL)));
                    }
                    for (String coreLogPackage : coreLogPackages) {
                        if (!tmpLogger.getName().contains(coreLogPackage.trim())) continue;
                        LOGGER.info((Object)("Updaged logger level for '" + tmpLogger.getName() + "' to " + Configuration.get((Configuration.Parameter)Configuration.Parameter.CORE_LOG_LEVEL)));
                        tmpLogger.setLevel(Level.toLevel((String)Configuration.get((Configuration.Parameter)Configuration.Parameter.CORE_LOG_LEVEL)));
                    }
                }
            }
            catch (NoSuchMethodError e) {
                LOGGER.error((Object)"Unable to redefine logger level due to the conflicts between log4j and slf4j!");
            }
        }
        this.setThreadCount(suite);
        this.onHealthCheck(suite);
        LOGGER.info((Object)("CARINA_CORE_VERSION: " + this.getCarinaVersion()));
    }

    @Override
    public void onStart(ITestContext context) {
        LOGGER.debug((Object)("CarinaListener->OnTestStart(ITestContext context): " + context.getName()));
        ReportContext.getBaseDir();
        super.onStart(context);
    }

    @Override
    public void beforeConfiguration(ITestResult result) {
        LOGGER.debug((Object)"CarinaListener->beforeConfiguration");
        super.beforeConfiguration(result);
        if (result.getMethod().isBeforeSuiteConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.BEFORE_SUITE);
        }
        if (result.getMethod().isBeforeClassConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.BEFORE_CLASS);
        }
        if (result.getMethod().isBeforeMethodConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.BEFORE_METHOD);
        }
        if (result.getMethod().isAfterMethodConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.AFTER_METHOD);
        }
        if (result.getMethod().isAfterClassConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.AFTER_CLASS);
        }
        if (result.getMethod().isAfterSuiteConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.AFTER_SUITE);
        }
    }

    @Override
    public void onConfigurationFailure(ITestResult result) {
        LOGGER.debug((Object)"CarinaListener->onConfigurationFailure");
        String errorMessage = this.getFailureReason(result);
        this.takeScreenshot(result, "CONFIGURATION FAILED - " + errorMessage);
        super.onConfigurationFailure(result);
    }

    @Override
    public void onTestStart(ITestResult result) {
        LOGGER.debug((Object)"CarinaListener->onTestStart");
        TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.METHOD);
        Method testMethod = result.getMethod().getConstructorOrMethod().getMethod();
        if (ExpectedSkipManager.getInstance().isSkip(testMethod, result.getTestContext())) {
            this.skipExecution("Based on rule listed above");
        }
        super.onTestStart(result);
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        LOGGER.debug((Object)"CarinaListener->onTestSuccess");
        super.onTestSuccess(result);
        this.onTestFinish(result);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        LOGGER.debug((Object)"CarinaListener->onTestFailure");
        String errorMessage = this.getFailureReason(result);
        this.takeScreenshot(result, "TEST FAILED - " + errorMessage);
        super.onTestFailure(result);
        this.onTestFinish(result);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        LOGGER.debug((Object)"CarinaListener->onTestSkipped");
        String errorMessage = this.getFailureReason(result);
        this.takeScreenshot(result, "TEST FAILED - " + errorMessage);
        super.onTestSkipped(result);
        this.onTestFinish(result);
    }

    private boolean hasDependencies(ITestResult result) {
        String methodName = result.getMethod().getMethodName();
        String className = result.getMethod().getTestClass().getName();
        LOGGER.debug((Object)("current method: " + className + "." + methodName));
        List methods = result.getTestContext().getSuite().getAllMethods();
        for (ITestNGMethod method : methods) {
            LOGGER.debug((Object)("analyze method for dependency: " + method.getMethodName()));
            List<String> dependencies = Arrays.asList(method.getMethodsDependedUpon());
            if (!dependencies.contains(methodName) && !dependencies.contains(className + "." + methodName)) continue;
            return true;
        }
        return false;
    }

    private void onTestFinish(ITestResult result) {
        try {
            R.CONFIG.clearTestProperties();
            R.TESTDATA.clearTestProperties();
            R.DATABASE.clearTestProperties();
            R.EMAIL.clearTestProperties();
            R.REPORT.clearTestProperties();
            R.ZAFIRA.clearTestProperties();
            LOGGER.debug((Object)("Test result is : " + result.getStatus()));
            if (automaticDriversCleanup && !this.hasDependencies(result) || result.getStatus() == 2 || result.getStatus() == 3) {
                this.quitDrivers(new TestPhase.Phase[]{TestPhase.Phase.BEFORE_METHOD, TestPhase.Phase.METHOD});
            }
            if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("ALREADY_PASSED")) {
                return;
            }
            if (result.getThrowable() != null && result.getThrowable().getMessage() != null && result.getThrowable().getMessage().startsWith("SKIP_EXECUTION")) {
                return;
            }
            List tickets = Jira.getTickets((ITestResult)result);
            result.setAttribute("JIRA#", (Object)tickets);
            Jira.updateAfterTest((ITestResult)result);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception in CarinaListener->onTestFinish!", (Throwable)e);
        }
    }

    @Override
    public void onFinish(ITestContext context) {
        LOGGER.debug((Object)"CarinaListener->onFinish(ITestContext context)");
        super.onFinish(context);
        this.quitDrivers(new TestPhase.Phase[]{TestPhase.Phase.BEFORE_CLASS});
        LOGGER.debug((Object)("CarinaListener->onFinish(context): " + context.getName()));
        Jira.updateAfterSuite((ITestContext)context, (List)EmailReportItemCollector.getTestResults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish(ISuite suite) {
        LOGGER.debug((Object)"CarinaListener->onFinish(ISuite suite)");
        try {
            ReportContext.removeTempDir();
            String browser = this.getBrowser();
            String deviceName = this.getDeviceName();
            String title = this.getTitle(suite.getXmlSuite());
            TestResultType testResult = EmailReportGenerator.getSuiteResult(EmailReportItemCollector.getTestResults());
            String status = testResult.getName();
            title = status + ": " + title;
            String env = "";
            if (!Configuration.isNull((Configuration.Parameter)Configuration.Parameter.ENV)) {
                env = Configuration.get((Configuration.Parameter)Configuration.Parameter.ENV);
            }
            if (!Configuration.get((Configuration.Parameter)Configuration.Parameter.URL).isEmpty()) {
                env = env + " - <a href='" + Configuration.get((Configuration.Parameter)Configuration.Parameter.URL) + "'>" + Configuration.get((Configuration.Parameter)Configuration.Parameter.URL) + "</a>";
            }
            ReportContext.getTempDir().delete();
            LOGGER.debug((Object)"Generating email report...");
            EmailReportGenerator report = new EmailReportGenerator(title, env, Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION), deviceName, browser, DateUtils.now(), EmailReportItemCollector.getTestResults(), EmailReportItemCollector.getCreatedItems());
            String emailContent = report.getEmailBody();
            ReportContext.generateHtmlReport((String)emailContent);
            this.printExecutionSummary(EmailReportItemCollector.getTestResults());
            TestResultType suiteResult = EmailReportGenerator.getSuiteResult(EmailReportItemCollector.getTestResults());
            switch (suiteResult) {
                case SKIP_ALL: {
                    Assert.fail((String)"All tests were skipped! Analyze logs to determine possible configuration issues.");
                    break;
                }
                case SKIP_ALL_ALREADY_PASSED: {
                    LOGGER.info((Object)"Nothing was executed in rerun mode because all tests already passed and registered in Zafira Repoting Service!");
                    break;
                }
            }
            LOGGER.debug((Object)"Finish email report generation.");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception in CarinaListener->onFinish(ISuite suite)", (Throwable)e);
        }
        finally {
            int counter = 0;
            while (FtpUtils.isUploading() && ++counter < 30) {
                LOGGER.info((Object)("waiting to finish FTP uploading... " + counter + " sec."));
                CommonUtils.pause((Number)1);
            }
        }
    }

    public static void disableDriversCleanup() {
        automaticDriversCleanup = false;
    }

    private String getDeviceName() {
        String deviceName = "Desktop";
        if (!IDriverPool.getDefaultDevice().isNull()) {
            Device device = IDriverPool.getDefaultDevice();
            String deviceTemplate = "%s - %s %s";
            deviceName = String.format(deviceTemplate, device.getName(), device.getOs(), device.getOsVersion());
        }
        return deviceName;
    }

    protected String getBrowser() {
        return Configuration.getBrowser();
    }

    protected String getTitle(XmlSuite suite) {
        String browser = this.getBrowser();
        if (!browser.isEmpty()) {
            browser = " " + browser;
        }
        String device = this.getDeviceName();
        String env = !Configuration.isNull((Configuration.Parameter)Configuration.Parameter.ENV) ? Configuration.get((Configuration.Parameter)Configuration.Parameter.ENV) : Configuration.get((Configuration.Parameter)Configuration.Parameter.URL);
        String title = "";
        String app_version = "";
        if (!Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION).isEmpty()) {
            app_version = Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION) + " - ";
        }
        String suiteName = this.getSuiteName(suite);
        String xmlFile = this.getSuiteFileName(suite);
        title = String.format(SUITE_TITLE, app_version, suiteName, String.format(XML_SUITE_NAME, xmlFile), env, device, browser);
        return title;
    }

    private String getSuiteFileName(XmlSuite suite) {
        String fileName = suite.getFileName();
        if (fileName == null) {
            fileName = "undefined";
        }
        LOGGER.debug((Object)("Full suite file name: " + fileName));
        if (fileName.contains("\\")) {
            fileName = fileName.replaceAll("\\\\", "/");
        }
        fileName = StringUtils.substringAfterLast((String)fileName, (String)"/");
        LOGGER.debug((Object)("Short suite file name: " + fileName));
        return fileName;
    }

    protected String getSuiteName(XmlSuite suite) {
        String suiteName = "";
        suiteName = suite != null && !"Default suite".equals(suite.getName()) ? (Configuration.get((Configuration.Parameter)Configuration.Parameter.SUITE_NAME).isEmpty() ? suite.getName() : Configuration.get((Configuration.Parameter)Configuration.Parameter.SUITE_NAME)) : (Configuration.get((Configuration.Parameter)Configuration.Parameter.SUITE_NAME).isEmpty() ? R.EMAIL.get("title") : Configuration.get((Configuration.Parameter)Configuration.Parameter.SUITE_NAME));
        return suiteName;
    }

    private void printExecutionSummary(List<TestResultItem> tris) {
        Messager.INROMATION.info(new String[]{"**************** Test execution summary ****************"});
        int num = 1;
        for (TestResultItem tri : tris) {
            String failReason = tri.getFailReason();
            if (failReason == null) {
                failReason = "";
            }
            if (tri.isConfig() || failReason.contains("ALREADY_PASSED") || failReason.contains("SKIP_EXECUTION")) continue;
            String reportLinks = !StringUtils.isEmpty((CharSequence)tri.getLinkToScreenshots()) ? "screenshots=" + tri.getLinkToScreenshots() + " | " : "";
            reportLinks = reportLinks + (!StringUtils.isEmpty((CharSequence)tri.getLinkToLog()) ? "log=" + tri.getLinkToLog() : "");
            Messager.TEST_RESULT.info(new String[]{String.valueOf(num++), tri.getTest(), tri.getResult().toString(), reportLinks});
        }
    }

    @Deprecated
    protected void setJiraTicket(String ... tickets) {
        ArrayList<String> jiraTickets = new ArrayList<String>();
        for (String ticket : tickets) {
            jiraTickets.add(ticket);
        }
        Jira.setTickets(jiraTickets);
    }

    protected void putS3Artifact(String key, String path) {
        AmazonS3Manager.getInstance().put(Configuration.get((Configuration.Parameter)Configuration.Parameter.S3_BUCKET_NAME), key, path);
    }

    protected S3Object getS3Artifact(String bucket, String key) {
        return AmazonS3Manager.getInstance().get(Configuration.get((Configuration.Parameter)Configuration.Parameter.S3_BUCKET_NAME), key);
    }

    protected S3Object getS3Artifact(String key) {
        return this.getS3Artifact(Configuration.get((Configuration.Parameter)Configuration.Parameter.S3_BUCKET_NAME), key);
    }

    private static void updateAppPath() {
        try {
            if (!Configuration.get((Configuration.Parameter)Configuration.Parameter.ACCESS_KEY_ID).isEmpty()) {
                CarinaListener.updateS3AppPath();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"AWS S3 manager exception detected!", (Throwable)e);
        }
        try {
            if (!Configuration.get((Configuration.Parameter)Configuration.Parameter.APPCENTER_TOKEN).isEmpty()) {
                CarinaListener.updateAppCenterAppPath();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"AppCenter manager exception detected!", (Throwable)e);
        }
    }

    private static void updateAppCenterAppPath() {
        Pattern APPCENTER_PATTERN = Pattern.compile("appcenter:\\/\\/([a-zA-Z-0-9][^\\/]*)\\/([a-zA-Z-0-9][^\\/]*)\\/([a-zA-Z-0-9][^\\/]*)\\/([a-zA-Z-0-9][^\\/]*)");
        String mobileAppPath = Configuration.getMobileApp();
        Matcher matcher = APPCENTER_PATTERN.matcher(mobileAppPath);
        LOGGER.info((Object)"Analyzing if mobile_app is located on AppCenter...");
        if (matcher.find()) {
            LOGGER.info((Object)"app artifact is located on AppCenter...");
            String appName = matcher.group(1);
            String platformName = matcher.group(2);
            String buildType = matcher.group(3);
            String version = matcher.group(4);
            String appCenterAppLocalStorage = Configuration.get((Configuration.Parameter)Configuration.Parameter.APPCENTER_LOCAL_STORAGE);
            File file = AppCenterManager.getInstance().getBuild(appCenterAppLocalStorage, appName, platformName, buildType, version);
            Configuration.setMobileApp((String)file.getAbsolutePath());
            LOGGER.info((Object)("Updated mobile app: " + Configuration.getMobileApp()));
            String appVersion = Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION);
            if (appVersion.equals("latest") || appVersion.isEmpty()) {
                R.CONFIG.put(Configuration.Parameter.APP_VERSION.getKey(), file.getName());
            }
        }
    }

    private static void updateS3AppPath() {
        Pattern S3_BUCKET_PATTERN = Pattern.compile("s3:\\/\\/([a-zA-Z-0-9][^\\/]*)\\/(.*)");
        String mobileAppPath = Configuration.getMobileApp();
        Matcher matcher = S3_BUCKET_PATTERN.matcher(mobileAppPath);
        LOGGER.info((Object)"Analyzing if mobile app is located on S3...");
        if (matcher.find()) {
            int slashPosition;
            LOGGER.info((Object)"app artifact is located on s3...");
            String bucketName = matcher.group(1);
            String key = matcher.group(2);
            Pattern pattern = Pattern.compile(key);
            int position = key.indexOf(".*");
            if (position > 0 && (slashPosition = key.substring(0, position).lastIndexOf("/")) > 0) {
                key = key.substring(0, slashPosition);
                S3ObjectSummary lastBuild = AmazonS3Manager.getInstance().getLatestBuildArtifact(bucketName, key, pattern);
                key = lastBuild.getKey();
            }
            if (Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.S3_USE_PRESIGN_URL)) {
                long hours = 28800000L;
                String presignedAppUrl = AmazonS3Manager.getInstance().generatePreSignUrl(bucketName, key, hours).toString();
                LOGGER.debug((Object)("preSigned URL: " + presignedAppUrl));
                Configuration.setMobileApp((String)presignedAppUrl);
            } else {
                S3Object objBuild = AmazonS3Manager.getInstance().get(bucketName, key);
                String s3LocalStorage = Configuration.get((Configuration.Parameter)Configuration.Parameter.S3_LOCAL_STORAGE);
                String fileName = s3LocalStorage + "/" + StringUtils.substringAfterLast((String)objBuild.getKey(), (String)"/");
                File file = new File(fileName);
                if (file.exists() && file.length() == objBuild.getObjectMetadata().getContentLength()) {
                    LOGGER.info((Object)("build artifact with the same size already downloaded: " + file.getAbsolutePath()));
                } else {
                    LOGGER.info((Object)String.format("Following data was extracted: bucket: %s, key: %s, local file: %s", bucketName, key, file.getAbsolutePath()));
                    AmazonS3Manager.getInstance().download(bucketName, key, new File(fileName));
                }
                Configuration.setMobileApp((String)file.getAbsolutePath());
                String appVersion = Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION);
                if (appVersion.equals("latest") || appVersion.isEmpty()) {
                    R.CONFIG.put(Configuration.Parameter.APP_VERSION.getKey(), file.getName());
                }
            }
        }
    }

    protected void skipExecution(String message) {
        throw new SkipException("SKIP_EXECUTION: " + message);
    }

    protected void onHealthCheck(ISuite suite) {
        String healthCheckClass = Configuration.get((Configuration.Parameter)Configuration.Parameter.HEALTH_CHECK_CLASS);
        if (suite.getParameter(Configuration.Parameter.HEALTH_CHECK_CLASS.getKey()) != null) {
            healthCheckClass = suite.getParameter(Configuration.Parameter.HEALTH_CHECK_CLASS.getKey());
        }
        String healthCheckMethods = Configuration.get((Configuration.Parameter)Configuration.Parameter.HEALTH_CHECK_METHODS);
        if (suite.getParameter(Configuration.Parameter.HEALTH_CHECK_METHODS.getKey()) != null) {
            healthCheckMethods = suite.getParameter(Configuration.Parameter.HEALTH_CHECK_METHODS.getKey());
        }
        String[] healthCheckMethodsArray = null;
        if (!healthCheckMethods.isEmpty()) {
            healthCheckMethodsArray = healthCheckMethods.split(",");
        }
        this.checkHealth(suite, healthCheckClass, healthCheckMethodsArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHealth(ISuite suite, String className, String[] methods) {
        if (className.isEmpty()) {
            return;
        }
        XmlSuite xmlSuite = new XmlSuite();
        xmlSuite.setName("HealthCheck XmlSuite - " + className);
        XmlTest xmlTest = new XmlTest(xmlSuite);
        xmlTest.setName("HealthCheck TestCase");
        XmlClass xmlHealthCheckClass = new XmlClass();
        xmlHealthCheckClass.setName(className);
        int expectedMethodsCount = -1;
        if (methods != null) {
            List<XmlInclude> methodsToRun = this.constructIncludes(methods);
            expectedMethodsCount = methodsToRun.size();
            xmlHealthCheckClass.setIncludedMethods(methodsToRun);
        }
        xmlTest.setXmlClasses(Arrays.asList(xmlHealthCheckClass));
        xmlSuite.setTests(Arrays.asList(xmlTest));
        LOGGER.info((Object)("HealthCheck '" + className + "' is started."));
        LOGGER.debug((Object)("HealthCheck suite content:" + xmlSuite.toXml()));
        TestNG testng = new TestNG();
        testng.setXmlSuites(Arrays.asList(xmlSuite));
        TestListenerAdapter tla = new TestListenerAdapter();
        testng.addListener((ITestNGListener)tla);
        testng.run();
        CarinaListener carinaListener = this;
        synchronized (carinaListener) {
            boolean passed = false;
            if (expectedMethodsCount == -1) {
                if (tla.getPassedTests().size() > 0 && tla.getFailedTests().size() == 0 && tla.getSkippedTests().size() == 0) {
                    passed = true;
                }
            } else {
                LOGGER.info((Object)("Expected passed tests count: " + expectedMethodsCount));
                if (tla.getPassedTests().size() == expectedMethodsCount && tla.getFailedTests().size() == 0 && tla.getSkippedTests().size() == 0) {
                    passed = true;
                }
            }
            if (!passed) {
                throw new SkipException("Skip test(s) due to health check failures for '" + className + "'");
            }
            LOGGER.info((Object)("HealthCheck suite '" + className + "' is finished successfully."));
        }
    }

    private List<XmlInclude> constructIncludes(String ... methodNames) {
        ArrayList<XmlInclude> includes = new ArrayList<XmlInclude>();
        for (String eachMethod : methodNames) {
            includes.add(new XmlInclude(eachMethod));
        }
        return includes;
    }

    private String takeScreenshot(ITestResult result, String msg) {
        String screenId = "";
        ConcurrentHashMap drivers = this.getDrivers();
        try {
            for (Map.Entry entry : drivers.entrySet()) {
                String driverName = (String)entry.getKey();
                WebDriver drv = ((CarinaDriver)entry.getValue()).getDriver();
                if (drv instanceof EventFiringWebDriver) {
                    drv = ((EventFiringWebDriver)drv).getWrappedDriver();
                }
                if (!Screenshot.isEnabled()) continue;
                screenId = Screenshot.capture((WebDriver)drv, (String)(driverName + ": " + msg), (boolean)true);
            }
        }
        catch (Throwable thr) {
            LOGGER.error((Object)"Failure detected on screenshot generation after failure: ", thr);
        }
        return screenId;
    }

    private String getAttributeValue(ISuite suite, String attribute) {
        String res = "";
        File file = new File(suite.getXmlSuite().getFileName());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                Node nodeAttribute;
                Node nodeName;
                NamedNodeMap nodeMapAttributes = document.getChildNodes().item(i).getAttributes();
                if (nodeMapAttributes == null || (nodeName = nodeMapAttributes.getNamedItem("name")) == null || !suite.getName().equals(nodeName.getNodeValue()) || (nodeAttribute = nodeMapAttributes.getNamedItem(attribute)) == null) continue;
                res = nodeAttribute.getNodeValue();
                break;
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Unable to get attribute '" + attribute + "' from suite: " + suite.getXmlSuite().getFileName()), (Throwable)e);
        }
        return res;
    }

    private void setThreadCount(ISuite suite) {
        if (Configuration.getInt((Configuration.Parameter)Configuration.Parameter.THREAD_COUNT) >= 1) {
            suite.getXmlSuite().setThreadCount(Configuration.getInt((Configuration.Parameter)Configuration.Parameter.THREAD_COUNT));
            LOGGER.debug((Object)("Updated thread_count=" + suite.getXmlSuite().getThreadCount()));
        } else {
            String suiteThreadCount = this.getAttributeValue(suite, "thread-count");
            LOGGER.debug((Object)("thread-count from suite: " + suiteThreadCount));
            if (suiteThreadCount.isEmpty()) {
                LOGGER.info((Object)"Set thread_count=1");
                R.CONFIG.put(Configuration.Parameter.THREAD_COUNT.getKey(), "1");
                suite.getXmlSuite().setThreadCount(1);
            } else {
                LOGGER.debug((Object)"Synching thread_count with values from suite xml file...");
                R.CONFIG.put(Configuration.Parameter.THREAD_COUNT.getKey(), suiteThreadCount);
                LOGGER.info((Object)("Use thread_count='" + suite.getXmlSuite().getThreadCount() + "' from suite file."));
            }
        }
        if (Configuration.getInt((Configuration.Parameter)Configuration.Parameter.DATA_PROVIDER_THREAD_COUNT) >= 1) {
            suite.getXmlSuite().setDataProviderThreadCount(Configuration.getInt((Configuration.Parameter)Configuration.Parameter.DATA_PROVIDER_THREAD_COUNT));
            LOGGER.debug((Object)("Updated data_provider_thread_count=" + suite.getXmlSuite().getDataProviderThreadCount()));
        } else {
            String suiteDataProviderThreadCount = this.getAttributeValue(suite, "data-provider-thread-count");
            LOGGER.debug((Object)("data-provider-thread-count from suite: " + suiteDataProviderThreadCount));
            if (suiteDataProviderThreadCount.isEmpty()) {
                LOGGER.info((Object)"Set data_provider_thread_count=1");
                R.CONFIG.put(Configuration.Parameter.DATA_PROVIDER_THREAD_COUNT.getKey(), "1");
                suite.getXmlSuite().setDataProviderThreadCount(1);
            } else {
                LOGGER.debug((Object)"Synching data_provider_thread_count with values from suite xml file...");
                R.CONFIG.put(Configuration.Parameter.DATA_PROVIDER_THREAD_COUNT.getKey(), suiteDataProviderThreadCount);
                LOGGER.info((Object)("Use data_provider_thread_count='" + suite.getXmlSuite().getDataProviderThreadCount() + "' from suite file."));
            }
        }
    }

    private String getCarinaVersion() {
        String carinaVersion = "";
        try {
            Class<CarinaListener> theClass = CarinaListener.class;
            String classPath = theClass.getResource(theClass.getSimpleName() + ".class").toString();
            LOGGER.debug((Object)("Class: " + classPath));
            Pattern pattern = Pattern.compile(".*\\/(.*)\\/.*!");
            Matcher matcher = pattern.matcher(classPath);
            if (matcher.find()) {
                carinaVersion = matcher.group(1);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
        }
        return carinaVersion;
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            URL log4jUrl = ClassLoader.getSystemResource("carina-log4j.properties");
            LOGGER.debug((Object)("carina-log4j.properties: " + log4jUrl));
            PropertyConfigurator.configure((URL)log4jUrl);
            LOGGER.info((Object)Configuration.asString());
            try {
                L10N.init();
            }
            catch (Exception e) {
                LOGGER.error((Object)"L10N bundle is not initialized successfully!", (Throwable)e);
            }
            try {
                L10Nparser.init();
            }
            catch (Exception e) {
                LOGGER.error((Object)"L10Nparser bundle is not initialized successfully!", (Throwable)e);
            }
            String customCapabilities = Configuration.get((Configuration.Parameter)Configuration.Parameter.CUSTOM_CAPABILITIES);
            if (!customCapabilities.isEmpty()) {
                new CapabilitiesLoader().loadCapabilities(customCapabilities);
            }
            AutoScreenshotRule autoScreenshotsRule = new AutoScreenshotRule();
            Screenshot.addScreenshotRule((IScreenshotRule)autoScreenshotsRule);
            CarinaListener.updateAppPath();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Undefined failure during static carina listener init!", (Throwable)e);
        }
    }

    public static class ShutdownHook
    extends Thread {
        private static final Logger LOGGER = Logger.getLogger(ShutdownHook.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateMetadata() {
            Map allData = MetadataCollector.getAllCollectedData();
            if (allData.size() > 0) {
                LOGGER.debug((Object)"Generating collected metadada start...");
            }
            for (String key : allData.keySet()) {
                LOGGER.debug((Object)("Creating... medata for '" + key + "' object..."));
                File file = new File(ReportContext.getArtifactsFolder().getAbsolutePath() + "/metadata/" + key.hashCode() + ".json");
                try (PrintWriter out = null;){
                    out = new PrintWriter(file);
                    out.append(JsonUtils.toJson(MetadataCollector.getAllCollectedData().get(key)));
                    out.flush();
                }
                LOGGER.debug((Object)("Created medata for '" + key + "' object..."));
            }
            if (allData.size() > 0) {
                LOGGER.debug((Object)"Generating collected metadada finish...");
            }
        }

        private void quitAllDriversOnHook() {
            if (ZafiraSingleton.INSTANCE.isRunning()) {
                LOGGER.debug((Object)"Zafira test run is still in progress. trying to abort...");
                try {
                    Optional testRun = ZafiraEventRegistrar.getTestRun();
                    if (testRun != null) {
                        LOGGER.debug((Object)("detected testrun id to abort: " + ((TestRunType)testRun.get()).getId()));
                        ZafiraSingleton.INSTANCE.getClient().abortTestRun(((TestRunType)testRun.get()).getId());
                        LOGGER.debug((Object)"aborted testrun");
                    }
                }
                catch (NoSuchElementException e) {
                    LOGGER.debug((Object)"No Zafira testrun detected.");
                }
            }
            for (CarinaDriver carinaDriver : IDriverPool.driversPool) {
                String name = carinaDriver.getName();
                LOGGER.warn((Object)("Trying to quit driver '" + name + "' on shutdown hook action!"));
                carinaDriver.getDevice().disconnectRemote();
                ProxyPool.stopProxy();
                try {
                    LOGGER.debug((Object)("Driver exiting..." + name));
                    carinaDriver.getDriver().quit();
                    LOGGER.debug((Object)("Driver exited..." + name));
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void run() {
            LOGGER.debug((Object)"Running shutdown hook");
            this.quitAllDriversOnHook();
            this.generateMetadata();
        }
    }
}

