/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.qaprosoft.carina.core.foundation.filter.Filter;
import com.qaprosoft.carina.core.foundation.filter.IFilter;
import com.qaprosoft.carina.core.foundation.filter.rule.Rule;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestNGMethod;

public class FilterTestsListener
implements ISuiteListener {
    private static final Logger LOGGER = Logger.getLogger(FilterTestsListener.class);
    private List<Rule> rules = new ArrayList<Rule>();

    public void onStart(ISuite suite) {
        this.rules = this.parseRules(Configuration.get((Configuration.Parameter)Configuration.Parameter.TEST_RUN_RULES));
        if (this.rules.isEmpty()) {
            LOGGER.info((Object)"There are no any rules and limitations");
            return;
        }
        LOGGER.info((Object)"Extracted rules: ".concat(this.rules.toString()));
        for (ITestNGMethod testMethod : suite.getAllMethods()) {
            boolean isPerform = true;
            for (Rule rule : this.rules) {
                if (!isPerform) break;
                isPerform = rule.getTestFilter().isPerform(testMethod, rule.getRuleValues());
            }
            if (isPerform) continue;
            this.disableTest(testMethod);
        }
    }

    public void onFinish(ISuite suite) {
    }

    private void disableTest(ITestNGMethod testMethod) {
        LOGGER.info((Object)String.format("Disable test: [%s]", testMethod.getMethodName()));
        testMethod.setInvocationCount(0);
    }

    private List<Rule> parseRules(String ruleStr) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (!ruleStr.isEmpty()) {
            LOGGER.info((Object)"Rules for suite limitation have been defined.");
            if (ruleStr.contains("&amp;&amp;")) {
                ruleStr = ruleStr.replaceAll("&amp;&amp;", "&&");
            }
            for (String ruleItem : ruleStr.split(";;")) {
                String[] ruleStructure = ruleItem.split("=>");
                String[] ruleValues = ruleStructure[1].split("&&");
                IFilter filter = Filter.PRIORITY.getRuleByName(ruleStructure[0]).getFilter();
                Rule rule = new Rule(ruleStructure[0], filter, Arrays.asList(ruleValues));
                LOGGER.info((Object)"Following rule will be added: ".concat(rule.toString()));
                rules.add(rule);
            }
        }
        return rules;
    }
}

