/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.report;

import com.qaprosoft.carina.core.foundation.jira.Jira;
import com.qaprosoft.carina.core.foundation.listeners.TestNamingListener;
import com.qaprosoft.carina.core.foundation.performance.Timer;
import com.qaprosoft.carina.core.foundation.report.Artifacts;
import com.qaprosoft.carina.core.foundation.report.qtest.IQTestManager;
import com.qaprosoft.carina.core.foundation.report.testrail.ITestRailManager;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.ownership.Ownership;
import com.qaprosoft.carina.core.foundation.utils.tag.PriorityManager;
import com.qaprosoft.carina.core.foundation.utils.tag.TagManager;
import com.qaprosoft.carina.core.foundation.webdriver.IDriverPool;
import com.qaprosoft.carina.core.foundation.webdriver.device.Device;
import com.qaprosoft.zafira.config.IConfigurator;
import com.qaprosoft.zafira.listener.adapter.SuiteAdapter;
import com.qaprosoft.zafira.listener.adapter.TestResultAdapter;
import com.qaprosoft.zafira.models.db.workitem.BaseWorkItem;
import com.qaprosoft.zafira.models.dto.TagType;
import com.qaprosoft.zafira.models.dto.TestArtifactType;
import com.qaprosoft.zafira.models.dto.config.ArgumentType;
import com.qaprosoft.zafira.models.dto.config.ConfigurationType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.testng.ISuite;
import org.testng.ITestResult;

public class ZafiraConfigurator
implements IConfigurator,
ITestRailManager,
IQTestManager {
    private static final Logger LOGGER = Logger.getLogger(ZafiraConfigurator.class);

    public ConfigurationType getConfiguration() {
        String browserVersion;
        String browser;
        String platformVersion;
        ConfigurationType conf = new ConfigurationType();
        for (Configuration.Parameter parameter : Configuration.Parameter.values()) {
            conf.getArg().add(this.buildArgumentType(parameter.getKey(), R.CONFIG.get(parameter.getKey())));
        }
        String platform = Configuration.getPlatform();
        if (!platform.isEmpty() && !"*".equalsIgnoreCase(platform)) {
            LOGGER.debug((Object)("Detected platform: '" + platform + "';"));
            conf.getArg().add(this.buildArgumentType("platform", platform));
        }
        if (!(platformVersion = Configuration.getPlatformVersion()).isEmpty()) {
            LOGGER.debug((Object)("Detected platform_version: '" + platformVersion + "';"));
            conf.getArg().add(this.buildArgumentType("platform_version", platformVersion));
        }
        if (!(browser = Configuration.getBrowser()).isEmpty()) {
            LOGGER.debug((Object)("Detected browser: '" + browser + "';"));
            conf.getArg().add(this.buildArgumentType("browser", browser));
        }
        if (!(browserVersion = Configuration.getBrowserVersion()).isEmpty()) {
            LOGGER.debug((Object)("Detected browser_version: '" + browserVersion + "';"));
            conf.getArg().add(this.buildArgumentType("browser_version", browserVersion));
        }
        long threadId = Thread.currentThread().getId();
        Device device = IDriverPool.getDefaultDevice();
        if (!device.getName().isEmpty()) {
            String deviceName = device.getName();
            String deviceOs = device.getOs();
            String deviceOsVersion = device.getOsVersion();
            conf.getArg().add(this.buildArgumentType("device", deviceName));
            conf.getArg().add(this.buildArgumentType("platform", deviceOs));
            conf.getArg().add(this.buildArgumentType("platform_version", deviceOsVersion));
            LOGGER.debug((Object)("Detected device: '" + deviceName + "'; os: '" + deviceOs + "'; os version: '" + deviceOsVersion + "'"));
        } else {
            LOGGER.debug((Object)("Unable to detect current device for threadId: " + threadId));
        }
        return conf;
    }

    private ArgumentType buildArgumentType(String key, String value) {
        ArgumentType arg = new ArgumentType();
        arg.setKey(key);
        arg.setValue("NULL".equalsIgnoreCase(value) ? null : value);
        return arg;
    }

    public String getOwner(SuiteAdapter suiteAdapter) {
        ISuite suite = (ISuite)suiteAdapter.getSuite();
        String owner = suite.getParameter("suiteOwner");
        LOGGER.debug((Object)("owner: " + owner));
        return owner != null ? owner : "";
    }

    public String getPrimaryOwner(TestResultAdapter testResultAdapter) {
        ITestResult test = (ITestResult)testResultAdapter.getTestResult();
        String primaryOwner = Ownership.getMethodOwner((ITestResult)test);
        LOGGER.debug((Object)("primaryOwner: " + primaryOwner));
        return primaryOwner;
    }

    public String getSecondaryOwner(TestResultAdapter testResultAdapter) {
        ITestResult test = (ITestResult)testResultAdapter.getTestResult();
        String secondaryOwner = Ownership.getMethodOwner((ITestResult)test);
        LOGGER.debug((Object)("secondaryOwner: " + secondaryOwner));
        return secondaryOwner;
    }

    public String getTestName(TestResultAdapter testResultAdapter) {
        ITestResult testResult = (ITestResult)testResultAdapter.getTestResult();
        return TestNamingListener.getTestName((ITestResult)testResult);
    }

    public String getTestMethodName(TestResultAdapter testResultAdapter) {
        ITestResult testResult = (ITestResult)testResultAdapter.getTestResult();
        return testResult.getMethod().getMethodName();
    }

    public List<String> getTestWorkItems(TestResultAdapter testResultAdapter) {
        ITestResult test = (ITestResult)testResultAdapter.getTestResult();
        return Jira.getTickets((ITestResult)test);
    }

    public BaseWorkItem getTestKnownIssue(TestResultAdapter testResultAdapter) {
        return Jira.getKnownIssue();
    }

    public void clearTestWorkItemArtifacts() {
        Jira.clearJiraArtifacts();
    }

    public int getRunCount(TestResultAdapter testResultAdapter) {
        return 0;
    }

    public Map<String, Long> getTestMetrics(TestResultAdapter testResultAdapter) {
        return Timer.readAndClear();
    }

    public Set<TagType> getTestTags(TestResultAdapter testResultAdapter) {
        LOGGER.debug((Object)"Collecting TestTags...");
        ITestResult test = (ITestResult)testResultAdapter.getTestResult();
        HashSet<TagType> tags = new HashSet<TagType>();
        String testPriority = PriorityManager.getPriority((ITestResult)test);
        if (testPriority != null && !testPriority.isEmpty()) {
            TagType priority = new TagType();
            priority.setName("priority");
            priority.setValue(testPriority);
            tags.add(priority);
        }
        Map testTags = TagManager.getTags((ITestResult)test);
        testTags.forEach((name, value) -> {
            TagType tagEntry = new TagType();
            tagEntry.setName(name);
            tagEntry.setValue(value);
            tags.add(tagEntry);
        });
        tags.addAll(this.getTestRailTags(test));
        tags.addAll(this.getQTestTags(test));
        LOGGER.debug((Object)("Found " + tags.size() + " new TestTags"));
        return tags;
    }

    public Set<TestArtifactType> getArtifacts(TestResultAdapter testResultAdapter) {
        LOGGER.debug((Object)"Collecting artifacts...");
        return Artifacts.getArtifacts();
    }

    public void clearArtifacts() {
        Artifacts.clearArtifacts();
    }

    private Set<TagType> getTestRailTags(ITestResult test) {
        LOGGER.debug((Object)"Collecting TestRail Tags...");
        HashSet<TagType> tags = new HashSet<TagType>();
        Set testRailTags = this.getTestRailCasesUuid(test);
        int projectID = this.getTestRailProjectId(test.getTestContext());
        int suiteID = this.getTestRailSuiteId(test.getTestContext());
        if (projectID != -1 && suiteID != -1) {
            testRailTags.forEach(entry -> {
                TagType tagEntry = new TagType();
                tagEntry.setName("TESTRAIL_TESTCASE_UUID");
                tagEntry.setValue(projectID + "-" + suiteID + "-" + entry);
                tags.add(tagEntry);
            });
        }
        LOGGER.debug((Object)("Found " + tags.size() + " new TestRail tags"));
        return tags;
    }

    private Set<TagType> getQTestTags(ITestResult test) {
        LOGGER.debug((Object)"Collecting qTest Tags...");
        HashSet<TagType> tags = new HashSet<TagType>();
        Set qTestTags = this.getQTestCasesUuid(test);
        int projectID = this.getQTestProjectId(test.getTestContext());
        if (projectID != -1) {
            qTestTags.forEach(entry -> {
                TagType tagEntry = new TagType();
                tagEntry.setName("QTEST_TESTCASE_UUID");
                tagEntry.setValue(projectID + "-" + entry);
                tags.add(tagEntry);
            });
        }
        LOGGER.debug((Object)("Found " + tags.size() + " new qTest tags"));
        return tags;
    }
}

