/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.utils.resources;

import com.qaprosoft.carina.core.foundation.report.ReportContext;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.resources.L10N;
import com.qaprosoft.carina.core.foundation.utils.resources.LocaleReader;
import com.qaprosoft.carina.core.foundation.webdriver.decorator.ExtendedWebElement;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class L10Nparser {
    private static final Logger LOGGER = Logger.getLogger(L10Nparser.class);
    public static Locale actualLocale;
    public static String assertErrorMsg;
    public static boolean newLocalization;
    public static LinkedList<String> newLocList;
    public static Properties prop;
    public static String propFileName;
    private static String encoding;
    protected static final int BASIC_WAIT_SHORT_TIMEOUT = 5;

    public static void init() {
    }

    public static Locale getActualLocale() {
        return actualLocale;
    }

    public static String getAssertErrorMsg() {
        return assertErrorMsg;
    }

    public static boolean getNewLocalization() {
        return newLocalization;
    }

    public static void setActualLocale(String countryCode) {
        List locales = LocaleReader.init((String)Configuration.get((Configuration.Parameter)Configuration.Parameter.LOCALE));
        Locale locale = (Locale)locales.get(0);
        try {
            String[] localeSetttings = countryCode.split("_");
            String country = "";
            String lang = localeSetttings[0];
            if (localeSetttings.length > 1) {
                country = localeSetttings[1];
            }
            locale = new Locale(lang, country);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        L10Nparser.setActualLocale(locale);
    }

    public static void setActualLocale(Locale locale) {
        L10Nparser.setActualLocale(locale, false);
    }

    public static void setActualLocale(Locale locale, boolean updateConfig) {
        LOGGER.info((Object)("Set actual Locale to " + locale));
        actualLocale = locale;
        if (updateConfig) {
            R.CONFIG.put(Configuration.Parameter.LOCALE.getKey(), actualLocale.toString());
            String savedLocale = R.CONFIG.get(Configuration.Parameter.LOCALE.getKey());
            LOGGER.debug((Object)("Saved actualLocale in config =" + savedLocale));
            List locales = LocaleReader.init((String)Configuration.get((Configuration.Parameter)Configuration.Parameter.LOCALE));
            LOGGER.debug((Object)("First locale from LocaleReader=" + ((Locale)locales.get(0)).toString()));
        }
        if (L10Nparser.getAddNewLocalization()) {
            try {
                propFileName = L10Nparser.getPropertyFileName(actualLocale.toString());
                LOGGER.info((Object)("propFileName:=" + propFileName));
                FileInputStream in = new FileInputStream(propFileName);
                prop.load(in);
                in.close();
            }
            catch (Exception e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean getAddNewLocalization() {
        boolean ret = false;
        if (!newLocalization) {
            try {
                String add_new = Configuration.get((Configuration.Parameter)Configuration.Parameter.ADD_NEW_LOCALIZATION);
                if (add_new.toLowerCase().contains("true")) {
                    LOGGER.info((Object)"New localization will be added.");
                    newLocalization = true;
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private static String getPropertyFileName(String localName) {
        String add_new_loc_path = "null";
        String add_new_loc_name = "null";
        try {
            add_new_loc_path = Configuration.get((Configuration.Parameter)Configuration.Parameter.ADD_NEW_LOCALIZATION_PATH);
            add_new_loc_name = Configuration.get((Configuration.Parameter)Configuration.Parameter.ADD_NEW_LOCALIZATION_PROPERTY_NAME);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Using default parameters because of error: " + e));
        }
        if (add_new_loc_path.toLowerCase().contains("null") || add_new_loc_path.toLowerCase().contains("{must_override}") || add_new_loc_path.isEmpty()) {
            add_new_loc_path = ReportContext.getArtifactsFolder().getAbsolutePath();
        }
        if (add_new_loc_name.toLowerCase().contains("null") || add_new_loc_name.toLowerCase().contains("{must_override}") || add_new_loc_name.isEmpty()) {
            add_new_loc_name = "new_localization_";
        }
        String ret = add_new_loc_path + "\\" + add_new_loc_name + localName + ".properties";
        return ret;
    }

    public static boolean checkLocalizationText(ExtendedWebElement elem) {
        return L10Nparser.checkLocalizationText(elem, true);
    }

    public static boolean checkLocalizationText(ExtendedWebElement elem, boolean skipMissed) {
        return L10Nparser.checkLocalizationText(elem, skipMissed, 5, false);
    }

    public static boolean checkLocalizationText(ExtendedWebElement elem, boolean skipMissed, int timeout, boolean skipPunctuationAndNumbers) {
        if (elem.isElementPresent((long)timeout)) {
            String elemText = elem.getText();
            String locKey = elem.getName();
            return L10Nparser.checkLocalizationText(elemText, locKey, skipPunctuationAndNumbers);
        }
        LOGGER.info((Object)("Expected element not present. Please check: " + elem));
        if (skipMissed) {
            LOGGER.info((Object)("Skip missed element: " + elem));
            return true;
        }
        return false;
    }

    public static boolean checkLocalizationText(ExtendedWebElement elem, String locKey) {
        return L10Nparser.checkLocalizationText(elem, locKey, 5, false);
    }

    public static boolean checkLocalizationText(ExtendedWebElement elem, String locKey, int timeout, boolean skipPunctuationAndNumbers) {
        if (elem.isElementPresent((long)timeout)) {
            String elemText = elem.getText();
            return L10Nparser.checkLocalizationText(elemText, locKey, skipPunctuationAndNumbers);
        }
        LOGGER.info((Object)("Expected element not present. Please check:" + elem));
        return false;
    }

    public static boolean checkLocalizationText(String expectedText, String locKey, boolean skipPunctuationAndNumbers) {
        String l10n_default = L10N.getText((String)locKey, (Locale)actualLocale);
        boolean ret = skipPunctuationAndNumbers ? L10Nparser.removeNumbersAndPunctuation(expectedText).toLowerCase().contains(L10Nparser.removeNumbersAndPunctuation(l10n_default).toLowerCase()) : expectedText.contains(l10n_default);
        if (!ret) {
            if (!newLocalization) {
                LOGGER.error((Object)("Actual text should be localized and be equal to: '" + l10n_default + "'. But currently it is '" + expectedText + "'."));
                assertErrorMsg = "Expected: '" + l10n_default + "', length=" + l10n_default.length() + ". Actually: '" + expectedText + "', length=" + expectedText.length() + ".";
                return false;
            }
            if (skipPunctuationAndNumbers) {
                expectedText = L10Nparser.removeNumbersAndPunctuation(expectedText);
            }
            String newItem = locKey + "=" + expectedText;
            LOGGER.info((Object)("Making new localization string: " + newItem));
            newLocList.add(newItem);
            prop.setProperty(locKey, expectedText);
            return true;
        }
        LOGGER.debug((Object)("Found localization text '" + expectedText + "' in ISO-8859-1 encoding : " + l10n_default));
        return true;
    }

    private static String removeNumbersAndPunctuation(String str) {
        try {
            str = str.replaceAll("[0-9]", "");
            str = str.replace("!", "").replace("\u0085", "").replace("\u2026", "");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return str;
    }

    public static boolean checkMultipleLocalization(ExtendedWebElement[] localizationCheckList) {
        return L10Nparser.checkMultipleLocalization(localizationCheckList, 5, false);
    }

    public static boolean checkMultipleLocalization(ExtendedWebElement[] localizationCheckList, boolean skipPunctuationAndNumbers) {
        return L10Nparser.checkMultipleLocalization(localizationCheckList, 5, false);
    }

    public static boolean checkMultipleLocalization(ExtendedWebElement[] localizationCheckList, int timeout, boolean skipPunctuationAndNumbers) {
        boolean ret = true;
        String returnAssertErrorMsg = "";
        assertErrorMsg = "";
        for (ExtendedWebElement elem : localizationCheckList) {
            if (L10Nparser.checkLocalizationText(elem, true, timeout, skipPunctuationAndNumbers)) continue;
            ret = false;
            returnAssertErrorMsg = returnAssertErrorMsg + " \n" + assertErrorMsg;
        }
        assertErrorMsg = returnAssertErrorMsg;
        return ret;
    }

    public static void saveLocalization() {
        if (L10Nparser.getAddNewLocalization()) {
            try {
                if (prop.size() == 0) {
                    LOGGER.info((Object)"There are no new localization properties.");
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            LOGGER.info((Object)("New localization for '" + actualLocale + "'"));
            LOGGER.info((Object)newLocList.toString());
            LOGGER.info((Object)("Properties: " + prop.toString()));
            newLocList.clear();
            try {
                String encoding;
                if (propFileName.isEmpty()) {
                    propFileName = L10Nparser.getPropertyFileName(actualLocale.toString());
                    LOGGER.info((Object)("propFileName:=" + propFileName));
                }
                if ((encoding = L10Nparser.getLocalizationSaveEncoding()).contains("UTF")) {
                    prop.store(new OutputStreamWriter((OutputStream)new FileOutputStream(propFileName), "UTF-8"), null);
                } else {
                    FileOutputStream output = new FileOutputStream(propFileName);
                    prop.store(output, null);
                    ((OutputStream)output).close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            prop.clear();
        } else {
            LOGGER.debug((Object)"There is no new localization for saving.");
        }
    }

    private static String getLocalizationSaveEncoding() {
        try {
            encoding = Configuration.get((Configuration.Parameter)Configuration.Parameter.ADD_NEW_LOCALIZATION_ENCODING);
        }
        catch (Exception e) {
            LOGGER.error((Object)"There is no localization encoding parameter in config property.");
        }
        LOGGER.info((Object)("Will use encoding: " + encoding));
        return encoding.toUpperCase();
    }

    static {
        assertErrorMsg = "";
        newLocalization = false;
        newLocList = new LinkedList();
        prop = new Properties();
        propFileName = "";
        encoding = "ISO-8859-1";
    }
}

