/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.filter.impl;

import com.qaprosoft.carina.core.foundation.filter.IFilter;
import com.qaprosoft.carina.core.foundation.utils.ownership.MethodOwner;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestNGMethod;

public class OwnerFilter
implements IFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public boolean isPerform(ITestNGMethod testMethod, List<String> rules) {
        if (testMethod != null) {
            MethodOwner.List ownerAnnotations;
            MethodOwner ownerAnnotation;
            if (testMethod.getConstructorOrMethod().getMethod().isAnnotationPresent(MethodOwner.class) && (ownerAnnotation = testMethod.getConstructorOrMethod().getMethod().getAnnotation(MethodOwner.class)) != null) {
                String owner = ownerAnnotation.owner().toLowerCase();
                LOGGER.info(String.format("Test: [%s]. Owners: %s. Expected ownerAnnotation: [%s]", testMethod.getMethodName(), owner, rules.toString()));
                return this.ruleCheck(rules, owner);
            }
            if (testMethod.getConstructorOrMethod().getMethod().isAnnotationPresent(MethodOwner.List.class) && (ownerAnnotations = testMethod.getConstructorOrMethod().getMethod().getAnnotation(MethodOwner.List.class)) != null) {
                ArrayList<String> owners = new ArrayList<String>();
                for (MethodOwner methodOwner : ownerAnnotations.value()) {
                    owners.add(methodOwner.owner().toLowerCase());
                }
                LOGGER.info(String.format("Test: [%s]. Owners: %s. Expected owner: [%s]", testMethod.getMethodName(), ((Object)owners).toString(), rules.toString()));
                return this.ruleCheck(rules, owners);
            }
            return this.ruleCheck(rules);
        }
        return false;
    }
}

