/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.filter.impl;

import com.qaprosoft.carina.core.foundation.filter.IFilter;
import com.qaprosoft.carina.core.foundation.utils.tag.TestTag;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestNGMethod;

public class TagFilter
implements IFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public boolean isPerform(ITestNGMethod testMethod, List<String> rules) {
        if (testMethod != null) {
            TestTag methodAnnotation;
            if (testMethod.getConstructorOrMethod().getMethod().isAnnotationPresent(TestTag.class) && (methodAnnotation = testMethod.getConstructorOrMethod().getMethod().getAnnotation(TestTag.class)) != null) {
                String tagName = methodAnnotation.name();
                String tagValue = methodAnnotation.value();
                String tag = tagName + "=" + tagValue;
                LOGGER.info(String.format("Test: [%s]. Tag: [%s]. Expected tag: [%s]", testMethod.getMethodName(), tag, rules.toString()));
                return this.ruleCheck(rules, tag);
            }
            if (testMethod.getConstructorOrMethod().getMethod().isAnnotationPresent(TestTag.List.class) && (methodAnnotation = testMethod.getConstructorOrMethod().getMethod().getAnnotation(TestTag.List.class)) != null) {
                ArrayList<String> tags = new ArrayList<String>();
                for (TestTag tag : methodAnnotation.value()) {
                    String tagName = tag.name();
                    String tagValue = tag.value();
                    String fullTag = tagName + "=" + tagValue;
                    tags.add(fullTag.toLowerCase());
                }
                LOGGER.info(String.format("Test: [%s]. Tag: [%s]. Expected tag: [%s]", testMethod.getMethodName(), tags, rules.toString()));
                return this.ruleCheck(rules, tags);
            }
            return this.ruleCheck(rules);
        }
        return false;
    }
}

