/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.qaprosoft.carina.core.foundation.dataprovider.parser.DSBean;
import com.qaprosoft.carina.core.foundation.listeners.TestNamingService;
import com.qaprosoft.carina.core.foundation.report.ReportContext;
import com.qaprosoft.carina.core.foundation.report.TestResultItem;
import com.qaprosoft.carina.core.foundation.report.TestResultType;
import com.qaprosoft.carina.core.foundation.report.email.EmailReportItemCollector;
import com.qaprosoft.carina.core.foundation.retry.RetryAnalyzer;
import com.qaprosoft.carina.core.foundation.utils.DateUtils;
import com.qaprosoft.carina.core.foundation.utils.Messager;
import com.qaprosoft.carina.core.foundation.utils.ParameterGenerator;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.StringGenerator;
import com.qaprosoft.carina.core.foundation.webdriver.IDriverPool;
import com.zebrunner.agent.testng.core.retry.RetryAnalyzerInterceptor;
import com.zebrunner.agent.testng.core.testname.TestNameResolverRegistry;
import com.zebrunner.agent.testng.listener.RetryService;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IRetryAnalyzer;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.annotations.DisabledRetryAnalyzer;

public class AbstractTestListener
extends TestListenerAdapter
implements IDriverPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private void startItem(ITestResult result, Messager messager) {
        String test = TestNameResolverRegistry.get().resolve(result);
        messager.info(new String[]{test, DateUtils.now()});
    }

    private void passItem(ITestResult result, Messager messager) {
        String test = TestNameResolverRegistry.get().resolve(result);
        messager.info(new String[]{test, DateUtils.now()});
        EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, TestResultType.PASS, null, result.getMethod().getDescription()));
        result.getTestContext().removeAttribute("testFailureMessage");
    }

    private String failItem(ITestResult result, Messager messager) {
        String test = TestNameResolverRegistry.get().resolve(result);
        String errorMessage = this.getFailureReason(result);
        TestResultType failType = TestResultType.FAIL;
        if (result.getStatus() == 3) {
            failType = TestResultType.SKIP;
        }
        if (!errorMessage.contains("All tests were skipped! Analyze logs to determine possible configuration issues.")) {
            messager.error(new String[]{test, DateUtils.now(), errorMessage});
            if (!R.EMAIL.getBoolean("fail_full_stacktrace_in_report") && result.getThrowable() != null && result.getThrowable().getMessage() != null && !StringUtils.isEmpty((CharSequence)result.getThrowable().getMessage())) {
                EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, failType, result.getThrowable().getMessage(), result.getMethod().getDescription()));
            } else {
                EmailReportItemCollector.push((TestResultItem)this.createTestResult(result, failType, errorMessage, result.getMethod().getDescription()));
            }
        }
        result.getTestContext().removeAttribute("testFailureMessage");
        return errorMessage;
    }

    private void afterTest(ITestResult result) {
        ReportContext.generateTestReport();
        ReportContext.emptyTestDirData();
    }

    public void beforeConfiguration(ITestResult result) {
        LOGGER.debug("AbstractTestListener->beforeConfiguration");
        super.beforeConfiguration(result);
    }

    public void onConfigurationSuccess(ITestResult result) {
        LOGGER.debug("AbstractTestListener->onConfigurationSuccess");
        super.onConfigurationSuccess(result);
    }

    public void onConfigurationSkip(ITestResult result) {
        LOGGER.debug("AbstractTestListener->onConfigurationSkip");
        super.onConfigurationSkip(result);
    }

    public void onConfigurationFailure(ITestResult result) {
        LOGGER.debug("AbstractTestListener->onConfigurationFailure");
        super.onConfigurationFailure(result);
    }

    public void onStart(ITestContext context) {
        LOGGER.debug("AbstractTestListener->onStart(ITestContext context)");
        String uuid = StringGenerator.generateNumeric((int)8);
        ParameterGenerator.setUUID((String)uuid);
        super.onStart(context);
    }

    public void onTestStart(ITestResult result) {
        ReportContext.createTestDir();
        LOGGER.debug("AbstractTestListener->onTestStart");
        LOGGER.debug("Test Directory: {}", (Object)ReportContext.getTestDir().getName());
        IRetryAnalyzer curRetryAnalyzer = this.getRetryAnalyzer(result);
        if (curRetryAnalyzer == null || curRetryAnalyzer instanceof DisabledRetryAnalyzer || curRetryAnalyzer instanceof RetryAnalyzerInterceptor) {
            RetryService.setRetryAnalyzerClass(RetryAnalyzer.class, (ITestContext)result.getTestContext(), (ITestNGMethod)result.getMethod());
            result.getMethod().setRetryAnalyzerClass(RetryAnalyzerInterceptor.class);
        } else if (!(curRetryAnalyzer instanceof RetryAnalyzerInterceptor)) {
            LOGGER.warn("Custom RetryAnalyzer is used: " + curRetryAnalyzer.getClass().getName());
            RetryService.setRetryAnalyzerClass(curRetryAnalyzer.getClass(), (ITestContext)result.getTestContext(), (ITestNGMethod)result.getMethod());
            result.getMethod().setRetryAnalyzerClass(RetryAnalyzerInterceptor.class);
        }
        this.generateParameters(result);
        if (!result.getTestContext().getCurrentXmlTest().getAllParameters().containsKey("{excel_ds_custom_provider}") && result.getParameters().length > 0 && result.getTestContext().getCurrentXmlTest().getAllParameters().containsKey("{excel_ds_args}")) {
            DSBean dsBean = new DSBean(result.getTestContext());
            int index = 0;
            for (String arg : dsBean.getArgs()) {
                dsBean.getTestParams().put(arg, (String)result.getParameters()[index++]);
            }
            result.getTestContext().getCurrentXmlTest().setParameters(dsBean.getTestParams());
        }
        this.startItem(result, Messager.TEST_STARTED);
        super.onTestStart(result);
    }

    private void generateParameters(ITestResult result) {
        if (result != null && result.getParameters() != null) {
            for (int i = 0; i < result.getParameters().length; ++i) {
                if (result.getParameters()[i] instanceof String) {
                    result.getParameters()[i] = ParameterGenerator.process((String)result.getParameters()[i].toString());
                }
                if (!(result.getParameters()[i] instanceof Map)) continue;
                Map dynamicAgrs = (Map)result.getParameters()[i];
                for (Map.Entry entry : dynamicAgrs.entrySet()) {
                    Object param = ParameterGenerator.process((String)((String)entry.getValue()));
                    if (param != null) {
                        dynamicAgrs.put((String)entry.getKey(), param.toString());
                        continue;
                    }
                    dynamicAgrs.put((String)entry.getKey(), null);
                }
            }
        }
    }

    public void onTestSuccess(ITestResult result) {
        LOGGER.debug("AbstractTestListener->onTestSuccess");
        this.passItem(result, Messager.TEST_PASSED);
        this.afterTest(result);
        super.onTestSuccess(result);
    }

    public void onTestFailure(ITestResult result) {
        LOGGER.debug("AbstractTestListener->onTestFailure");
        this.failItem(result, Messager.TEST_FAILED);
        this.afterTest(result);
        super.onTestFailure(result);
    }

    public void onTestSkipped(ITestResult result) {
        LOGGER.debug("AbstractTestListener->onTestSkipped");
        this.failItem(result, Messager.TEST_SKIPPED);
        super.onTestSkipped(result);
    }

    public void onFinish(ITestContext context) {
        LOGGER.debug("AbstractTestListener->onFinish(ITestContext context)");
        super.onFinish(context);
    }

    protected TestResultItem createTestResult(ITestResult result, TestResultType resultType, String failReason, String description) {
        String group = StringEscapeUtils.escapeHtml4((String)TestNamingService.getPackageName((ITestResult)result));
        String linkToLog = ReportContext.getTestLogLink();
        String linkToScreenshots = ReportContext.getTestScreenshotsLink();
        String test = StringEscapeUtils.escapeHtml4((String)TestNameResolverRegistry.get().resolve(result));
        TestResultItem testResultItem = new TestResultItem(group, test, description, resultType, linkToScreenshots, linkToLog, failReason);
        return testResultItem;
    }

    protected String getFailureReason(ITestResult result) {
        String errorMessage = "";
        String message = "";
        if (result.getThrowable() != null) {
            Throwable thr = result.getThrowable();
            errorMessage = this.getFullStackTrace(thr);
            message = thr.getMessage();
            result.getTestContext().setAttribute("testFailureMessage", (Object)message);
        }
        if (errorMessage.isEmpty()) {
            Set results = result.getTestContext().getSkippedConfigurations().getAllResults();
            for (ITestResult resultItem : results) {
                String methodName = resultItem.getMethod().getMethodName();
                if (!methodName.equals("executeBeforeTestMethod")) continue;
                errorMessage = this.getFullStackTrace(resultItem.getThrowable());
            }
        }
        return errorMessage;
    }

    private String getFullStackTrace(Throwable thr) {
        Object stackTrace = "";
        if (thr != null) {
            StackTraceElement[] elems;
            stackTrace = thr.getMessage() + "\n";
            for (StackTraceElement elem : elems = thr.getStackTrace()) {
                stackTrace = (String)stackTrace + "\n" + elem.toString();
            }
        }
        return stackTrace;
    }

    private IRetryAnalyzer getRetryAnalyzer(ITestResult result) {
        return result.getMethod().getRetryAnalyzer(result);
    }
}

