/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.carina.core.foundation.listeners;

import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.azure.storage.blob.models.BlobProperties;
import com.qaprosoft.amazon.AmazonS3Manager;
import com.qaprosoft.appcenter.AppCenterManager;
import com.qaprosoft.azure.AzureManager;
import com.qaprosoft.carina.browsermobproxy.ProxyPool;
import com.qaprosoft.carina.core.foundation.listeners.AbstractTestListener;
import com.qaprosoft.carina.core.foundation.report.ReportContext;
import com.qaprosoft.carina.core.foundation.report.TestResultItem;
import com.qaprosoft.carina.core.foundation.report.TestResultType;
import com.qaprosoft.carina.core.foundation.report.email.EmailReportGenerator;
import com.qaprosoft.carina.core.foundation.report.email.EmailReportItemCollector;
import com.qaprosoft.carina.core.foundation.report.qtest.IQTestManager;
import com.qaprosoft.carina.core.foundation.report.testrail.ITestRailManager;
import com.qaprosoft.carina.core.foundation.skip.ExpectedSkipManager;
import com.qaprosoft.carina.core.foundation.utils.Configuration;
import com.qaprosoft.carina.core.foundation.utils.DateUtils;
import com.qaprosoft.carina.core.foundation.utils.FileManager;
import com.qaprosoft.carina.core.foundation.utils.Messager;
import com.qaprosoft.carina.core.foundation.utils.R;
import com.qaprosoft.carina.core.foundation.utils.ZebrunnerNameResolver;
import com.qaprosoft.carina.core.foundation.utils.ownership.Ownership;
import com.qaprosoft.carina.core.foundation.utils.ownership.SuiteOwnerResolver;
import com.qaprosoft.carina.core.foundation.utils.resources.L10N;
import com.qaprosoft.carina.core.foundation.utils.tag.PriorityManager;
import com.qaprosoft.carina.core.foundation.utils.tag.TagManager;
import com.qaprosoft.carina.core.foundation.webdriver.CarinaDriver;
import com.qaprosoft.carina.core.foundation.webdriver.IDriverPool;
import com.qaprosoft.carina.core.foundation.webdriver.Screenshot;
import com.qaprosoft.carina.core.foundation.webdriver.TestPhase;
import com.qaprosoft.carina.core.foundation.webdriver.core.capability.CapabilitiesLoader;
import com.qaprosoft.carina.core.foundation.webdriver.screenshot.AutoScreenshotRule;
import com.qaprosoft.carina.core.foundation.webdriver.screenshot.IScreenshotRule;
import com.zebrunner.agent.core.registrar.Artifact;
import com.zebrunner.agent.core.registrar.CurrentTest;
import com.zebrunner.agent.core.registrar.CurrentTestRun;
import com.zebrunner.agent.core.registrar.Label;
import com.zebrunner.agent.core.registrar.TestRail;
import com.zebrunner.agent.core.registrar.label.CompositeLabelResolver;
import com.zebrunner.agent.core.registrar.label.LabelResolver;
import com.zebrunner.agent.core.registrar.maintainer.ChainedMaintainerResolver;
import com.zebrunner.agent.core.registrar.maintainer.MaintainerResolver;
import com.zebrunner.agent.core.webdriver.RemoteWebDriverFactory;
import com.zebrunner.agent.testng.core.testname.TestNameResolver;
import com.zebrunner.agent.testng.core.testname.TestNameResolverRegistry;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IClassListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.xml.XmlSuite;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CarinaListener
extends AbstractTestListener
implements ISuiteListener,
IQTestManager,
ITestRailManager,
IClassListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final long EXPLICIT_TIMEOUT = com.qaprosoft.carina.core.foundation.utils.Configuration.getLong((Configuration.Parameter)Configuration.Parameter.EXPLICIT_TIMEOUT);
    protected static final String SUITE_TITLE = "%s%s%s - %s (%s)";
    protected static final String XML_SUITE_NAME = " (%s)";
    protected static boolean automaticDriversCleanup = true;
    protected boolean isRunLabelsRegistered = false;
    private static final Pattern S3_BUCKET_PATTERN = Pattern.compile("s3:\\/\\/([a-zA-Z-0-9][^\\/]*)\\/(.*)");
    private static final Pattern AZURE_CONTAINER_PATTERN = Pattern.compile("\\/\\/([a-z0-9]{3,24})\\.blob.core.windows.net\\/(?:(\\$root|(?:[a-z0-9](?!.*--)[a-z0-9-]{1,61}[a-z0-9]))\\/)?(.{1,1024})");
    private static final Pattern APPCENTER_PATTERN = Pattern.compile("appcenter:\\/\\/([a-zA-Z-0-9][^\\/]*)\\/([a-zA-Z-0-9][^\\/]*)\\/([a-zA-Z-0-9][^\\/]*)\\/([a-zA-Z-0-9][^\\/]*)");

    public CarinaListener() {
        Capabilities zebrunnerCapabilities;
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        R.reinit();
        LOGGER.info(com.qaprosoft.carina.core.foundation.utils.Configuration.asString());
        try {
            L10N.load();
        }
        catch (Exception e) {
            LOGGER.error("L10N bundle is not initialized successfully!", (Throwable)e);
        }
        String customCapabilities = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.CUSTOM_CAPABILITIES);
        if (!customCapabilities.isEmpty()) {
            new CapabilitiesLoader().loadCapabilities(customCapabilities);
        }
        if (!(zebrunnerCapabilities = RemoteWebDriverFactory.getCapabilities()).asMap().isEmpty()) {
            new CapabilitiesLoader().loadCapabilities(zebrunnerCapabilities);
        }
        AutoScreenshotRule autoScreenshotsRule = new AutoScreenshotRule();
        Screenshot.addScreenshotRule((IScreenshotRule)autoScreenshotsRule);
        TestNameResolverRegistry.set((TestNameResolver)new ZebrunnerNameResolver());
        CompositeLabelResolver.addResolver((LabelResolver)new TagManager());
        CompositeLabelResolver.addResolver((LabelResolver)new PriorityManager());
        ReportContext.getBaseDir();
    }

    public void onStart(ISuite suite) {
        String mobileApp;
        LOGGER.debug("CarinaListener->onStart(ISuite suite)");
        ChainedMaintainerResolver.addLast((MaintainerResolver)new SuiteOwnerResolver(suite));
        ChainedMaintainerResolver.addFirst((MaintainerResolver)new Ownership());
        if (!"INFO".equalsIgnoreCase(com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.CORE_LOG_LEVEL))) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig logger = config.getLoggerConfig("com.qaprosoft.carina.core");
            logger.setLevel(Level.getLevel((String)com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.CORE_LOG_LEVEL)));
        }
        CarinaListener.updateAppPath();
        this.setThreadCount(suite);
        if (com.qaprosoft.carina.core.foundation.utils.Configuration.getPlatform().equalsIgnoreCase("API")) {
            CurrentTestRun.setPlatform((String)"API");
        }
        if (!(mobileApp = com.qaprosoft.carina.core.foundation.utils.Configuration.getMobileApp()).isEmpty()) {
            Artifact.attachReferenceToTestRun((String)"app", (String)mobileApp);
        }
        CurrentTestRun.setLocale((String)com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.LOCALE));
        com.qaprosoft.carina.core.foundation.utils.Configuration.setBuild((String)com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION));
        String sha1 = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.GIT_HASH);
        if (!sha1.isEmpty()) {
            Label.attachToTestRun((String)"sha1", (String[])new String[]{sha1});
        }
        this.registerOwner();
        if (!this.isRunLabelsRegistered) {
            this.attachTestRunLabels(suite);
            this.isRunLabelsRegistered = true;
        }
        LOGGER.info("CARINA_CORE_VERSION: " + this.getCarinaVersion());
    }

    @Override
    public void onStart(ITestContext context) {
        LOGGER.debug("CarinaListener->OnTestStart(ITestContext context): " + context.getName());
        super.onStart(context);
    }

    @Override
    public void beforeConfiguration(ITestResult result) {
        LOGGER.debug("CarinaListener->beforeConfiguration");
        super.beforeConfiguration(result);
        if (result.getMethod().isBeforeSuiteConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.BEFORE_SUITE);
        }
        if (result.getMethod().isBeforeTestConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.BEFORE_TEST);
        }
        if (result.getMethod().isBeforeClassConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.BEFORE_CLASS);
        }
        if (result.getMethod().isBeforeMethodConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.BEFORE_METHOD);
        }
        if (result.getMethod().isAfterMethodConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.AFTER_METHOD);
        }
        if (result.getMethod().isAfterClassConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.AFTER_CLASS);
        }
        if (result.getMethod().isAfterTestConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.AFTER_TEST);
        }
        if (result.getMethod().isAfterSuiteConfiguration()) {
            TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.AFTER_SUITE);
        }
    }

    @Override
    public void onConfigurationFailure(ITestResult result) {
        LOGGER.debug("CarinaListener->onConfigurationFailure");
        super.onConfigurationFailure(result);
    }

    @Override
    public void onTestStart(ITestResult result) {
        LOGGER.debug("CarinaListener->onTestStart");
        TestPhase.setActivePhase((TestPhase.Phase)TestPhase.Phase.METHOD);
        Method testMethod = result.getMethod().getConstructorOrMethod().getMethod();
        if (ExpectedSkipManager.getInstance().isSkip(testMethod, result.getTestContext())) {
            this.skipExecution("Based on rule listed above");
        }
        super.onTestStart(result);
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        LOGGER.debug("CarinaListener->onTestSuccess");
        this.onTestFinish(result);
        super.onTestSuccess(result);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        LOGGER.debug("CarinaListener->onTestFailure");
        this.takeScreenshot();
        this.onTestFinish(result);
        super.onTestFailure(result);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        LOGGER.debug("CarinaListener->onTestSkipped");
        this.takeScreenshot();
        this.onTestFinish(result);
        super.onTestSkipped(result);
    }

    private boolean hasDependencies(ITestResult result) {
        String methodName = result.getMethod().getMethodName();
        String className = result.getMethod().getTestClass().getName();
        List methods = result.getTestContext().getSuite().getAllMethods();
        for (ITestNGMethod method : methods) {
            List<String> dependencies = Arrays.asList(method.getMethodsDependedUpon());
            if (!dependencies.contains(methodName) && !dependencies.contains(className + "." + methodName)) continue;
            LOGGER.debug("dependency detected for " + methodName);
            return true;
        }
        return false;
    }

    private void onTestFinish(ITestResult result) {
        try {
            R.CONFIG.clearTestProperties();
            R.TESTDATA.clearTestProperties();
            R.DATABASE.clearTestProperties();
            R.EMAIL.clearTestProperties();
            R.REPORT.clearTestProperties();
            R.ZAFIRA.clearTestProperties();
            LOGGER.debug("Test result is : " + result.getStatus());
            if ((automaticDriversCleanup && !this.hasDependencies(result) || result.getStatus() == 2 || result.getStatus() == 3) && !com.qaprosoft.carina.core.foundation.utils.Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.FORCIBLY_DISABLE_DRIVER_QUIT)) {
                this.quitDrivers(new TestPhase.Phase[]{TestPhase.Phase.BEFORE_METHOD, TestPhase.Phase.METHOD});
            }
            this.attachTestLabels(result);
        }
        catch (Exception e) {
            LOGGER.error("Exception in CarinaListener->onTestFinish!", (Throwable)e);
        }
    }

    public void onAfterClass(ITestClass testClass) {
        LOGGER.debug("CarinaListener->onAfterClass(ITestClass testClass)");
        this.quitDrivers(new TestPhase.Phase[]{TestPhase.Phase.BEFORE_CLASS});
    }

    @Override
    public void onFinish(ITestContext context) {
        LOGGER.debug("CarinaListener->onFinish(ITestContext context)");
        super.onFinish(context);
        this.quitDrivers(new TestPhase.Phase[]{TestPhase.Phase.BEFORE_TEST});
        LOGGER.debug("CarinaListener->onFinish(context): " + context.getName());
    }

    public void onFinish(ISuite suite) {
        LOGGER.debug("CarinaListener->onFinish(ISuite suite)");
        try {
            String browser = this.getBrowser();
            Object title = this.getTitle(suite.getXmlSuite());
            TestResultType testResult = EmailReportGenerator.getSuiteResult(EmailReportItemCollector.getTestResults());
            String status = testResult.getName();
            title = status + ": " + (String)title;
            Object env = "";
            if (!com.qaprosoft.carina.core.foundation.utils.Configuration.isNull((Configuration.Parameter)Configuration.Parameter.ENV)) {
                env = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.ENV);
            }
            if (!com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.URL).isEmpty()) {
                env = (String)env + " - <a href='" + com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.URL) + "'>" + com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.URL) + "</a>";
            }
            ReportContext.getTempDir().delete();
            LOGGER.debug("Generating email report...");
            EmailReportGenerator report = new EmailReportGenerator((String)title, (String)env, com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION), browser, DateUtils.now(), EmailReportItemCollector.getTestResults(), EmailReportItemCollector.getCreatedItems());
            String emailContent = report.getEmailBody();
            ReportContext.generateHtmlReport((String)emailContent);
            this.printExecutionSummary(EmailReportItemCollector.getTestResults());
            LOGGER.debug("Finish email report generation.");
        }
        catch (Exception e) {
            LOGGER.error("Exception in CarinaListener->onFinish(ISuite suite)", (Throwable)e);
        }
    }

    public static void disableDriversCleanup() {
        LOGGER.info("Automatic drivers cleanup will be disabled!");
        automaticDriversCleanup = false;
    }

    protected String getBrowser() {
        return com.qaprosoft.carina.core.foundation.utils.Configuration.getBrowser();
    }

    protected String getTitle(XmlSuite suite) {
        Object browser = this.getBrowser();
        if (!((String)browser).isEmpty()) {
            browser = " " + (String)browser;
        }
        String env = !com.qaprosoft.carina.core.foundation.utils.Configuration.isNull((Configuration.Parameter)Configuration.Parameter.ENV) ? com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.ENV) : com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.URL);
        String title = "";
        Object app_version = "";
        if (!com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION).isEmpty()) {
            app_version = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION) + " - ";
        }
        String suiteName = this.getSuiteName(suite);
        String xmlFile = this.getSuiteFileName(suite);
        title = String.format(SUITE_TITLE, app_version, suiteName, String.format(XML_SUITE_NAME, xmlFile), env, browser);
        return title;
    }

    private String getSuiteFileName(XmlSuite suite) {
        String fileName = suite.getFileName();
        if (fileName == null) {
            fileName = "undefined";
        }
        LOGGER.debug("Full suite file name: " + fileName);
        if (fileName.contains("\\")) {
            fileName = fileName.replaceAll("\\\\", "/");
        }
        fileName = StringUtils.substringAfterLast((String)fileName, (String)"/");
        LOGGER.debug("Short suite file name: " + fileName);
        return fileName;
    }

    protected String getSuiteName(XmlSuite suite) {
        String suiteName = "";
        suiteName = suite != null && !"Default suite".equals(suite.getName()) ? (com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.SUITE_NAME).isEmpty() ? suite.getName() : com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.SUITE_NAME)) : (com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.SUITE_NAME).isEmpty() ? R.EMAIL.get("title") : com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.SUITE_NAME));
        return suiteName;
    }

    private void printExecutionSummary(List<TestResultItem> tris) {
        Messager.INFORMATION.info(new String[]{"**************** Test execution summary ****************"});
        int num = 1;
        for (TestResultItem tri : tris) {
            String failReason = tri.getFailReason();
            if (failReason == null) {
                failReason = "";
            }
            if (tri.isConfig()) continue;
            Object reportLinks = !StringUtils.isEmpty((CharSequence)tri.getLinkToScreenshots()) ? "screenshots=" + tri.getLinkToScreenshots() + " | " : "";
            reportLinks = (String)reportLinks + (String)(!StringUtils.isEmpty((CharSequence)tri.getLinkToLog()) ? "log=" + tri.getLinkToLog() : "");
            Messager.TEST_RESULT.info(new String[]{String.valueOf(num++), tri.getTest(), tri.getResult().toString(), reportLinks});
        }
    }

    @Deprecated
    protected void putS3Artifact(String key, String path) {
        AmazonS3Manager.getInstance().put(com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.S3_BUCKET_NAME), key, path);
    }

    @Deprecated
    protected S3Object getS3Artifact(String bucket, String key) {
        return AmazonS3Manager.getInstance().get(com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.S3_BUCKET_NAME), key);
    }

    @Deprecated
    protected S3Object getS3Artifact(String key) {
        return this.getS3Artifact(com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.S3_BUCKET_NAME), key);
    }

    @Deprecated
    protected void putAzureArtifact(String remotePath, String localPath) {
        AzureManager.getInstance().put(com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.AZURE_CONTAINER_NAME), remotePath, localPath);
    }

    @Deprecated
    protected void getAzureArtifact(String bucket, String remotePath, File localPath) {
        AzureManager.getInstance().download(bucket, remotePath, localPath);
    }

    private static void updateAppPath() {
        String mobileAppPath = com.qaprosoft.carina.core.foundation.utils.Configuration.getMobileApp();
        Matcher matcher = S3_BUCKET_PATTERN.matcher(mobileAppPath);
        LOGGER.debug("Analyzing if mobile app is located on S3...");
        if (matcher.find()) {
            mobileAppPath = CarinaListener.updateS3AppPath(mobileAppPath);
        }
        matcher = AZURE_CONTAINER_PATTERN.matcher(mobileAppPath);
        LOGGER.debug("Analyzing if mobile app is located on Azure...");
        if (matcher.find()) {
            mobileAppPath = CarinaListener.updateAzureAppPath(mobileAppPath);
        }
        matcher = APPCENTER_PATTERN.matcher(mobileAppPath);
        LOGGER.debug("Analyzing if mobile_app is located on AppCenter...");
        if (matcher.find()) {
            mobileAppPath = CarinaListener.updateAppCenterAppPath(mobileAppPath);
        }
        if (!mobileAppPath.isEmpty()) {
            com.qaprosoft.carina.core.foundation.utils.Configuration.setMobileApp((String)mobileAppPath);
        }
    }

    private static String updateAppCenterAppPath(String mobileAppPath) {
        Matcher matcher = APPCENTER_PATTERN.matcher(mobileAppPath);
        if (matcher.find()) {
            LOGGER.info("app artifact is located on AppCenter...");
            String appName = matcher.group(1);
            String platformName = matcher.group(2);
            String buildType = matcher.group(3);
            String version = matcher.group(4);
            mobileAppPath = AppCenterManager.getInstance().getDownloadUrl(appName, platformName, buildType, version);
        } else {
            LOGGER.error("Unable to parse '{}' path using AppCenter pattern", (Object)mobileAppPath);
        }
        return mobileAppPath;
    }

    private static String updateS3AppPath(String mobileAppPath) {
        Matcher matcher = S3_BUCKET_PATTERN.matcher(mobileAppPath);
        if (matcher.find()) {
            LOGGER.info("app artifact is located on s3...");
            String bucketName = matcher.group(1);
            String key = matcher.group(2);
            Pattern pattern = Pattern.compile(key);
            int position = key.indexOf(".*");
            if (position > 0) {
                int slashPosition = key.substring(0, position).lastIndexOf("/");
                if (slashPosition > 0) {
                    key = key.substring(0, slashPosition);
                    S3ObjectSummary lastBuild = AmazonS3Manager.getInstance().getLatestBuildArtifact(bucketName, key, pattern);
                    key = lastBuild.getKey();
                }
            } else {
                key = AmazonS3Manager.getInstance().get(bucketName, key).getKey();
            }
            LOGGER.info("next s3 app key will be used: " + key);
            long hours = 259200000L;
            mobileAppPath = AmazonS3Manager.getInstance().generatePreSignUrl(bucketName, key, hours).toString();
        } else {
            LOGGER.error("Unable to parse '{}' path using S3 pattern", (Object)mobileAppPath);
        }
        return mobileAppPath;
    }

    private static String updateAzureAppPath(String mobileAppPath) {
        Matcher matcher = AZURE_CONTAINER_PATTERN.matcher(mobileAppPath);
        if (matcher.find()) {
            LOGGER.info("app artifact is located on Azure...");
            String accountName = matcher.group(1);
            String containerName = matcher.group(2) == null ? "$root" : matcher.group(2);
            String remoteFilePath = matcher.group(3);
            LOGGER.info("Account: " + accountName + "\nContainer: " + containerName + "\nRemotePath: " + remoteFilePath + "\n");
            R.CONFIG.put(Configuration.Parameter.AZURE_ACCOUNT_NAME.getKey(), accountName);
            BlobProperties blobProperties = AzureManager.getInstance().get(containerName, remoteFilePath);
            String azureLocalStorage = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.AZURE_LOCAL_STORAGE);
            String localFilePath = azureLocalStorage + File.separator + StringUtils.substringAfterLast((String)remoteFilePath, (String)"/");
            File file = new File(localFilePath);
            try {
                if (file.exists() && FileManager.getFileChecksum((FileManager.Checksum)FileManager.Checksum.MD5, (File)file).equals(Base64.encodeBase64String((byte[])blobProperties.getContentMd5()))) {
                    LOGGER.info("build artifact with the same checksum already downloaded: " + file.getAbsolutePath());
                } else {
                    LOGGER.info(String.format("Following data was extracted: container: %s, remotePath: %s, local file: %s", containerName, remoteFilePath, file.getAbsolutePath()));
                    AzureManager.getInstance().download(containerName, remoteFilePath, file);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Azure app path update exception detected!", (Throwable)exception);
            }
            mobileAppPath = file.getAbsolutePath();
            String appVersion = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.APP_VERSION);
            if (appVersion.equals("latest") || appVersion.isEmpty()) {
                com.qaprosoft.carina.core.foundation.utils.Configuration.setBuild((String)file.getName());
            }
        } else {
            LOGGER.error("Unable to parse '{}' path using Azure pattern", (Object)mobileAppPath);
        }
        return mobileAppPath;
    }

    protected void skipExecution(String message) {
        CurrentTest.revertRegistration();
        throw new SkipException(message);
    }

    private String getAttributeValue(ISuite suite, String attribute) {
        String res = "";
        if (suite.getXmlSuite() == null || suite.getXmlSuite().getFileName() == null) {
            return res;
        }
        File file = new File(suite.getXmlSuite().getFileName());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                Node nodeAttribute;
                Node nodeName;
                NamedNodeMap nodeMapAttributes = document.getChildNodes().item(i).getAttributes();
                if (nodeMapAttributes == null || (nodeName = nodeMapAttributes.getNamedItem("name")) == null || !suite.getName().equals(nodeName.getNodeValue()) || (nodeAttribute = nodeMapAttributes.getNamedItem(attribute)) == null) continue;
                res = nodeAttribute.getNodeValue();
                break;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to get attribute '" + attribute + "' from suite: " + suite.getXmlSuite().getFileName(), (Throwable)e);
        }
        return res;
    }

    private void setThreadCount(ISuite suite) {
        if (com.qaprosoft.carina.core.foundation.utils.Configuration.getThreadCount() >= 1) {
            suite.getXmlSuite().setThreadCount(com.qaprosoft.carina.core.foundation.utils.Configuration.getThreadCount());
            LOGGER.debug("Updated thread-count=" + suite.getXmlSuite().getThreadCount());
        } else {
            String suiteThreadCount = this.getAttributeValue(suite, "thread-count");
            LOGGER.debug("thread-count from suite: " + suiteThreadCount);
            if (suiteThreadCount.isEmpty()) {
                LOGGER.info("Set thread-count=1");
                R.CONFIG.put(Configuration.Parameter.THREAD_COUNT.getKey(), "1");
                suite.getXmlSuite().setThreadCount(1);
            } else {
                LOGGER.debug("Synching thread-count with values from suite xml file...");
                R.CONFIG.put(Configuration.Parameter.THREAD_COUNT.getKey(), suiteThreadCount);
                LOGGER.info("Use thread-count='" + suite.getXmlSuite().getThreadCount() + "' from suite file.");
            }
        }
        if (com.qaprosoft.carina.core.foundation.utils.Configuration.getDataProviderThreadCount() >= 1) {
            suite.getXmlSuite().setDataProviderThreadCount(com.qaprosoft.carina.core.foundation.utils.Configuration.getDataProviderThreadCount());
            LOGGER.debug("Updated data-provider-thread-count=" + suite.getXmlSuite().getDataProviderThreadCount());
        } else {
            String suiteDataProviderThreadCount = this.getAttributeValue(suite, "data-provider-thread-count");
            LOGGER.debug("data-provider-thread-count from suite: " + suiteDataProviderThreadCount);
            if (suiteDataProviderThreadCount.isEmpty()) {
                LOGGER.info("Set data-provider-thread-count=1");
                R.CONFIG.put(Configuration.Parameter.DATA_PROVIDER_THREAD_COUNT.getKey(), "1");
                suite.getXmlSuite().setDataProviderThreadCount(1);
            } else {
                LOGGER.debug("Synching data-provider-thread-count with values from suite xml file...");
                R.CONFIG.put(Configuration.Parameter.DATA_PROVIDER_THREAD_COUNT.getKey(), suiteDataProviderThreadCount);
                LOGGER.info("Use data-provider-thread-count='" + suite.getXmlSuite().getDataProviderThreadCount() + "' from suite file.");
            }
        }
    }

    private String getCarinaVersion() {
        String carinaVersion = "";
        try {
            Class<CarinaListener> theClass = CarinaListener.class;
            String classPath = theClass.getResource(theClass.getSimpleName() + ".class").toString();
            LOGGER.debug("Class: " + classPath);
            Pattern pattern = Pattern.compile(".*\\/(.*)\\/.*!");
            Matcher matcher = pattern.matcher(classPath);
            if (matcher.find()) {
                carinaVersion = matcher.group(1);
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return carinaVersion;
    }

    private void attachTestLabels(ITestResult result) {
        Set trCases = this.getTestRailCasesUuid(result);
        for (String trCase : trCases) {
            TestRail.setTestCaseId((String)trCase);
        }
        Set qtestCases = this.getQTestCasesUuid(result);
        if (qtestCases.size() > 0) {
            Label.attachToTest((String)"com.zebrunner.app/tcm.qtest.testcase-id", (String[])((String[])Arrays.copyOf(qtestCases.toArray(), qtestCases.size(), String[].class)));
        }
    }

    private void attachTestRunLabels(ISuite suite) {
        String qtestProject;
        String assignee;
        String runName;
        String milestone;
        String trSuite = this.getTestRailSuiteId(suite);
        if (!trSuite.isEmpty()) {
            TestRail.setSuiteId((String)trSuite);
        }
        if (!com.qaprosoft.carina.core.foundation.utils.Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.TESTRAIL_ENABLED)) {
            LOGGER.debug("disable TestRail integration!");
            TestRail.disableSync();
        }
        if (com.qaprosoft.carina.core.foundation.utils.Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.INCLUDE_ALL)) {
            LOGGER.info("enable include_all for TestRail integration!");
            TestRail.includeAllTestCasesInNewRun();
        }
        if (!(milestone = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.MILESTONE)).isEmpty()) {
            LOGGER.info("Set TestRail milestone name: " + milestone);
            TestRail.setMilestone((String)milestone);
        }
        if (!(runName = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.RUN_NAME)).isEmpty()) {
            LOGGER.info("Set TestRail run name: " + runName);
            TestRail.setRunName((String)runName);
        }
        if (!(assignee = com.qaprosoft.carina.core.foundation.utils.Configuration.get((Configuration.Parameter)Configuration.Parameter.ASSIGNEE)).isEmpty()) {
            LOGGER.info("Set TestRail assignee: " + assignee);
            TestRail.setAssignee((String)assignee);
        }
        if (!(qtestProject = this.getQTestProjectId(suite)).isEmpty()) {
            Label.attachToTestRun((String)"com.zebrunner.app/tcm.qtest.project-id", (String[])new String[]{qtestProject});
        }
    }

    private void registerOwner() {
        String owner = System.getProperty("BUILD_USER_ID");
        if (owner == null) {
            owner = System.getenv("USERNAME");
            System.out.println(owner);
        }
        if (owner != null) {
            Label.attachToTestRun((String)"Owner", (String[])new String[]{owner});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeScreenshot() {
        ConcurrentHashMap drivers = this.getDrivers();
        try {
            for (Map.Entry entry : drivers.entrySet()) {
                WebDriver drv = ((CarinaDriver)entry.getValue()).getDriver();
                if (drv instanceof EventFiringWebDriver) {
                    drv = ((EventFiringWebDriver)drv).getWrappedDriver();
                }
                R.CONFIG.put(Configuration.Parameter.ERROR_SCREENSHOT.getKey(), "true", true);
                Screenshot.captureByRule((WebDriver)drv, (String)"", (boolean)true);
            }
        }
        catch (Throwable thr) {
            LOGGER.error("Failure detected on screenshot generation after failure: ", thr);
        }
        finally {
            R.CONFIG.put(Configuration.Parameter.ERROR_SCREENSHOT.getKey(), "false", true);
        }
    }

    public static class ShutdownHook
    extends Thread {
        private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHook.class);

        private void quitAllDriversOnHook() {
            for (CarinaDriver carinaDriver : IDriverPool.driversPool) {
                String name = carinaDriver.getName();
                LOGGER.warn("Trying to quit driver '" + name + "' on shutdown hook action!");
                carinaDriver.getDevice().disconnectRemote();
                ProxyPool.stopProxy();
                try {
                    LOGGER.debug("Driver closing..." + name);
                    carinaDriver.getDriver().close();
                    LOGGER.debug("Driver exiting..." + name);
                    carinaDriver.getDriver().quit();
                    LOGGER.debug("Driver exited..." + name);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void run() {
            LOGGER.debug("Running shutdown hook");
            if (!com.qaprosoft.carina.core.foundation.utils.Configuration.getBoolean((Configuration.Parameter)Configuration.Parameter.FORCIBLY_DISABLE_DRIVER_QUIT)) {
                this.quitAllDriversOnHook();
            }
        }
    }
}

